/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloAddable;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSet;
import ilog.concert.IloIntSetVar;
import ilog.concert.IloIntVar;
import ilog.concert.IloLPMatrix;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloModel;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarBound;
import ilog.concert.IloNumVarBoundType;
import ilog.concert.IloObjective;
import ilog.concert.IloRange;
import ilog.concert.IloSOS1;
import ilog.concert.IloSOS2;
import ilog.cplex.Cplex;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxAndGoal;
import ilog.cplex.CpxApplyGoal;
import ilog.cplex.CpxBranchAsCplex;
import ilog.cplex.CpxBranchCallback;
import ilog.cplex.CpxCallback;
import ilog.cplex.CpxControlCallback;
import ilog.cplex.CpxCutArrayGoal;
import ilog.cplex.CpxCutCallback;
import ilog.cplex.CpxCutGoal;
import ilog.cplex.CpxDisjunctiveCutCallback;
import ilog.cplex.CpxDisjunctiveCutInfoCallback;
import ilog.cplex.CpxException;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxFailGoal;
import ilog.cplex.CpxFlowMIRCutCallback;
import ilog.cplex.CpxFlowMIRCutInfoCallback;
import ilog.cplex.CpxFractionalCutCallback;
import ilog.cplex.CpxFractionalCutInfoCallback;
import ilog.cplex.CpxGlobalCutArrayGoal;
import ilog.cplex.CpxGlobalCutGoal;
import ilog.cplex.CpxHeuristicCallback;
import ilog.cplex.CpxIfThen;
import ilog.cplex.CpxIncumbentCallback;
import ilog.cplex.CpxIntSetVar;
import ilog.cplex.CpxLPCallback;
import ilog.cplex.CpxLPMatrix;
import ilog.cplex.CpxLimitSearchGoal;
import ilog.cplex.CpxMIPCallback;
import ilog.cplex.CpxMIPInfoCallback;
import ilog.cplex.CpxNetworkCallback;
import ilog.cplex.CpxNode;
import ilog.cplex.CpxNodeCallback;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxNumVarBound;
import ilog.cplex.CpxObjective;
import ilog.cplex.CpxOrGoal;
import ilog.cplex.CpxProbingCallback;
import ilog.cplex.CpxProbingInfoCallback;
import ilog.cplex.CpxRange;
import ilog.cplex.CpxSOS;
import ilog.cplex.CpxSolutionGoal;
import ilog.cplex.CpxSolveCallback;
import ilog.cplex.CpxTuningCallback;
import ilog.cplex.EvalVisitor;
import ilog.cplex.IloCplexModeler;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class IloCplex
extends IloCplexModeler {
    static final String IBM_COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5725-A06 5725-A29 5724-Y48 5724-Y49 5724-Y54 5724-Y55 5655-Y21\nCopyright IBM Corp. 2001, 2017. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final long serialVersionUID = 12080000L;
    CplexI _cplexi;
    private IloCopyManager _copier;
    public static final int IncumbentId = -1;
    private DeleteMode _deleteMode = DeleteMode.LeaveBasis;
    public static final String CPX_BENDERS_ANNOTATION = "cpxBendersPartition";
    public static final int CPX_BENDERS_MASTERVALUE = 0;
    private static final AnnotationTraits<LongAnnotation, Long, long[]> LONG_TRAITS = new AnnotationTraits<LongAnnotation, Long, long[]>(){

        @Override
        public int delIndex(long l, long l2, int n) {
            return Cplex.CPXdellongannotation(l, l2, n);
        }

        @Override
        public LongAnnotation newInstance(CplexIndex cplexIndex) {
            return new LongAnnotation(cplexIndex);
        }

        @Override
        public int create(long l, long l2, String string, Long l3) {
            return Cplex.CPXnewlongannotation(l, l2, string, l3);
        }

        @Override
        public int getIndex(long l, long l2, String string, int[] nArray) {
            return Cplex.CPXgetlongannotationindex(l, l2, string, nArray);
        }

        @Override
        public int getDefault(long l, long l2, int n, long[] lArray) {
            return Cplex.CPXgetlongannotationdefval(l, l2, n, lArray);
        }

        @Override
        public int getAnnotation(long l, long l2, int n, int n2, long[] lArray, int n3) {
            return Cplex.CPXgetlongannotations(l, l2, n, n2, lArray, n3, n3);
        }

        @Override
        public long[] makeBuffer(int n) {
            return new long[n];
        }

        @Override
        public void copyBuffer(long[] lArray, int n, long[] lArray2, int n2, int n3) {
            System.arraycopy(lArray, n, lArray2, n2, n3);
        }

        @Override
        public int setAnnotation(long l, long l2, int n, int n2, int n3, int[] nArray, long[] lArray) {
            return Cplex.CPXsetlongannotations(l, l2, n, n2, n3, nArray, lArray);
        }

        @Override
        public int getName(long l, long l2, int n, String[] stringArray) {
            return Cplex.CPXgetlongannotationname(l, l2, n, stringArray);
        }

        @Override
        public int count(long l, long l2) {
            return Cplex.CPXgetnumlongannotations(l, l2);
        }

        @Override
        public Long dereference(long[] lArray) {
            return new Long(lArray[0]);
        }

        @Override
        public void delIndicator(long l, long l2) {
            int n = this.count(l, l2);
            if (n <= 0) {
                return;
            }
            int n2 = Cplex.CPXgetnumindconstrs(l, l2);
            if (n2 <= 0) {
                return;
            }
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = i;
            }
            long[] lArray = new long[n2];
            long[] lArray2 = new long[1];
            for (int i = 0; i < n; ++i) {
                if (this.getDefault(l, l2, i, lArray2) != 0) continue;
                Arrays.fill(lArray, lArray2[0]);
                Cplex.CPXsetlongannotations(l, l2, i, 4, n2, nArray, lArray);
            }
        }
    };
    private final transient AnnotationList<LongAnnotation, Long, long[]> longAnnotations = new AnnotationList<LongAnnotation, Long, long[]>(LONG_TRAITS);
    private static final AnnotationTraits<DoubleAnnotation, Double, double[]> DOUBLE_TRAITS = new AnnotationTraits<DoubleAnnotation, Double, double[]>(){

        @Override
        public int delIndex(long l, long l2, int n) {
            return Cplex.CPXdeldblannotation(l, l2, n);
        }

        @Override
        public DoubleAnnotation newInstance(CplexIndex cplexIndex) {
            return new DoubleAnnotation(cplexIndex);
        }

        @Override
        public int create(long l, long l2, String string, Double d) {
            return Cplex.CPXnewdblannotation(l, l2, string, d);
        }

        @Override
        public int getIndex(long l, long l2, String string, int[] nArray) {
            return Cplex.CPXgetdblannotationindex(l, l2, string, nArray);
        }

        @Override
        public int getDefault(long l, long l2, int n, double[] dArray) {
            return Cplex.CPXgetdblannotationdefval(l, l2, n, dArray);
        }

        @Override
        public int getAnnotation(long l, long l2, int n, int n2, double[] dArray, int n3) {
            return Cplex.CPXgetdblannotations(l, l2, n, n2, dArray, n3, n3);
        }

        @Override
        public double[] makeBuffer(int n) {
            return new double[n];
        }

        @Override
        public void copyBuffer(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            System.arraycopy(dArray, n, dArray2, n2, n3);
        }

        @Override
        public int setAnnotation(long l, long l2, int n, int n2, int n3, int[] nArray, double[] dArray) {
            return Cplex.CPXsetdblannotations(l, l2, n, n2, n3, nArray, dArray);
        }

        @Override
        public int getName(long l, long l2, int n, String[] stringArray) {
            return Cplex.CPXgetdblannotationname(l, l2, n, stringArray);
        }

        @Override
        public int count(long l, long l2) {
            return Cplex.CPXgetnumdblannotations(l, l2);
        }

        @Override
        public Double dereference(double[] dArray) {
            return new Double(dArray[0]);
        }

        @Override
        public void delIndicator(long l, long l2) {
            int n = this.count(l, l2);
            if (n <= 0) {
                return;
            }
            int n2 = Cplex.CPXgetnumindconstrs(l, l2);
            if (n2 <= 0) {
                return;
            }
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = i;
            }
            double[] dArray = new double[n2];
            double[] dArray2 = new double[1];
            for (int i = 0; i < n; ++i) {
                if (this.getDefault(l, l2, i, dArray2) != 0) continue;
                Arrays.fill(dArray, dArray2[0]);
                Cplex.CPXsetdblannotations(l, l2, i, 4, n2, nArray, dArray);
            }
        }
    };
    private final transient AnnotationList<DoubleAnnotation, Double, double[]> doubleAnnotations = new AnnotationList<DoubleAnnotation, Double, double[]>(DOUBLE_TRAITS);

    @Override
    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        throw check;
    }

    public IloCopyable getCopy(IloCopyable iloCopyable) throws IloException {
        return iloCopyable.makeCopy(this._copier);
    }

    @Override
    public void setModel(IloModel iloModel) throws IloException {
        this._model.uninstallCon();
        super.setModel(iloModel);
        this._model.installCon(this._cplexi);
    }

    public void deleteNames() throws IloException {
        this._model.setName(null);
        this._cplexi.deleteNames();
    }

    public IloRange addUserCut(IloRange iloRange) throws IloException {
        IloRange[] iloRangeArray = new IloRange[]{iloRange};
        this.addUserCuts(iloRangeArray, 0, 1);
        return iloRange;
    }

    public IloRange[] addUserCuts(IloRange[] iloRangeArray) throws IloException {
        return this.addUserCuts(iloRangeArray, 0, iloRangeArray.length);
    }

    public IloRange[] addUserCuts(IloRange[] iloRangeArray, int n, int n2) throws IloException {
        this._cplexi.addCuts(iloRangeArray, n, n2, 0);
        return iloRangeArray;
    }

    public void clearUserCuts() throws IloException {
        this._cplexi.delCuts(0);
    }

    public IloRange addLazyConstraint(IloRange iloRange) throws IloException {
        IloRange[] iloRangeArray = new IloRange[]{iloRange};
        this.addLazyConstraints(iloRangeArray, 0, 1);
        return iloRange;
    }

    public IloRange[] addLazyConstraints(IloRange[] iloRangeArray) throws IloException {
        return this.addLazyConstraints(iloRangeArray, 0, iloRangeArray.length);
    }

    public IloRange[] addLazyConstraints(IloRange[] iloRangeArray, int n, int n2) throws IloException {
        this._cplexi.addCuts(iloRangeArray, n, n2, 1);
        return iloRangeArray;
    }

    public void clearLazyConstraints() throws IloException {
        this._cplexi.delCuts(1);
    }

    public IloRange addCut(IloRange iloRange) throws IloException {
        return this.addLazyConstraint(iloRange);
    }

    public IloRange[] addCuts(IloRange[] iloRangeArray) throws IloException {
        return this.addLazyConstraints(iloRangeArray, 0, iloRangeArray.length);
    }

    public IloRange[] addCuts(IloRange[] iloRangeArray, int n, int n2) throws IloException {
        return this.addLazyConstraints(iloRangeArray, n, n2);
    }

    public void clearCuts() throws IloException {
        this.clearLazyConstraints();
    }

    public void exportModel(String string) throws IloException {
        this._cplexi.exportModel(string, this);
    }

    public void importModel(String string) throws IloException {
        CplexI.importModel(string, this);
    }

    public void clearModel() throws IloException {
        this._model.emptyModel();
    }

    public void endModel() throws IloException {
        this._model.endAll();
        this._cplexi.endModel();
    }

    public void end(IloAddable[] iloAddableArray, int n, int n2) throws IloException {
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        IloCopyable[] iloCopyableArray = new CpxNumVar[n2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (iloAddableArray[i + n] instanceof CpxRange) {
                cpxRangeArray[n3++] = (CpxRange)iloAddableArray[i + n];
                continue;
            }
            if (iloAddableArray[i + n] instanceof CpxNumVar) {
                iloCopyableArray[n4++] = (CpxNumVar)iloAddableArray[i + n];
                continue;
            }
            ((CpxExtractable)iloAddableArray[i + n]).end();
        }
        if (n3 > 0) {
            CpxRange.end(cpxRangeArray, n3);
        }
        if (n4 > 0) {
            this.delete(iloCopyableArray, 0, n4);
        }
    }

    public void end(IloAddable[] iloAddableArray) throws IloException {
        this.end(iloAddableArray, 0, iloAddableArray.length);
    }

    public void end(IloAddable iloAddable) throws IloException {
        IloAddable[] iloAddableArray = new IloAddable[]{iloAddable};
        this.end(iloAddableArray);
    }

    public int getNcols() {
        return this._cplexi == null ? 0 : this._cplexi.getNcols();
    }

    public int getNrows() {
        return this._cplexi == null ? 0 : this._cplexi.getNrows();
    }

    public int getNQCs() {
        return this._cplexi == null ? 0 : this._cplexi.getNQCs();
    }

    public int getNSOS1() {
        return this._model._sos1.size();
    }

    public int getNSOS2() {
        return this._model._sos2.size();
    }

    public int getNSOSs() {
        return this._cplexi == null ? 0 : this._cplexi.getNSOSs();
    }

    public int getNindicators() {
        return this._cplexi == null ? 0 : this._cplexi._getNinds();
    }

    public int getNLCs() {
        return this._cplexi == null ? 0 : this._cplexi._getNLCs();
    }

    public int getNUCs() {
        return this._cplexi == null ? 0 : this._cplexi._getNUCs();
    }

    public int getNNZs() {
        return this._cplexi == null ? 0 : this._cplexi.getNNZs();
    }

    public int getNintVars() {
        return this._cplexi == null ? 0 : this._cplexi.getNintVars();
    }

    public int getNbinVars() {
        return this._cplexi == null ? 0 : this._cplexi.getNbinVars();
    }

    public int getNsemiContVars() {
        return this._cplexi == null ? 0 : this._cplexi.getNsemiContVars();
    }

    public int getNsemiIntVars() {
        return this._cplexi == null ? 0 : this._cplexi.getNsemiIntVars();
    }

    public boolean isMIP() {
        return this._cplexi.isMIP();
    }

    public boolean isQO() {
        return this._cplexi.isQO();
    }

    public boolean isQC() {
        return this._cplexi.isQC();
    }

    static Status makeStatus(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 1: 
            case 5: 
            case 102: 
            case 129: 
            case 130: {
                return Status.Optimal;
            }
            case 3: 
            case 15: 
            case 17: 
            case 19: 
            case 31: {
                return Status.Infeasible;
            }
            case 30: {
                return Status.Feasible;
            }
            case 6: 
            case 14: 
            case 16: 
            case 18: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return Status.Unknown;
            }
            case 2: 
            case 133: {
                return Status.Unbounded;
            }
            case 23: 
            case 104: 
            case 105: 
            case 109: 
            case 111: 
            case 116: 
            case 128: {
                if (bl2) {
                    return Status.Optimal;
                }
                return Status.Feasible;
            }
            case 4: {
                return Status.InfeasibleOrUnbounded;
            }
            case 10: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 25: 
            case 106: 
            case 110: 
            case 112: 
            case 117: 
            case 126: {
                if (bl && bl2) {
                    return Status.Optimal;
                }
                if (bl) {
                    return Status.Feasible;
                }
                if (bl2) {
                    return Status.Bounded;
                }
                return Status.Unknown;
            }
            case 24: {
                if (bl) {
                    return Status.Feasible;
                }
                return Status.Unknown;
            }
            case 0: {
                return Status.Unknown;
            }
        }
        return Status.Error;
    }

    public Status getStatus() throws IloException {
        return IloCplex.makeStatus(this.getCplexIntStatus(), this._cplexi.isPfeas(), this._cplexi.isDfeas());
    }

    public boolean isPrimalFeasible() throws IloException {
        return this._cplexi.isPfeas();
    }

    public boolean isDualFeasible() throws IloException {
        return this._cplexi.isDfeas();
    }

    public void setParam(IntParam intParam, int n) throws IloException {
        this._cplexi.setIntParam(intParam.getValue(), n);
    }

    public int getParam(IntParam intParam) throws IloException {
        return this._cplexi.getIntParam(intParam.getValue());
    }

    public int getMin(IntParam intParam) throws IloException {
        return this._cplexi.minIntParam(intParam.getValue());
    }

    public int getMax(IntParam intParam) throws IloException {
        return this._cplexi.maxIntParam(intParam.getValue());
    }

    public int getDefault(IntParam intParam) throws IloException {
        return this._cplexi.defIntParam(intParam.getValue());
    }

    public void setParam(LongParam longParam, long l) throws IloException {
        if (this._cplexi.getParamType(longParam.getValue()) == 1) {
            this._cplexi.setIntParam(longParam.getValue(), CplexI.truncateLong(l));
        } else {
            this._cplexi.setLongParam(longParam.getValue(), l);
        }
    }

    public long getParam(LongParam longParam) throws IloException {
        if (this._cplexi.getParamType(longParam.getValue()) == 1) {
            return this._cplexi.getIntParam(longParam.getValue());
        }
        return this._cplexi.getLongParam(longParam.getValue());
    }

    public long getMin(LongParam longParam) throws IloException {
        if (this._cplexi.getParamType(longParam.getValue()) == 1) {
            return this._cplexi.minIntParam(longParam.getValue());
        }
        return this._cplexi.minLongParam(longParam.getValue());
    }

    public long getMax(LongParam longParam) throws IloException {
        if (this._cplexi.getParamType(longParam.getValue()) == 1) {
            return this._cplexi.maxIntParam(longParam.getValue());
        }
        return this._cplexi.maxLongParam(longParam.getValue());
    }

    public long getDefault(LongParam longParam) throws IloException {
        if (this._cplexi.getParamType(longParam.getValue()) == 1) {
            return this._cplexi.defIntParam(longParam.getValue());
        }
        return this._cplexi.defLongParam(longParam.getValue());
    }

    public void setParam(BooleanParam booleanParam, boolean bl) throws IloException {
        if (bl) {
            this._cplexi.setIntParam(booleanParam.getValue(), 1);
        } else {
            this._cplexi.setIntParam(booleanParam.getValue(), 0);
        }
    }

    public boolean getParam(BooleanParam booleanParam) throws IloException {
        return this._cplexi.getIntParam(booleanParam.getValue()) == 1;
    }

    public boolean getDefault(BooleanParam booleanParam) throws IloException {
        return this._cplexi.defIntParam(booleanParam.getValue()) == 1;
    }

    public void setParam(DoubleParam doubleParam, double d) throws IloException {
        this._cplexi.setDoubleParam(doubleParam.getValue(), d);
    }

    public double getParam(DoubleParam doubleParam) throws IloException {
        return this._cplexi.getDoubleParam(doubleParam.getValue());
    }

    public double getMin(DoubleParam doubleParam) throws IloException {
        return this._cplexi.minDoubleParam(doubleParam.getValue());
    }

    public double getMax(DoubleParam doubleParam) throws IloException {
        return this._cplexi.maxDoubleParam(doubleParam.getValue());
    }

    public double getDefault(DoubleParam doubleParam) throws IloException {
        return this._cplexi.defDoubleParam(doubleParam.getValue());
    }

    public void setParam(StringParam stringParam, String string) throws IloException {
        this._cplexi.setStringParam(stringParam.getValue(), string);
    }

    public String getParam(StringParam stringParam) throws IloException {
        return this._cplexi.getStringParam(stringParam.getValue());
    }

    public String getDefault(StringParam stringParam) throws IloException {
        return this._cplexi.defStringParam(stringParam.getValue());
    }

    public void setDefaults() throws IloException {
        if (this._cplexi != null) {
            this._cplexi.setDefaults();
        }
    }

    public ParameterSet getParameterSet() throws IloException {
        return this._cplexi.getParameterSet();
    }

    public void setParameterSet(ParameterSet parameterSet) throws IloException {
        this._cplexi.setParameterSet(parameterSet);
    }

    public String getVersion() throws IloException {
        return this._cplexi == null ? "" : this._cplexi.getVersion();
    }

    public int getVersionNumber() throws IloException {
        return this._cplexi == null ? 0 : this._cplexi.getVersionNumber();
    }

    public void setDeleteMode(DeleteMode deleteMode) {
        this._deleteMode = deleteMode;
        if (this._deleteMode == DeleteMode.FixBasis) {
            this._cplexi.setFixBasis(true);
        } else {
            this._cplexi.setFixBasis(false);
        }
    }

    public DeleteMode getDeleteMode() {
        return this._deleteMode;
    }

    public CplexStatus getCplexStatus() throws IloException {
        return CplexStatus.getStatus(this._cplexi.getCplexStatus());
    }

    final int getCplexIntStatus() throws IloException {
        return this.getCplexStatus().getValue();
    }

    public CplexStatus getCplexSubStatus() throws IloException {
        int n = this._cplexi.getCplexSubStatus();
        return CplexStatus.getStatus(n);
    }

    public int getAlgorithm() {
        return this._cplexi.getMethod();
    }

    public int getSubAlgorithm() {
        return this._cplexi.getSubMethod();
    }

    public double getObjValue() throws IloException {
        return this._cplexi.getObjValue();
    }

    public double getObjValue(int n) throws IloException {
        return this._cplexi.getObjValue(n);
    }

    public double getBestObjValue() throws IloException {
        return this._cplexi.getBestObjValue();
    }

    public double getMIPRelativeGap() throws IloException {
        return this._cplexi.getMIPRelativeGap();
    }

    public double getCutoff() throws IloException {
        return this._cplexi.getCutoff();
    }

    public double[] getValues(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getValues(iloLPMatrix, 0, iloLPMatrix.getNcols());
    }

    public double[] getValues(IloLPMatrix iloLPMatrix, int n) throws UnknownObjectException, IloException {
        return this.getValues(iloLPMatrix, 0, iloLPMatrix.getNcols(), n);
    }

    public double[] getValues(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        return this.getValues(cpxLPMatrix._var, n, n2);
    }

    public double[] getValues(IloLPMatrix iloLPMatrix, int n, int n2, int n3) throws UnknownObjectException, IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        return this.getValues(cpxLPMatrix._var, n, n2, n3);
    }

    public double getValue(IloNumVar iloNumVar) throws UnknownObjectException, IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
            throw new UnknownObjectException(cpxNumVar);
        }
        return this._cplexi.getXcache()[cpxNumVar.getVarIndexValue()];
    }

    public double getValue(IloNumVar iloNumVar, int n) throws UnknownObjectException, IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
            throw new UnknownObjectException(cpxNumVar);
        }
        if (n == -1) {
            return this._cplexi.getXcache()[cpxNumVar.getVarIndexValue()];
        }
        IloNumVar[] iloNumVarArray = new IloNumVar[]{iloNumVar};
        return this.getValues(iloNumVarArray, 0, 1, n)[0];
    }

    public double[] getValues(IloNumVar[] iloNumVarArray) throws UnknownObjectException, IloException {
        return this.getValues(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public double[] getValues(IloNumVar[] iloNumVarArray, int n) throws UnknownObjectException, IloException {
        return this.getValues(iloNumVarArray, 0, iloNumVarArray.length, n);
    }

    public double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2) throws UnknownObjectException, IloException {
        double[] dArray = this._cplexi.getXcache();
        double[] dArray2 = new double[n2];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
            if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
                throw new UnknownObjectException(cpxNumVar);
            }
            dArray2[i - n] = dArray[cpxNumVar.getVarIndexValue()];
        }
        return dArray2;
    }

    public double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2, int n3) throws UnknownObjectException, IloException {
        return this._cplexi.getValues(iloNumVarArray, n, n2, n3);
    }

    public double[] getReducedCosts(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getReducedCosts(iloLPMatrix, 0, iloLPMatrix.getNcols());
    }

    public double[] getReducedCosts(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        return this.getReducedCosts(cpxLPMatrix._var, n, n2);
    }

    public double getReducedCost(IloNumVar iloNumVar) throws UnknownObjectException, IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
            throw new UnknownObjectException(cpxNumVar);
        }
        double[] dArray = this._cplexi.getReducedCosts(cpxNumVar.getVarIndexValue(), cpxNumVar.getVarIndexValue());
        return dArray[0];
    }

    public double getInfeasibility(IloNumVar iloNumVar) throws UnknownObjectException, IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
            throw new UnknownObjectException(cpxNumVar);
        }
        double[] dArray = this._cplexi.getColInfeasibilities(cpxNumVar.getVarIndexValue(), cpxNumVar.getVarIndexValue());
        return dArray[0];
    }

    public double[] getReducedCosts(IloNumVar[] iloNumVarArray) throws UnknownObjectException, IloException {
        return this.getReducedCosts(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public double[] getInfeasibilities(IloNumVar[] iloNumVarArray) throws UnknownObjectException, IloException {
        return this.getInfeasibilities(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public double[] getReducedCosts(IloNumVar[] iloNumVarArray, int n, int n2) throws UnknownObjectException, IloException {
        double[] dArray = this._cplexi.getReducedCosts(0, this.getNcols() - 1);
        double[] dArray2 = new double[n2];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
            if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
                throw new UnknownObjectException(cpxNumVar);
            }
            dArray2[i - n] = dArray[cpxNumVar.getVarIndexValue()];
        }
        return dArray2;
    }

    public double[] getInfeasibilities(IloNumVar[] iloNumVarArray, int n, int n2) throws UnknownObjectException, IloException {
        double[] dArray = this._cplexi.getColInfeasibilities(0, this.getNcols() - 1);
        double[] dArray2 = new double[n2];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
            if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
                throw new UnknownObjectException(cpxNumVar);
            }
            dArray2[i - n] = dArray[cpxNumVar.getVarIndexValue()];
        }
        return dArray2;
    }

    public double[] getDuals(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getDuals(iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public double[] getDuals(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        return this.getDuals(((CpxLPMatrix)iloLPMatrix)._row, n, n2);
    }

    public double getDual(IloRange iloRange) throws UnknownObjectException, IloException {
        CpxRange cpxRange = (CpxRange)iloRange;
        if (cpxRange.isQC()) {
            throw new CpxException(1031, this._cplexi.getErrorMessage(1031));
        }
        int n = cpxRange.getIndexValue();
        if (n < 0) {
            throw new UnknownObjectException(cpxRange);
        }
        return this._cplexi.getPi(n, n)[0];
    }

    public double[] getDuals(IloRange[] iloRangeArray) throws UnknownObjectException, IloException {
        return this.getDuals(iloRangeArray, 0, iloRangeArray.length);
    }

    public double[] getDuals(IloRange[] iloRangeArray, int n, int n2) throws UnknownObjectException, IloException {
        if (n2 <= 0) {
            return null;
        }
        int n3 = this.getNrows();
        int n4 = -1;
        int n5 = n + n2;
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = n; i < n5; ++i) {
            cpxRangeArray[i - n] = (CpxRange)iloRangeArray[i];
            if (cpxRangeArray[i - n].isQC()) {
                throw new CpxException(1031, this._cplexi.getErrorMessage(1031));
            }
            int n6 = cpxRangeArray[i - n].getIndexValue();
            if (n6 < 0) {
                throw new UnknownObjectException(iloRangeArray[i]);
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (n6 >= n3) continue;
            n3 = n6;
        }
        double[] dArray = this._cplexi.getPi(n3, n4);
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[cpxRangeArray[i].getIndexValue() - n3];
        }
        return dArray2;
    }

    public double[] getSlacks(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getSlacks(iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public double[] getSlacks(IloLPMatrix iloLPMatrix, int n) throws UnknownObjectException, IloException {
        return this.getSlacks(iloLPMatrix, 0, iloLPMatrix.getNrows(), n);
    }

    public double[] getInfeasibilities(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getInfeasibilities(iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public double[] getSlacks(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        return this.getSlacks(((CpxLPMatrix)iloLPMatrix)._row, n, n2);
    }

    public double[] getSlacks(IloLPMatrix iloLPMatrix, int n, int n2, int n3) throws UnknownObjectException, IloException {
        return this.getSlacks(((CpxLPMatrix)iloLPMatrix)._row, n, n2, n3);
    }

    public double[] getInfeasibilities(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        IloConstraint[] iloConstraintArray = cpxLPMatrix.getRanges();
        return this.getInfeasibilities(iloConstraintArray, n, n2);
    }

    public double getSlack(IloRange iloRange) throws UnknownObjectException, IloException {
        IloRange[] iloRangeArray = new IloRange[]{iloRange};
        return this.getSlacks(iloRangeArray, 0, 1)[0];
    }

    public double getSlack(IloRange iloRange, int n) throws UnknownObjectException, IloException {
        IloRange[] iloRangeArray = new IloRange[]{iloRange};
        return this.getSlacks(iloRangeArray, 0, 1, n)[0];
    }

    public double getInfeasibility(IloConstraint iloConstraint) throws UnknownObjectException, IloException {
        IloConstraint[] iloConstraintArray = new IloConstraint[]{iloConstraint};
        return this.getInfeasibilities(iloConstraintArray, 0, 1)[0];
    }

    public double[] getSlacks(IloRange[] iloRangeArray) throws UnknownObjectException, IloException {
        return this.getSlacks(iloRangeArray, 0, iloRangeArray.length);
    }

    public double[] getSlacks(IloRange[] iloRangeArray, int n) throws UnknownObjectException, IloException {
        return this.getSlacks(iloRangeArray, 0, iloRangeArray.length, n);
    }

    public double[] getInfeasibilities(IloConstraint[] iloConstraintArray) throws UnknownObjectException, IloException {
        return this.getInfeasibilities(iloConstraintArray, 0, iloConstraintArray.length);
    }

    public double[] getSlacks(IloRange[] iloRangeArray, int n, int n2) throws UnknownObjectException, IloException {
        return this.getSlacks(iloRangeArray, n, n2, -1);
    }

    public double[] getSlacks(IloRange[] iloRangeArray, int n, int n2, int n3) throws UnknownObjectException, IloException {
        int n4;
        if (n2 <= 0) {
            return null;
        }
        int n5 = this.getNrows();
        int n6 = -1;
        int n7 = n + n2;
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        double[] dArray = new double[n2];
        for (int i = n; i < n7; ++i) {
            cpxRangeArray[i - n] = (CpxRange)iloRangeArray[i];
            if (cpxRangeArray[i - n].isQC()) {
                dArray[i] = this._cplexi.getQCSlack(cpxRangeArray[i - n].getIndexValue(), n3);
                continue;
            }
            n4 = cpxRangeArray[i - n].getIndexValue();
            if (n4 < 0) {
                throw new UnknownObjectException(iloRangeArray[i]);
            }
            if (n4 > n6) {
                n6 = n4;
            }
            if (n4 >= n5) continue;
            n5 = n4;
        }
        if (n5 <= n6) {
            double[] dArray2 = this._cplexi.getSlacks(n5, n6, n3);
            for (n4 = 0; n4 < n2; ++n4) {
                if (cpxRangeArray[n4].isQC()) continue;
                dArray[n4] = dArray2[cpxRangeArray[n4].getIndexValue() - n5];
            }
        }
        return dArray;
    }

    public double[] getInfeasibilities(IloConstraint[] iloConstraintArray, int n, int n2) throws UnknownObjectException, IloException {
        if (n2 <= 0) {
            return null;
        }
        return this._cplexi.getInfeasibilities(iloConstraintArray, n, n2);
    }

    public double getValue(IloNumExpr iloNumExpr) throws IloException {
        EvalVisitor evalVisitor = new EvalVisitor(this._cplexi.getXcache());
        CpxNumExpr cpxNumExpr = (CpxNumExpr)iloNumExpr;
        cpxNumExpr.accept(evalVisitor);
        return evalVisitor.getValue();
    }

    public double getValue(IloNumExpr iloNumExpr, int n) throws IloException {
        int n2 = this.getNcols();
        double[] dArray = new double[n2];
        this._cplexi.getValuesForExpr(dArray, n);
        EvalVisitor evalVisitor = new EvalVisitor(dArray);
        CpxNumExpr cpxNumExpr = (CpxNumExpr)iloNumExpr;
        cpxNumExpr.accept(evalVisitor);
        return evalVisitor.getValue();
    }

    public double[] getAX(IloLPMatrix iloLPMatrix) throws UnknownObjectException, IloException {
        return this.getAX(iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public double[] getAX(IloLPMatrix iloLPMatrix, int n, int n2) throws UnknownObjectException, IloException {
        if (n2 <= 0) {
            return null;
        }
        int n3 = this.getNrows();
        int n4 = -1;
        int n5 = n + n2;
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        for (int i = n; i < n5; ++i) {
            int n6 = cpxLPMatrix._row[i].getIndexValue();
            if (n6 < 0) {
                throw new UnknownObjectException(iloLPMatrix);
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (n6 >= n3) continue;
            n3 = n6;
        }
        double[] dArray = this._cplexi.getAX(n3, n4);
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[cpxLPMatrix._row[n + i].getIndexValue() - n3];
        }
        return dArray2;
    }

    public double getAX(IloRange iloRange) throws UnknownObjectException, IloException {
        int n = ((CpxRange)iloRange).getIndexValue();
        if (n < 0) {
            throw new UnknownObjectException(iloRange);
        }
        return this._cplexi.getAX(n, n)[0];
    }

    public double[] getAX(IloRange[] iloRangeArray) throws UnknownObjectException, IloException {
        return this.getAX(iloRangeArray, 0, iloRangeArray.length);
    }

    public double[] getAX(IloRange[] iloRangeArray, int n, int n2) throws UnknownObjectException, IloException {
        if (n2 <= 0) {
            return null;
        }
        int n3 = this.getNrows();
        int n4 = -1;
        int n5 = n + n2;
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = n; i < n5; ++i) {
            cpxRangeArray[i - n] = (CpxRange)iloRangeArray[i];
            int n6 = cpxRangeArray[i - n].getIndexValue();
            if (n6 < 0) {
                throw new UnknownObjectException(iloRangeArray[i]);
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (n6 >= n3) continue;
            n3 = n6;
        }
        double[] dArray = this._cplexi.getAX(n3, n4);
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = dArray[cpxRangeArray[i].getIndexValue() - n3];
        }
        return dArray2;
    }

    public BasisStatus getBasisStatus(IloNumVar iloNumVar) throws IloException {
        return this._cplexi.getColumnBasis(((CpxNumVar)iloNumVar).getVarIndex());
    }

    public BasisStatus[] getBasisStatuses(IloNumVar[] iloNumVarArray) throws IloException {
        return this.getBasisStatuses(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public BasisStatus[] getBasisStatuses(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = new CplexIndex[n2];
        for (int i = 0; i < n2; ++i) {
            cplexIndexArray[i] = ((CpxNumVar)iloNumVarArray[i + n]).getVarIndex();
        }
        return this._cplexi.getColumnBasis(cplexIndexArray, 0, n2);
    }

    public BasisStatus getBasisStatus(IloConstraint iloConstraint) throws IloException {
        return this._cplexi.getRowBasis(((CpxRange)iloConstraint).getIndex());
    }

    public BasisStatus[] getBasisStatuses(IloConstraint[] iloConstraintArray) throws IloException {
        return this.getBasisStatuses(iloConstraintArray, 0, iloConstraintArray.length);
    }

    public BasisStatus[] getBasisStatuses(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = 0; i < n2; ++i) {
            cpxRangeArray[i] = (CpxRange)iloConstraintArray[i + n];
        }
        return this._cplexi.getRowBasis(cpxRangeArray, 0, n2);
    }

    public void setBasisStatuses(IloNumVar[] iloNumVarArray, BasisStatus[] basisStatusArray, IloRange[] iloRangeArray, BasisStatus[] basisStatusArray2) throws IloException {
        this.setBasisStatuses(iloNumVarArray, basisStatusArray, 0, iloNumVarArray.length, iloRangeArray, basisStatusArray2, 0, iloRangeArray.length);
    }

    public void setBasisStatuses(IloNumVar[] iloNumVarArray, BasisStatus[] basisStatusArray, int n, int n2, IloConstraint[] iloConstraintArray, BasisStatus[] basisStatusArray2, int n3, int n4) throws IloException {
        int n5;
        int n6 = n + n2;
        CplexIndex[] cplexIndexArray = new CplexIndex[n6];
        for (n5 = n; n5 < n6; ++n5) {
            cplexIndexArray[n5] = ((CpxNumVar)iloNumVarArray[n5]).getVarIndex();
        }
        n5 = n3 + n4;
        CplexIndex[] cplexIndexArray2 = new CplexIndex[n5];
        for (int i = n3; i < n5; ++i) {
            cplexIndexArray2[i] = ((CpxRange)iloConstraintArray[i]).getIndex();
        }
        this._cplexi.setBasis(cplexIndexArray, basisStatusArray, n, n2, cplexIndexArray2, basisStatusArray2, n3, n4);
    }

    public void setStart(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray) throws IloException {
        int n = iloNumVarArray != null ? iloNumVarArray.length : 0;
        int n2 = iloRangeArray != null ? iloRangeArray.length : 0;
        this.setStart(dArray, dArray2, iloNumVarArray, 0, n, dArray3, dArray4, iloRangeArray, 0, n2);
    }

    public void setStart(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, int n, int n2, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray, int n3, int n4) throws IloException {
        int n5 = iloNumVarArray != null ? n : 0;
        int n6 = iloNumVarArray != null ? n2 : 0;
        int n7 = iloRangeArray != null ? n3 : 0;
        int n8 = iloRangeArray != null ? n4 : 0;
        this._cplexi.setStart(dArray, dArray2, iloNumVarArray, n5, n6, dArray3, dArray4, iloRangeArray, n7, n8);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2, MIPStartEffort mIPStartEffort, String string) throws IloException {
        return this._cplexi.addMIPStart(iloNumVarArray, dArray, n, n2, mIPStartEffort, string);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, MIPStartEffort mIPStartEffort, String string) throws IloException {
        return this.addMIPStart(iloNumVarArray, dArray, 0, iloNumVarArray == null ? 0 : iloNumVarArray.length, mIPStartEffort, string);
    }

    public int addMIPStart(MIPStartEffort mIPStartEffort, String string) throws IloException {
        return this.addMIPStart(null, null, mIPStartEffort, string);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, MIPStartEffort mIPStartEffort) throws IloException {
        return this.addMIPStart(iloNumVarArray, dArray, mIPStartEffort, null);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        return this.addMIPStart(iloNumVarArray, dArray, MIPStartEffort.Auto, null);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, String string) throws IloException {
        return this.addMIPStart(iloNumVarArray, dArray, MIPStartEffort.Auto, string);
    }

    public int addMIPStart(MIPStartEffort mIPStartEffort) throws IloException {
        return this.addMIPStart(null, null, mIPStartEffort, null);
    }

    public int addMIPStart(String string) throws IloException {
        return this.addMIPStart(null, null, MIPStartEffort.Auto, string);
    }

    public int addMIPStart() throws IloException {
        return this.addMIPStart(null, null, MIPStartEffort.Auto, null);
    }

    public void changeMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray, int n2, int n3, MIPStartEffort mIPStartEffort) throws IloException {
        this._cplexi.changeMIPStart(n, iloNumVarArray, dArray, n2, n3, mIPStartEffort);
    }

    public void changeMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray, MIPStartEffort mIPStartEffort) throws IloException {
        this._cplexi.changeMIPStart(n, iloNumVarArray, dArray, 0, iloNumVarArray == null ? 0 : iloNumVarArray.length, mIPStartEffort);
    }

    public void deleteMIPStarts(int n, int n2) throws IloException {
        this._cplexi.deleteMIPStarts(n, n2);
    }

    public void deleteMIPStarts(int n) throws IloException {
        this._cplexi.deleteMIPStarts(n, 1);
    }

    public void changeMIPStart(int n, MIPStartEffort mIPStartEffort) throws IloException {
        this.changeMIPStart(n, null, null, mIPStartEffort);
    }

    public void changeMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this._cplexi.changeMIPStart(n, iloNumVarArray, dArray, 0, iloNumVarArray == null ? 0 : iloNumVarArray.length);
    }

    public int getNMIPStarts() throws IloException {
        return this._cplexi.getNMIPStarts();
    }

    public String getMIPStartName(int n) throws IloException {
        return this._cplexi.getMIPStartName(n);
    }

    public int getMIPStartIndex(String string) throws IloException {
        return this._cplexi.getMIPStartIndex(string);
    }

    public MIPStartEffort getMIPStart(int n, IloNumVar[] iloNumVarArray, int n2, int n3, double[] dArray, boolean[] blArray) throws IloException {
        CplexIndex[] cplexIndexArray = new CplexIndex[n3];
        for (int i = 0; i < n3; ++i) {
            cplexIndexArray[i] = ((CpxNumVar)iloNumVarArray[i + n2]).getVarIndex();
        }
        return this._cplexi.getMIPStart(n, cplexIndexArray, dArray, blArray);
    }

    public MIPStartEffort getMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray, boolean[] blArray) throws IloException {
        return this.getMIPStart(n, iloNumVarArray, 0, iloNumVarArray.length, dArray, blArray);
    }

    public MIPStartEffort getMIPStart(int n, IloNumVar[] iloNumVarArray, int n2, int n3, double[] dArray) throws IloException {
        return this.getMIPStart(n, iloNumVarArray, 0, iloNumVarArray.length, dArray, null);
    }

    public MIPStartEffort getMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        return this.getMIPStart(n, iloNumVarArray, 0, iloNumVarArray.length, dArray, null);
    }

    public MIPStartEffort getMIPStart(int n) throws IloException {
        return this._cplexi.getMIPStart(n, null, null, null);
    }

    public boolean feasOpt(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        return this._cplexi.feasOpt(iloConstraintArray, dArray);
    }

    public boolean feasOpt(IloRange[] iloRangeArray, double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, double[] dArray3, double[] dArray4) throws IloException {
        return this._cplexi.feasOpt(iloRangeArray, dArray, dArray2, iloNumVarArray, dArray3, dArray4);
    }

    public boolean feasOpt(IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2) throws IloException {
        return this.feasOpt(null, null, null, iloNumVarArray, dArray, dArray2);
    }

    public boolean feasOpt(IloRange[] iloRangeArray, double[] dArray, double[] dArray2) throws IloException {
        return this.feasOpt(iloRangeArray, dArray, dArray2, null, null, null);
    }

    public IloNumVarBound bound(IloNumVar iloNumVar, IloNumVarBoundType iloNumVarBoundType) {
        return new CpxNumVarBound(iloNumVar, iloNumVarBoundType);
    }

    public IloNumVarBound lowerBound(IloNumVar iloNumVar) {
        return new CpxNumVarBound(iloNumVar, 1);
    }

    public IloNumVarBound upperBound(IloNumVar iloNumVar) {
        return new CpxNumVarBound(iloNumVar, 2);
    }

    public boolean refineConflict(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        return this._cplexi.refineConflict(iloConstraintArray, dArray);
    }

    public boolean refineConflict(IloConstraint[] iloConstraintArray, double[] dArray, int n, int n2) throws IloException {
        return this._cplexi.refineConflict(iloConstraintArray, dArray, n, n2);
    }

    public boolean refineMIPStartConflict(int n, IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        return this._cplexi.refineMIPStartConflict(n, iloConstraintArray, dArray, 0, iloConstraintArray.length);
    }

    public boolean refineMIPStartConflict(int n, IloConstraint[] iloConstraintArray, double[] dArray, int n2, int n3) throws IloException {
        return this._cplexi.refineMIPStartConflict(n, iloConstraintArray, dArray, 0, iloConstraintArray.length);
    }

    public ConflictStatus[] getConflict(IloConstraint[] iloConstraintArray) throws IloException {
        return this._cplexi.getConflict(iloConstraintArray, 0, iloConstraintArray.length);
    }

    public ConflictStatus getConflict(IloConstraint iloConstraint) throws IloException {
        IloConstraint[] iloConstraintArray = new IloConstraint[]{iloConstraint};
        return this._cplexi.getConflict(iloConstraintArray, 0, 1)[0];
    }

    public ConflictStatus[] getConflict(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        return this._cplexi.getConflict(iloConstraintArray, n, n2);
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloLPMatrix iloLPMatrix) throws IloException {
        this.getBoundSA(dArray, dArray2, dArray3, dArray4, iloLPMatrix, 0, iloLPMatrix.getNcols());
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloLPMatrix iloLPMatrix, int n, int n2) throws IloException {
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloLPMatrix;
        this.getBoundSA(dArray, dArray2, dArray3, dArray4, cpxLPMatrix._var, n, n2);
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloNumVar[] iloNumVarArray) throws IloException {
        this.getBoundSA(dArray, dArray2, dArray3, dArray4, iloNumVarArray, 0, iloNumVarArray.length);
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = new CplexIndex[n2];
        for (int i = 0; i < n2; ++i) {
            cplexIndexArray[i] = ((CpxNumVar)iloNumVarArray[i + n]).getVarIndex();
        }
        this._cplexi.getBoundSA(dArray, dArray2, dArray3, dArray4, cplexIndexArray, 0, n2);
    }

    public void getObjSA(double[] dArray, double[] dArray2, IloLPMatrix iloLPMatrix) throws IloException {
        this.getObjSA(dArray, dArray2, iloLPMatrix, 0, iloLPMatrix.getNcols());
    }

    public void getObjSA(double[] dArray, double[] dArray2, IloLPMatrix iloLPMatrix, int n, int n2) throws IloException {
        this.getObjSA(dArray, dArray2, ((CpxLPMatrix)iloLPMatrix)._var, n, n2);
    }

    public void getObjSA(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray) throws IloException {
        this.getObjSA(dArray, dArray2, iloNumVarArray, 0, iloNumVarArray.length);
    }

    public void getObjSA(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = new CplexIndex[n2];
        for (int i = 0; i < n2; ++i) {
            cplexIndexArray[i] = ((CpxNumVar)iloNumVarArray[i + n]).getVarIndex();
        }
        this._cplexi.getObjSA(dArray, dArray2, cplexIndexArray, 0, n2);
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray) throws IloException {
        this.getRangeSA(dArray, dArray2, dArray3, dArray4, iloRangeArray, 0, iloRangeArray.length);
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray, int n, int n2) throws IloException {
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = 0; i < n2; ++i) {
            cpxRangeArray[i] = (CpxRange)iloRangeArray[i + n];
        }
        this._cplexi.getRangeSA(dArray, dArray2, dArray3, dArray4, cpxRangeArray, 0, n2);
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloLPMatrix iloLPMatrix, int n, int n2) throws IloException {
        this._cplexi.getRangeSA(dArray, dArray2, dArray3, dArray4, ((CpxLPMatrix)iloLPMatrix)._row, n, n2);
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, IloLPMatrix iloLPMatrix) throws IloException {
        this.getRangeSA(dArray, dArray2, dArray3, dArray4, iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public void getRHSSA(double[] dArray, double[] dArray2, IloRange[] iloRangeArray) throws IloException {
        this.getRHSSA(dArray, dArray2, iloRangeArray, 0, iloRangeArray.length);
    }

    public void getRHSSA(double[] dArray, double[] dArray2, IloRange[] iloRangeArray, int n, int n2) throws IloException {
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        for (int i = 0; i < n2; ++i) {
            cpxRangeArray[i] = (CpxRange)iloRangeArray[i + n];
        }
        this._cplexi.getRHSSA(dArray, dArray2, cpxRangeArray, 0, n2);
    }

    public void getRHSSA(double[] dArray, double[] dArray2, IloLPMatrix iloLPMatrix) throws IloException {
        this.getRHSSA(dArray, dArray2, iloLPMatrix, 0, iloLPMatrix.getNrows());
    }

    public void getRHSSA(double[] dArray, double[] dArray2, IloLPMatrix iloLPMatrix, int n, int n2) throws IloException {
        this._cplexi.getRHSSA(dArray, dArray2, ((CpxLPMatrix)iloLPMatrix)._row, n, n2);
    }

    public Quality getQuality(QualityType qualityType) throws IloException {
        Quality quality = this._cplexi.getQuality(qualityType.getValue(), -1);
        quality.type = qualityType;
        return quality;
    }

    public Quality getQuality(QualityType qualityType, int n) throws IloException {
        Quality quality = this._cplexi.getQuality(qualityType.getValue(), n);
        quality.type = qualityType;
        return quality;
    }

    public IloIntSet getIntSetValue(IloIntSetVar iloIntSetVar) throws UnknownObjectException, IloException {
        return this._cplexi.getIntSetValue((CpxIntSetVar)iloIntSetVar);
    }

    private IloCplex(boolean bl, String string, String[] stringArray) throws IloException {
        this._cplexi = new CplexI(bl, string, stringArray);
        this._copier = new IloCopyManager(this);
        this.setCplexI(this._cplexi);
        this._cplexi.setIloCplex(this);
    }

    public IloCplex() throws IloException {
        this(false, null, null);
    }

    public IloCplex(String string, String[] stringArray) throws IloException {
        this(true, string, stringArray);
    }

    public PrintStream output() {
        return this._cplexi.output();
    }

    public PrintStream warning() {
        return this._cplexi.warning();
    }

    public void setOut(OutputStream outputStream) {
        this._cplexi.setOut(outputStream);
    }

    public void setWarning(OutputStream outputStream) {
        this._cplexi.setWarning(outputStream);
    }

    public boolean solve() throws IloException {
        this._cplexi.solve();
        return this._cplexi.isPfeas();
    }

    public boolean solveFixed() throws IloException {
        this._cplexi.solveFixed(-1);
        return this._cplexi.isPfeas();
    }

    public boolean solveFixed(int n) throws IloException {
        this._cplexi.solveFixed(n);
        return this._cplexi.isPfeas();
    }

    public int tuneParam() throws IloException {
        return this._cplexi.tuneParam(null);
    }

    public int tuneParam(ParameterSet parameterSet) throws IloException {
        return this._cplexi.tuneParam(parameterSet);
    }

    public int tuneParam(String[] stringArray) throws IloException {
        return this._cplexi.tuneParam(stringArray, null);
    }

    public int tuneParam(String[] stringArray, ParameterSet parameterSet) throws IloException {
        return this._cplexi.tuneParam(stringArray, parameterSet);
    }

    public long getNiterations64() {
        return this._cplexi == null ? 0L : this._cplexi.getNiterations();
    }

    public long getNphaseOneIterations64() {
        return this._cplexi == null ? 0L : this._cplexi.getNphaseOneIterations();
    }

    public long getNbarrierIterations64() {
        return this._cplexi == null ? 0L : this._cplexi.getNbarrierIterations();
    }

    public long getNsiftingIterations64() {
        return this._cplexi == null ? 0L : this._cplexi.getNsiftingIterations();
    }

    public long getNsiftingPhaseOneIterations64() {
        return this._cplexi == null ? 0L : this._cplexi.getNsiftingPhaseOneIterations();
    }

    public long getNcrossDExch64() {
        return this._cplexi == null ? 0L : this._cplexi.getNcrossDExch();
    }

    public long getNcrossDPush64() {
        return this._cplexi == null ? 0L : this._cplexi.getNcrossDPush();
    }

    public long getNcrossPExch64() {
        return this._cplexi == null ? 0L : this._cplexi.getNcrossPExch();
    }

    public long getNcrossPPush64() {
        return this._cplexi == null ? 0L : this._cplexi.getNcrossPPush();
    }

    public int getNiterations() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNiterations());
    }

    public int getNphaseOneIterations() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNphaseOneIterations());
    }

    public int getNbarrierIterations() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNbarrierIterations());
    }

    public int getNsiftingIterations() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNsiftingIterations());
    }

    public int getNsiftingPhaseOneIterations() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNsiftingPhaseOneIterations());
    }

    public int getNcrossDExch() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNcrossDExch());
    }

    public int getNcrossDPush() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNcrossDPush());
    }

    public int getNcrossPExch() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNcrossPExch());
    }

    public int getNcrossPPush() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNcrossPPush());
    }

    public int getNdualSuperbasics() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNdualSuperbasics());
    }

    public int getNprimalSuperbasics() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNprimalSuperbasics());
    }

    public int getNnodes() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNnodes());
    }

    public int getNnodesLeft() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getNnodesLeft());
    }

    public int getIncumbentNode() {
        return this._cplexi == null ? 0 : CplexI.truncateLong(this._cplexi.getIncumbentNode());
    }

    public long getNnodes64() {
        return this._cplexi == null ? 0L : this._cplexi.getNnodes();
    }

    public long getNnodesLeft64() {
        return this._cplexi == null ? 0L : this._cplexi.getNnodesLeft();
    }

    public long getIncumbentNode64() {
        return this._cplexi == null ? 0L : this._cplexi.getIncumbentNode();
    }

    public int getNcuts(int n) throws IloException {
        return this._cplexi.getNcuts(n);
    }

    public void setPriority(IloNumVar iloNumVar, int n) throws IloException {
        this._cplexi.setPriority(this.getIndexOrException(iloNumVar), n);
    }

    public void setPriorities(IloNumVar[] iloNumVarArray, int[] nArray) throws IloException {
        this.setPriorities(iloNumVarArray, nArray, 0, iloNumVarArray.length);
    }

    public void setPriorities(IloNumVar[] iloNumVarArray, int[] nArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = this.getIndexOrException(iloNumVarArray, n, n2);
        this._cplexi.setPriorities(cplexIndexArray, nArray, n, n2);
    }

    private final CplexIndex getIndexOrException(IloNumVar iloNumVar) throws IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        CplexIndex cplexIndex = cpxNumVar.getVarIndex();
        if (cplexIndex == null || cplexIndex.getValue() < 0) {
            throw new UnknownObjectException(iloNumVar);
        }
        return cplexIndex;
    }

    private final CplexIndex[] getIndexOrException(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        CplexIndex[] cplexIndexArray = new CplexIndex[n3];
        for (int i = n; i < n3; ++i) {
            cplexIndexArray[i] = this.getIndexOrException(iloNumVarArray[i]);
        }
        return cplexIndexArray;
    }

    public void setDirection(IloNumVar iloNumVar, BranchDirection branchDirection) throws IloException {
        this._cplexi.setDirection(this.getIndexOrException(iloNumVar), branchDirection.getValue());
    }

    public void setDirections(IloNumVar[] iloNumVarArray, BranchDirection[] branchDirectionArray) throws IloException {
        this.setDirections(iloNumVarArray, branchDirectionArray, 0, iloNumVarArray.length);
    }

    public void setDirections(IloNumVar[] iloNumVarArray, BranchDirection[] branchDirectionArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        int[] nArray = new int[n3];
        for (int i = n; i < n3; ++i) {
            nArray[i] = branchDirectionArray[i].getValue();
        }
        CplexIndex[] cplexIndexArray = this.getIndexOrException(iloNumVarArray, n, n2);
        this._cplexi.setDirections(cplexIndexArray, nArray, n, n2);
    }

    public void delPriority(IloNumVar iloNumVar) throws IloException {
        this.setPriority(iloNumVar, 0);
    }

    public void delPriorities(IloNumVar[] iloNumVarArray) throws IloException {
        this.delPriorities(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public void delPriorities(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        int[] nArray = new int[n3];
        for (int i = n; i < n3; ++i) {
            nArray[i] = 0;
        }
        this.setPriorities(iloNumVarArray, nArray, n, n2);
    }

    public void delDirection(IloNumVar iloNumVar) throws IloException {
        this.setDirection(iloNumVar, BranchDirection.Global);
    }

    public void delDirections(IloNumVar[] iloNumVarArray) throws IloException {
        this.delDirections(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public void delDirections(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        BranchDirection[] branchDirectionArray = new BranchDirection[n3];
        for (int i = n; i < n3; ++i) {
            branchDirectionArray[i] = BranchDirection.Global;
        }
        this.setDirections(iloNumVarArray, branchDirectionArray, n, n2);
    }

    public int getPriority(IloNumVar iloNumVar) throws IloException {
        return this._cplexi.getPriority(this.getIndexOrException(iloNumVar));
    }

    public int[] getPriorities(IloNumVar[] iloNumVarArray) throws IloException {
        return this.getPriorities(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public int[] getPriorities(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = this.getIndexOrException(iloNumVarArray, n, n2);
        int[] nArray = new int[n2];
        this._cplexi.getPriorities(nArray, cplexIndexArray, n, n2);
        return nArray;
    }

    public BranchDirection getDirection(IloNumVar iloNumVar) throws IloException {
        CplexIndex cplexIndex = this.getIndexOrException(iloNumVar);
        return BranchDirection.getDirection(this._cplexi.getDirection(cplexIndex));
    }

    public BranchDirection[] getDirections(IloNumVar[] iloNumVarArray) throws IloException {
        return this.getDirections(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public BranchDirection[] getDirections(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        CplexIndex[] cplexIndexArray = this.getIndexOrException(iloNumVarArray, n, n2);
        int[] nArray = new int[n2];
        this._cplexi.getDirections(nArray, cplexIndexArray, n, n2);
        BranchDirection[] branchDirectionArray = new BranchDirection[n2];
        for (int i = 0; i < n2; ++i) {
            branchDirectionArray[i] = BranchDirection.getDirection(nArray[i]);
        }
        return branchDirectionArray;
    }

    public void writeOrder(String string) throws IloException {
        this._cplexi.writeOrder(string);
    }

    public void writeConflict(String string) throws IloException {
        this._cplexi.writeConflict(string);
    }

    public void writeParam(String string) throws IloException {
        this._cplexi.writeParam(string);
    }

    public void writeBasis(String string) throws IloException {
        this._cplexi.writeBasis(string);
    }

    public void writeSolution(String string) throws IloException {
        this._cplexi.writeSolution(string, -1);
    }

    public void writeSolution(String string, int n) throws IloException {
        this._cplexi.writeSolution(string, n);
    }

    public void writeSolutions(String string) throws IloException {
        this._cplexi.writeSolutions(string);
    }

    public void writeMIPStarts(String string, int n, int n2) throws IloException {
        this._cplexi.writeMIPStarts(string, n, n2);
    }

    public void writeMIPStarts(String string) throws IloException {
        this.writeMIPStarts(string, 0, Integer.MAX_VALUE);
    }

    public void readOrder(String string) throws IloException {
        this._cplexi.readOrder(string);
    }

    public void readParam(String string) throws IloException {
        this._cplexi.readParam(string);
    }

    public void readBasis(String string) throws IloException {
        this._cplexi.readBasis(string);
    }

    public void readSolution(String string) throws IloException {
        this._cplexi.readSolution(string);
    }

    public void readMIPStarts(String string) throws IloException {
        this._cplexi.readMIPStarts(string);
    }

    public void use(Callback callback) throws IloException {
        if (callback.cb.getCplex() == this) {
            return;
        }
        if (callback.cb.getCplex() != null) {
            throw new IloException("callback already in use");
        }
        this._cplexi.setCallback(callback.cb);
        callback.cb.setCplex(this);
    }

    public void remove(Callback callback) throws IloException {
        if (callback == null || callback.cb == null || callback.cb.getCplex() != this) {
            return;
        }
        callback.cb.setCplex(null);
        this._cplexi.removeCallback(callback.cb);
    }

    public void clearCallbacks() throws IloException {
        this._cplexi.clearCallbacks();
    }

    public IloLinearNumExpr getRay() throws IloException {
        return this._cplexi.getRay();
    }

    public IloCopyable getDiverging() throws IloException {
        return this._cplexi.getDiverging();
    }

    public double dualFarkas(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        return this._cplexi.dualFarkas(iloConstraintArray, dArray);
    }

    public void qpIndefCertificate(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this._cplexi.qpIndefCertificate(iloNumVarArray, dArray);
    }

    public void protectVariables(IloNumVar[] iloNumVarArray, int n, int n2) throws UnknownObjectException, IloException {
        this._cplexi.protectVariables(iloNumVarArray, n, n2);
    }

    public void protectVariables(IloNumVar[] iloNumVarArray) throws UnknownObjectException, IloException {
        this.protectVariables(iloNumVarArray, 0, iloNumVarArray.length);
    }

    public void end() {
        if (this._cplexi != null) {
            this._cplexi.callFinit();
            this._cplexi = null;
        }
    }

    protected void finalize() {
        this.end();
    }

    public final Goal and(Goal goal, Goal goal2) {
        return new CpxAndGoal(goal, goal2);
    }

    public final Goal and(Goal goal, Goal goal2, Goal goal3) {
        return new CpxAndGoal(new CpxAndGoal(goal, goal2), goal3);
    }

    public final Goal and(Goal goal, Goal goal2, Goal goal3, Goal goal4) {
        return new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(goal, goal2), goal3), goal4);
    }

    public final Goal and(Goal goal, Goal goal2, Goal goal3, Goal goal4, Goal goal5) {
        return new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(goal, goal2), goal3), goal4), goal5);
    }

    public final Goal and(Goal goal, Goal goal2, Goal goal3, Goal goal4, Goal goal5, Goal goal6) {
        return new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(new CpxAndGoal(goal, goal2), goal3), goal4), goal5), goal6);
    }

    public final Goal or(Goal goal, Goal goal2) {
        return new CpxOrGoal(goal, goal2, 1.0E20, 1.0E20);
    }

    final Goal or(Goal goal, Goal goal2, double d, double d2) {
        return new CpxOrGoal(goal, goal2, d, d2);
    }

    public final Goal or(Goal goal, Goal goal2, Goal goal3) {
        return this.or(goal, this.or(goal2, goal3));
    }

    public final Goal or(Goal goal, Goal goal2, Goal goal3, Goal goal4) {
        return this.or(goal, this.or(goal2, goal3, goal4));
    }

    public final Goal or(Goal goal, Goal goal2, Goal goal3, Goal goal4, Goal goal5) {
        return this.or(goal, this.or(goal2, goal3, goal4, goal5));
    }

    public final Goal or(Goal goal, Goal goal2, Goal goal3, Goal goal4, Goal goal5, Goal goal6) {
        return this.or(goal, this.or(goal2, goal3, goal4, goal5, goal6));
    }

    public final Goal branchAsCplex() {
        return new CpxBranchAsCplex();
    }

    public final Goal apply(Goal goal, NodeEvaluator nodeEvaluator) {
        return this.and(new CpxApplyGoal(nodeEvaluator), goal);
    }

    public final Goal limitSearch(Goal goal, SearchLimit searchLimit) {
        return this.and(new CpxLimitSearchGoal(searchLimit), goal);
    }

    public final boolean solve(Goal goal) throws IloException {
        this._cplexi.solve(this, goal);
        Status status = this.getStatus();
        return status == Status.Feasible || status == Status.Optimal;
    }

    public final Goal failGoal() {
        return new CpxFailGoal();
    }

    final void setDefaultSearch(boolean bl) {
        this._cplexi.setDefaultSearch(bl);
    }

    public final Goal constraintGoal(IloConstraint iloConstraint) throws IloException {
        return new CpxCutGoal(iloConstraint);
    }

    public final Goal constraintGoal(IloConstraint[] iloConstraintArray) throws IloException {
        return new CpxCutArrayGoal(iloConstraintArray);
    }

    public final Goal globalCutGoal(IloConstraint iloConstraint) throws IloException {
        return new CpxGlobalCutGoal(iloConstraint);
    }

    public final Goal globalCutGoal(IloConstraint[] iloConstraintArray) throws IloException {
        return new CpxGlobalCutArrayGoal(iloConstraintArray);
    }

    public final Goal solutionGoal(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        return new CpxSolutionGoal(iloNumVarArray, dArray);
    }

    public Goal eqGoal(IloNumExpr iloNumExpr, double d) throws IloException {
        return new CpxCutGoal(this.eq(iloNumExpr, d));
    }

    public Goal eqGoal(IloNumExpr iloNumExpr, IloNumExpr iloNumExpr2) throws IloException {
        return new CpxCutGoal((IloRange)this.eq(iloNumExpr, iloNumExpr2));
    }

    public Goal eqGoal(double d, IloNumExpr iloNumExpr) throws IloException {
        return new CpxCutGoal(this.eq(d, iloNumExpr));
    }

    public Goal geGoal(IloNumExpr iloNumExpr, double d) throws IloException {
        return new CpxCutGoal(this.ge(iloNumExpr, d));
    }

    public Goal geGoal(IloNumExpr iloNumExpr, IloNumExpr iloNumExpr2) throws IloException {
        return new CpxCutGoal((IloRange)this.ge(iloNumExpr, iloNumExpr2));
    }

    public Goal geGoal(double d, IloNumExpr iloNumExpr) throws IloException {
        return new CpxCutGoal(this.ge(d, iloNumExpr));
    }

    public Goal leGoal(IloNumExpr iloNumExpr, double d) throws IloException {
        return new CpxCutGoal(this.le(iloNumExpr, d));
    }

    public Goal leGoal(IloNumExpr iloNumExpr, IloNumExpr iloNumExpr2) throws IloException {
        return new CpxCutGoal((IloRange)this.le(iloNumExpr, iloNumExpr2));
    }

    public Goal leGoal(double d, IloNumExpr iloNumExpr) throws IloException {
        return new CpxCutGoal(this.le(d, iloNumExpr));
    }

    public double getSolnPoolMeanObjValue() throws IloException {
        return this._cplexi.getSolnPoolMeanObjValue();
    }

    public int getSolnPoolNsolns() throws IloException {
        return this._cplexi.getSolnPoolNsolns();
    }

    public int getSolnPoolNreplaced() throws IloException {
        return this._cplexi.getSolnPoolNreplaced();
    }

    public void delSolnPoolSoln(int n) throws IloException {
        this._cplexi.delSolnPoolSolns(n, n);
    }

    public void delSolnPoolSolns(int n, int n2) throws IloException {
        this._cplexi.delSolnPoolSolns(n, n2);
    }

    public FilterIndex addDiversityFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2) {
        return this._cplexi.addDiversityFilter(d, d2, iloNumVarArray, dArray, dArray2, null);
    }

    public FilterIndex addDiversityFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2, String string) {
        return this._cplexi.addDiversityFilter(d, d2, iloNumVarArray, dArray, dArray2, string);
    }

    public FilterIndex getFilterIndex(String string) throws IloException {
        return this._cplexi.getFilterIndex(string);
    }

    public int getNfilters() {
        return this._cplexi.getNfilters();
    }

    public int getFilterType(FilterIndex filterIndex) {
        return this._cplexi.getFilterType(filterIndex);
    }

    public double getDiversityFilterLowerCutoff(FilterIndex filterIndex) {
        return this._cplexi.getFilterLowerBound(filterIndex);
    }

    public double getDiversityFilterUpperCutoff(FilterIndex filterIndex) {
        return this._cplexi.getFilterUpperBound(filterIndex);
    }

    public IloNumVar[] getFilterVars(FilterIndex filterIndex) {
        return this._cplexi.getFilterVars(filterIndex);
    }

    public double[] getDiversityFilterWeights(FilterIndex filterIndex) {
        return this._cplexi.getFilterWeights(filterIndex);
    }

    public double[] getDiversityFilterRefVals(FilterIndex filterIndex) {
        return this._cplexi.getFilterRefVals(filterIndex);
    }

    public FilterIndex addRangeFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray) {
        return this._cplexi.addRangeFilter(d, d2, iloNumVarArray, dArray, null);
    }

    public FilterIndex addRangeFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, String string) {
        return this._cplexi.addRangeFilter(d, d2, iloNumVarArray, dArray, string);
    }

    public double getRangeFilterLowerBound(FilterIndex filterIndex) {
        return this._cplexi.getFilterLowerBound(filterIndex);
    }

    public double getRangeFilterUpperBound(FilterIndex filterIndex) {
        return this._cplexi.getFilterUpperBound(filterIndex);
    }

    public double[] getRangeFilterCoefs(FilterIndex filterIndex) {
        return this._cplexi.getFilterWeights(filterIndex);
    }

    public void delFilter(FilterIndex filterIndex) throws IloException {
        this._cplexi.delFilter(filterIndex);
    }

    public FilterIndex[] readFilters(String string) throws IloException {
        return this._cplexi.readFilters(string);
    }

    public void writeFilters(String string) throws IloException {
        this._cplexi.writeFilters(string);
    }

    public double getCplexTime() throws IloException {
        return this._cplexi.getCplexTime();
    }

    public double getDetTime() throws IloException {
        return this._cplexi.getDetTime();
    }

    public int getNumCores() throws IloException {
        return this._cplexi.getNumCores();
    }

    public boolean populate() throws IloException {
        this._cplexi.populate();
        return this._cplexi.isPfeas();
    }

    public Aborter use(Aborter aborter) throws IloException {
        this._cplexi.use(aborter.getImpl());
        return aborter;
    }

    public Aborter getAborter() {
        return new Aborter(this._cplexi.getAborter());
    }

    public void remove(Aborter aborter) throws IloException {
        this._cplexi.remove(aborter.getImpl());
    }

    public IloLinearNumExpr getQCDSlack(IloRange iloRange) throws IloException {
        CpxRange cpxRange = (CpxRange)iloRange;
        if (!cpxRange.isQC()) {
            throw new CpxException(-1, "Not a quadratic constraint");
        }
        int n = cpxRange.getIndexValue();
        if (n < 0) {
            throw new UnknownObjectException(cpxRange);
        }
        return this._cplexi.getQCDSlack(n);
    }

    public RemoteInfoHandler setRemoteInfoHandler(RemoteInfoHandler remoteInfoHandler) throws IloException {
        return this._cplexi.setRemoteInfoHandler(remoteInfoHandler);
    }

    public RemoteInfoHandler getRemoteInfoHandler() {
        return this._cplexi.getRemoteInfoHandler();
    }

    public RemoteInfoHandler removeRemoteInfoHandler() throws IloException {
        return this._cplexi.removeRemoteInfoHandler();
    }

    public int userfunction(int n, int n2, byte[] byArray, int n3, int[] nArray, byte[] byArray2) throws IloException {
        return this._cplexi.userfunction(n, n2, byArray, n3, nArray, byArray2);
    }

    public void transportctrl(int n, int[] nArray) throws IloException {
        this._cplexi.CALL(this._cplexi.transportctrl(n, nArray));
    }

    public void transportctrl(int n, long[] lArray) throws IloException {
        this._cplexi.CALL(this._cplexi.transportctrl(n, lArray));
    }

    public void transportctrl(int n, double[] dArray) throws IloException {
        this._cplexi.CALL(this._cplexi.transportctrl(n, dArray));
    }

    public RefineMIPStartConflictHandle refineMIPStartConflict(int n, IloConstraint[] iloConstraintArray, double[] dArray, boolean bl) throws IloException {
        return this._cplexi.refineMIPStartConflict(n, iloConstraintArray, dArray, 0, iloConstraintArray.length, bl);
    }

    public RefineMIPStartConflictHandle refineMIPStartConflict(int n, IloConstraint[] iloConstraintArray, double[] dArray, int n2, int n3, boolean bl) throws IloException {
        return this._cplexi.refineMIPStartConflict(n, iloConstraintArray, dArray, n2, n3, bl);
    }

    public SolveHandle solve(boolean bl) throws IloException {
        return this._cplexi.solve(bl);
    }

    public SolveFixedHandle solveFixed(boolean bl) throws IloException {
        return this._cplexi.solveFixed(-1, bl);
    }

    public SolveFixedHandle solveFixed(int n, boolean bl) throws IloException {
        return this._cplexi.solveFixed(n, bl);
    }

    public RefineConflictHandle refineConflict(IloConstraint[] iloConstraintArray, double[] dArray, boolean bl) throws IloException {
        return this._cplexi.refineConflict(iloConstraintArray, dArray, bl);
    }

    public RefineConflictHandle refineConflict(IloConstraint[] iloConstraintArray, double[] dArray, int n, int n2, boolean bl) throws IloException {
        return this._cplexi.refineConflict(iloConstraintArray, dArray, n, n2, bl);
    }

    public PopulateHandle populate(boolean bl) throws IloException {
        return this._cplexi.populate(bl);
    }

    public FeasOptHandle feasOpt(IloConstraint[] iloConstraintArray, double[] dArray, boolean bl) throws IloException {
        return this._cplexi.feasOpt(iloConstraintArray, dArray, bl);
    }

    public FeasOptHandle feasOpt(IloRange[] iloRangeArray, double[] dArray, double[] dArray2, boolean bl) throws IloException {
        return this.feasOpt(iloRangeArray, dArray, dArray2, null, null, null, bl);
    }

    public FeasOptHandle feasOpt(IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2, boolean bl) throws IloException {
        return this.feasOpt(null, null, null, iloNumVarArray, dArray, dArray2, bl);
    }

    public FeasOptHandle feasOpt(IloRange[] iloRangeArray, double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, double[] dArray3, double[] dArray4, boolean bl) throws IloException {
        return this._cplexi.feasOpt(iloRangeArray, dArray, dArray2, iloNumVarArray, dArray3, dArray4, bl);
    }

    public TuneParamHandle tuneParam(boolean bl) throws IloException {
        return this._cplexi.tuneParam(null, bl);
    }

    public TuneParamHandle tuneParam(ParameterSet parameterSet, boolean bl) throws IloException {
        return this._cplexi.tuneParam(parameterSet, bl);
    }

    public void copyVMConfig(String string) throws IloException {
        this._cplexi.copyVMConfig(string);
    }

    public void readVMConfig(String string) throws IloException {
        this._cplexi.readVMConfig(string);
    }

    public boolean hasVMConfig() throws IloException {
        return this._cplexi.hasVMConfig();
    }

    public void delVMConfig() throws IloException {
        this._cplexi.delVMConfig();
    }

    public LongAnnotation newLongAnnotation(String string) throws IloException {
        return this.newLongAnnotation(string, 0L);
    }

    public LongAnnotation newLongAnnotation(String string, long l) throws IloException {
        return this.longAnnotations.create(this._cplexi, string, l);
    }

    public LongAnnotation findLongAnnotation(String string) throws IloException {
        return this.longAnnotations.getByName(this._cplexi, string);
    }

    public LongAnnotation findLongAnnotation(int n) throws IloException {
        return this.longAnnotations.getAnnotationAt(n);
    }

    public String getAnnotationName(LongAnnotation longAnnotation) throws IloException {
        return this.longAnnotations.getName(this._cplexi, longAnnotation);
    }

    public int getNumLongAnnotations() throws IloException {
        return this.longAnnotations.size();
    }

    public void delAnnotation(LongAnnotation longAnnotation) throws IloException {
        this.longAnnotations.del(this._cplexi, longAnnotation);
    }

    public boolean hasLongAnnotation(String string) throws IloException {
        try {
            return this.findLongAnnotation(string).isValid();
        }
        catch (IloException iloException) {
            return false;
        }
    }

    public long getDefaultValue(LongAnnotation longAnnotation) throws IloException {
        return this.longAnnotations.getDefault(this._cplexi, longAnnotation);
    }

    public long getAnnotation(LongAnnotation longAnnotation, IloNumVar iloNumVar) throws IloException {
        return this.longAnnotations.getAnnotation(this._cplexi, longAnnotation, 1, this.getIndexOrException(iloNumVar).getIndex());
    }

    public long getAnnotation(LongAnnotation longAnnotation, IloIntVar iloIntVar) throws IloException {
        return this.longAnnotations.getAnnotation(this._cplexi, longAnnotation, 1, this.getIndexOrException(iloIntVar).getIndex());
    }

    public long getAnnotation(LongAnnotation longAnnotation, IloObjective iloObjective) throws IloException {
        return this.longAnnotations.getAnnotation(this._cplexi, longAnnotation, 0, iloObjective == this.getObjective() ? 0 : -1);
    }

    public long getAnnotation(LongAnnotation longAnnotation, IloConstraint iloConstraint) throws IloException {
        return this.longAnnotations.getAnnotation(this, longAnnotation, iloConstraint);
    }

    public long[] getAnnotation(LongAnnotation longAnnotation, IloAddable[] iloAddableArray) throws IloException {
        long[] lArray = new long[iloAddableArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.longAnnotations.getAnnotation(this, longAnnotation, iloAddableArray[i]);
        }
        return lArray;
    }

    public void setAnnotation(LongAnnotation longAnnotation, IloNumVar iloNumVar, long l) throws IloException {
        this.longAnnotations.setAnnotation(this, longAnnotation, new IloAddable[]{iloNumVar}, new long[]{l});
    }

    public void setAnnotation(LongAnnotation longAnnotation, IloIntVar iloIntVar, long l) throws IloException {
        this.longAnnotations.setAnnotation(this, longAnnotation, new IloAddable[]{iloIntVar}, new long[]{l});
    }

    public void setAnnotation(LongAnnotation longAnnotation, IloObjective iloObjective, long l) throws IloException {
        this.longAnnotations.setAnnotation(this, longAnnotation, new IloAddable[]{iloObjective}, new long[]{l});
    }

    public void setAnnotation(LongAnnotation longAnnotation, IloConstraint iloConstraint, long l) throws IloException {
        this.longAnnotations.setAnnotation(this, longAnnotation, new IloAddable[]{iloConstraint}, new long[]{l});
    }

    public void setAnnotation(LongAnnotation longAnnotation, IloAddable[] iloAddableArray, long[] lArray) throws IloException {
        this.longAnnotations.setAnnotation(this, longAnnotation, iloAddableArray, lArray);
    }

    public DoubleAnnotation newDoubleAnnotation(String string) throws IloException {
        return this.newDoubleAnnotation(string, 0.0);
    }

    public DoubleAnnotation newDoubleAnnotation(String string, double d) throws IloException {
        return this.doubleAnnotations.create(this._cplexi, string, d);
    }

    public DoubleAnnotation findDoubleAnnotation(String string) throws IloException {
        return this.doubleAnnotations.getByName(this._cplexi, string);
    }

    public DoubleAnnotation findDoubleAnnotation(int n) throws IloException {
        return this.doubleAnnotations.getAnnotationAt(n);
    }

    public String getAnnotationName(DoubleAnnotation doubleAnnotation) throws IloException {
        return this.doubleAnnotations.getName(this._cplexi, doubleAnnotation);
    }

    public int getNumDoubleAnnotations() throws IloException {
        return this.doubleAnnotations.size();
    }

    public void delAnnotation(DoubleAnnotation doubleAnnotation) throws IloException {
        this.doubleAnnotations.del(this._cplexi, doubleAnnotation);
    }

    public boolean hasDoubleAnnotation(String string) throws IloException {
        try {
            return this.findDoubleAnnotation(string).isValid();
        }
        catch (IloException iloException) {
            return false;
        }
    }

    public double getDefaultValue(DoubleAnnotation doubleAnnotation) throws IloException {
        return this.doubleAnnotations.getDefault(this._cplexi, doubleAnnotation);
    }

    public double getAnnotation(DoubleAnnotation doubleAnnotation, IloNumVar iloNumVar) throws IloException {
        return this.doubleAnnotations.getAnnotation(this._cplexi, doubleAnnotation, 1, this.getIndexOrException(iloNumVar).getIndex());
    }

    public double getAnnotation(DoubleAnnotation doubleAnnotation, IloIntVar iloIntVar) throws IloException {
        return this.doubleAnnotations.getAnnotation(this._cplexi, doubleAnnotation, 1, this.getIndexOrException(iloIntVar).getIndex());
    }

    public double getAnnotation(DoubleAnnotation doubleAnnotation, IloObjective iloObjective) throws IloException {
        return this.doubleAnnotations.getAnnotation(this._cplexi, doubleAnnotation, 0, iloObjective == this.getObjective() ? 0 : -1);
    }

    public double getAnnotation(DoubleAnnotation doubleAnnotation, IloConstraint iloConstraint) throws IloException {
        return this.doubleAnnotations.getAnnotation(this, doubleAnnotation, iloConstraint);
    }

    public double[] getAnnotation(DoubleAnnotation doubleAnnotation, IloAddable[] iloAddableArray) throws IloException {
        double[] dArray = new double[iloAddableArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.doubleAnnotations.getAnnotation(this, doubleAnnotation, iloAddableArray[i]);
        }
        return dArray;
    }

    public void setAnnotation(DoubleAnnotation doubleAnnotation, IloNumVar iloNumVar, double d) throws IloException {
        this.doubleAnnotations.setAnnotation(this, doubleAnnotation, new IloAddable[]{iloNumVar}, new double[]{d});
    }

    public void setAnnotation(DoubleAnnotation doubleAnnotation, IloIntVar iloIntVar, double d) throws IloException {
        this.doubleAnnotations.setAnnotation(this, doubleAnnotation, new IloAddable[]{iloIntVar}, new double[]{d});
    }

    public void setAnnotation(DoubleAnnotation doubleAnnotation, IloObjective iloObjective, double d) throws IloException {
        this.doubleAnnotations.setAnnotation(this, doubleAnnotation, new IloAddable[]{iloObjective}, new double[]{d});
    }

    public void setAnnotation(DoubleAnnotation doubleAnnotation, IloConstraint iloConstraint, double d) throws IloException {
        this.doubleAnnotations.setAnnotation(this, doubleAnnotation, new IloAddable[]{iloConstraint}, new double[]{d});
    }

    public void setAnnotation(DoubleAnnotation doubleAnnotation, IloAddable[] iloAddableArray, double[] dArray) throws IloException {
        this.doubleAnnotations.setAnnotation(this, doubleAnnotation, iloAddableArray, dArray);
    }

    public void writeAnnotations(String string) throws IloException {
        this._cplexi.CALL(Cplex.CPXwriteannotations(this._cplexi.getEnv(), this._cplexi.getLP(), CplexI.getBytes(string)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAnnotations(String string) throws IloException {
        this.longAnnotations.clear();
        this.doubleAnnotations.clear();
        boolean bl = false;
        try {
            this._cplexi.CALL(Cplex.CPXreadcopyannotations(this._cplexi.getEnv(), this._cplexi.getLP(), CplexI.getBytes(string)));
            LONG_TRAITS.delIndicator(this._cplexi.getEnv(), this._cplexi.getLP());
            DOUBLE_TRAITS.delIndicator(this._cplexi.getEnv(), this._cplexi.getLP());
            this.longAnnotations.load(this._cplexi);
            this.doubleAnnotations.load(this._cplexi);
            bl = true;
        }
        finally {
            if (!bl) {
                this.longAnnotations.clear();
                this.doubleAnnotations.clear();
            }
        }
    }

    public void writeBendersAnnotation(String string) throws IloException {
        this._cplexi.CALL(Cplex.CPXwritebendersannotation(this._cplexi.getEnv(), this._cplexi.getLP(), CplexI.getBytes(string)));
    }

    static int[] var2ind(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int[] nArray = new int[n2 - n];
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            CplexIndex cplexIndex = ((CpxNumVar)iloNumVarArray[n3]).getVarIndex();
            if (cplexIndex == null || cplexIndex.getValue() < 0) {
                throw new UnknownObjectException(iloNumVarArray[n3]);
            }
            nArray[n4] = cplexIndex.getValue();
            ++n3;
            ++n4;
        }
        return nArray;
    }

    public void use(Callback.Function function, long l) throws IloException {
        this._cplexi.setGenericCallback(this, function, l);
    }

    public static final class DoubleAnnotation
    extends Annotation {
        protected DoubleAnnotation(CplexIndex cplexIndex) {
            super(cplexIndex);
        }
    }

    public static final class LongAnnotation
    extends Annotation {
        protected LongAnnotation(CplexIndex cplexIndex) {
            super(cplexIndex);
        }
    }

    private static final class AnnotationList<T extends Annotation, W extends Number, A> {
        private final AnnotationTraits<T, W, A> traits;
        private final A buffer;
        private final Vector<T> list = new Vector();

        public AnnotationList(AnnotationTraits<T, W, A> annotationTraits) {
            this.traits = annotationTraits;
            this.buffer = this.traits.makeBuffer(1);
        }

        public T create(CplexI cplexI, String string, W w) throws IloException {
            this.list.ensureCapacity(this.list.size() + 1);
            CplexIndex cplexIndex = new CplexIndex(-1);
            T t = this.traits.newInstance(cplexIndex);
            cplexI.CALL(this.traits.create(cplexI.getEnv(), cplexI.getLP(), string, w));
            int[] nArray = new int[1];
            cplexI.CALL(this.traits.getIndex(cplexI.getEnv(), cplexI.getLP(), string, nArray));
            cplexIndex.setIndex(nArray[0]);
            this.list.add(t);
            return t;
        }

        public void del(CplexI cplexI, T t) throws IloException {
            int n = ((Annotation)t).getIntIndex();
            ((Annotation)t).invalidateIndex();
            cplexI.CALL(this.traits.delIndex(cplexI.getEnv(), cplexI.getLP(), n));
            for (int i = n; i < this.list.size() - 1; ++i) {
                Annotation annotation = (Annotation)this.list.elementAt(i + 1);
                annotation.decrement();
                this.list.setElementAt(annotation, i);
            }
            this.list.setSize(this.list.size() - 1);
        }

        public T getAnnotationAt(int n) {
            if (n >= 0 && n < this.list.size()) {
                return (T)((Annotation)this.list.elementAt(n));
            }
            return this.traits.newInstance(null);
        }

        public T getByName(CplexI cplexI, String string) throws IloException {
            int[] nArray = new int[1];
            cplexI.CALL(this.traits.getIndex(cplexI.getEnv(), cplexI.getLP(), string, nArray));
            return this.getAnnotationAt(nArray[0]);
        }

        public W getDefault(CplexI cplexI, T t) throws IloException {
            cplexI.CALL(this.traits.getDefault(cplexI.getEnv(), cplexI.getLP(), ((Annotation)t).getIntIndex(), this.buffer));
            return this.traits.dereference(this.buffer);
        }

        public W getAnnotation(CplexI cplexI, T t, int n, int n2) throws IloException {
            cplexI.CALL(this.traits.getAnnotation(cplexI.getEnv(), cplexI.getLP(), ((Annotation)t).getIntIndex(), n, this.buffer, n2));
            return this.traits.dereference(this.buffer);
        }

        private int getIndexAndType(IloCplex iloCplex, IloAddable iloAddable, int[] nArray) throws IloException {
            nArray[0] = -1;
            if (iloAddable instanceof CpxObjective) {
                if (iloAddable == iloCplex.getObjective()) {
                    nArray[0] = 0;
                    return 0;
                }
            } else if (iloAddable instanceof CpxRange) {
                CpxRange cpxRange = (CpxRange)iloAddable;
                int n = cpxRange.getIndexValue();
                if (n >= 0) {
                    nArray[0] = cpxRange.isQC() ? 5 : 2;
                    return n;
                }
            } else if (iloAddable instanceof CpxSOS) {
                int n = ((CpxSOS)iloAddable).getIndexValue();
                if (n >= 0) {
                    nArray[0] = 3;
                    return n;
                }
            } else if (!(iloAddable instanceof CpxIfThen) && iloAddable instanceof CpxNumVar) {
                int n = iloCplex.getIndexOrException((CpxNumVar)iloAddable).getValue();
                nArray[0] = 1;
                return n;
            }
            throw new UnknownObjectException(iloAddable);
        }

        public W getAnnotation(IloCplex iloCplex, T t, IloAddable iloAddable) throws IloException {
            int[] nArray = new int[1];
            int n = this.getIndexAndType(iloCplex, iloAddable, nArray);
            return this.getAnnotation(iloCplex._cplexi, t, nArray[0], n);
        }

        public void setAnnotation(IloCplex iloCplex, T t, IloAddable[] iloAddableArray, A a) throws IloException {
            int[] nArray = new int[iloAddableArray.length];
            A a2 = this.traits.makeBuffer(iloAddableArray.length);
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int n = 0;
            while (n < iloAddableArray.length) {
                nArray[0] = this.getIndexAndType(iloCplex, iloAddableArray[n], nArray2);
                int n2 = n;
                while (n2 + 1 < iloAddableArray.length && (nArray[1 + n2 - n] = this.getIndexAndType(iloCplex, iloAddableArray[n2 + 1], nArray3)) >= 0 && nArray3[0] == nArray2[0]) {
                    ++n2;
                }
                this.traits.copyBuffer(a, n, a2, 0, 1 + n2 - n);
                iloCplex._cplexi.CALL(this.traits.setAnnotation(iloCplex._cplexi.getEnv(), iloCplex._cplexi.getLP(), ((Annotation)t).getIntIndex(), nArray2[0], 1 + n2 - n, nArray, a2));
                n = n2 + 1;
            }
        }

        public void load(CplexI cplexI) throws IloException {
            this.clear();
            int n = this.traits.count(cplexI.getEnv(), cplexI.getLP());
            for (int i = 0; i < n; ++i) {
                this.list.add(this.traits.newInstance(new CplexIndex(i)));
            }
        }

        public String getName(CplexI cplexI, T t) throws IloException {
            String[] stringArray = new String[1];
            cplexI.CALL(this.traits.getName(cplexI.getEnv(), cplexI.getLP(), ((Annotation)t).getIntIndex(), stringArray));
            return stringArray[0];
        }

        public void clear() {
            for (Annotation annotation : this.list) {
                annotation.invalidateIndex();
            }
            this.list.clear();
        }

        public int size() {
            return this.list.size();
        }
    }

    private static interface AnnotationTraits<T extends Annotation, W extends Number, A> {
        public int delIndex(long var1, long var3, int var5);

        public T newInstance(CplexIndex var1);

        public int create(long var1, long var3, String var5, W var6);

        public int getIndex(long var1, long var3, String var5, int[] var6);

        public int getDefault(long var1, long var3, int var5, A var6);

        public int getAnnotation(long var1, long var3, int var5, int var6, A var7, int var8);

        public A makeBuffer(int var1);

        public W dereference(A var1);

        public void copyBuffer(A var1, int var2, A var3, int var4, int var5);

        public int setAnnotation(long var1, long var3, int var5, int var6, int var7, int[] var8, A var9);

        public int getName(long var1, long var3, int var5, String[] var6);

        public int count(long var1, long var3);

        public void delIndicator(long var1, long var3);
    }

    public static abstract class Annotation {
        private CplexIndex index;

        protected Annotation(CplexIndex cplexIndex) {
            this.index = cplexIndex;
        }

        private final synchronized CplexIndex getIndex() {
            if (this.index == null) {
                return null;
            }
            if (this.index.getIndex() < 0) {
                this.index = null;
            }
            return this.index;
        }

        final synchronized void setIndex(CplexIndex cplexIndex) {
            this.index = cplexIndex;
        }

        final synchronized void decrement() {
            CplexIndex cplexIndex = this.getIndex();
            cplexIndex.setIndex(cplexIndex.getIndex() - 1);
        }

        final synchronized void invalidateIndex() {
            if (this.index != null) {
                this.index.setIndex(-1);
                this.index = null;
            }
        }

        final int getIntIndex() {
            return this.getIndex().getIndex();
        }

        public final boolean isValid() {
            return this.getIndex() != null;
        }

        public final boolean equals(Annotation annotation) {
            if (annotation == null) {
                return false;
            }
            CplexIndex cplexIndex = this.getIndex();
            CplexIndex cplexIndex2 = annotation.getIndex();
            return cplexIndex != null && cplexIndex2 != null && cplexIndex.getIndex() == cplexIndex2.getIndex();
        }
    }

    public static interface TuneParamHandle
    extends AsyncHandle {
        public int joinTuneParam() throws IloException;
    }

    public static interface FeasOptHandle
    extends AsyncHandle {
        public boolean joinFeasOpt() throws IloException;
    }

    public static interface PopulateHandle
    extends AsyncHandle {
        public boolean joinPopulate() throws IloException;
    }

    public static interface RefineConflictHandle
    extends AsyncHandle {
        public boolean joinRefineConflict() throws IloException;
    }

    public static interface SolveFixedHandle
    extends AsyncHandle {
        public boolean joinSolveFixed() throws IloException;
    }

    public static interface SolveHandle
    extends AsyncHandle {
        public boolean joinSolve() throws IloException;
    }

    public static interface RefineMIPStartConflictHandle
    extends AsyncHandle {
        public boolean joinRefineMIPStartConflict() throws IloException;
    }

    public static interface AsyncHandle {
        public boolean test() throws IloException;

        public void kill() throws IloException;

        public void join() throws IloException;
    }

    public static class Deserializer {
        private int idx = 0;
        private final int size;
        private final byte[] data;

        public Deserializer(int n, byte[] byArray) {
            this.size = n;
            this.data = byArray;
        }

        protected synchronized byte nextByte() {
            return this.data[this.idx++];
        }

        protected synchronized short nextShort() {
            short s = (short)(((short)this.data[this.idx + 0] & 0xFF) << 8 | ((short)this.data[this.idx + 1] & 0xFF) << 0);
            this.idx += 2;
            return s;
        }

        protected synchronized int nextInt() {
            int n = (this.data[this.idx + 0] & 0xFF) << 24 | (this.data[this.idx + 1] & 0xFF) << 16 | (this.data[this.idx + 2] & 0xFF) << 8 | (this.data[this.idx + 3] & 0xFF) << 0;
            this.idx += 4;
            return n;
        }

        protected synchronized long nextLong() {
            long l = ((long)this.data[this.idx + 0] & 0xFFL) << 56 | ((long)this.data[this.idx + 1] & 0xFFL) << 48 | ((long)this.data[this.idx + 2] & 0xFFL) << 40 | ((long)this.data[this.idx + 3] & 0xFFL) << 32 | ((long)this.data[this.idx + 4] & 0xFFL) << 24 | ((long)this.data[this.idx + 5] & 0xFFL) << 16 | ((long)this.data[this.idx + 6] & 0xFFL) << 8 | ((long)this.data[this.idx + 7] & 0xFFL) << 0;
            this.idx += 8;
            return l;
        }

        protected synchronized float nextFloat() {
            return Float.intBitsToFloat(this.nextInt());
        }

        protected synchronized double nextDouble() {
            return Double.longBitsToDouble(this.nextLong());
        }

        public synchronized byte readByte() {
            if (this.idx + 1 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 1);
            }
            return this.nextByte();
        }

        public synchronized void read(byte[] byArray, int n, int n2) {
            if (this.idx + 1 * n2 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 1 * n2);
            }
            for (int i = n; i < n + n2; ++i) {
                byArray[i] = this.nextByte();
            }
        }

        public synchronized short readShort() {
            if (this.idx + 2 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 2);
            }
            return this.nextShort();
        }

        public synchronized void read(short[] sArray, int n, int n2) {
            if (this.idx + 2 * n2 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 2 * n2);
            }
            for (int i = n; i < n + n2; ++i) {
                sArray[i] = this.nextShort();
            }
        }

        public synchronized int readInt() {
            if (this.idx + 4 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 4);
            }
            return this.nextInt();
        }

        public synchronized void read(int[] nArray, int n, int n2) {
            if (this.idx + 4 * n2 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 4 * n2);
            }
            for (int i = n; i < n + n2; ++i) {
                nArray[i] = this.nextInt();
            }
        }

        public synchronized long readLong() {
            if (this.idx + 8 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 8);
            }
            return this.nextLong();
        }

        public synchronized void read(long[] lArray, int n, int n2) {
            if (this.idx + 8 * n2 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 8 * n2);
            }
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = this.nextLong();
            }
        }

        public synchronized float readFloat() {
            if (this.idx + 4 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 4);
            }
            return this.nextFloat();
        }

        public synchronized void read(float[] fArray, int n, int n2) {
            if (this.idx + 4 * n2 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 4 * n2);
            }
            for (int i = n; i < n + n2; ++i) {
                fArray[i] = this.nextFloat();
            }
        }

        public synchronized double readDouble() {
            if (this.idx + 8 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 8);
            }
            return this.nextDouble();
        }

        public synchronized void read(double[] dArray, int n, int n2) {
            if (this.idx + 8 * n2 > this.size) {
                throw new ArrayIndexOutOfBoundsException(this.idx + 8 * n2);
            }
            for (int i = n; i < n + n2; ++i) {
                dArray[i] = this.nextDouble();
            }
        }
    }

    public static class Serializer {
        private int size;
        private byte[] data = new byte[32];

        protected synchronized void ensureCapacity(int n) {
            if (n > this.data.length) {
                int n2 = Math.max(this.data.length * 2, n);
                byte[] byArray = new byte[n2];
                System.arraycopy(this.data, 0, byArray, 0, this.data.length);
                this.data = byArray;
            }
        }

        public byte[] getRawData() {
            return this.data;
        }

        public int getRawLength() {
            return this.size;
        }

        protected synchronized void append(byte by) {
            this.data[this.size++] = by;
        }

        protected synchronized void append(short s) {
            this.data[this.size++] = (byte)(s >> 8 & 0xFF);
            this.data[this.size++] = (byte)(s >> 0 & 0xFF);
        }

        protected synchronized void append(int n) {
            this.data[this.size++] = (byte)(n >> 24 & 0xFF);
            this.data[this.size++] = (byte)(n >> 16 & 0xFF);
            this.data[this.size++] = (byte)(n >> 8 & 0xFF);
            this.data[this.size++] = (byte)(n >> 0 & 0xFF);
        }

        protected synchronized void append(long l) {
            this.data[this.size++] = (byte)(l >> 56 & 0xFFL);
            this.data[this.size++] = (byte)(l >> 48 & 0xFFL);
            this.data[this.size++] = (byte)(l >> 40 & 0xFFL);
            this.data[this.size++] = (byte)(l >> 32 & 0xFFL);
            this.data[this.size++] = (byte)(l >> 24 & 0xFFL);
            this.data[this.size++] = (byte)(l >> 16 & 0xFFL);
            this.data[this.size++] = (byte)(l >> 8 & 0xFFL);
            this.data[this.size++] = (byte)(l >> 0 & 0xFFL);
        }

        protected synchronized void append(float f) {
            this.append(Float.floatToRawIntBits(f));
        }

        protected synchronized void append(double d) {
            this.append(Double.doubleToRawLongBits(d));
        }

        public synchronized void add(byte by) {
            this.ensureCapacity(this.size + 1);
            this.append(by);
        }

        public synchronized void add(byte[] byArray) {
            this.add(byArray, 0, byArray.length);
        }

        public synchronized void add(byte[] byArray, int n, int n2) {
            this.ensureCapacity(this.size + n2);
            for (int i = n; i < n + n2; ++i) {
                this.append(byArray[i]);
            }
        }

        public synchronized void add(short s) {
            this.ensureCapacity(this.size + 2);
            this.append(s);
        }

        public synchronized void add(short[] sArray) {
            this.add(sArray, 0, sArray.length);
        }

        public synchronized void add(short[] sArray, int n, int n2) {
            this.ensureCapacity(this.size + 2 * n2);
            for (int i = n; i < n + n2; ++i) {
                this.append(sArray[i]);
            }
        }

        public synchronized void add(int n) {
            this.ensureCapacity(this.size + 4);
            this.append(n);
        }

        public synchronized void add(int[] nArray) {
            this.add(nArray, 0, nArray.length);
        }

        public synchronized void add(int[] nArray, int n, int n2) {
            this.ensureCapacity(this.size + 4 * n2);
            for (int i = n; i < n + n2; ++i) {
                this.append(nArray[i]);
            }
        }

        public synchronized void add(long l) {
            this.ensureCapacity(this.size + 8);
            this.append(l);
        }

        public synchronized void add(long[] lArray) {
            this.add(lArray, 0, lArray.length);
        }

        public synchronized void add(long[] lArray, int n, int n2) {
            this.ensureCapacity(this.size + 8 * n2);
            for (int i = n; i < n + n2; ++i) {
                this.append(lArray[i]);
            }
        }

        public synchronized void add(float f) {
            this.ensureCapacity(this.size + 4);
            this.append(f);
        }

        public synchronized void add(float[] fArray) {
            this.add(fArray, 0, fArray.length);
        }

        public synchronized void add(float[] fArray, int n, int n2) {
            this.ensureCapacity(this.size + 4 * n2);
            for (int i = n; i < n + n2; ++i) {
                this.append(fArray[i]);
            }
        }

        public synchronized void add(double d) {
            this.ensureCapacity(this.size + 8);
            this.append(d);
        }

        public synchronized void add(double[] dArray) {
            this.add(dArray, 0, dArray.length);
        }

        public synchronized void add(double[] dArray, int n, int n2) {
            this.ensureCapacity(this.size + 8 * n2);
            for (int i = n; i < n + n2; ++i) {
                this.append(dArray[i]);
            }
        }
    }

    public static interface RemoteInfoHandler {
        public void main(Class var1, int var2, Object var3);
    }

    public static class Aborter {
        private CplexI.AborterI _impl;

        public Aborter() {
            this._impl = new CplexI.AborterI();
        }

        Aborter(CplexI.AborterI aborterI) {
            this._impl = aborterI;
        }

        protected void finalize() throws IloException {
            this.end();
        }

        public CplexI.AborterI getImpl() {
            return this._impl;
        }

        public void abort() {
            this._impl.abort();
        }

        public void clear() {
            this._impl.clear();
        }

        public boolean isAborted() {
            return this._impl.isAborted();
        }

        public void end() throws IloException {
            if (this._impl != null) {
                this._impl.end();
                this._impl = null;
            }
        }
    }

    public static class FilterIndex
    extends CplexIndex {
        private static final long serialVersionUID = 12080000L;

        public FilterIndex(int n) {
            super(n);
        }
    }

    public static abstract class FilterType {
        public static final int Diversity = 1;
        public static final int Range = 2;
    }

    public static abstract class SearchLimit
    implements Cloneable {
        boolean _isViolated = false;
        CpxNode _node;

        final SearchLimit makeClone() {
            try {
                SearchLimit searchLimit = (SearchLimit)this.clone();
                searchLimit._node = null;
                return searchLimit;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public abstract boolean check();

        public void init() {
        }

        final boolean checkNode(CpxNode cpxNode) {
            this._node = cpxNode;
            return this.check();
        }

        final void initNode(CpxNode cpxNode) {
            this._isViolated = false;
            this._node = cpxNode;
            this.init();
        }

        final void setViolated() {
            this._isViolated = true;
        }

        final boolean isViolated() {
            return this._isViolated;
        }

        public final int getDepth() {
            return this._node.getDepth();
        }

        public final int getLeftDepth() {
            return this._node.getLeftDepth();
        }

        public final int getRightDepth() {
            return this._node.getRightDepth();
        }
    }

    public static abstract class NodeEvaluator
    implements Cloneable {
        int _nIndex = -1;
        boolean _isInit = false;
        CpxNode _node;
        int _id = -1;

        protected NodeEvaluator() {
        }

        final CpxNode getNode() {
            return this._node;
        }

        final NodeEvaluator makeClone() {
            try {
                NodeEvaluator nodeEvaluator = (NodeEvaluator)this.clone();
                nodeEvaluator._node = null;
                return nodeEvaluator;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public final int getId() {
            return this._id;
        }

        protected abstract double evaluate() throws IloException;

        protected boolean subsume(double d, double d2) {
            return d2 > d;
        }

        protected void init() {
        }

        void initNode(CpxNode cpxNode) {
            this._node = cpxNode;
            this._isInit = true;
            this.init();
        }

        final boolean isInit() {
            return this._isInit;
        }

        final boolean callSubsume(double d, double d2) {
            return this.subsume(d, d2);
        }

        final double evaluateNode(CpxNode cpxNode, int n) throws IloException {
            this._node = cpxNode;
            this._nIndex = n;
            return this.evaluate();
        }

        protected final double getObjValue() throws IloException {
            return this.getNode().getNodeCallback().getObjValue(this._nIndex);
        }

        protected final double getEstimatedObjValue() throws IloException {
            return this.getNode().getNodeCallback().getEstimatedObjValue(this._nIndex);
        }

        protected final int getDepth() throws IloException {
            return this.getNode().getNodeCallback().getDepth(this._nIndex);
        }

        protected final double getInfeasibilitySum() throws IloException {
            return this.getNode().getNodeCallback().getInfeasibilitySum(this._nIndex);
        }

        protected final int getNinfeasibilities() throws IloException {
            return this.getNode().getNodeCallback().getNinfeasibilities(this._nIndex);
        }

        protected final IloNumVar getBranchVar() throws IloException {
            return this.getNode().getNodeCallback().getBranchVar(this._nIndex);
        }

        protected final int getLeftDepth() {
            return this._node.getLeftDepth();
        }

        protected final int getRightDepth() {
            return this._node.getRightDepth();
        }
    }

    public static abstract class Goal
    implements Cloneable {
        CpxNode _node = null;

        final int getIndex(IloNumVar iloNumVar) throws IloException {
            return ((CpxNumVar)iloNumVar).getVarIndexValue();
        }

        final int getIndex(IloRange iloRange) throws IloException {
            return ((CpxRange)iloRange).getVarIndexValue();
        }

        final int getIndex(IloSOS1 iloSOS1) throws IloException {
            return ((CpxSOS)((Object)iloSOS1)).getIndexValue();
        }

        final int getIndex(IloSOS2 iloSOS2) throws IloException {
            return ((CpxSOS)((Object)iloSOS2)).getIndexValue();
        }

        final Goal executeNode(IloCplex iloCplex, CpxNode cpxNode) throws IloException {
            this._node = cpxNode;
            return this.execute(iloCplex);
        }

        final CpxNode getNode() {
            return this._node;
        }

        final Goal makeClone() {
            try {
                Goal goal = (Goal)this.clone();
                goal._node = null;
                return goal;
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public abstract Goal execute(IloCplex var1) throws IloException;

        protected double getBestObjValue() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getBestObjValue();
            }
            return this.getNode().getBranchCallback().getBestObjValue();
        }

        protected double getMIPRelativeGap() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getMIPRelativeGap();
            }
            return this.getNode().getBranchCallback().getMIPRelativeGap();
        }

        protected final double getCutoff() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getCutoff();
            }
            return this.getNode().getBranchCallback().getCutoff();
        }

        protected final double getIncumbentObjValue() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getObjValue();
            }
            return this.getNode().getBranchCallback().getIncumbentObjValue();
        }

        protected final double getIncumbentValue(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVar);
            }
            return this.getNode().getBranchCallback().getIncumbentValue(this.getIndex(iloNumVar));
        }

        protected final double[] getIncumbentValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getIncumbentValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getIncumbentValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVarArray, n, n2);
            }
            double[] dArray = new double[n2];
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            this.getNode().getBranchCallback().getIncumbentValues(dArray, nArray);
            return dArray;
        }

        protected final boolean isIntegerFeasible() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return true;
            }
            return this.getNode().getBranchCallback().isIntegerFeasible();
        }

        protected final boolean hasIncumbent() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().hasIncumbent();
            }
            return this.getNode().getBranchCallback().hasIncumbent();
        }

        protected final int getNnodes() throws IloException {
            return CplexI.truncateLong(this.getNnodes64());
        }

        protected final int getNremainingNodes() throws IloException {
            return CplexI.truncateLong(this.getNremainingNodes64());
        }

        protected final int getNiterations() throws IloException {
            return CplexI.truncateLong(this.getNiterations64());
        }

        protected final long getNnodes64() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNnodes();
            }
            return this.getNode().getBranchCallback().getNnodes();
        }

        protected final long getNremainingNodes64() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNremainingNodes();
            }
            return this.getNode().getBranchCallback().getNremainingNodes();
        }

        protected final long getNiterations64() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNiterations();
            }
            return this.getNode().getBranchCallback().getNiterations();
        }

        protected int getNcuts(int n) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getNcuts(n);
            }
            return this.getNode().getBranchCallback().getNcuts(n);
        }

        protected final BranchDirection getDirection(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getCplex().getDirection(iloNumVar);
            }
            return this.getNode().getBranchCallback().getCplex().getDirection(iloNumVar);
        }

        protected final int getPriority(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getCplex().getPriority(iloNumVar);
            }
            return this.getNode().getBranchCallback().getCplex().getPriority(iloNumVar);
        }

        protected final double getLB(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVar);
            }
            return this.getNode().getBranchCallback().getLB(this.getIndex(iloNumVar));
        }

        protected final double[] getLBs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getLBs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getLBs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVarArray, n, n2);
            }
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            this.getNode().getBranchCallback().getLBs(dArray, nArray);
            return dArray;
        }

        protected final double getUB(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVar);
            }
            return this.getNode().getBranchCallback().getUB(this.getIndex(iloNumVar));
        }

        protected final double[] getUBs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getUBs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getUBs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVarArray, n, n2);
            }
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            this.getNode().getBranchCallback().getUBs(dArray, nArray);
            return dArray;
        }

        protected final double getObjValue() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getObjValue();
            }
            return this.getNode().getBranchCallback().getObjValue();
        }

        protected final double getValue(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVar);
            }
            return this.getNode().getBranchCallback().getX(this.getIndex(iloNumVar));
        }

        protected final double[] getValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getX(iloNumVarArray, n, n2);
            }
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            this.getNode().getBranchCallback().getX(dArray, nArray);
            return dArray;
        }

        protected final double getSlack(IloRange iloRange) throws IloException {
            IloRange[] iloRangeArray = new IloRange[]{iloRange};
            return this.getSlacks(iloRangeArray, 0, 1)[0];
        }

        protected final double[] getSlacks(IloRange[] iloRangeArray) throws IloException {
            return this.getSlacks(iloRangeArray, 0, iloRangeArray.length);
        }

        protected final double[] getSlacks(IloRange[] iloRangeArray, int n, int n2) throws IloException {
            double[] dArray = new double[this.getNode().getCplex().getNrows()];
            double[] dArray2 = new double[this.getNode().getCplex().getNQCs()];
            if (this.getNode().getIncumbentCallback() != null) {
                this.getNode().getIncumbentCallback().getSlacks(dArray, dArray2);
            } else {
                this.getNode().getBranchCallback().getSlacks(dArray, dArray2);
            }
            double[] dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                CpxRange cpxRange = (CpxRange)iloRangeArray[i + n];
                dArray3[i] = cpxRange.isQC() ? dArray2[cpxRange.getIndexValue()] : dArray[cpxRange.getIndexValue()];
            }
            return dArray3;
        }

        protected final double getValue(IloNumExpr iloNumExpr) throws IloException {
            return this.getNode().getValue((CpxNumExpr)iloNumExpr);
        }

        protected final double getObjCoef(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return this.getNode().getIncumbentCallback().getObjCoef(this.getIndex(iloNumVar));
            }
            return this.getNode().getBranchCallback().getObjCoef(this.getIndex(iloNumVar));
        }

        protected final double[] getObjCoefs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getObjCoefs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final double[] getObjCoefs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            if (this.getNode().getIncumbentCallback() != null) {
                this.getNode().getIncumbentCallback().getObjCoefs(dArray, nArray);
            } else {
                this.getNode().getBranchCallback().getObjCoefs(dArray, nArray);
            }
            return dArray;
        }

        protected final double getDownPseudoCost(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return 0.0;
            }
            return this.getNode().getBranchCallback().getDownPseudoCost(this.getIndex(iloNumVar));
        }

        protected final double getUpPseudoCost(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return 0.0;
            }
            return this.getNode().getBranchCallback().getUpPseudoCost(this.getIndex(iloNumVar));
        }

        protected final IntegerFeasibilityStatus getFeasibility(IloNumVar iloNumVar) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return IntegerFeasibilityStatus.Feasible;
            }
            int n = this.getNode().getBranchCallback().getFeasibility(this.getIndex(iloNumVar));
            return IntegerFeasibilityStatus.map[n];
        }

        protected final IntegerFeasibilityStatus[] getFeasibilities(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getFeasibilities(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected final IntegerFeasibilityStatus[] getFeasibilities(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int n3;
            IntegerFeasibilityStatus[] integerFeasibilityStatusArray = null;
            int[] nArray = null;
            if (this.getNode().getIncumbentCallback() != null) {
                integerFeasibilityStatusArray = new IntegerFeasibilityStatus[n2];
                for (int i = 0; i < n2; ++i) {
                    integerFeasibilityStatusArray[i] = IntegerFeasibilityStatus.Feasible;
                }
                return integerFeasibilityStatusArray;
            }
            int[] nArray2 = new int[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                nArray2[n3] = this.getIndex(iloNumVarArray[n3 + n]);
            }
            nArray = new int[n2];
            this.getNode().getBranchCallback().getFeasibilities(nArray, nArray2);
            integerFeasibilityStatusArray = new IntegerFeasibilityStatus[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                integerFeasibilityStatusArray[n3] = IntegerFeasibilityStatus.map[nArray[n3]];
            }
            return integerFeasibilityStatusArray;
        }

        protected final IntegerFeasibilityStatus getSOSFeasibility(IloSOS1 iloSOS1) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return IntegerFeasibilityStatus.Feasible;
            }
            if (this.getNode().getBranchCallback().getSOSFeasibility(this.getIndex(iloSOS1)) == 1) {
                return IntegerFeasibilityStatus.Feasible;
            }
            return IntegerFeasibilityStatus.Infeasible;
        }

        protected final IntegerFeasibilityStatus getSOSFeasibility(IloSOS2 iloSOS2) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return IntegerFeasibilityStatus.Feasible;
            }
            if (this.getNode().getBranchCallback().getSOSFeasibility(this.getIndex(iloSOS2)) == 1) {
                return IntegerFeasibilityStatus.Feasible;
            }
            return IntegerFeasibilityStatus.Infeasible;
        }

        protected final NodeId getNodeId() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return new NodeId(this.getNode().getIncumbentCallback().getNodeId());
            }
            return new NodeId(this.getNode().getBranchCallback().getNodeId());
        }

        protected final int getNbranches() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return 0;
            }
            return this.getNode().getBranchCallback().getNbranches();
        }

        protected final BranchType getBranchType() throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return BranchType.BranchOnVariable;
            }
            return this.getNode().getBranchCallback().getBranchType();
        }

        protected double[] getBranches(IloNumVar[][] iloNumVarArray, double[][] dArray, BranchDirection[][] branchDirectionArray) throws IloException {
            if (this.getNode().getIncumbentCallback() != null) {
                return null;
            }
            return this.getNode().getBranchCallback().getBranches(iloNumVarArray, dArray, branchDirectionArray);
        }

        protected double[] getBranches(IloRange[][] iloRangeArray) throws IloException {
            return this.getNode().getBranchCallback().getBranches(iloRangeArray);
        }
    }

    public static class CplexEndedException
    extends IloException {
        private static final long serialVersionUID = 12080000L;

        CplexEndedException() {
            super("illegal method invocation after IloCplex.end()");
        }
    }

    public static class MultipleUseException
    extends IloException {
        private static final long serialVersionUID = 12080000L;

        MultipleUseException() {
            super("");
        }
    }

    public static class UnsupportedObjectException
    extends CpxException {
        private static final long serialVersionUID = 12080000L;
        Object _obj;

        public UnsupportedObjectException(Object object) {
            super(-3, "CPLEX Error: object type is not supported by IloCplex");
            this._obj = object;
        }

        public Object getObject() {
            return this._obj;
        }
    }

    public static class UnknownObjectException
    extends CpxException {
        private static final long serialVersionUID = 12080000L;
        Object _obj;

        public UnknownObjectException(Object object) {
            super(-2, "CPLEX Error: object is unknown to IloCplex");
            this._obj = object;
        }

        public Object getObject() {
            return this._obj;
        }
    }

    public static abstract class TuningCallback
    extends Callback {
        protected TuningCallback() {
            this.cb = new CpxTuningCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxTuningCallback)this.cb).getProgress();
        }
    }

    public static abstract class HeuristicCallback
    extends ControlCallback {
        protected HeuristicCallback() {
            this.cb = new CpxHeuristicCallback(this);
        }

        protected void setBounds(IloNumVar iloNumVar, double d, double d2) throws IloException {
            ((CpxHeuristicCallback)this.cb).setBounds(iloNumVar, d, d2);
        }

        protected void setBounds(IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2) throws IloException {
            this.setBounds(iloNumVarArray, dArray, dArray2, 0, iloNumVarArray.length);
        }

        protected void setBounds(IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2, int n, int n2) throws IloException {
            ((CpxHeuristicCallback)this.cb).setBounds(iloNumVarArray, dArray, dArray2, n, n2);
        }

        protected boolean solve(int n) throws IloException {
            ((CpxHeuristicCallback)this.cb).solveAlg(n);
            Status status = this.getStatus();
            return status == Status.Feasible || status == Status.Optimal;
        }

        protected boolean solve() throws IloException {
            return this.solve(2);
        }

        protected Status getStatus() throws IloException {
            return IloCplex.makeStatus(((CpxHeuristicCallback)this.cb).getCplexStatus(), ((CpxHeuristicCallback)this.cb).isPfeas(), ((CpxHeuristicCallback)this.cb).isDfeas());
        }

        protected CplexStatus getCplexStatus() throws IloException {
            return CplexStatus.getStatus(((CpxHeuristicCallback)this.cb).getCplexStatus());
        }

        public boolean isDualFeasible() throws IloException {
            return ((CpxHeuristicCallback)this.cb).isDfeas();
        }

        public boolean isPrimalFeasible() throws IloException {
            return ((CpxHeuristicCallback)this.cb).isPfeas();
        }

        protected void setSolution(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2) throws IloException {
            ((CpxHeuristicCallback)this.cb).setSolution(iloNumVarArray, dArray, n, n2);
        }

        protected void setSolution(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
            this.setSolution(iloNumVarArray, dArray, 0, iloNumVarArray.length);
        }

        protected void setSolution(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2, double d) throws IloException {
            ((CpxHeuristicCallback)this.cb).setSolution(iloNumVarArray, dArray, n, n2, d);
        }

        protected void setSolution(IloNumVar[] iloNumVarArray, double[] dArray, double d) throws IloException {
            this.setSolution(iloNumVarArray, dArray, 0, iloNumVarArray.length, d);
        }
    }

    public static abstract class BranchCallback
    extends ControlCallback {
        protected BranchCallback() {
            this.cb = new CpxBranchCallback(this);
        }

        protected int getNbranches() {
            return ((CpxBranchCallback)this.cb).getNbranches();
        }

        protected BranchType getBranchType() {
            return ((CpxBranchCallback)this.cb).getBranchType();
        }

        protected double[] getBranches(IloNumVar[][] iloNumVarArray, double[][] dArray, BranchDirection[][] branchDirectionArray) throws IloException {
            return ((CpxBranchCallback)this.cb).getBranches(iloNumVarArray, dArray, branchDirectionArray);
        }

        protected double[] getBranches(IloRange[][] iloRangeArray) throws IloException {
            return ((CpxBranchCallback)this.cb).getBranches(iloRangeArray);
        }

        protected boolean isIntegerFeasible() throws IloException {
            return ((CpxBranchCallback)this.cb).isIntegerFeasible();
        }

        protected NodeId makeBranch(IloNumVar[] iloNumVarArray, double[] dArray, BranchDirection[] branchDirectionArray, double d) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloNumVarArray, dArray, branchDirectionArray, d, null);
        }

        protected NodeId makeBranch(int n, Object object) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(n, object);
        }

        protected NodeId makeBranch(IloNumVar[] iloNumVarArray, double[] dArray, BranchDirection[] branchDirectionArray, double d, Object object) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloNumVarArray, dArray, branchDirectionArray, d, object);
        }

        protected NodeId makeBranch(IloNumVar iloNumVar, double d, BranchDirection branchDirection, double d2) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloNumVar, d, branchDirection, d2, null);
        }

        protected NodeId makeBranch(IloNumVar iloNumVar, double d, BranchDirection branchDirection, double d2, Object object) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloNumVar, d, branchDirection, d2, object);
        }

        protected NodeId makeBranch(IloRange[] iloRangeArray, double d) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloRangeArray, d, null);
        }

        protected NodeId makeBranch(IloRange[] iloRangeArray, double d, Object object) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloRangeArray, d, object);
        }

        protected NodeId makeBranch(IloRange iloRange, double d) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloRange, d, null);
        }

        protected NodeId makeBranch(IloRange iloRange, double d, Object object) throws IloException {
            return ((CpxBranchCallback)this.cb).makeBranch(iloRange, d, object);
        }

        protected void prune() {
            ((CpxBranchCallback)this.cb).prune();
        }
    }

    public static class BranchType {
        int _type;
        public static final BranchType BranchOnVariable = new _BranchOnVariable();
        public static final BranchType BranchOnAny = new _BranchOnAny();
        public static final BranchType BranchOnSOS1 = new _BranchOnSOS1();
        public static final BranchType BranchOnSOS2 = new _BranchOnSOS2();

        BranchType(int n) {
            this._type = n;
        }

        public boolean equals(Object object) {
            if (object instanceof BranchType) {
                return this._type == ((BranchType)object)._type;
            }
            return false;
        }

        public String toString() {
            switch (this._type) {
                case 49: {
                    return "BranchOnSOS1";
                }
                case 50: {
                    return "BranchOnSOS2";
                }
                case 65: {
                    return "BranchOnAny";
                }
            }
            return "BranchOnVariable";
        }

        private static class _BranchOnSOS2
        extends BranchType {
            _BranchOnSOS2() {
                super(50);
            }

            @Override
            public String toString() {
                return "BranchOnSOS2";
            }
        }

        private static class _BranchOnSOS1
        extends BranchType {
            _BranchOnSOS1() {
                super(49);
            }

            @Override
            public String toString() {
                return "BranchOnSOS1";
            }
        }

        private static class _BranchOnAny
        extends BranchType {
            _BranchOnAny() {
                super(65);
            }

            @Override
            public String toString() {
                return "BranchOnAny";
            }
        }

        private static class _BranchOnVariable
        extends BranchType {
            _BranchOnVariable() {
                super(48);
            }

            @Override
            public String toString() {
                return "BranchOnVariable";
            }
        }
    }

    public static abstract class NodeCallback
    extends MIPCallback {
        protected NodeCallback() {
            this.cb = new CpxNodeCallback(this);
        }

        protected NodeId getNodeId(long l) throws IloException {
            return new NodeId(((CpxNodeCallback)this.cb).getNodeId(l));
        }

        protected double getObjValue(long l) throws IloException {
            return ((CpxNodeCallback)this.cb).getObjValue(l);
        }

        protected double getEstimatedObjValue(long l) throws IloException {
            return ((CpxNodeCallback)this.cb).getEstimatedObjValue(l);
        }

        protected int getDepth(long l) throws IloException {
            return ((CpxNodeCallback)this.cb).getDepth(l);
        }

        protected double getInfeasibilitySum(long l) throws IloException {
            return ((CpxNodeCallback)this.cb).getInfeasibilitySum(l);
        }

        protected int getNinfeasibilities(long l) throws IloException {
            return ((CpxNodeCallback)this.cb).getNinfeasibilities(l);
        }

        protected void selectNode(long l) throws IloException {
            ((CpxNodeCallback)this.cb).selectNode(l);
        }

        protected IloNumVar getBranchVar(long l) throws IloException {
            return ((CpxNodeCallback)this.cb).getBranchVar(l);
        }

        protected Object getNodeData(long l) throws IloException {
            return ((CpxNodeCallback)this.cb).getNodeData(l);
        }

        protected Object setNodeData(long l, Object object) throws IloException {
            return ((CpxNodeCallback)this.cb).setNodeData(l, object);
        }

        protected int getNodeNumber(NodeId nodeId) throws IloException {
            return CplexI.truncateLong(this.getNodeNumber64(nodeId));
        }

        protected long getNodeNumber64(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getNodeNumber(nodeId._id);
        }

        protected double getObjValue(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getObjValueById(nodeId._id);
        }

        protected double getEstimatedObjValue(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getEstimatedObjValueById(nodeId._id);
        }

        protected int getDepth(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getDepthById(nodeId._id);
        }

        protected double getInfeasibilitySum(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getInfeasibilitySumById(nodeId._id);
        }

        protected int getNinfeasibilities(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getNinfeasibilitiesById(nodeId._id);
        }

        protected void selectNode(NodeId nodeId) throws IloException {
            ((CpxNodeCallback)this.cb).selectNodeById(nodeId._id);
        }

        protected IloNumVar getBranchVar(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getBranchVarById(nodeId._id);
        }

        protected Object getNodeData(NodeId nodeId) throws IloException {
            return ((CpxNodeCallback)this.cb).getNodeDataById(nodeId._id);
        }
    }

    public static class NodeId {
        long _id;

        NodeId(long l) {
            this._id = l;
        }

        public boolean equals(Object object) {
            if (object instanceof NodeId) {
                return this._id == ((NodeId)object)._id;
            }
            return false;
        }

        public String toString() {
            return "Node" + this._id;
        }
    }

    public static abstract class DisjunctiveCutCallback
    extends MIPCallback {
        protected DisjunctiveCutCallback() {
            this.cb = new CpxDisjunctiveCutCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxDisjunctiveCutCallback)this.cb).getProgress();
        }
    }

    public static abstract class DisjunctiveCutInfoCallback
    extends MIPInfoCallback {
        protected DisjunctiveCutInfoCallback() {
            this.cb = new CpxDisjunctiveCutInfoCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxDisjunctiveCutInfoCallback)this.cb).getProgress();
        }
    }

    public static abstract class FlowMIRCutCallback
    extends MIPCallback {
        protected FlowMIRCutCallback() {
            this.cb = new CpxFlowMIRCutCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxFlowMIRCutCallback)this.cb).getProgress();
        }
    }

    public static abstract class FlowMIRCutInfoCallback
    extends MIPInfoCallback {
        protected FlowMIRCutInfoCallback() {
            this.cb = new CpxFlowMIRCutInfoCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxFlowMIRCutInfoCallback)this.cb).getProgress();
        }
    }

    public static abstract class FractionalCutCallback
    extends MIPCallback {
        protected FractionalCutCallback() {
            this.cb = new CpxFractionalCutCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxFractionalCutCallback)this.cb).getProgress();
        }
    }

    public static abstract class FractionalCutInfoCallback
    extends MIPInfoCallback {
        protected FractionalCutInfoCallback() {
            this.cb = new CpxFractionalCutInfoCallback(this);
        }

        protected double getProgress() throws IloException {
            return ((CpxFractionalCutInfoCallback)this.cb).getProgress();
        }
    }

    public static abstract class ProbingCallback
    extends MIPCallback {
        protected ProbingCallback() {
            this.cb = new CpxProbingCallback(this);
        }

        protected int getPhase() throws IloException {
            return ((CpxProbingCallback)this.cb).getPhase();
        }

        protected double getProgress() throws IloException {
            return ((CpxProbingCallback)this.cb).getProgress();
        }
    }

    public static abstract class ProbingInfoCallback
    extends MIPInfoCallback {
        protected ProbingInfoCallback() {
            this.cb = new CpxProbingInfoCallback(this);
        }

        protected int getPhase() throws IloException {
            return ((CpxProbingInfoCallback)this.cb).getPhase();
        }

        protected double getProgress() throws IloException {
            return ((CpxProbingInfoCallback)this.cb).getProgress();
        }
    }

    public static abstract class UserCutCallback
    extends ControlCallback {
        protected IloRange add(IloRange iloRange, int n) throws IloException {
            return ((CpxCutCallback)this.cb).addCut(iloRange, n);
        }

        protected IloRange addLocal(IloRange iloRange) throws IloException {
            return ((CpxCutCallback)this.cb).addLocalCut(iloRange);
        }

        protected boolean isAfterCutLoop() {
            return ((CpxMIPCallback)this.cb).whereFrom() == 114;
        }

        protected void abortCutLoop() {
            ((CpxCutCallback)this.cb).setUserAction(3);
        }

        protected UserCutCallback() {
            this.cb = new CpxCutCallback(this, false);
        }
    }

    public static abstract class LazyConstraintCallback
    extends ControlCallback {
        protected IloRange add(IloRange iloRange) throws IloException {
            return ((CpxCutCallback)this.cb).addCut(iloRange, 0);
        }

        protected IloRange add(IloRange iloRange, int n) throws IloException {
            return ((CpxCutCallback)this.cb).addCut(iloRange, n);
        }

        protected IloRange addLocal(IloRange iloRange) throws IloException {
            return ((CpxCutCallback)this.cb).addLocalCut(iloRange);
        }

        protected boolean isUnboundedNode() {
            return ((CpxMIPCallback)this.cb).whereFrom() == 116;
        }

        protected int getSolutionSource() {
            switch (((CpxCutCallback)this.cb).getSource()) {
                case 111: {
                    return 111;
                }
                case 117: {
                    return 117;
                }
                case 118: {
                    return 118;
                }
                case 119: {
                    return 119;
                }
            }
            return 117;
        }

        protected LazyConstraintCallback() {
            this.cb = new CpxCutCallback(this, true);
        }
    }

    public static class CutManagement {
        public static final int UseCutForce = 0;
        public static final int UseCutPurge = 1;
        public static final int UseCutFilter = 2;
    }

    public static abstract class ControlCallback
    extends MIPCallback {
        protected NodeId getNodeId() throws IloException {
            return new NodeId(((CpxControlCallback)this.cb).getNodeId());
        }

        protected double getLB(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getLB(this.getIndex(iloNumVar));
        }

        protected double[] getLBs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getLBs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getLBs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            ((CpxControlCallback)this.cb).getLBs(dArray, nArray);
            return dArray;
        }

        protected double getUB(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getUB(this.getIndex(iloNumVar));
        }

        protected double[] getUBs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getUBs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getUBs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            ((CpxControlCallback)this.cb).getUBs(dArray, nArray);
            return dArray;
        }

        protected double getObjValue() throws IloException {
            return ((CpxControlCallback)this.cb).getObjValue();
        }

        protected double getValue(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getX(this.getIndex(iloNumVar));
        }

        protected double[] getValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            ((CpxControlCallback)this.cb).getX(dArray, nArray);
            return dArray;
        }

        protected double getSlack(IloRange iloRange) throws IloException {
            IloRange[] iloRangeArray = new IloRange[]{iloRange};
            return this.getSlacks(iloRangeArray, 0, 1)[0];
        }

        protected double[] getSlacks(IloRange[] iloRangeArray) throws IloException {
            return this.getSlacks(iloRangeArray, 0, iloRangeArray.length);
        }

        protected double[] getSlacks(IloRange[] iloRangeArray, int n, int n2) throws IloException {
            double[] dArray = new double[this.getNrows()];
            double[] dArray2 = new double[this.getNQCs()];
            ((CpxControlCallback)this.cb).getSlacks(dArray, dArray2);
            double[] dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                CpxRange cpxRange = (CpxRange)iloRangeArray[i + n];
                dArray3[i] = cpxRange.isQC() ? dArray2[cpxRange.getIndexValue()] : dArray[cpxRange.getIndexValue()];
            }
            return dArray3;
        }

        protected double getValue(IloNumExpr iloNumExpr) throws IloException {
            CpxControlCallback cpxControlCallback = (CpxControlCallback)this.cb;
            int n = cpxControlCallback.getCplexI().getNcols();
            double[] dArray = new double[n];
            cpxControlCallback.getX(dArray);
            EvalVisitor evalVisitor = new EvalVisitor(dArray);
            CpxNumExpr cpxNumExpr = (CpxNumExpr)iloNumExpr;
            cpxNumExpr.accept(evalVisitor);
            return evalVisitor.getValue();
        }

        final double callGetValue(IloNumExpr iloNumExpr) throws IloException {
            return this.getValue(iloNumExpr);
        }

        protected double getDownPseudoCost(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getDownPseudoCost(this.getIndex(iloNumVar));
        }

        protected double getUpPseudoCost(IloNumVar iloNumVar) throws IloException {
            return ((CpxControlCallback)this.cb).getUpPseudoCost(this.getIndex(iloNumVar));
        }

        protected IntegerFeasibilityStatus getFeasibility(IloNumVar iloNumVar) throws IloException {
            int n = ((CpxControlCallback)this.cb).getFeasibility(this.getIndex(iloNumVar));
            return IntegerFeasibilityStatus.map[n];
        }

        protected IntegerFeasibilityStatus[] getFeasibilities(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getFeasibilities(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected IntegerFeasibilityStatus[] getFeasibilities(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            int[] nArray2 = new int[n2];
            ((CpxControlCallback)this.cb).getFeasibilities(nArray2, nArray);
            IntegerFeasibilityStatus[] integerFeasibilityStatusArray = new IntegerFeasibilityStatus[n2];
            for (int i = 0; i < n2; ++i) {
                integerFeasibilityStatusArray[i] = IntegerFeasibilityStatus.map[nArray2[i]];
            }
            return integerFeasibilityStatusArray;
        }

        protected IntegerFeasibilityStatus getSOSFeasibility(IloSOS1 iloSOS1) throws IloException {
            if (((CpxControlCallback)this.cb).getSOSFeasibility(this.getIndex(iloSOS1)) == 1) {
                return IntegerFeasibilityStatus.Feasible;
            }
            return IntegerFeasibilityStatus.Infeasible;
        }

        protected IntegerFeasibilityStatus getSOSFeasibility(IloSOS2 iloSOS2) throws IloException {
            if (((CpxControlCallback)this.cb).getSOSFeasibility(this.getIndex(iloSOS2)) == 1) {
                return IntegerFeasibilityStatus.Feasible;
            }
            return IntegerFeasibilityStatus.Infeasible;
        }

        protected Object getNodeData() throws IloException {
            return ((CpxControlCallback)this.cb).getNodeData();
        }

        protected Object setNodeData(Object object) throws IloException {
            return ((CpxControlCallback)this.cb).setNodeData(object);
        }
    }

    public static class IntegerFeasibilityStatus {
        public static final IntegerFeasibilityStatus Feasible = new _Feasible();
        public static final IntegerFeasibilityStatus Implied = new _Implied();
        public static final IntegerFeasibilityStatus Infeasible = new _Infeasible();
        static IntegerFeasibilityStatus[] map = new IntegerFeasibilityStatus[]{Feasible, Infeasible, Implied};

        private static class _Infeasible
        extends IntegerFeasibilityStatus {
            private _Infeasible() {
            }

            public String toString() {
                return "IntegerInfeasible";
            }
        }

        private static class _Implied
        extends IntegerFeasibilityStatus {
            private _Implied() {
            }

            public String toString() {
                return "ImpliedIntegerFeasible";
            }
        }

        private static class _Feasible
        extends IntegerFeasibilityStatus {
            private _Feasible() {
            }

            public String toString() {
                return "IntegerFeasible";
            }
        }
    }

    public static abstract class SolveCallback
    extends ControlCallback {
        protected SolveCallback() {
            this.cb = new CpxSolveCallback(this);
        }

        protected boolean solve(int n) throws IloException {
            ((CpxSolveCallback)this.cb).solveAlg(n);
            Status status = this.getStatus();
            return status == Status.Feasible || status == Status.Optimal;
        }

        protected boolean solve() throws IloException {
            return this.solve(0);
        }

        protected Status getStatus() throws IloException {
            return IloCplex.makeStatus(((CpxSolveCallback)this.cb).getCplexStatus(), ((CpxSolveCallback)this.cb).isPfeas(), ((CpxSolveCallback)this.cb).isDfeas());
        }

        protected CplexStatus getCplexStatus() throws IloException {
            return CplexStatus.getStatus(((CpxSolveCallback)this.cb).getCplexStatus());
        }

        public boolean isDualFeasible() throws IloException {
            return ((CpxSolveCallback)this.cb).isDfeas();
        }

        public boolean isPrimalFeasible() throws IloException {
            return ((CpxSolveCallback)this.cb).isPfeas();
        }

        protected void useSolution() {
            ((CpxSolveCallback)this.cb).useSolution();
        }

        protected void setStart(double[] dArray, IloNumVar[] iloNumVarArray, double[] dArray2, IloRange[] iloRangeArray) throws IloException {
            int n = iloNumVarArray != null ? iloNumVarArray.length : 0;
            int n2 = iloRangeArray != null ? iloRangeArray.length : 0;
            this.setStart(dArray, iloNumVarArray, 0, n, dArray2, iloRangeArray, 0, n2);
        }

        protected void setStart(double[] dArray, IloNumVar[] iloNumVarArray, int n, int n2, double[] dArray2, IloRange[] iloRangeArray, int n3, int n4) throws IloException {
            ((CpxSolveCallback)this.cb).setStart(dArray, iloNumVarArray, n, n2, dArray2, iloRangeArray, n3, n4);
        }
    }

    public static abstract class IncumbentCallback
    extends MIPCallback {
        protected IncumbentCallback() {
            this.cb = new CpxIncumbentCallback(this);
        }

        protected int getSolutionSource() {
            switch (((CpxMIPCallback)this.cb).whereFrom()) {
                case 111: {
                    return 111;
                }
                case 117: {
                    return 117;
                }
                case 118: {
                    return 118;
                }
                case 119: {
                    return 119;
                }
            }
            return 117;
        }

        protected double getObjValue() throws IloException {
            return ((CpxIncumbentCallback)this.cb).getObjValue();
        }

        protected double getValue(IloNumVar iloNumVar) throws IloException {
            return ((CpxIncumbentCallback)this.cb).getX(iloNumVar);
        }

        protected double[] getValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            return ((CpxIncumbentCallback)this.cb).getX(iloNumVarArray, n, n2);
        }

        protected double getValue(IloNumExpr iloNumExpr) throws IloException {
            return ((CpxIncumbentCallback)this.cb).getValue((CpxNumExpr)iloNumExpr);
        }

        protected double getSlack(IloRange iloRange) throws IloException {
            IloRange[] iloRangeArray = new IloRange[]{iloRange};
            return this.getSlacks(iloRangeArray, 0, 1)[0];
        }

        protected double[] getSlacks(IloRange[] iloRangeArray) throws IloException {
            return this.getSlacks(iloRangeArray, 0, iloRangeArray.length);
        }

        protected double[] getSlacks(IloRange[] iloRangeArray, int n, int n2) throws IloException {
            double[] dArray = new double[this.getNrows()];
            double[] dArray2 = new double[this.getNQCs()];
            ((CpxIncumbentCallback)this.cb).getSlacks(dArray, dArray2);
            double[] dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                CpxRange cpxRange = (CpxRange)iloRangeArray[i + n];
                dArray3[i] = cpxRange.isQC() ? dArray2[cpxRange.getIndexValue()] : dArray[cpxRange.getIndexValue()];
            }
            return dArray3;
        }

        protected NodeId getNodeId() throws IloException {
            return new NodeId(((CpxIncumbentCallback)this.cb).getNodeId());
        }

        protected Object getNodeData() throws IloException {
            return ((CpxIncumbentCallback)this.cb).getNodeData();
        }

        protected Object setNodeData(Object object) throws IloException {
            return ((CpxIncumbentCallback)this.cb).setNodeData(object);
        }

        protected void reject() {
            ((CpxIncumbentCallback)this.cb).reject();
        }
    }

    public static final class SolutionSource {
        public static final int NodeSolution = 111;
        public static final int HeuristicSolution = 117;
        public static final int UserSolution = 118;
        public static final int MIPStartSolution = 119;
    }

    public static abstract class MIPCallback
    extends MIPInfoCallback {
        protected MIPCallback() {
            this.cb = new CpxMIPCallback(this);
        }

        protected int getUserThreads() throws IloException {
            return ((CpxMIPCallback)this.cb).getUserThreads();
        }

        protected double getObjCoef(IloNumVar iloNumVar) throws IloException {
            return ((CpxMIPCallback)this.cb).getObjCoef(this.getIndex(iloNumVar));
        }

        protected double[] getObjCoefs(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getObjCoefs(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getObjCoefs(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            double[] dArray = new double[n2];
            ((CpxMIPCallback)this.cb).getObjCoefs(dArray, nArray);
            return dArray;
        }

        public static interface NodeData {
            public void delete();
        }
    }

    public static abstract class MIPInfoCallback
    extends OptimizationCallback {
        final int getIndex(IloNumVar iloNumVar) throws IloException {
            return ((CpxNumVar)iloNumVar).getVarIndexValue();
        }

        final int getIndex(IloRange iloRange) throws IloException {
            return ((CpxRange)iloRange).getIndexValue();
        }

        final int getIndex(IloSOS1 iloSOS1) throws IloException {
            return ((CpxSOS)((Object)iloSOS1)).getIndexValue();
        }

        final int getIndex(IloSOS2 iloSOS2) throws IloException {
            return ((CpxSOS)((Object)iloSOS2)).getIndexValue();
        }

        protected MIPInfoCallback() {
            this.cb = new CpxMIPInfoCallback(this);
        }

        protected int getMyThreadNum() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getMyThreadNum();
        }

        protected double getBestObjValue() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getBestObjValue();
        }

        protected double getMIPRelativeGap() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getMIPRelativeGap();
        }

        protected double getCutoff() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getCutoff();
        }

        protected double getIncumbentObjValue() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getIncumbentObjValue();
        }

        protected double getIncumbentValue(IloNumVar iloNumVar) throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getIncumbentValue(this.getIndex(iloNumVar));
        }

        protected double[] getIncumbentValues(IloNumVar[] iloNumVarArray) throws IloException {
            return this.getIncumbentValues(iloNumVarArray, 0, iloNumVarArray.length);
        }

        protected double[] getIncumbentValues(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
            double[] dArray = new double[n2];
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.getIndex(iloNumVarArray[i + n]);
            }
            ((CpxMIPInfoCallback)this.cb).getIncumbentValues(dArray, nArray);
            return dArray;
        }

        protected double getIncumbentValue(IloNumExpr iloNumExpr) throws IloException {
            CpxMIPInfoCallback cpxMIPInfoCallback = (CpxMIPInfoCallback)this.cb;
            int n = cpxMIPInfoCallback.getCplexI().getNcols();
            double[] dArray = cpxMIPInfoCallback.getIncumbentX();
            EvalVisitor evalVisitor = new EvalVisitor(dArray);
            CpxNumExpr cpxNumExpr = (CpxNumExpr)iloNumExpr;
            cpxNumExpr.accept(evalVisitor);
            return evalVisitor.getValue();
        }

        protected boolean hasIncumbent() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).hasIncumbent();
        }

        protected int getNcuts(int n) throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getNcuts(n);
        }

        protected int getNnodes() throws IloException {
            return CplexI.truncateLong(((CpxMIPInfoCallback)this.cb).getNnodes());
        }

        protected int getNremainingNodes() throws IloException {
            return CplexI.truncateLong(((CpxMIPInfoCallback)this.cb).getNremainingNodes());
        }

        protected int getNiterations() throws IloException {
            return CplexI.truncateLong(((CpxMIPInfoCallback)this.cb).getNiterations());
        }

        protected long getNnodes64() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getNnodes();
        }

        protected long getNremainingNodes64() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getNremainingNodes();
        }

        protected long getNiterations64() throws IloException {
            return ((CpxMIPInfoCallback)this.cb).getNiterations();
        }

        protected BranchDirection getDirection(IloNumVar iloNumVar) throws IloException {
            return this.cb.getCplex().getDirection(iloNumVar);
        }

        protected int getPriority(IloNumVar iloNumVar) throws IloException {
            return this.cb.getCplex().getPriority(iloNumVar);
        }

        protected Quality getQuality(QualityType qualityType) throws IloException {
            Quality quality = new Quality();
            quality.var = null;
            quality.rng = null;
            quality.value = ((CpxMIPInfoCallback)this.cb).getQuality(qualityType.getValue());
            quality.type = qualityType;
            return quality;
        }
    }

    public static abstract class NetworkCallback
    extends OptimizationCallback {
        protected NetworkCallback() {
            this.cb = new CpxNetworkCallback(this);
        }

        protected double getObjValue() throws IloException {
            return ((CpxNetworkCallback)this.cb).getObjValue();
        }

        protected double getInfeasibility() throws IloException {
            return ((CpxNetworkCallback)this.cb).getInfeasibility();
        }

        protected boolean isFeasible() throws IloException {
            return ((CpxNetworkCallback)this.cb).isFeasible();
        }

        protected int getNiterations() throws IloException {
            return CplexI.truncateLong(((CpxNetworkCallback)this.cb).getNiterations());
        }

        protected long getNiterations64() throws IloException {
            return ((CpxNetworkCallback)this.cb).getNiterations();
        }
    }

    public static abstract class CrossoverCallback
    extends OptimizationCallback {
        protected CrossoverCallback() {
            this.cb = new CpxLPCallback(this, 3);
        }

        protected int getNprimalPushes() throws IloException {
            return CplexI.truncateLong(((CpxLPCallback)this.cb).getNprimalPushes());
        }

        protected int getNprimalExchanges() throws IloException {
            return CplexI.truncateLong(((CpxLPCallback)this.cb).getNprimalExchanges());
        }

        protected int getNdualPushes() throws IloException {
            return CplexI.truncateLong(((CpxLPCallback)this.cb).getNdualPushes());
        }

        protected int getNdualExchanges() throws IloException {
            return CplexI.truncateLong(((CpxLPCallback)this.cb).getNdualExchanges());
        }

        protected long getNprimalPushes64() throws IloException {
            return ((CpxLPCallback)this.cb).getNprimalPushes();
        }

        protected long getNprimalExchanges64() throws IloException {
            return ((CpxLPCallback)this.cb).getNprimalExchanges();
        }

        protected long getNdualPushes64() throws IloException {
            return ((CpxLPCallback)this.cb).getNdualPushes();
        }

        protected long getNdualExchanges64() throws IloException {
            return ((CpxLPCallback)this.cb).getNdualExchanges();
        }

        protected int getNsuperbasics() throws IloException {
            return ((CpxLPCallback)this.cb).getNsuperbasics();
        }
    }

    @Deprecated
    public static abstract class PresolveCallback
    extends OptimizationCallback {
        protected PresolveCallback() {
            this.cb = new CpxLPCallback(this, 0);
        }

        protected int getNremovedRows() throws IloException {
            return ((CpxLPCallback)this.cb).getNremovedRows();
        }

        protected int getNremovedCols() throws IloException {
            return ((CpxLPCallback)this.cb).getNremovedCols();
        }

        protected int getNaggregations() throws IloException {
            return CplexI.truncateLong(((CpxLPCallback)this.cb).getNaggregations());
        }

        protected int getNmodifiedCoeffs() throws IloException {
            return CplexI.truncateLong(((CpxLPCallback)this.cb).getNmodifiedCoeffs());
        }

        protected long getNaggregations64() throws IloException {
            return ((CpxLPCallback)this.cb).getNaggregations();
        }

        protected long getNmodifiedCoeffs64() throws IloException {
            return ((CpxLPCallback)this.cb).getNmodifiedCoeffs();
        }
    }

    public static abstract class BarrierCallback
    extends ContinuousCallback {
        protected BarrierCallback() {
            super(2);
        }

        protected double getDualObjValue() throws IloException {
            return ((CpxLPCallback)this.cb).getDualObjValue();
        }
    }

    public static abstract class SimplexCallback
    extends ContinuousCallback {
        protected SimplexCallback() {
            super(1);
        }
    }

    public static abstract class ContinuousCallback
    extends OptimizationCallback {
        protected ContinuousCallback(int n) {
            this.cb = new CpxLPCallback(this, n);
        }

        protected ContinuousCallback() {
            this.cb = new CpxLPCallback(this, -1);
        }

        protected double getObjValue() throws IloException {
            return ((CpxLPCallback)this.cb).getObjValue();
        }

        protected double getInfeasibility() throws IloException {
            return ((CpxLPCallback)this.cb).getInfeasibility();
        }

        protected double getDualInfeasibility() throws IloException {
            return ((CpxLPCallback)this.cb).getDualInfeasibility();
        }

        protected boolean isFeasible() throws IloException {
            return ((CpxLPCallback)this.cb).isFeasible();
        }

        protected boolean isDualFeasible() throws IloException {
            return ((CpxLPCallback)this.cb).isDualFeasible();
        }

        protected int getNiterations() throws IloException {
            return CplexI.truncateLong(((CpxLPCallback)this.cb).getNiterations());
        }

        protected long getNiterations64() throws IloException {
            return ((CpxLPCallback)this.cb).getNiterations();
        }
    }

    public static abstract class OptimizationCallback
    extends Callback {
        protected IloModel getModel() throws IloException {
            return this.cb.getCplex().getModel();
        }

        protected int getNrows() {
            return this.cb.getCplex().getNrows();
        }

        protected int getNQCs() {
            return this.cb.getCplex().getNQCs();
        }

        protected int getNcols() {
            return this.cb.getCplex().getNcols();
        }
    }

    public static abstract class Callback
    implements Cloneable {
        CpxCallback cb;

        Callback() {
        }

        protected abstract void main() throws IloException;

        protected void abort() {
            this.cb.abort();
        }

        public double getCplexTime() throws IloException {
            return this.cb.getCplexTime();
        }

        public double getDetTime() throws IloException {
            return this.cb.getDetTime();
        }

        protected double getStartTime() throws IloException {
            return this.cb.getStartTime();
        }

        protected double getStartDetTime() throws IloException {
            return this.cb.getStartDetTime();
        }

        protected double getEndTime() throws IloException {
            return this.cb.getEndTime();
        }

        protected double getEndDetTime() throws IloException {
            return this.cb.getEndDetTime();
        }

        final Callback makeClone() {
            try {
                return (Callback)this.clone();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public static interface Function {
            public void invoke(Context var1) throws IloException;
        }

        public static abstract class Context {
            protected Context() {
            }

            public abstract long getId();

            public final boolean inThreadUp() {
                return this.getId() == 2L;
            }

            public final boolean inThreadDown() {
                return this.getId() == 4L;
            }

            public final boolean inLocalProgress() {
                return this.getId() == 8L;
            }

            public final boolean inGlobalProgress() {
                return this.getId() == 16L;
            }

            public final boolean inCandidate() {
                return this.getId() == 32L;
            }

            public final boolean inRelaxation() {
                return this.getId() == 64L;
            }

            public abstract IloCplex getCplex();

            public abstract void abort() throws IloException;

            public abstract int getIntInfo(Info var1) throws IloException;

            public abstract long getLongInfo(Info var1) throws IloException;

            public abstract double getDoubleInfo(Info var1) throws IloException;

            public abstract void postHeuristicSolution(IloNumVar[] var1, double[] var2, int var3, int var4, double var5, SolutionStrategy var7) throws IloException;

            public abstract boolean isCandidatePoint() throws IloException;

            public abstract double[] getCandidatePoint(IloNumVar[] var1, int var2, int var3) throws IloException;

            public abstract boolean isCandidateRay() throws IloException;

            public abstract IloLinearNumExpr getCandidateRay() throws IloException;

            public double[] getCandidatePoint(IloNumVar[] iloNumVarArray) throws IloException {
                return this.getCandidatePoint(iloNumVarArray, 0, iloNumVarArray.length);
            }

            public double getCandidatePoint(IloNumVar iloNumVar) throws IloException {
                return this.getCandidatePoint(new IloNumVar[]{iloNumVar}, 0, 1)[0];
            }

            public abstract double getCandidateValue(IloNumExpr var1) throws IloException;

            public abstract double getCandidateObjective() throws IloException;

            public abstract void rejectCandidate(IloRange[] var1) throws IloException;

            public void rejectCandidate(IloRange iloRange) throws IloException {
                IloRange[] iloRangeArray;
                if (iloRange != null) {
                    IloRange[] iloRangeArray2 = new IloRange[1];
                    iloRangeArray = iloRangeArray2;
                    iloRangeArray2[0] = iloRange;
                } else {
                    iloRangeArray = null;
                }
                this.rejectCandidate(iloRangeArray);
            }

            public abstract double[] getRelaxationPoint(IloNumVar[] var1, int var2, int var3) throws IloException;

            public double[] getRelaxationPoint(IloNumVar[] iloNumVarArray) throws IloException {
                return this.getRelaxationPoint(iloNumVarArray, 0, iloNumVarArray.length);
            }

            public double getRelaxationPoint(IloNumVar iloNumVar) throws IloException {
                return this.getRelaxationPoint(new IloNumVar[]{iloNumVar}, 0, 1)[0];
            }

            public abstract double getRelaxationValue(IloNumExpr var1) throws IloException;

            public abstract double getRelaxationObjective() throws IloException;

            public abstract double[] getIncumbent(IloNumVar[] var1, int var2, int var3) throws IloException;

            public double[] getIncumbent(IloNumVar[] iloNumVarArray) throws IloException {
                return this.getIncumbent(iloNumVarArray, 0, iloNumVarArray.length);
            }

            public double getIncumbent(IloNumVar iloNumVar) throws IloException {
                return this.getIncumbent(new IloNumVar[]{iloNumVar}, 0, 1)[0];
            }

            public abstract double getIncumbentValue(IloNumExpr var1) throws IloException;

            public abstract double getIncumbentObjective() throws IloException;

            public abstract double[] getLocalLB(IloNumVar[] var1, int var2, int var3) throws IloException;

            public double[] getLocalLB(IloNumVar[] iloNumVarArray) throws IloException {
                return this.getLocalLB(iloNumVarArray, 0, iloNumVarArray.length);
            }

            public double getLocalLB(IloNumVar iloNumVar) throws IloException {
                return this.getLocalLB(new IloNumVar[]{iloNumVar}, 0, 1)[0];
            }

            public abstract double[] getLocalUB(IloNumVar[] var1, int var2, int var3) throws IloException;

            public double[] getLocalUB(IloNumVar[] iloNumVarArray) throws IloException {
                return this.getLocalUB(iloNumVarArray, 0, iloNumVarArray.length);
            }

            public double getLocalUB(IloNumVar iloNumVar) throws IloException {
                return this.getLocalUB(new IloNumVar[]{iloNumVar}, 0, 1)[0];
            }

            public abstract double[] getGlobalLB(IloNumVar[] var1, int var2, int var3) throws IloException;

            public double[] getGlobalLB(IloNumVar[] iloNumVarArray) throws IloException {
                return this.getGlobalLB(iloNumVarArray, 0, iloNumVarArray.length);
            }

            public double getGlobalLB(IloNumVar iloNumVar) throws IloException {
                return this.getGlobalLB(new IloNumVar[]{iloNumVar}, 0, 1)[0];
            }

            public abstract double[] getGlobalUB(IloNumVar[] var1, int var2, int var3) throws IloException;

            public double[] getGlobalUB(IloNumVar[] iloNumVarArray) throws IloException {
                return this.getGlobalUB(iloNumVarArray, 0, iloNumVarArray.length);
            }

            public double getGlobalUB(IloNumVar iloNumVar) throws IloException {
                return this.getGlobalUB(new IloNumVar[]{iloNumVar}, 0, 1)[0];
            }

            public abstract void addUserCuts(IloRange[] var1, int[] var2, boolean[] var3) throws IloException;

            public void addUserCut(IloRange iloRange, int n, boolean bl) throws IloException {
                this.addUserCuts(new IloRange[]{iloRange}, new int[]{n}, new boolean[]{bl});
            }

            public static final class Id {
                public static final long ThreadUp = 2L;
                public static final long ThreadDown = 4L;
                public static final long LocalProgress = 8L;
                public static final long GlobalProgress = 16L;
                public static final long Candidate = 32L;
                public static final long Relaxation = 64L;

                private Id() {
                }
            }

            public static enum SolutionStrategy {
                CheckFeasible(0),
                Propagate(1);

                final int cpxid;

                private SolutionStrategy(int n2) {
                    this.cpxid = n2;
                }
            }

            public static enum Info {
                ThreadId(0),
                NodeCount(1),
                IterationCount(2),
                BestSolution(3),
                BestBound(4),
                Threads(5),
                Feasible(6),
                Time(7),
                DeterministicTime(8);

                final int cpxid;

                private Info(int n2) {
                    this.cpxid = n2;
                }
            }
        }
    }

    public static abstract class BranchDirection {
        public static final BranchDirection Up = new _Up();
        public static final BranchDirection Down = new _Down();
        public static final BranchDirection Global = new _Global();
        static BranchDirection[] map = new BranchDirection[]{Down, Global, Up};

        abstract int getValue();

        static BranchDirection getDirection(int n) {
            return map[n + 1];
        }

        private static class _Global
        extends BranchDirection {
            private _Global() {
            }

            @Override
            int getValue() {
                return 0;
            }

            public String toString() {
                return "Global";
            }
        }

        private static class _Down
        extends BranchDirection {
            private _Down() {
            }

            @Override
            int getValue() {
                return -1;
            }

            public String toString() {
                return "Down";
            }
        }

        private static class _Up
        extends BranchDirection {
            private _Up() {
            }

            @Override
            int getValue() {
                return 1;
            }

            public String toString() {
                return "Up";
            }
        }
    }

    public static class CutType {
        public static final int Cover = 0;
        public static final int GUBCover = 1;
        public static final int FlowCover = 2;
        public static final int CliqueCover = 3;
        public static final int Frac = 4;
        public static final int MIR = 5;
        public static final int FlowPath = 6;
        public static final int Disj = 7;
        public static final int ImplBd = 8;
        public static final int ZeroHalf = 9;
        public static final int MCF = 10;
        public static final int LocalCover = 11;
        public static final int Tighten = 12;
        public static final int ObjDisj = 13;
        public static final int LiftProj = 14;
        public static final int User = 15;
        public static final int Table = 16;
        public static final int SolnPool = 17;
        public static final int LocalImplBd = 18;
        public static final int BQP = 19;
        public static final int RLT = 20;
        public static final int Benders = 21;
    }

    public static class TuningStatus {
        public static final int Complete = 0;
        public static final int Abort = 1;
        public static final int TimeLim = 2;
        public static final int DetTimeLim = 3;
    }

    public static class Quality {
        QualityType type;
        IloNumVar var;
        IloConstraint rng;
        double value;

        public double getValue() {
            return this.value;
        }

        public IloNumVar getNumVar() {
            return this.var;
        }

        public IloConstraint getConstraint() {
            return this.rng;
        }

        public String toString() {
            return Double.toString(this.value);
        }

        public QualityType getQualityType() {
            return this.type;
        }
    }

    public static abstract class QualityType {
        public static final QualityType MaxPrimalInfeas = new _MaxPrimalInfeas();
        public static final QualityType MaxScaledPrimalInfeas = new _MaxScaledPrimalInfeas();
        public static final QualityType SumPrimalInfeas = new _SumPrimalInfeas();
        public static final QualityType SumScaledPrimalInfeas = new _SumScaledPrimalInfeas();
        public static final QualityType MaxDualInfeas = new _MaxDualInfeas();
        public static final QualityType MaxScaledDualInfeas = new _MaxScaledDualInfeas();
        public static final QualityType SumDualInfeas = new _SumDualInfeas();
        public static final QualityType SumScaledDualInfeas = new _SumScaledDualInfeas();
        public static final QualityType MaxIntInfeas = new _MaxIntInfeas();
        public static final QualityType SumIntInfeas = new _SumIntInfeas();
        public static final QualityType MaxPrimalResidual = new _MaxPrimalResidual();
        public static final QualityType MaxScaledPrimalResidual = new _MaxScaledPrimalResidual();
        public static final QualityType SumPrimalResidual = new _SumPrimalResidual();
        public static final QualityType SumScaledPrimalResidual = new _SumScaledPrimalResidual();
        public static final QualityType MaxDualResidual = new _MaxDualResidual();
        public static final QualityType MaxScaledDualResidual = new _MaxScaledDualResidual();
        public static final QualityType SumDualResidual = new _SumDualResidual();
        public static final QualityType SumScaledDualResidual = new _SumScaledDualResidual();
        public static final QualityType MaxCompSlack = new _MaxCompSlack();
        public static final QualityType SumCompSlack = new _SumCompSlack();
        public static final QualityType MaxX = new _MaxX();
        public static final QualityType MaxScaledX = new _MaxScaledX();
        public static final QualityType MaxPi = new _MaxPi();
        public static final QualityType MaxScaledPi = new _MaxScaledPi();
        public static final QualityType MaxSlack = new _MaxSlack();
        public static final QualityType MaxScaledSlack = new _MaxScaledSlack();
        public static final QualityType MaxRedCost = new _MaxRedCost();
        public static final QualityType MaxScaledRedCost = new _MaxScaledRedCost();
        public static final QualityType SumX = new _SumX();
        public static final QualityType SumScaledX = new _SumScaledX();
        public static final QualityType SumPi = new _SumPi();
        public static final QualityType SumScaledPi = new _SumScaledPi();
        public static final QualityType SumSlack = new _SumSlack();
        public static final QualityType SumScaledSlack = new _SumScaledSlack();
        public static final QualityType SumRedCost = new _SumRedCost();
        public static final QualityType SumScaledRedCost = new _SumScaledRedCost();
        public static final QualityType Kappa = new _Kappa();
        public static final QualityType ObjGap = new _ObjGap();
        public static final QualityType DualObj = new _DualObj();
        public static final QualityType PrimalObj = new _PrimalObj();
        public static final QualityType ExactKappa = new _ExactKappa();
        public static final QualityType KappaStable = new _KappaStable();
        public static final QualityType KappaSuspicious = new _KappaSuspicious();
        public static final QualityType KappaUnstable = new _KappaUnstable();
        public static final QualityType KappaIllposed = new _KappaIllposed();
        public static final QualityType KappaMax = new _KappaMax();
        public static final QualityType KappaAttention = new _KappaAttention();

        abstract int getValue();

        private static class _KappaAttention
        extends QualityType {
            private _KappaAttention() {
            }

            public String toString() {
                return "KappaAttention";
            }

            @Override
            int getValue() {
                return 57;
            }
        }

        private static class _KappaMax
        extends QualityType {
            private _KappaMax() {
            }

            public String toString() {
                return "KappaMax";
            }

            @Override
            int getValue() {
                return 56;
            }
        }

        private static class _KappaIllposed
        extends QualityType {
            private _KappaIllposed() {
            }

            public String toString() {
                return "KappaIllposed";
            }

            @Override
            int getValue() {
                return 55;
            }
        }

        private static class _KappaUnstable
        extends QualityType {
            private _KappaUnstable() {
            }

            public String toString() {
                return "KappaUnstable";
            }

            @Override
            int getValue() {
                return 54;
            }
        }

        private static class _KappaSuspicious
        extends QualityType {
            private _KappaSuspicious() {
            }

            public String toString() {
                return "KappaSuspicious";
            }

            @Override
            int getValue() {
                return 53;
            }
        }

        private static class _KappaStable
        extends QualityType {
            private _KappaStable() {
            }

            public String toString() {
                return "KappaStable";
            }

            @Override
            int getValue() {
                return 52;
            }
        }

        private static class _ExactKappa
        extends QualityType {
            private _ExactKappa() {
            }

            public String toString() {
                return "ExactKappa";
            }

            @Override
            int getValue() {
                return 51;
            }
        }

        private static class _PrimalObj
        extends QualityType {
            private _PrimalObj() {
            }

            public String toString() {
                return "PrimalObj";
            }

            @Override
            int getValue() {
                return 42;
            }
        }

        private static class _DualObj
        extends QualityType {
            private _DualObj() {
            }

            public String toString() {
                return "DualObj";
            }

            @Override
            int getValue() {
                return 41;
            }
        }

        private static class _ObjGap
        extends QualityType {
            private _ObjGap() {
            }

            public String toString() {
                return "ObjGap";
            }

            @Override
            int getValue() {
                return 40;
            }
        }

        private static class _Kappa
        extends QualityType {
            private _Kappa() {
            }

            public String toString() {
                return "Kappa";
            }

            @Override
            int getValue() {
                return 39;
            }
        }

        private static class _SumScaledRedCost
        extends QualityType {
            private _SumScaledRedCost() {
            }

            public String toString() {
                return "SumScaledRedCost";
            }

            @Override
            int getValue() {
                return 38;
            }
        }

        private static class _SumRedCost
        extends QualityType {
            private _SumRedCost() {
            }

            public String toString() {
                return "SumRedCost";
            }

            @Override
            int getValue() {
                return 37;
            }
        }

        private static class _SumScaledSlack
        extends QualityType {
            private _SumScaledSlack() {
            }

            public String toString() {
                return "SumScaledSlack";
            }

            @Override
            int getValue() {
                return 36;
            }
        }

        private static class _SumSlack
        extends QualityType {
            private _SumSlack() {
            }

            public String toString() {
                return "SumSlack";
            }

            @Override
            int getValue() {
                return 35;
            }
        }

        private static class _SumScaledPi
        extends QualityType {
            private _SumScaledPi() {
            }

            public String toString() {
                return "SumScaledPi";
            }

            @Override
            int getValue() {
                return 34;
            }
        }

        private static class _SumPi
        extends QualityType {
            private _SumPi() {
            }

            public String toString() {
                return "SumPi";
            }

            @Override
            int getValue() {
                return 33;
            }
        }

        private static class _SumScaledX
        extends QualityType {
            private _SumScaledX() {
            }

            public String toString() {
                return "SumScaledX";
            }

            @Override
            int getValue() {
                return 32;
            }
        }

        private static class _SumX
        extends QualityType {
            private _SumX() {
            }

            public String toString() {
                return "SumX";
            }

            @Override
            int getValue() {
                return 31;
            }
        }

        private static class _MaxScaledRedCost
        extends QualityType {
            private _MaxScaledRedCost() {
            }

            public String toString() {
                return "MaxScaledRedCost";
            }

            @Override
            int getValue() {
                return 30;
            }
        }

        private static class _MaxRedCost
        extends QualityType {
            private _MaxRedCost() {
            }

            public String toString() {
                return "MaxRedCost";
            }

            @Override
            int getValue() {
                return 29;
            }
        }

        private static class _MaxScaledSlack
        extends QualityType {
            private _MaxScaledSlack() {
            }

            public String toString() {
                return "MaxScaledSlack";
            }

            @Override
            int getValue() {
                return 28;
            }
        }

        private static class _MaxSlack
        extends QualityType {
            private _MaxSlack() {
            }

            public String toString() {
                return "MaxSlack";
            }

            @Override
            int getValue() {
                return 27;
            }
        }

        private static class _MaxScaledPi
        extends QualityType {
            private _MaxScaledPi() {
            }

            public String toString() {
                return "MaxScaledPi";
            }

            @Override
            int getValue() {
                return 26;
            }
        }

        private static class _MaxPi
        extends QualityType {
            private _MaxPi() {
            }

            public String toString() {
                return "MaxPi";
            }

            @Override
            int getValue() {
                return 25;
            }
        }

        private static class _MaxScaledX
        extends QualityType {
            private _MaxScaledX() {
            }

            public String toString() {
                return "MaxScaledX";
            }

            @Override
            int getValue() {
                return 24;
            }
        }

        private static class _MaxX
        extends QualityType {
            private _MaxX() {
            }

            public String toString() {
                return "MaxX";
            }

            @Override
            int getValue() {
                return 23;
            }
        }

        private static class _SumCompSlack
        extends QualityType {
            private _SumCompSlack() {
            }

            public String toString() {
                return "SumCompSlack";
            }

            @Override
            int getValue() {
                return 21;
            }
        }

        private static class _MaxCompSlack
        extends QualityType {
            private _MaxCompSlack() {
            }

            public String toString() {
                return "MaxCompSlack";
            }

            @Override
            int getValue() {
                return 19;
            }
        }

        private static class _SumScaledDualResidual
        extends QualityType {
            private _SumScaledDualResidual() {
            }

            public String toString() {
                return "SumScaledDualResidual";
            }

            @Override
            int getValue() {
                return 18;
            }
        }

        private static class _SumDualResidual
        extends QualityType {
            private _SumDualResidual() {
            }

            public String toString() {
                return "SumDualResidual";
            }

            @Override
            int getValue() {
                return 17;
            }
        }

        private static class _MaxScaledDualResidual
        extends QualityType {
            private _MaxScaledDualResidual() {
            }

            public String toString() {
                return "MaxScaledDualResidual";
            }

            @Override
            int getValue() {
                return 16;
            }
        }

        private static class _MaxDualResidual
        extends QualityType {
            private _MaxDualResidual() {
            }

            public String toString() {
                return "MaxDualResidual";
            }

            @Override
            int getValue() {
                return 15;
            }
        }

        private static class _SumScaledPrimalResidual
        extends QualityType {
            private _SumScaledPrimalResidual() {
            }

            public String toString() {
                return "SumScaledPrimalResidual";
            }

            @Override
            int getValue() {
                return 14;
            }
        }

        private static class _SumPrimalResidual
        extends QualityType {
            private _SumPrimalResidual() {
            }

            public String toString() {
                return "SumPrimalResidual";
            }

            @Override
            int getValue() {
                return 13;
            }
        }

        private static class _MaxScaledPrimalResidual
        extends QualityType {
            private _MaxScaledPrimalResidual() {
            }

            public String toString() {
                return "MaxScaledPrimalResidual";
            }

            @Override
            int getValue() {
                return 12;
            }
        }

        private static class _MaxPrimalResidual
        extends QualityType {
            private _MaxPrimalResidual() {
            }

            public String toString() {
                return "MaxPrimalResidual";
            }

            @Override
            int getValue() {
                return 11;
            }
        }

        private static class _SumIntInfeas
        extends QualityType {
            private _SumIntInfeas() {
            }

            public String toString() {
                return "SumIntInfeas";
            }

            @Override
            int getValue() {
                return 10;
            }
        }

        private static class _MaxIntInfeas
        extends QualityType {
            private _MaxIntInfeas() {
            }

            public String toString() {
                return "MaxIntInfeas";
            }

            @Override
            int getValue() {
                return 9;
            }
        }

        private static class _SumScaledDualInfeas
        extends QualityType {
            private _SumScaledDualInfeas() {
            }

            public String toString() {
                return "SumScaledDualInfeas";
            }

            @Override
            int getValue() {
                return 8;
            }
        }

        private static class _SumDualInfeas
        extends QualityType {
            private _SumDualInfeas() {
            }

            public String toString() {
                return "SumDualInfeas";
            }

            @Override
            int getValue() {
                return 7;
            }
        }

        private static class _MaxScaledDualInfeas
        extends QualityType {
            private _MaxScaledDualInfeas() {
            }

            public String toString() {
                return "MaxScaledDualInfeas";
            }

            @Override
            int getValue() {
                return 6;
            }
        }

        private static class _MaxDualInfeas
        extends QualityType {
            private _MaxDualInfeas() {
            }

            public String toString() {
                return "MaxDualInfeas";
            }

            @Override
            int getValue() {
                return 5;
            }
        }

        private static class _SumScaledPrimalInfeas
        extends QualityType {
            private _SumScaledPrimalInfeas() {
            }

            public String toString() {
                return "SumScaledPrimalInfeas";
            }

            @Override
            int getValue() {
                return 4;
            }
        }

        private static class _SumPrimalInfeas
        extends QualityType {
            private _SumPrimalInfeas() {
            }

            public String toString() {
                return "SumPrimalInfeas";
            }

            @Override
            int getValue() {
                return 3;
            }
        }

        private static class _MaxScaledPrimalInfeas
        extends QualityType {
            private _MaxScaledPrimalInfeas() {
            }

            public String toString() {
                return "MaxScaledPrimalInfeas";
            }

            @Override
            int getValue() {
                return 2;
            }
        }

        private static class _MaxPrimalInfeas
        extends QualityType {
            private _MaxPrimalInfeas() {
            }

            public String toString() {
                return "MaxPrimalInfeas";
            }

            @Override
            int getValue() {
                return 1;
            }
        }
    }

    public static class ConflictStatus
    implements Serializable {
        private static final long serialVersionUID = 12080000L;
        private int _stat;
        public static final ConflictStatus Excluded = new ConflictStatus(-1);
        public static final ConflictStatus PossibleMember = new ConflictStatus(0);
        public static final ConflictStatus Member = new ConflictStatus(3);

        private ConflictStatus(int n) {
            this._stat = n;
        }

        static ConflictStatus make(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    return PossibleMember;
                }
                case 3: 
                case 4: 
                case 5: {
                    return Member;
                }
            }
            return Excluded;
        }

        public String toString() {
            switch (this._stat) {
                case 0: {
                    return "PossibleMember";
                }
                case 3: {
                    return "Member";
                }
            }
            return "Excluded";
        }

        public boolean equals(Object object) {
            if (object instanceof ConflictStatus) {
                return this._stat == ((ConflictStatus)object)._stat;
            }
            return false;
        }
    }

    public static class Relaxation {
        public static final int MinSum = 0;
        public static final int OptSum = 1;
        public static final int MinInf = 2;
        public static final int OptInf = 3;
        public static final int MinQuad = 4;
        public static final int OptQuad = 5;
    }

    public static class MIPStartEffort {
        int _value;
        public static final MIPStartEffort Auto = new MIPStartEffort(0);
        public static final MIPStartEffort CheckFeas = new MIPStartEffort(1);
        public static final MIPStartEffort SolveFixed = new MIPStartEffort(2);
        public static final MIPStartEffort SolveMIP = new MIPStartEffort(3);
        public static final MIPStartEffort Repair = new MIPStartEffort(4);
        public static final MIPStartEffort NoCheck = new MIPStartEffort(5);

        MIPStartEffort(int n) {
            this._value = n;
        }
    }

    public static class WriteLevel {
        public static final int Auto = 0;
        public static final int AllVars = 1;
        public static final int NonzeroVars = 3;
        public static final int DiscreteVars = 2;
        public static final int NonzeroDiscreteVars = 4;
    }

    public static class BasisStatus {
        int _stat;
        public static final BasisStatus NotABasicStatus = new BasisStatus(-1);
        public static final BasisStatus AtLower = new BasisStatus(0);
        public static final BasisStatus Basic = new BasisStatus(1);
        public static final BasisStatus AtUpper = new BasisStatus(2);
        public static final BasisStatus FreeOrSuperbasic = new BasisStatus(3);

        BasisStatus(int n) {
            this._stat = n;
        }

        public String toString() {
            switch (this._stat) {
                case 0: {
                    return "AtLower";
                }
                case 1: {
                    return "Basic";
                }
                case 2: {
                    return "AtUpper";
                }
                case 3: {
                    return "FreeOrSuperbasic";
                }
            }
            return "NotABasicStatus";
        }

        public boolean equals(Object object) {
            if (object instanceof BasisStatus) {
                BasisStatus basisStatus = (BasisStatus)object;
                return basisStatus._stat == this._stat;
            }
            return false;
        }
    }

    public static class CplexStatus
    implements Serializable {
        static final long serialVersionUID = -7367834674783924158L;
        int _status;
        String _name;
        public static final CplexStatus Unknown = new CplexStatus(0, "Unknown");
        static final int Unknown_Status = 0;
        public static final CplexStatus Optimal = new CplexStatus(1, "Optimal");
        static final int Optimal_Status = 1;
        public static final CplexStatus Unbounded = new CplexStatus(2, "Unbounded");
        static final int Unbounded_Status = 2;
        public static final CplexStatus Infeasible = new CplexStatus(3, "Infeasible");
        static final int Infeasible_Status = 3;
        public static final CplexStatus InfOrUnbd = new CplexStatus(4, "InfOrUnbd");
        static final int InfOrUnbd_Status = 4;
        public static final CplexStatus OptimalInfeas = new CplexStatus(5, "OptimalInfeas");
        static final int OptimalInfeas_Status = 5;
        public static final CplexStatus NumBest = new CplexStatus(6, "NumBest");
        static final int NumBest_Status = 6;
        public static final CplexStatus FeasibleRelaxedSum = new CplexStatus(14, "FeasibleRelaxedSum");
        static final int FeasibleRelaxedSum_Status = 14;
        public static final CplexStatus OptimalRelaxedSum = new CplexStatus(15, "OptimalRelaxedSum");
        static final int OptimalRelaxedSum_Status = 15;
        public static final CplexStatus FeasibleRelaxedInf = new CplexStatus(16, "FeasibleRelaxedInf");
        static final int FeasibleRelaxedInf_Status = 16;
        public static final CplexStatus OptimalRelaxedInf = new CplexStatus(17, "OptimalRelaxedInf");
        static final int OptimalRelaxedInf_Status = 17;
        public static final CplexStatus FeasibleRelaxedQuad = new CplexStatus(18, "FeasibleRelaxedQuad");
        static final int FeasibleRelaxedQuad_Status = 18;
        public static final CplexStatus OptimalRelaxedQuad = new CplexStatus(19, "OptimalRelaxedQuad");
        static final int OptimalRelaxedQuad_Status = 19;
        public static final CplexStatus AbortRelaxed = new CplexStatus(126, "AbortRelaxed");
        static final int AbortRelaxed_Status = 126;
        public static final CplexStatus AbortObjLim = new CplexStatus(12, "AbortObjLim");
        static final int AbortObjLim_Status = 12;
        public static final CplexStatus AbortPrimObjLim = new CplexStatus(21, "AbortPrimObjLim");
        static final int AbortPrimObjLim_Status = 21;
        public static final CplexStatus AbortDualObjLim = new CplexStatus(22, "AbortDualObjLim");
        static final int AbortDualObjLim_Status = 22;
        public static final CplexStatus AbortItLim = new CplexStatus(10, "AbortItLim");
        static final int AbortItLim_Status = 10;
        public static final CplexStatus AbortTimeLim = new CplexStatus(11, "AbortTimeLim");
        static final int AbortTimeLim_Status = 11;
        public static final CplexStatus AbortDetTimeLim = new CplexStatus(25, "AbortDetTimeLim");
        static final int AbortDetTimeLim_Status = 25;
        public static final CplexStatus AbortUser = new CplexStatus(13, "AbortUser");
        static final int AbortUser_Status = 13;
        public static final CplexStatus OptimalFaceUnbounded = new CplexStatus(20, "OptimalFaceUnbounded");
        static final int OptimalFaceUnbounded_Status = 20;
        public static final CplexStatus OptimalTol = new CplexStatus(102, "OptimalTol");
        static final int OptimalTol_Status = 102;
        public static final CplexStatus SolLim = new CplexStatus(104, "SolLim");
        static final int SolLim_Status = 104;
        public static final CplexStatus PopulateSolLim = new CplexStatus(128, "PopulateSolLim");
        static final int PopulateSolLim_Status = 128;
        public static final CplexStatus NodeLimFeas = new CplexStatus(105, "NodeLimFeas");
        static final int NodeLimFeas_Status = 105;
        public static final CplexStatus NodeLimInfeas = new CplexStatus(106, "NodeLimInfeas");
        static final int NodeLimInfeas_Status = 106;
        public static final CplexStatus FailFeas = new CplexStatus(109, "FailFeas");
        static final int FailFeas_Status = 109;
        public static final CplexStatus FailInfeas = new CplexStatus(110, "FailInfeas");
        static final int FailInfeas_Status = 110;
        public static final CplexStatus MemLimFeas = new CplexStatus(111, "MemLimFeas");
        static final int MemLimFeas_Status = 111;
        public static final CplexStatus MemLimInfeas = new CplexStatus(112, "MemLimInfeas");
        static final int MemLimInfeas_Status = 112;
        public static final CplexStatus FailFeasNoTree = new CplexStatus(116, "FailFeasNoTree");
        static final int FailFeasNoTree_Status = 116;
        public static final CplexStatus FailInfeasNoTree = new CplexStatus(117, "FailInfeasNoTree");
        static final int FailInfeasNoTree_Status = 117;
        public static final CplexStatus ConflictFeasible = new CplexStatus(30, "ConflictFeasible");
        static final int ConflictFeasible_Status = 30;
        public static final CplexStatus ConflictMinimal = new CplexStatus(31, "ConflictMinimal");
        static final int ConflictMinimal_Status = 31;
        public static final CplexStatus ConflictAbortContradiction = new CplexStatus(32, "ConflictAbortContradiction");
        static final int ConflictAbortContradiction_Status = 32;
        public static final CplexStatus ConflictAbortTimeLim = new CplexStatus(33, "ConflictAbortTimeLim");
        static final int ConflictAbortTimeLim_Status = 33;
        public static final CplexStatus ConflictAbortDetTimeLim = new CplexStatus(39, "ConflictAbortDetTimeLim");
        static final int ConflictAbortDetTimeLim_Status = 39;
        public static final CplexStatus ConflictAbortItLim = new CplexStatus(34, "ConflictAbortItLim");
        static final int ConflictAbortItLim_Status = 34;
        public static final CplexStatus ConflictAbortNodeLim = new CplexStatus(35, "ConflictAbortNodeLim");
        static final int ConflictAbortNodeLim_Status = 35;
        public static final CplexStatus ConflictAbortObjLim = new CplexStatus(36, "ConflictAbortObjLim");
        static final int ConflictAbortObjLim_Status = 36;
        public static final CplexStatus ConflictAbortMemLim = new CplexStatus(37, "ConflictAbortMemLim");
        static final int ConflictAbortMemLim_Status = 37;
        public static final CplexStatus ConflictAbortUser = new CplexStatus(38, "ConflictAbortUser");
        static final int ConflictAbortUser_Status = 38;
        public static final CplexStatus Feasible = new CplexStatus(23, "Feasible");
        static final int Feasible_Status = 23;
        public static final CplexStatus OptimalPopulated = new CplexStatus(129, "OptimalPopulated");
        static final int OptimalPopulated_Status = 129;
        public static final CplexStatus OptimalPopulatedTol = new CplexStatus(130, "OptimalPopulatedTol");
        static final int OptimalPopulatedTol_Status = 130;
        public static final CplexStatus RelaxationUnbounded = new CplexStatus(133, "RelaxationUnbounded");
        static final int RelaxationUnbounded_Status = 133;
        public static final CplexStatus FirstOrder = new CplexStatus(24, "FirstOrder");
        static final int FirstOrder_Status = 24;

        CplexStatus(int n, String string) {
            this._status = n;
            this._name = string;
        }

        final int getValue() {
            return this._status;
        }

        static CplexStatus getStatus(int n) {
            switch (n) {
                case 0: {
                    return Unknown;
                }
                case 1: {
                    return Optimal;
                }
                case 2: {
                    return Unbounded;
                }
                case 3: {
                    return Infeasible;
                }
                case 4: {
                    return InfOrUnbd;
                }
                case 5: {
                    return OptimalInfeas;
                }
                case 6: {
                    return NumBest;
                }
                case 14: {
                    return FeasibleRelaxedSum;
                }
                case 15: {
                    return OptimalRelaxedSum;
                }
                case 16: {
                    return FeasibleRelaxedInf;
                }
                case 17: {
                    return OptimalRelaxedInf;
                }
                case 18: {
                    return FeasibleRelaxedQuad;
                }
                case 19: {
                    return OptimalRelaxedQuad;
                }
                case 126: {
                    return AbortRelaxed;
                }
                case 12: {
                    return AbortObjLim;
                }
                case 21: {
                    return AbortPrimObjLim;
                }
                case 22: {
                    return AbortDualObjLim;
                }
                case 10: {
                    return AbortItLim;
                }
                case 11: {
                    return AbortTimeLim;
                }
                case 25: {
                    return AbortDetTimeLim;
                }
                case 13: {
                    return AbortUser;
                }
                case 20: {
                    return OptimalFaceUnbounded;
                }
                case 102: {
                    return OptimalTol;
                }
                case 104: {
                    return SolLim;
                }
                case 128: {
                    return PopulateSolLim;
                }
                case 105: {
                    return NodeLimFeas;
                }
                case 106: {
                    return NodeLimInfeas;
                }
                case 109: {
                    return FailFeas;
                }
                case 110: {
                    return FailInfeas;
                }
                case 111: {
                    return MemLimFeas;
                }
                case 112: {
                    return MemLimInfeas;
                }
                case 116: {
                    return FailFeasNoTree;
                }
                case 117: {
                    return FailInfeasNoTree;
                }
                case 30: {
                    return ConflictFeasible;
                }
                case 31: {
                    return ConflictMinimal;
                }
                case 32: {
                    return ConflictAbortContradiction;
                }
                case 33: {
                    return ConflictAbortTimeLim;
                }
                case 39: {
                    return ConflictAbortDetTimeLim;
                }
                case 34: {
                    return ConflictAbortItLim;
                }
                case 35: {
                    return ConflictAbortNodeLim;
                }
                case 36: {
                    return ConflictAbortObjLim;
                }
                case 37: {
                    return ConflictAbortMemLim;
                }
                case 38: {
                    return ConflictAbortUser;
                }
                case 23: {
                    return Feasible;
                }
                case 129: {
                    return OptimalPopulated;
                }
                case 130: {
                    return OptimalPopulatedTol;
                }
                case 133: {
                    return RelaxationUnbounded;
                }
                case 24: {
                    return FirstOrder;
                }
                case 40: {
                    return Unbounded;
                }
                case 41: {
                    return NumBest;
                }
                case 134: {
                    return Unbounded;
                }
                case 101: {
                    return Optimal;
                }
                case 103: {
                    return Infeasible;
                }
                case 107: {
                    return AbortTimeLim;
                }
                case 108: {
                    return AbortTimeLim;
                }
                case 131: {
                    return AbortDetTimeLim;
                }
                case 132: {
                    return AbortDetTimeLim;
                }
                case 113: {
                    return AbortUser;
                }
                case 114: {
                    return AbortUser;
                }
                case 115: {
                    return OptimalInfeas;
                }
                case 118: {
                    return Unbounded;
                }
                case 119: {
                    return InfOrUnbd;
                }
                case 120: {
                    return FeasibleRelaxedSum;
                }
                case 121: {
                    return OptimalRelaxedSum;
                }
                case 122: {
                    return FeasibleRelaxedInf;
                }
                case 123: {
                    return OptimalRelaxedInf;
                }
                case 124: {
                    return FeasibleRelaxedQuad;
                }
                case 125: {
                    return OptimalRelaxedQuad;
                }
                case 127: {
                    return Feasible;
                }
            }
            return Unknown;
        }

        public String toString() {
            return this._name;
        }

        public boolean equals(Object object) {
            if (object instanceof CplexStatus) {
                return ((CplexStatus)object).getValue() == this.getValue();
            }
            return false;
        }
    }

    public static class DeleteMode {
        public static final DeleteMode LeaveBasis = new DeleteMode();
        public static final DeleteMode FixBasis = new DeleteMode();

        private DeleteMode() {
        }
    }

    public static class CalcQCPDuals {
        public static final int No = 0;
        public static final int IfPossible = 1;
        public static final int Force = 2;
    }

    public static class OptimalityTarget {
        public static final int Auto = 0;
        public static final int OptimalConvex = 1;
        public static final int FirstOrder = 2;
        public static final int OptimalGlobal = 3;
    }

    public static class MIPSearch {
        public static final int Auto = 0;
        public static final int Traditional = 1;
        public static final int Dynamic = 2;
    }

    public static class ParallelMode {
        public static final int Auto = 0;
        public static final int Deterministic = 1;
        public static final int Opportunistic = -1;
    }

    public static class DualPricing {
        public static final int Auto = 0;
        public static final int Full = 1;
        public static final int Steep = 2;
        public static final int FullSteep = 3;
        public static final int SteepQStart = 4;
        public static final int Devex = 5;
    }

    public static class DataCheck {
        public static final int Off = 0;
        public static final int Warn = 1;
        public static final int Assist = 2;
    }

    public static class BendersStrategy {
        public static final int Off = -1;
        public static final int Auto = 0;
        public static final int User = 1;
        public static final int Workers = 2;
        public static final int Full = 3;
    }

    public static class ConflictAlgorithm {
        public static final int Auto = 0;
        public static final int Fast = 1;
        public static final int Propagate = 2;
        public static final int Presolve = 3;
        public static final int IIS = 4;
        public static final int LimitedSolve = 5;
        public static final int Solve = 6;
    }

    public static class PrimalPricing {
        public static final int Partial = -1;
        public static final int Auto = 0;
        public static final int Devex = 1;
        public static final int Steep = 2;
        public static final int SteepQStart = 3;
        public static final int Full = 4;
    }

    public static class DistMIPRampupDuration {
        public static final int RampupDisabled = -1;
        public static final int RampupAuto = 0;
        public static final int RampupDynamic = 1;
        public static final int RampupInfinite = 2;
    }

    public static class NodeSelect {
        public static final int DFS = 0;
        public static final int BestBound = 1;
        public static final int BestEst = 2;
        public static final int BestEstAlt = 3;
    }

    public static class VariableSelect {
        public static final int MinInfeas = -1;
        public static final int DefaultVarSel = 0;
        public static final int MaxInfeas = 1;
        public static final int Pseudo = 2;
        public static final int Strong = 3;
        public static final int PseudoReduced = 4;
    }

    public static class MIPEmphasis {
        public static final int Balanced = 0;
        public static final int Feasibility = 1;
        public static final int Optimality = 2;
        public static final int BestBound = 3;
        public static final int HiddenFeas = 4;
    }

    public static class StringParameter
    extends Parameter {
        private StringParam _key;
        private String _value;

        public StringParameter(StringParam stringParam, String string) {
            this._key = stringParam;
            this._value = string;
        }

        @Override
        public int getType() {
            return 3;
        }

        public StringParam getKey() {
            return this._key;
        }

        public String getValue() {
            return this._value;
        }
    }

    public static class BooleanParameter
    extends Parameter {
        private BooleanParam _key;
        private boolean _value;

        public BooleanParameter(BooleanParam booleanParam, boolean bl) {
            this._key = booleanParam;
            this._value = bl;
        }

        @Override
        public int getType() {
            return 2;
        }

        public BooleanParam getKey() {
            return this._key;
        }

        public boolean getValue() {
            return this._value;
        }
    }

    public static class DoubleParameter
    extends Parameter {
        private DoubleParam _key;
        private double _value;

        public DoubleParameter(DoubleParam doubleParam, double d) {
            this._key = doubleParam;
            this._value = d;
        }

        @Override
        public int getType() {
            return 1;
        }

        public DoubleParam getKey() {
            return this._key;
        }

        public double getValue() {
            return this._value;
        }
    }

    public static class LongParameter
    extends Parameter {
        private LongParam _key;
        private long _value;

        public LongParameter(LongParam longParam, long l) {
            this._key = longParam;
            this._value = l;
        }

        @Override
        public int getType() {
            return 4;
        }

        public LongParam getKey() {
            return this._key;
        }

        public long getValue() {
            return this._value;
        }
    }

    public static class IntParameter
    extends Parameter {
        private IntParam _key;
        private int _value;

        public IntParameter(IntParam intParam, int n) {
            this._key = intParam;
            this._value = n;
        }

        @Override
        public int getType() {
            return 0;
        }

        public IntParam getKey() {
            return this._key;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static abstract class Parameter {
        public static final int IntType = 0;
        public static final int DoubleType = 1;
        public static final int BooleanType = 2;
        public static final int StringType = 3;
        public static final int LongType = 4;
        public static final int UnknownType = 5;

        public abstract int getType();
    }

    public static class ParameterSet
    implements Serializable {
        private static final long serialVersionUID = 12080000L;
        Hashtable _params = new Hashtable();

        public void clear() {
            this._params.clear();
        }

        public void setParam(IntParam intParam, int n) {
            Integer n2 = new Integer(intParam.getValue());
            if (intParam.alsoLong()) {
                if (this._params.containsKey(n2)) {
                    this._params.remove(n2);
                }
                this._params.put(n2, new Long(n));
            } else {
                if (this._params.containsKey(n2)) {
                    this._params.remove(n2);
                }
                this._params.put(n2, new Integer(n));
            }
        }

        public void setParam(LongParam longParam, long l) {
            Integer n = new Integer(longParam.getValue());
            if (this._params.containsKey(n)) {
                this._params.remove(n);
            }
            this._params.put(n, new Long(l));
        }

        public void setParam(StringParam stringParam, String string) {
            Integer n = new Integer(stringParam.getValue());
            if (this._params.containsKey(n)) {
                this._params.remove(n);
            }
            this._params.put(n, string);
        }

        public void setParam(BooleanParam booleanParam, boolean bl) {
            Integer n = new Integer(booleanParam.getValue());
            if (this._params.containsKey(n)) {
                this._params.remove(n);
            }
            this._params.put(n, new Boolean(bl));
        }

        public void setParam(DoubleParam doubleParam, double d) {
            Integer n = new Integer(doubleParam.getValue());
            if (this._params.containsKey(n)) {
                this._params.remove(n);
            }
            this._params.put(n, new Double(d));
        }

        public int getParam(IntParam intParam) throws IloException {
            Integer n = new Integer(intParam.getValue());
            if (this._params.containsKey(n)) {
                if (intParam.alsoLong()) {
                    Long l = (Long)this._params.get(n);
                    return CplexI.truncateLong(l.intValue());
                }
                Integer n2 = (Integer)this._params.get(n);
                return n2;
            }
            throw new IloException("Parameter not in ParameterSet");
        }

        public long getParam(LongParam longParam) throws IloException {
            Integer n = new Integer(longParam.getValue());
            if (this._params.containsKey(n)) {
                Long l = (Long)this._params.get(n);
                return l;
            }
            throw new IloException("Parameter not in ParameterSet");
        }

        public String getParam(StringParam stringParam) throws IloException {
            Integer n = new Integer(stringParam.getValue());
            if (this._params.containsKey(n)) {
                return (String)this._params.get(n);
            }
            throw new IloException("Parameter not in ParameterSet");
        }

        public boolean getParam(BooleanParam booleanParam) throws IloException {
            Integer n = new Integer(booleanParam.getValue());
            if (this._params.containsKey(n)) {
                Boolean bl = (Boolean)this._params.get(n);
                return bl;
            }
            throw new IloException("Parameter not in ParameterSet");
        }

        public double getParam(DoubleParam doubleParam) throws IloException {
            Integer n = new Integer(doubleParam.getValue());
            if (this._params.containsKey(n)) {
                Double d = (Double)this._params.get(n);
                return d;
            }
            throw new IloException("Parameter not in ParameterSet");
        }

        void applyTo(CplexI cplexI) throws IloException {
            for (Integer n : this._params.keySet()) {
                Object v = this._params.get(n);
                if (v instanceof Boolean) {
                    int n2 = 0;
                    if (((Boolean)v).booleanValue()) {
                        n2 = 1;
                    }
                    cplexI.setIntParam(n, n2);
                    continue;
                }
                if (v instanceof Integer) {
                    cplexI.setIntParam(n, (Integer)v);
                    continue;
                }
                if (v instanceof Long) {
                    if (cplexI.getParamType(n) == 1) {
                        cplexI.setIntParam(n, CplexI.truncateLong((Long)v));
                        continue;
                    }
                    cplexI.setLongParam(n, (Long)v);
                    continue;
                }
                if (v instanceof Double) {
                    cplexI.setDoubleParam(n, (Double)v);
                    continue;
                }
                if (!(v instanceof String)) continue;
                cplexI.setStringParam(n, ((String)v).toString());
            }
        }

        void extractFrom(CplexI cplexI) throws IloException {
            this.clear();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1000];
            int[] nArray4 = new int[1];
            int[] nArray5 = new int[1];
            int[] nArray6 = new int[1];
            int[] nArray7 = new int[1];
            long[] lArray = new long[1];
            long[] lArray2 = new long[1];
            long[] lArray3 = new long[1];
            long[] lArray4 = new long[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            cplexI.CALL(Cplex.CPXgetchgparam(cplexI.getEnv(), nArray, nArray3, 1000, nArray2));
            block6: for (int i = 0; i < nArray[0]; ++i) {
                int n = nArray3[i];
                int[] nArray8 = new int[1];
                cplexI.CALL(Cplex.CPXgetparamtype(cplexI.getEnv(), n, nArray8));
                switch (nArray8[0]) {
                    case 4: {
                        cplexI.CALL(Cplex.CPXinfolongparam(cplexI.getEnv(), n, lArray, lArray2, lArray3));
                        Cplex.CPXgetlongparam(cplexI.getEnv(), n, lArray4);
                        this._params.put(new Integer(n), new Long(lArray4[0]));
                        continue block6;
                    }
                    case 1: {
                        Object object;
                        cplexI.CALL(Cplex.CPXinfointparam(cplexI.getEnv(), n, nArray4, nArray5, nArray6));
                        Cplex.CPXgetintparam(cplexI.getEnv(), n, nArray7);
                        if (nArray6[0] != 1 || nArray5[0] != 0 || n == 1067 || n == 2139) {
                            if (n == 1063 || n == 2025) continue block6;
                            object = new Integer(n);
                            Object v = Param._revindex.get(object);
                            if (v instanceof LongParam) {
                                this._params.put(new Integer(n), new Long(nArray7[0]));
                                continue block6;
                            }
                            this._params.put(new Integer(n), new Integer(nArray7[0]));
                            continue block6;
                        }
                        boolean bl = false;
                        if (nArray7[0] == 1) {
                            bl = true;
                        }
                        this._params.put(new Integer(n), new Boolean(bl));
                        continue block6;
                    }
                    case 2: {
                        cplexI.CALL(Cplex.CPXinfodblparam(cplexI.getEnv(), n, dArray, dArray2, dArray3));
                        Cplex.CPXgetdblparam(cplexI.getEnv(), n, dArray4);
                        this._params.put(new Integer(n), new Double(dArray4[0]));
                        continue block6;
                    }
                    case 3: {
                        Object object = new byte[512];
                        Cplex.CPXgetstrparam(cplexI.getEnv(), n, object);
                        this._params.put(new Integer(n), CplexI.getString(object));
                    }
                }
            }
        }

        public Iterator iterator() {
            Vector<Parameter> vector = new Vector<Parameter>();
            Enumeration enumeration = this._params.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = Param._revindex.get(k);
                Object v2 = this._params.get(k);
                if (v instanceof IntParam) {
                    vector.add(new IntParameter((IntParam)v, (Integer)v2));
                    continue;
                }
                if (v instanceof LongParam) {
                    vector.add(new LongParameter((LongParam)v, (Long)v2));
                    continue;
                }
                if (v instanceof DoubleParam) {
                    vector.add(new DoubleParameter((DoubleParam)v, (Double)v2));
                    continue;
                }
                if (v instanceof BooleanParam) {
                    vector.add(new BooleanParameter((BooleanParam)v, (Boolean)v2));
                    continue;
                }
                if (!(v instanceof StringParam)) continue;
                vector.add(new StringParameter((StringParam)v, (String)v2));
            }
            return vector.iterator();
        }
    }

    public static class StringParam
    extends Param {
        public static final StringParam WorkDir = StringParam.makeParam(1064, "WorkDir");
        public static final StringParam FileEncoding = StringParam.makeParam(1129, "FileEncoding");
        public static final StringParam IntSolFilePrefix = StringParam.makeParam(2143, "IntSolFilePrefix");

        public StringParam() {
        }

        public StringParam(int n, String string) {
            super(n, string);
        }

        static StringParam makeParam(int n, String string) {
            StringParam stringParam = (StringParam)StringParam.findParam(n);
            if (stringParam == null) {
                stringParam = new StringParam(n, string);
                StringParam.addParam(stringParam);
            }
            return stringParam;
        }
    }

    public static class DoubleParam
    extends Param {
        public static final DoubleParam EpMrk = DoubleParam.makeParam(1013, "EpMrk");
        public static final DoubleParam EpOpt = DoubleParam.makeParam(1014, "EpOpt");
        public static final DoubleParam EpPer = DoubleParam.makeParam(1015, "EpPer");
        public static final DoubleParam EpRHS = DoubleParam.makeParam(1016, "EpRHS");
        public static final DoubleParam NetEpOpt = DoubleParam.makeParam(5002, "NetEpOpt");
        public static final DoubleParam NetEpRHS = DoubleParam.makeParam(5003, "NetEpRHS");
        public static final DoubleParam TiLim = DoubleParam.makeParam(1039, "TiLim");
        public static final DoubleParam DetTiLim = DoubleParam.makeParam(1127, "DetTiLim");
        public static final DoubleParam TuningTiLim = DoubleParam.makeParam(1112, "TuningTiLim");
        public static final DoubleParam TuningDetTiLim = DoubleParam.makeParam(1139, "TuningDetTiLim");
        public static final DoubleParam BtTol = DoubleParam.makeParam(2002, "BtTol");
        public static final DoubleParam CutLo = DoubleParam.makeParam(2006, "CutLo");
        public static final DoubleParam CutUp = DoubleParam.makeParam(2007, "CutUp");
        public static final DoubleParam EpGap = DoubleParam.makeParam(2009, "EpGap");
        public static final DoubleParam EpInt = DoubleParam.makeParam(2010, "EpInt");
        public static final DoubleParam EpAGap = DoubleParam.makeParam(2008, "EpAGap");
        public static final DoubleParam EpRelax = DoubleParam.makeParam(2073, "EpRelax");
        public static final DoubleParam ObjDif = DoubleParam.makeParam(2019, "ObjDif");
        public static final DoubleParam ObjLLim = DoubleParam.makeParam(1025, "ObjLLim");
        public static final DoubleParam ObjULim = DoubleParam.makeParam(1026, "ObjULim");
        public static final DoubleParam PolishTime = DoubleParam.makeParam(2066, "PolishTime");
        public static final DoubleParam PolishAfterEpAGap = DoubleParam.makeParam(2126, "PolishAfterEpAGap");
        public static final DoubleParam PolishAfterEpGap = DoubleParam.makeParam(2127, "PolishAfterEpGap");
        public static final DoubleParam PolishAfterTime = DoubleParam.makeParam(2130, "PolishAfterTime");
        public static final DoubleParam PolishAfterDetTime = DoubleParam.makeParam(2151, "PolishAfterDetTime");
        public static final DoubleParam ProbeTime = DoubleParam.makeParam(2065, "ProbeTime");
        public static final DoubleParam ProbeDetTime = DoubleParam.makeParam(2150, "ProbeDetTime");
        public static final DoubleParam RelObjDif = DoubleParam.makeParam(2022, "RelObjDif");
        public static final DoubleParam CutsFactor = DoubleParam.makeParam(2033, "CutsFactor");
        public static final DoubleParam TreLim = DoubleParam.makeParam(2027, "TreLim");
        public static final DoubleParam SolnPoolGap = DoubleParam.makeParam(2105, "SolnPoolGap");
        public static final DoubleParam SolnPoolAGap = DoubleParam.makeParam(2106, "SolnPoolAGap");
        public static final DoubleParam WorkMem = DoubleParam.makeParam(1065, "WorkMem");
        public static final DoubleParam BarEpComp = DoubleParam.makeParam(3002, "BarEpComp");
        public static final DoubleParam BarQCPEpComp = DoubleParam.makeParam(3020, "BarQCPEpComp");
        public static final DoubleParam BarGrowth = DoubleParam.makeParam(3003, "BarGrowth");
        public static final DoubleParam BarObjRng = DoubleParam.makeParam(3004, "BarObjRng");
        public static final DoubleParam EpLin = DoubleParam.makeParam(2068, "EpLin");
        public static final DoubleParam RampupDettimeLim = DoubleParam.makeParam(2164, "RampupDettimeLim");
        public static final DoubleParam RampupWalltimeLim = DoubleParam.makeParam(2165, "RampupWalltimeLim");

        public DoubleParam() {
        }

        public DoubleParam(int n, String string) {
            super(n, string);
        }

        static DoubleParam makeParam(int n, String string) {
            DoubleParam doubleParam = (DoubleParam)DoubleParam.findParam(n);
            if (doubleParam == null) {
                doubleParam = new DoubleParam(n, string);
                DoubleParam.addParam(doubleParam);
            }
            return doubleParam;
        }
    }

    public static class LongParam
    extends Param {
        public static final LongParam AggFill = LongParam.makeParam(1002, "AggFill");
        public static final LongParam NzReadLim = LongParam.makeParam(1024, "NzReadLim");
        public static final LongParam QPNzReadLim = LongParam.makeParam(4001, "QPNzReadLim");
        public static final LongParam ItLim = LongParam.makeParam(1020, "ItLim");
        public static final LongParam SiftItLim = LongParam.makeParam(1078, "SiftItLim");
        public static final LongParam BarItLim = LongParam.makeParam(3012, "BarItLim");
        public static final LongParam BarMaxCor = LongParam.makeParam(3013, "BarMaxCor");
        public static final LongParam BBInterval = LongParam.makeParam(2039, "BBInterval");
        public static final LongParam CutPass = LongParam.makeParam(2056, "CutPass");
        public static final LongParam FracPass = LongParam.makeParam(2050, "FracPass");
        public static final LongParam HeurFreq = LongParam.makeParam(2031, "HeurFreq");
        public static final LongParam MIPInterval = LongParam.makeParam(2013, "MIPInterval");
        public static final LongParam NodeLim = LongParam.makeParam(2017, "NodeLim");
        public static final LongParam IntSolLim = LongParam.makeParam(2015, "IntSolLim");
        public static final LongParam StrongItLim = LongParam.makeParam(2046, "StrongItLim");
        public static final LongParam RINSHeur = LongParam.makeParam(2061, "RINSHeur");
        public static final LongParam SubMIPNodeLim = LongParam.makeParam(2062, "SubMIPNodeLim");
        public static final LongParam RepairTries = LongParam.makeParam(2067, "RepairTries");
        public static final LongParam PolishAfterNode = LongParam.makeParam(2128, "PolishAfterNode");
        public static final LongParam PolishAfterIntSol = LongParam.makeParam(2129, "PolishAfterIntSol");
        public static final LongParam NetItLim = LongParam.makeParam(5001, "NetItLim");

        public LongParam() {
        }

        public LongParam(int n, String string) {
            super(n, string);
        }

        static LongParam makeParam(int n, String string) {
            LongParam longParam = (LongParam)LongParam.findParam(n);
            if (longParam == null) {
                longParam = new LongParam(n, string);
                LongParam.addParam(longParam);
            }
            return longParam;
        }
    }

    public static class IntParam
    extends Param {
        public static final IntParam AdvInd = IntParam.makeParam(1001, "AdvInd");
        public static final IntParam RootAlg = IntParam.makeParam(1062, "RootAlg");
        public static final IntParam NodeAlg = IntParam.makeParam(2026, "NodeAlg");
        public static final IntParam MIPEmphasis = IntParam.makeParam(2058, "MIPEmphasis");
        public static final IntParam AggInd = IntParam.makeParam(1003, "AggInd");
        public static final IntParam ClockType = IntParam.makeParam(1006, "ClockType");
        public static final IntParam CraInd = IntParam.makeParam(1007, "CraInd");
        public static final IntParam DataCheck = IntParam.makeParam(1056, "DataCheck");
        public static final IntParam DepInd = IntParam.makeParam(1008, "DepInd");
        public static final IntParam PreDual = IntParam.makeParam(1044, "PreDual");
        public static final IntParam PrePass = IntParam.makeParam(1052, "PrePass");
        public static final IntParam PreLinear = IntParam.makeParam(1058, "PreLinear");
        public static final IntParam RelaxPreInd = IntParam.makeParam(2034, "RelaxPreInd");
        public static final IntParam RepeatPresolve = IntParam.makeParam(2064, "RepeatPresolve");
        public static final IntParam Symmetry = IntParam.makeParam(2059, "Symmetry");
        public static final IntParam DPriInd = IntParam.makeParam(1009, "DPriInd");
        public static final IntParam PriceLim = IntParam.makeParam(1010, "PriceLim");
        public static final IntParam SimDisplay = IntParam.makeParam(1019, "SimDisplay");
        public static final IntParam NetFind = IntParam.makeParam(1022, "NetFind");
        public static final IntParam PerLim = IntParam.makeParam(1028, "PerLim");
        public static final IntParam PPriInd = IntParam.makeParam(1029, "PPriInd");
        public static final IntParam ReInv = IntParam.makeParam(1031, "ReInv");
        public static final IntParam ScaInd = IntParam.makeParam(1034, "ScaInd");
        public static final IntParam Threads = IntParam.makeParam(1067, "Threads");
        public static final IntParam AuxRootThreads = IntParam.makeParam(2139, "AuxRootThreads");
        public static final IntParam ParallelMode = IntParam.makeParam(1109, "ParallelMode");
        public static final IntParam SingLim = IntParam.makeParam(1037, "SingLim");
        public static final IntParam Reduce = IntParam.makeParam(1057, "Reduce");
        public static final IntParam CalcQCPDuals = IntParam.makeParam(4003, "CalcQCPDuals");
        public static final IntParam ColReadLim = IntParam.makeParam(1023, "ColReadLim");
        public static final IntParam RowReadLim = IntParam.makeParam(1021, "RowReadLim");
        public static final IntParam WriteLevel = IntParam.makeParam(1114, "WriteLevel");
        public static final IntParam RandomSeed = IntParam.makeParam(1124, "RandomSeed");
        public static final IntParam SiftDisplay = IntParam.makeParam(1076, "SiftDisplay");
        public static final IntParam SiftAlg = IntParam.makeParam(1077, "SiftAlg");
        public static final IntParam BrDir = IntParam.makeParam(2001, "BrDir");
        public static final IntParam Cliques = IntParam.makeParam(2003, "Cliques");
        public static final IntParam CoeRedInd = IntParam.makeParam(2004, "CoeRedInd");
        public static final IntParam Covers = IntParam.makeParam(2005, "Covers");
        public static final IntParam MIPDisplay = IntParam.makeParam(2012, "MIPDisplay");
        public static final IntParam NodeFileInd = IntParam.makeParam(2016, "NodeFileInd");
        public static final IntParam NodeSel = IntParam.makeParam(2018, "NodeSel");
        public static final IntParam VarSel = IntParam.makeParam(2028, "VarSel");
        public static final IntParam BndStrenInd = IntParam.makeParam(2029, "BndStrenInd");
        public static final IntParam FPHeur = IntParam.makeParam(2098, "FPHeur");
        public static final IntParam MIPOrdType = IntParam.makeParam(2032, "MIPOrdType");
        public static final IntParam FlowCovers = IntParam.makeParam(2040, "FlowCovers");
        public static final IntParam ImplBd = IntParam.makeParam(2041, "ImplBd");
        public static final IntParam Probe = IntParam.makeParam(2042, "Probe");
        public static final IntParam GUBCovers = IntParam.makeParam(2044, "GUBCovers");
        public static final IntParam StrongCandLim = IntParam.makeParam(2045, "StrongCandLim");
        public static final IntParam FracCand = IntParam.makeParam(2048, "FracCand");
        public static final IntParam FracCuts = IntParam.makeParam(2049, "FracCuts");
        public static final IntParam PreslvNd = IntParam.makeParam(2037, "PreslvNd");
        public static final IntParam FlowPaths = IntParam.makeParam(2051, "FlowPaths");
        public static final IntParam MIRCuts = IntParam.makeParam(2052, "MIRCuts");
        public static final IntParam DisjCuts = IntParam.makeParam(2053, "DisjCuts");
        public static final IntParam ZeroHalfCuts = IntParam.makeParam(2111, "ZeroHalfCuts");
        public static final IntParam MCFCuts = IntParam.makeParam(2134, "MCFCuts");
        public static final IntParam LiftProjCuts = IntParam.makeParam(2152, "LiftProjCuts");
        public static final IntParam AggCutLim = IntParam.makeParam(2054, "AggCutLim");
        public static final IntParam EachCutLim = IntParam.makeParam(2102, "EachCutLim");
        public static final IntParam DiveType = IntParam.makeParam(2060, "DiveType");
        public static final IntParam MIPSearch = IntParam.makeParam(2109, "MIPSearch");
        public static final IntParam MIQCPStrat = IntParam.makeParam(2110, "MIQCPStrat");
        public static final IntParam SolnPoolCapacity = IntParam.makeParam(2103, "SolnPoolCapacity");
        public static final IntParam SolnPoolReplace = IntParam.makeParam(2104, "SolnPoolReplace");
        public static final IntParam SolnPoolIntensity = IntParam.makeParam(2107, "SolnPoolIntensity");
        public static final IntParam PopulateLim = IntParam.makeParam(2108, "PopulateLim");
        public static final IntParam BarAlg = IntParam.makeParam(3007, "BarAlg");
        public static final IntParam BarColNz = IntParam.makeParam(3009, "BarColNz");
        public static final IntParam BarDisplay = IntParam.makeParam(3010, "BarDisplay");
        public static final IntParam BarOrder = IntParam.makeParam(3014, "BarOrder");
        public static final IntParam BarCrossAlg = IntParam.makeParam(3018, "BarCrossAlg");
        public static final IntParam BarStartAlg = IntParam.makeParam(3017, "BarStartAlg");
        public static final IntParam NetPPriInd = IntParam.makeParam(5004, "NetPPriInd");
        public static final IntParam NetDisplay = IntParam.makeParam(5005, "NetDisplay");
        public static final IntParam ConflictDisplay = IntParam.makeParam(1074, "ConflictDisplay");
        public static final IntParam FeasOptMode = IntParam.makeParam(1084, "FeasOptMode");
        public static final IntParam TuningMeasure = IntParam.makeParam(1110, "TuningMeasure");
        public static final IntParam TuningRepeat = IntParam.makeParam(1111, "TuningRepeat");
        public static final IntParam TuningDisplay = IntParam.makeParam(1113, "TuningDisplay");
        public static final IntParam MIPKappaStats = IntParam.makeParam(2137, "MIPKappaStats");
        public static final IntParam OptimalityTarget = IntParam.makeParam(1131, "OptimalityTarget");
        public static final IntParam RampupDuration = IntParam.makeParam(2163, "RampupDuration");
        @Deprecated
        public static final IntParam AggFill = new _AggFill();
        @Deprecated
        public static final IntParam NzReadLim = new _NzReadLim();
        @Deprecated
        public static final IntParam QPNzReadLim = new _QPNzReadLim();
        @Deprecated
        public static final IntParam ItLim = new _ItLim();
        @Deprecated
        public static final IntParam SiftItLim = new _SiftItLim();
        @Deprecated
        public static final IntParam BarItLim = new _BarItLim();
        @Deprecated
        public static final IntParam BarMaxCor = new _BarMaxCor();
        @Deprecated
        public static final IntParam BBInterval = new _BBInterval();
        @Deprecated
        public static final IntParam CutPass = new _CutPass();
        @Deprecated
        public static final IntParam FracPass = new _FracPass();
        @Deprecated
        public static final IntParam HeurFreq = new _HeurFreq();
        @Deprecated
        public static final IntParam MIPInterval = new _MIPInterval();
        @Deprecated
        public static final IntParam NodeLim = new _NodeLim();
        @Deprecated
        public static final IntParam IntSolLim = new _IntSolLim();
        @Deprecated
        public static final IntParam StrongItLim = new _StrongItLim();
        @Deprecated
        public static final IntParam RINSHeur = new _RINSHeur();
        @Deprecated
        public static final IntParam SubMIPNodeLim = new _SubMIPNodeLim();
        @Deprecated
        public static final IntParam RepairTries = new _RepairTries();
        @Deprecated
        public static final IntParam PolishAfterNode = new _PolishAfterNode();
        @Deprecated
        public static final IntParam PolishAfterIntSol = new _PolishAfterIntSol();
        @Deprecated
        public static final IntParam NetItLim = new _NetItLim();

        public IntParam() {
        }

        public IntParam(int n, String string) {
            super(n, string);
        }

        static IntParam makeParam(int n, String string) {
            IntParam intParam = (IntParam)IntParam.findParam(n);
            if (intParam == null) {
                intParam = new IntParam(n, string);
                IntParam.addParam(intParam);
            }
            return intParam;
        }

        public boolean alsoLong() {
            return false;
        }

        private static class _NetItLim
        extends IntParam {
            private _NetItLim() {
            }

            @Override
            public String toString() {
                return "NetItLim";
            }

            @Override
            public int getValue() {
                return 5001;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _PolishAfterIntSol
        extends IntParam {
            private _PolishAfterIntSol() {
            }

            @Override
            public String toString() {
                return "PolishAfterIntSol";
            }

            @Override
            public int getValue() {
                return 2129;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _PolishAfterNode
        extends IntParam {
            private _PolishAfterNode() {
            }

            @Override
            public String toString() {
                return "PolishAfterNode";
            }

            @Override
            public int getValue() {
                return 2128;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _RepairTries
        extends IntParam {
            private _RepairTries() {
            }

            @Override
            public String toString() {
                return "RepairTries";
            }

            @Override
            public int getValue() {
                return 2067;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _SubMIPNodeLim
        extends IntParam {
            private _SubMIPNodeLim() {
            }

            @Override
            public String toString() {
                return "SubMIPNodeLim";
            }

            @Override
            public int getValue() {
                return 2062;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _RINSHeur
        extends IntParam {
            private _RINSHeur() {
            }

            @Override
            public String toString() {
                return "RINSHeur";
            }

            @Override
            public int getValue() {
                return 2061;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _StrongItLim
        extends IntParam {
            private _StrongItLim() {
            }

            @Override
            public String toString() {
                return "StrongItLim";
            }

            @Override
            public int getValue() {
                return 2046;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _IntSolLim
        extends IntParam {
            private _IntSolLim() {
            }

            @Override
            public String toString() {
                return "IntSolLim";
            }

            @Override
            public int getValue() {
                return 2015;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _NodeLim
        extends IntParam {
            private _NodeLim() {
            }

            @Override
            public String toString() {
                return "NodeLim";
            }

            @Override
            public int getValue() {
                return 2017;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _MIPInterval
        extends IntParam {
            private _MIPInterval() {
            }

            @Override
            public String toString() {
                return "MIPInterval";
            }

            @Override
            public int getValue() {
                return 2013;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _HeurFreq
        extends IntParam {
            private _HeurFreq() {
            }

            @Override
            public String toString() {
                return "HeurFreq";
            }

            @Override
            public int getValue() {
                return 2031;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _FracPass
        extends IntParam {
            private _FracPass() {
            }

            @Override
            public String toString() {
                return "FracPass";
            }

            @Override
            public int getValue() {
                return 2050;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _CutPass
        extends IntParam {
            private _CutPass() {
            }

            @Override
            public String toString() {
                return "CutPass";
            }

            @Override
            public int getValue() {
                return 2056;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _BBInterval
        extends IntParam {
            private _BBInterval() {
            }

            @Override
            public String toString() {
                return "BBInterval";
            }

            @Override
            public int getValue() {
                return 2039;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _BarMaxCor
        extends IntParam {
            private _BarMaxCor() {
            }

            @Override
            public String toString() {
                return "BarMaxCor";
            }

            @Override
            public int getValue() {
                return 3013;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _BarItLim
        extends IntParam {
            private _BarItLim() {
            }

            @Override
            public String toString() {
                return "BarItLim";
            }

            @Override
            public int getValue() {
                return 3012;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _SiftItLim
        extends IntParam {
            private _SiftItLim() {
            }

            @Override
            public String toString() {
                return "SiftItLim";
            }

            @Override
            public int getValue() {
                return 1078;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _ItLim
        extends IntParam {
            private _ItLim() {
            }

            @Override
            public String toString() {
                return "ItLim";
            }

            @Override
            public int getValue() {
                return 1020;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _QPNzReadLim
        extends IntParam {
            private _QPNzReadLim() {
            }

            @Override
            public String toString() {
                return "QPNzReadLim";
            }

            @Override
            public int getValue() {
                return 4001;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _NzReadLim
        extends IntParam {
            private _NzReadLim() {
            }

            @Override
            public String toString() {
                return "NzReadLim";
            }

            @Override
            public int getValue() {
                return 1024;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }

        private static class _AggFill
        extends IntParam {
            private _AggFill() {
            }

            @Override
            public String toString() {
                return "AggFill";
            }

            @Override
            public int getValue() {
                return 1002;
            }

            @Override
            public boolean alsoLong() {
                return true;
            }
        }
    }

    public static class BooleanParam
    extends Param {
        public static final BooleanParam CloneLog = BooleanParam.makeParam(1132, "CloneLog");
        public static final BooleanParam PreInd = BooleanParam.makeParam(1030, "PreInd");
        public static final BooleanParam MIPOrdInd = BooleanParam.makeParam(2020, "MIPOrdInd");
        public static final BooleanParam MPSLongNum = BooleanParam.makeParam(1081, "MPSLongNum");
        public static final BooleanParam LBHeur = BooleanParam.makeParam(2063, "LBHeur");
        public static final BooleanParam PerInd = BooleanParam.makeParam(1027, "PerInd");
        public static final BooleanParam QPmakePSDInd = BooleanParam.makeParam(4010, "QPmakePSDInd");
        public static final BooleanParam MemoryEmphasis = BooleanParam.makeParam(1082, "MemoryEmphasis");
        public static final BooleanParam NumericalEmphasis = BooleanParam.makeParam(1083, "NumericalEmphasis");

        public BooleanParam() {
        }

        public BooleanParam(int n, String string) {
            super(n, string);
        }

        static BooleanParam makeParam(int n, String string) {
            BooleanParam booleanParam = (BooleanParam)BooleanParam.findParam(n);
            if (booleanParam == null) {
                booleanParam = new BooleanParam(n, string);
                BooleanParam.addParam(booleanParam);
            }
            return booleanParam;
        }
    }

    public static class Param
    implements Serializable {
        protected int _value = -1;
        protected String _name = null;
        public static Hashtable _revindex = new Hashtable();
        public static final IntParam Advance = IntParam.makeParam(1001, "IloCplex.Param.Advance");
        public static final IntParam ClockType = IntParam.makeParam(1006, "IloCplex.Param.ClockType");
        public static final StringParam CPUmask = StringParam.makeParam(1144, "IloCplex.Param.CPUmask");
        public static final DoubleParam DetTimeLimit = DoubleParam.makeParam(1127, "IloCplex.Param.DetTimeLimit");
        public static final IntParam NodeAlgorithm = IntParam.makeParam(2026, "IloCplex.Param.NodeAlgorithm");
        public static final IntParam OptimalityTarget = IntParam.makeParam(1131, "IloCplex.Param.OptimalityTarget");
        public static final IntParam Parallel = IntParam.makeParam(1109, "IloCplex.Param.Parallel");
        public static final BooleanParam ParamDisplay = BooleanParam.makeParam(1163, "IloCplex.Param.ParamDisplay");
        public static final IntParam RandomSeed = IntParam.makeParam(1124, "IloCplex.Param.RandomSeed");
        public static final BooleanParam Record = BooleanParam.makeParam(1162, "IloCplex.Param.Record");
        public static final IntParam RootAlgorithm = IntParam.makeParam(1062, "IloCplex.Param.RootAlgorithm");
        public static final IntParam SolutionType = IntParam.makeParam(1147, "IloCplex.Param.SolutionType");
        public static final IntParam Threads = IntParam.makeParam(1067, "IloCplex.Param.Threads");
        public static final DoubleParam TimeLimit = DoubleParam.makeParam(1039, "IloCplex.Param.TimeLimit");
        public static final StringParam WorkDir = StringParam.makeParam(1064, "IloCplex.Param.WorkDir");
        public static final DoubleParam WorkMem = DoubleParam.makeParam(1065, "IloCplex.Param.WorkMem");

        public int getValue() {
            return this._value;
        }

        public String toString() {
            return this._name;
        }

        public Param() {
        }

        public Param(int n, String string) {
            this._value = n;
            this._name = string;
        }

        public static Param findParam(int n) {
            return (Param)_revindex.get(new Integer(n));
        }

        static void addParam(Param param) {
            _revindex.put(new Integer(param.getValue()), param);
        }

        public boolean equals(Object object) {
            return object instanceof Param && ((Param)object).getValue() == this.getValue();
        }

        public static final class Tune {
            public static final DoubleParam DetTimeLimit = DoubleParam.makeParam(1139, "IloCplex.Param.Tune.DetTimeLimit");
            public static final IntParam Display = IntParam.makeParam(1113, "IloCplex.Param.Tune.Display");
            public static final IntParam Measure = IntParam.makeParam(1110, "IloCplex.Param.Tune.Measure");
            public static final IntParam Repeat = IntParam.makeParam(1111, "IloCplex.Param.Tune.Repeat");
            public static final DoubleParam TimeLimit = DoubleParam.makeParam(1112, "IloCplex.Param.Tune.TimeLimit");

            private Tune() {
            }
        }

        public static final class Simplex {
            public static final IntParam Crash = IntParam.makeParam(1007, "IloCplex.Param.Simplex.Crash");
            public static final IntParam DGradient = IntParam.makeParam(1009, "IloCplex.Param.Simplex.DGradient");
            public static final IntParam Display = IntParam.makeParam(1019, "IloCplex.Param.Simplex.Display");
            public static final IntParam DynamicRows = IntParam.makeParam(1161, "IloCplex.Param.Simplex.DynamicRows");
            public static final IntParam PGradient = IntParam.makeParam(1029, "IloCplex.Param.Simplex.PGradient");
            public static final IntParam Pricing = IntParam.makeParam(1010, "IloCplex.Param.Simplex.Pricing");
            public static final IntParam Refactor = IntParam.makeParam(1031, "IloCplex.Param.Simplex.Refactor");

            private Simplex() {
            }

            public static final class Tolerances {
                public static final DoubleParam Feasibility = DoubleParam.makeParam(1016, "IloCplex.Param.Simplex.Tolerances.Feasibility");
                public static final DoubleParam Markowitz = DoubleParam.makeParam(1013, "IloCplex.Param.Simplex.Tolerances.Markowitz");
                public static final DoubleParam Optimality = DoubleParam.makeParam(1014, "IloCplex.Param.Simplex.Tolerances.Optimality");

                private Tolerances() {
                }
            }

            public static final class Perturbation {
                public static final DoubleParam Constant = DoubleParam.makeParam(1015, "IloCplex.Param.Simplex.Perturbation.Constant");
                public static final BooleanParam Indicator = BooleanParam.makeParam(1027, "IloCplex.Param.Simplex.Perturbation.Indicator");

                private Perturbation() {
                }
            }

            public static final class Limits {
                public static final LongParam Iterations = LongParam.makeParam(1020, "IloCplex.Param.Simplex.Limits.Iterations");
                public static final DoubleParam LowerObj = DoubleParam.makeParam(1025, "IloCplex.Param.Simplex.Limits.LowerObj");
                public static final IntParam Perturbation = IntParam.makeParam(1028, "IloCplex.Param.Simplex.Limits.Perturbation");
                public static final IntParam Singularity = IntParam.makeParam(1037, "IloCplex.Param.Simplex.Limits.Singularity");
                public static final DoubleParam UpperObj = DoubleParam.makeParam(1026, "IloCplex.Param.Simplex.Limits.UpperObj");

                private Limits() {
                }
            }
        }

        public static final class Sifting {
            public static final IntParam Algorithm = IntParam.makeParam(1077, "IloCplex.Param.Sifting.Algorithm");
            public static final BooleanParam Simplex = BooleanParam.makeParam(1158, "IloCplex.Param.Sifting.Simplex");
            public static final IntParam Display = IntParam.makeParam(1076, "IloCplex.Param.Sifting.Display");
            public static final LongParam Iterations = LongParam.makeParam(1078, "IloCplex.Param.Sifting.Iterations");

            private Sifting() {
            }
        }

        public static final class Read {
            public static final IntParam Constraints = IntParam.makeParam(1021, "IloCplex.Param.Read.Constraints");
            public static final IntParam DataCheck = IntParam.makeParam(1056, "IloCplex.Param.Read.DataCheck");
            public static final StringParam FileEncoding = StringParam.makeParam(1129, "IloCplex.Param.Read.FileEncoding");
            public static final LongParam Nonzeros = LongParam.makeParam(1024, "IloCplex.Param.Read.Nonzeros");
            public static final LongParam QPNonzeros = LongParam.makeParam(4001, "IloCplex.Param.Read.QPNonzeros");
            public static final IntParam Scale = IntParam.makeParam(1034, "IloCplex.Param.Read.Scale");
            public static final IntParam Variables = IntParam.makeParam(1023, "IloCplex.Param.Read.Variables");

            private Read() {
            }
        }

        public static final class Preprocessing {
            public static final IntParam Aggregator = IntParam.makeParam(1003, "IloCplex.Param.Preprocessing.Aggregator");
            public static final IntParam BoundStrength = IntParam.makeParam(2029, "IloCplex.Param.Preprocessing.BoundStrength");
            public static final IntParam CoeffReduce = IntParam.makeParam(2004, "IloCplex.Param.Preprocessing.CoeffReduce");
            public static final IntParam Dependency = IntParam.makeParam(1008, "IloCplex.Param.Preprocessing.Dependency");
            public static final IntParam Dual = IntParam.makeParam(1044, "IloCplex.Param.Preprocessing.Dual");
            public static final LongParam Fill = LongParam.makeParam(1002, "IloCplex.Param.Preprocessing.Fill");
            public static final IntParam Linear = IntParam.makeParam(1058, "IloCplex.Param.Preprocessing.Linear");
            public static final IntParam NumPass = IntParam.makeParam(1052, "IloCplex.Param.Preprocessing.NumPass");
            public static final BooleanParam Presolve = BooleanParam.makeParam(1030, "IloCplex.Param.Preprocessing.Presolve");
            public static final IntParam QCPDuals = IntParam.makeParam(4003, "IloCplex.Param.Preprocessing.QCPDuals");
            public static final BooleanParam QPMakePSD = BooleanParam.makeParam(4010, "IloCplex.Param.Preprocessing.QPMakePSD");
            public static final IntParam QToLin = IntParam.makeParam(4012, "IloCplex.Param.Preprocessing.QToLin");
            public static final IntParam Reduce = IntParam.makeParam(1057, "IloCplex.Param.Preprocessing.Reduce");
            public static final IntParam Relax = IntParam.makeParam(2034, "IloCplex.Param.Preprocessing.Relax");
            public static final IntParam RepeatPresolve = IntParam.makeParam(2064, "IloCplex.Param.Preprocessing.RepeatPresolve");
            public static final IntParam Symmetry = IntParam.makeParam(2059, "IloCplex.Param.Preprocessing.Symmetry");

            private Preprocessing() {
            }
        }

        public static final class Output {
            public static final BooleanParam CloneLog = BooleanParam.makeParam(1132, "IloCplex.Param.Output.CloneLog");
            public static final StringParam IntSolFilePrefix = StringParam.makeParam(2143, "IloCplex.Param.Output.IntSolFilePrefix");
            public static final BooleanParam MPSLong = BooleanParam.makeParam(1081, "IloCplex.Param.Output.MPSLong");
            public static final IntParam WriteLevel = IntParam.makeParam(1114, "IloCplex.Param.Output.WriteLevel");

            private Output() {
            }
        }

        public static final class Network {
            public static final IntParam Display = IntParam.makeParam(5005, "IloCplex.Param.Network.Display");
            public static final LongParam Iterations = LongParam.makeParam(5001, "IloCplex.Param.Network.Iterations");
            public static final IntParam NetFind = IntParam.makeParam(1022, "IloCplex.Param.Network.NetFind");
            public static final IntParam Pricing = IntParam.makeParam(5004, "IloCplex.Param.Network.Pricing");

            private Network() {
            }

            public static final class Tolerances {
                public static final DoubleParam Feasibility = DoubleParam.makeParam(5003, "IloCplex.Param.Network.Tolerances.Feasibility");
                public static final DoubleParam Optimality = DoubleParam.makeParam(5002, "IloCplex.Param.Network.Tolerances.Optimality");

                private Tolerances() {
                }
            }
        }

        public static final class MIP {
            public static final IntParam Display = IntParam.makeParam(2012, "IloCplex.Param.MIP.Display");
            public static final LongParam Interval = LongParam.makeParam(2013, "IloCplex.Param.MIP.Interval");
            public static final IntParam OrderType = IntParam.makeParam(2032, "IloCplex.Param.MIP.OrderType");

            private MIP() {
            }

            public static final class Tolerances {
                public static final DoubleParam AbsMIPGap = DoubleParam.makeParam(2008, "IloCplex.Param.MIP.Tolerances.AbsMIPGap");
                public static final DoubleParam Linearization = DoubleParam.makeParam(2068, "IloCplex.Param.MIP.Tolerances.Linearization");
                public static final DoubleParam Integrality = DoubleParam.makeParam(2010, "IloCplex.Param.MIP.Tolerances.Integrality");
                public static final DoubleParam LowerCutoff = DoubleParam.makeParam(2006, "IloCplex.Param.MIP.Tolerances.LowerCutoff");
                public static final DoubleParam MIPGap = DoubleParam.makeParam(2009, "IloCplex.Param.MIP.Tolerances.MIPGap");
                public static final DoubleParam ObjDifference = DoubleParam.makeParam(2019, "IloCplex.Param.MIP.Tolerances.ObjDifference");
                public static final DoubleParam RelObjDifference = DoubleParam.makeParam(2022, "IloCplex.Param.MIP.Tolerances.RelObjDifference");
                public static final DoubleParam UpperCutoff = DoubleParam.makeParam(2007, "IloCplex.Param.MIP.Tolerances.UpperCutoff");

                private Tolerances() {
                }
            }

            public static final class Strategy {
                public static final DoubleParam Backtrack = DoubleParam.makeParam(2002, "IloCplex.Param.MIP.Strategy.Backtrack");
                public static final LongParam BBInterval = LongParam.makeParam(2039, "IloCplex.Param.MIP.Strategy.BBInterval");
                public static final IntParam Branch = IntParam.makeParam(2001, "IloCplex.Param.MIP.Strategy.Branch");
                public static final IntParam Dive = IntParam.makeParam(2060, "IloCplex.Param.MIP.Strategy.Dive");
                public static final IntParam File = IntParam.makeParam(2016, "IloCplex.Param.MIP.Strategy.File");
                public static final IntParam FPHeur = IntParam.makeParam(2098, "IloCplex.Param.MIP.Strategy.FPHeur");
                public static final LongParam HeuristicFreq = LongParam.makeParam(2031, "IloCplex.Param.MIP.Strategy.HeuristicFreq");
                public static final IntParam KappaStats = IntParam.makeParam(2137, "IloCplex.Param.MIP.Strategy.KappaStats");
                public static final BooleanParam LBHeur = BooleanParam.makeParam(2063, "IloCplex.Param.MIP.Strategy.LBHeur");
                public static final IntParam MIQCPStrat = IntParam.makeParam(2110, "IloCplex.Param.MIP.Strategy.MIQCPStrat");
                public static final IntParam NodeSelect = IntParam.makeParam(2018, "IloCplex.Param.MIP.Strategy.NodeSelect");
                public static final BooleanParam Order = BooleanParam.makeParam(2020, "IloCplex.Param.MIP.Strategy.Order");
                public static final IntParam PresolveNode = IntParam.makeParam(2037, "IloCplex.Param.MIP.Strategy.PresolveNode");
                public static final IntParam Probe = IntParam.makeParam(2042, "IloCplex.Param.MIP.Strategy.Probe");
                public static final LongParam RINSHeur = LongParam.makeParam(2061, "IloCplex.Param.MIP.Strategy.RINSHeur");
                public static final IntParam Search = IntParam.makeParam(2109, "IloCplex.Param.MIP.Strategy.Search");
                public static final IntParam VariableSelect = IntParam.makeParam(2028, "IloCplex.Param.MIP.Strategy.VariableSelect");

                private Strategy() {
                }
            }

            public static final class SubMIP {
                public static final IntParam StartAlg = IntParam.makeParam(2205, "IloCplex.Param.MIP.SubMIP.StartAlg");
                public static final IntParam SubAlg = IntParam.makeParam(2206, "IloCplex.Param.MIP.SubMIP.SubAlg");
                public static final LongParam NodeLimit = LongParam.makeParam(2212, "IloCplex.Param.MIP.SubMIP.NodeLimit");
                public static final IntParam Scale = IntParam.makeParam(2207, "IloCplex.Param.MIP.SubMIP.Scale");

                private SubMIP() {
                }
            }

            public static final class Pool {
                public static final DoubleParam AbsGap = DoubleParam.makeParam(2106, "IloCplex.Param.MIP.Pool.AbsGap");
                public static final IntParam Capacity = IntParam.makeParam(2103, "IloCplex.Param.MIP.Pool.Capacity");
                public static final IntParam Intensity = IntParam.makeParam(2107, "IloCplex.Param.MIP.Pool.Intensity");
                public static final DoubleParam RelGap = DoubleParam.makeParam(2105, "IloCplex.Param.MIP.Pool.RelGap");
                public static final IntParam Replace = IntParam.makeParam(2104, "IloCplex.Param.MIP.Pool.Replace");

                private Pool() {
                }
            }

            public static final class PolishAfter {
                public static final DoubleParam AbsMIPGap = DoubleParam.makeParam(2126, "IloCplex.Param.MIP.PolishAfter.AbsMIPGap");
                public static final DoubleParam DetTime = DoubleParam.makeParam(2151, "IloCplex.Param.MIP.PolishAfter.DetTime");
                public static final DoubleParam MIPGap = DoubleParam.makeParam(2127, "IloCplex.Param.MIP.PolishAfter.MIPGap");
                public static final LongParam Nodes = LongParam.makeParam(2128, "IloCplex.Param.MIP.PolishAfter.Nodes");
                public static final LongParam Solutions = LongParam.makeParam(2129, "IloCplex.Param.MIP.PolishAfter.Solutions");
                public static final DoubleParam Time = DoubleParam.makeParam(2130, "IloCplex.Param.MIP.PolishAfter.Time");

                private PolishAfter() {
                }
            }

            public static final class Limits {
                public static final IntParam AggForCut = IntParam.makeParam(2054, "IloCplex.Param.MIP.Limits.AggForCut");
                public static final IntParam AuxRootThreads = IntParam.makeParam(2139, "IloCplex.Param.MIP.Limits.AuxRootThreads");
                public static final LongParam CutPasses = LongParam.makeParam(2056, "IloCplex.Param.MIP.Limits.CutPasses");
                public static final DoubleParam CutsFactor = DoubleParam.makeParam(2033, "IloCplex.Param.MIP.Limits.CutsFactor");
                public static final IntParam EachCutLimit = IntParam.makeParam(2102, "IloCplex.Param.MIP.Limits.EachCutLimit");
                public static final IntParam GomoryCand = IntParam.makeParam(2048, "IloCplex.Param.MIP.Limits.GomoryCand");
                public static final LongParam GomoryPass = LongParam.makeParam(2050, "IloCplex.Param.MIP.Limits.GomoryPass");
                public static final LongParam Nodes = LongParam.makeParam(2017, "IloCplex.Param.MIP.Limits.Nodes");
                public static final DoubleParam PolishTime = DoubleParam.makeParam(2066, "IloCplex.Param.MIP.Limits.PolishTime");
                public static final IntParam Populate = IntParam.makeParam(2108, "IloCplex.Param.MIP.Limits.Populate");
                public static final DoubleParam ProbeDetTime = DoubleParam.makeParam(2150, "IloCplex.Param.MIP.Limits.ProbeDetTime");
                public static final DoubleParam ProbeTime = DoubleParam.makeParam(2065, "IloCplex.Param.MIP.Limits.ProbeTime");
                public static final LongParam RepairTries = LongParam.makeParam(2067, "IloCplex.Param.MIP.Limits.RepairTries");
                public static final LongParam Solutions = LongParam.makeParam(2015, "IloCplex.Param.MIP.Limits.Solutions");
                public static final IntParam StrongCand = IntParam.makeParam(2045, "IloCplex.Param.MIP.Limits.StrongCand");
                public static final LongParam StrongIt = LongParam.makeParam(2046, "IloCplex.Param.MIP.Limits.StrongIt");
                @Deprecated
                public static final LongParam SubMIPNodeLim = LongParam.makeParam(2062, "IloCplex.Param.MIP.Limits.SubMIPNodeLim");
                public static final DoubleParam TreeMemory = DoubleParam.makeParam(2027, "IloCplex.Param.MIP.Limits.TreeMemory");

                private Limits() {
                }
            }

            public static final class Cuts {
                public static final IntParam BQP = IntParam.makeParam(2195, "IloCplex.Param.MIP.Cuts.BQP");
                public static final IntParam Cliques = IntParam.makeParam(2003, "IloCplex.Param.MIP.Cuts.Cliques");
                public static final IntParam Covers = IntParam.makeParam(2005, "IloCplex.Param.MIP.Cuts.Covers");
                public static final IntParam Disjunctive = IntParam.makeParam(2053, "IloCplex.Param.MIP.Cuts.Disjunctive");
                public static final IntParam FlowCovers = IntParam.makeParam(2040, "IloCplex.Param.MIP.Cuts.FlowCovers");
                public static final IntParam Gomory = IntParam.makeParam(2049, "IloCplex.Param.MIP.Cuts.Gomory");
                public static final IntParam GUBCovers = IntParam.makeParam(2044, "IloCplex.Param.MIP.Cuts.GUBCovers");
                public static final IntParam Implied = IntParam.makeParam(2041, "IloCplex.Param.MIP.Cuts.Implied");
                public static final IntParam LiftProj = IntParam.makeParam(2152, "IloCplex.Param.MIP.Cuts.LiftProj");
                public static final IntParam LocalImplied = IntParam.makeParam(2181, "IloCplex.Param.MIP.Cuts.LocalImplied");
                public static final IntParam MCFCut = IntParam.makeParam(2134, "IloCplex.Param.MIP.Cuts.MCFCut");
                public static final IntParam MIRCut = IntParam.makeParam(2052, "IloCplex.Param.MIP.Cuts.MIRCut");
                public static final IntParam PathCut = IntParam.makeParam(2051, "IloCplex.Param.MIP.Cuts.PathCut");
                public static final IntParam RLT = IntParam.makeParam(2196, "IloCplex.Param.MIP.Cuts.RLT");
                public static final IntParam ZeroHalfCut = IntParam.makeParam(2111, "IloCplex.Param.MIP.Cuts.ZeroHalfCut");

                private Cuts() {
                }
            }
        }

        public static final class Feasopt {
            public static final IntParam Mode = IntParam.makeParam(1084, "IloCplex.Param.Feasopt.Mode");
            public static final DoubleParam Tolerance = DoubleParam.makeParam(2073, "IloCplex.Param.Feasopt.Tolerance");

            private Feasopt() {
            }
        }

        public static final class Emphasis {
            public static final BooleanParam Memory = BooleanParam.makeParam(1082, "IloCplex.Param.Emphasis.Memory");
            public static final IntParam MIP = IntParam.makeParam(2058, "IloCplex.Param.Emphasis.MIP");
            public static final BooleanParam Numerical = BooleanParam.makeParam(1083, "IloCplex.Param.Emphasis.Numerical");

            private Emphasis() {
            }
        }

        public static final class DistMIP {
            private DistMIP() {
            }

            public static final class Rampup {
                public static final DoubleParam DetTimeLimit = DoubleParam.makeParam(2164, "IloCplex.Param.DistMIP.Rampup.DetTimeLimit");
                public static final IntParam Duration = IntParam.makeParam(2163, "IloCplex.Param.DistMIP.Rampup.Duration");
                public static final DoubleParam TimeLimit = DoubleParam.makeParam(2165, "IloCplex.Param.DistMIP.Rampup.TimeLimit");

                private Rampup() {
                }
            }
        }

        public static final class Conflict {
            public static final IntParam Algorithm = IntParam.makeParam(1073, "IloCplex.Param.Conflict.Algorithm");
            public static final IntParam Display = IntParam.makeParam(1074, "IloCplex.Param.Conflict.Display");

            private Conflict() {
            }
        }

        public static final class Benders {
            public static final IntParam Strategy = IntParam.makeParam(1501, "IloCplex.Param.Benders.Strategy");
            public static final IntParam WorkerAlgorithm = IntParam.makeParam(1500, "IloCplex.Param.Benders.WorkerAlgorithm");

            private Benders() {
            }

            public static final class Tolerances {
                public static final DoubleParam feasibilitycut = DoubleParam.makeParam(1509, "IloCplex.Param.Benders.Tolerances.feasibilitycut");
                public static final DoubleParam optimalitycut = DoubleParam.makeParam(1510, "IloCplex.Param.Benders.Tolerances.optimalitycut");

                private Tolerances() {
                }
            }
        }

        public static final class Barrier {
            public static final IntParam Algorithm = IntParam.makeParam(3007, "IloCplex.Param.Barrier.Algorithm");
            public static final IntParam ColNonzeros = IntParam.makeParam(3009, "IloCplex.Param.Barrier.ColNonzeros");
            public static final DoubleParam ConvergeTol = DoubleParam.makeParam(3002, "IloCplex.Param.Barrier.ConvergeTol");
            public static final IntParam Crossover = IntParam.makeParam(3018, "IloCplex.Param.Barrier.Crossover");
            public static final IntParam Display = IntParam.makeParam(3010, "IloCplex.Param.Barrier.Display");
            public static final IntParam Ordering = IntParam.makeParam(3014, "IloCplex.Param.Barrier.Ordering");
            public static final DoubleParam QCPConvergeTol = DoubleParam.makeParam(3020, "IloCplex.Param.Barrier.QCPConvergeTol");
            public static final IntParam StartAlg = IntParam.makeParam(3017, "IloCplex.Param.Barrier.StartAlg");

            private Barrier() {
            }

            public static final class Limits {
                public static final LongParam Corrections = LongParam.makeParam(3013, "IloCplex.Param.Barrier.Limits.Corrections");
                public static final DoubleParam Growth = DoubleParam.makeParam(3003, "IloCplex.Param.Barrier.Limits.Growth");
                public static final LongParam Iteration = LongParam.makeParam(3012, "IloCplex.Param.Barrier.Limits.Iteration");
                public static final DoubleParam ObjRange = DoubleParam.makeParam(3004, "IloCplex.Param.Barrier.Limits.ObjRange");

                private Limits() {
                }
            }
        }
    }

    public static class Algorithm {
        public static final int None = -1;
        public static final int Auto = 0;
        public static final int Primal = 1;
        public static final int Dual = 2;
        public static final int Network = 3;
        public static final int Barrier = 4;
        public static final int Sifting = 5;
        public static final int Concurrent = 6;
        public static final int FeasOpt = 11;
        public static final int MIP = 12;
    }

    public static class Status {
        int _status;
        public static final Status Error = new Status(-1);
        public static final Status Unknown = new Status(0);
        public static final Status Feasible = new Status(1);
        public static final Status Bounded = new Status(2);
        public static final Status Optimal = new Status(3);
        public static final Status Infeasible = new Status(4);
        public static final Status Unbounded = new Status(8);
        public static final Status InfeasibleOrUnbounded = new Status(12);

        Status(int n) {
            this._status = n;
        }

        public String toString() {
            switch (this._status) {
                case 0: {
                    return "Unknown";
                }
                case 1: {
                    return "Feasible";
                }
                case 2: {
                    return "Bounded";
                }
                case 3: {
                    return "Optimal";
                }
                case 4: {
                    return "Infeasible";
                }
                case 8: {
                    return "Unbounded";
                }
                case 12: {
                    return "InfeasibleOrUnbounded";
                }
            }
            return "Error";
        }
    }
}

