/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.cplex.CpxConstExpr;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxLinearExpr;
import ilog.cplex.CpxLinkedExpr;
import ilog.cplex.CpxMult;
import ilog.cplex.CpxNegative;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxQExpr;
import ilog.cplex.CpxQLExpr;
import ilog.cplex.CpxQTerm;

class EvalVisitor
implements CpxExprVisitor {
    double[] _vals;
    double _val;

    EvalVisitor(double[] dArray) {
        this._vals = dArray;
        this._val = 0.0;
    }

    final double getValue() {
        this._vals = null;
        return this._val;
    }

    @Override
    public Object visitNumVar(CpxNumVar cpxNumVar) throws IloException {
        this._val = this._vals[cpxNumVar.getVarIndexValue()];
        return null;
    }

    @Override
    public Object visitLinearExpr(CpxLinearExpr cpxLinearExpr) throws IloException {
        this._val = cpxLinearExpr.getCpxConstant();
        CpxLinearExpr.LinIterator linIterator = new CpxLinearExpr.LinIterator(cpxLinearExpr);
        while (linIterator.hasNext()) {
            this._val += this._vals[linIterator.nextCpxVar().getVarIndexValue()] * linIterator.getCpxValue();
        }
        return null;
    }

    @Override
    public Object visitNegative(CpxNegative cpxNegative) throws IloException {
        cpxNegative.getExpr().accept(this);
        this._val = -this._val;
        return null;
    }

    @Override
    public Object visitLinkedExpr(CpxLinkedExpr cpxLinkedExpr) throws IloException {
        double d = 0.0;
        CpxLinkedExpr.Link link = cpxLinkedExpr.first;
        while (link != cpxLinkedExpr.last) {
            link.expr.accept(this);
            d += this._val;
            link = link.next;
        }
        if (cpxLinkedExpr.last != null) {
            cpxLinkedExpr.last.expr.accept(this);
            d += this._val;
        }
        this._val = d;
        return null;
    }

    @Override
    public Object visitMult(CpxMult cpxMult) throws IloException {
        cpxMult.getLeft().accept(this);
        double d = this._val;
        cpxMult.getRight().accept(this);
        this._val = d * this._val;
        return null;
    }

    @Override
    public Object visitQTerm(CpxQTerm cpxQTerm) throws IloException {
        this._val = cpxQTerm.getVal();
        this._val *= this._vals[cpxQTerm.getVar1().getVarIndexValue()];
        this._val *= this._vals[cpxQTerm.getVar2().getVarIndexValue()];
        return null;
    }

    @Override
    public Object visitQExpr(CpxQExpr cpxQExpr) throws IloException {
        this._val = 0.0;
        CpxQExpr.QuadIterator quadIterator = new CpxQExpr.QuadIterator(cpxQExpr);
        while (quadIterator.MoveNext()) {
            this._val += quadIterator.getCpxValue() * this._vals[quadIterator.getCpxVar1().getVarIndexValue()] * this._vals[quadIterator.getCpxVar2().getVarIndexValue()];
        }
        return null;
    }

    @Override
    public Object visitQLExpr(CpxQLExpr cpxQLExpr) throws IloException {
        this.visitLinearExpr(cpxQLExpr._lin);
        double d = this._val;
        this.visitQExpr(cpxQLExpr._quad);
        this._val += d;
        return null;
    }

    @Override
    public Object visitConst(CpxConstExpr cpxConstExpr) throws IloException {
        this._val = cpxConstExpr.getValue();
        return null;
    }
}

