/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.concert.IloNumVarType;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxConstExpr;
import ilog.cplex.CpxLinearExpr;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.IloCplex;
import ilog.cplex.IloCplexModeler;
import java.io.IOException;
import java.io.ObjectOutputStream;

public abstract class CpxSubVar
extends CpxNumVar {
    private static final long serialVersionUID = 12080000L;
    private boolean _duringInstall = false;
    private int _refCnt = 0;

    @Override
    void end() throws IloException {
        if (this._refCnt > 0) {
            this._refCnt = 1;
            this.userUninstall(this._cplexi.getModeler());
        }
        super.end();
    }

    protected CpxSubVar() throws IloException {
        super(0.0, 0.0, IloNumVarType.Float, null);
    }

    protected CpxSubVar(double d, double d2, IloNumVarType iloNumVarType, String string) throws IloException {
        super(d, d2, iloNumVarType, string);
    }

    void incrementRefCnt() {
        ++this._refCnt;
    }

    void incrementRefCnt(int n) {
        this._refCnt += n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userInstall(IloCplexModeler iloCplexModeler) throws IloException {
        if (!this._duringInstall) {
            ++this._refCnt;
            if (!this._duringInstall && this._refCnt == 1) {
                ++iloCplexModeler.getCplexI()._registerAdd;
                this._duringInstall = true;
                try {
                    this.installVar(iloCplexModeler);
                }
                finally {
                    --iloCplexModeler.getCplexI()._registerAdd;
                    this._duringInstall = false;
                }
            }
        }
    }

    void installVar(IloCplexModeler iloCplexModeler) throws IloException {
        throw new IloCplex.UnknownObjectException(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userUninstall(IloCplexModeler iloCplexModeler) throws IloException {
        if (!this._duringInstall) {
            --this._refCnt;
            if (!this._duringInstall && this._refCnt == 0) {
                ++iloCplexModeler.getCplexI()._registerAdd;
                this._duringInstall = true;
                try {
                    this.uninstallVar(iloCplexModeler);
                    this.getCplexI().delColumn(this._varIndex);
                    this._varIndex = null;
                }
                finally {
                    --iloCplexModeler.getCplexI()._registerAdd;
                    this._duringInstall = false;
                }
            }
        }
    }

    void uninstallVar(IloCplexModeler iloCplexModeler) throws IloException {
        throw new IloCplex.UnknownObjectException(this);
    }

    @Override
    void removeVars(CplexIndex cplexIndex) throws IloException {
        this.removeVarsFromSubVar(cplexIndex);
    }

    void removeVarsFromSubVar(CplexIndex cplexIndex) throws IloException {
        throw new UnsupportedOperationException("CpxSubVar.removeVarsFromSubVar not implemented");
    }

    void removeVarsFromSubExpr(CpxNumExpr[] cpxNumExprArray, CplexIndex cplexIndex) throws IloException {
        for (int i = 0; i < cpxNumExprArray.length; ++i) {
            if (cpxNumExprArray[i] instanceof CpxLinearExpr) {
                ((CpxLinearExpr)cpxNumExprArray[i]).removeVars(cplexIndex);
                continue;
            }
            if (cpxNumExprArray[i] instanceof CpxNumVar) {
                if (((CpxNumVar)cpxNumExprArray[i]).getVarIndex() == cplexIndex) {
                    cpxNumExprArray[i] = new CpxConstExpr(0.0);
                }
                if (!(cpxNumExprArray[i] instanceof CpxSubVar)) continue;
                ((CpxSubVar)cpxNumExprArray[i]).removeVarsFromSubVar(cplexIndex);
                continue;
            }
            if (cpxNumExprArray[i] instanceof CpxConstExpr) continue;
            throw new IloException("removeVarsFromSubExpr Not implemented");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this._refCnt;
        this._refCnt = 0;
        try {
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this._refCnt = n;
        }
    }
}

