/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloMPModeler;
import ilog.concert.IloNumVar;
import ilog.concert.IloQuadNumExpr;
import ilog.concert.IloQuadNumExprIterator;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxQExpr;
import java.util.NoSuchElementException;

class CpxQuadNumExpr
extends CpxQExpr
implements IloQuadNumExpr {
    private static final long serialVersionUID = 12080000L;

    @Override
    public IloQuadNumExprIterator quadIterator() {
        return new QuadNumIterator(this);
    }

    CpxQuadNumExpr() {
    }

    protected CpxQuadNumExpr(double[] dArray, CpxNumVar[] cpxNumVarArray, CpxNumVar[] cpxNumVarArray2, int n, int n2) {
        super(dArray, cpxNumVarArray, cpxNumVarArray2, n, n2);
    }

    @Override
    public CpxQExpr makeCopy() {
        return (CpxQuadNumExpr)this.copyTo(new CpxQuadNumExpr());
    }

    @Override
    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloMPModeler iloMPModeler = (IloMPModeler)iloCopyManager.getModeler();
        IloQuadNumExpr iloQuadNumExpr = iloMPModeler.quadNumExpr();
        if (this._num > 0) {
            IloNumVar[] iloNumVarArray = new IloNumVar[this._num];
            IloNumVar[] iloNumVarArray2 = new IloNumVar[this._num];
            double[] dArray = new double[this._num];
            for (int i = 0; i < this._num; ++i) {
                iloNumVarArray[i] = (IloNumVar)iloCopyManager.getCopy(this._var1[i]);
                iloNumVarArray2[i] = (IloNumVar)iloCopyManager.getCopy(this._var2[i]);
                dArray[i] = this._val[i];
            }
            iloQuadNumExpr.addTerms(dArray, iloNumVarArray, iloNumVarArray2, 0, this._num);
        }
        return iloQuadNumExpr;
    }

    @Override
    public void add(IloQuadNumExpr iloQuadNumExpr) throws IloException {
        IloQuadNumExprIterator iloQuadNumExprIterator = iloQuadNumExpr.quadIterator();
        while (iloQuadNumExprIterator.hasNext()) {
            iloQuadNumExprIterator.next();
            IloNumVar iloNumVar = iloQuadNumExprIterator.getNumVar1();
            IloNumVar iloNumVar2 = iloQuadNumExprIterator.getNumVar2();
            this.addTerm(iloQuadNumExprIterator.getValue(), iloNumVar, iloNumVar2);
        }
    }

    @Override
    public void addTerm(double d, IloNumVar iloNumVar, IloNumVar iloNumVar2) throws IloException {
        this.addCoef((CpxNumVar)iloNumVar, (CpxNumVar)iloNumVar2, d);
    }

    @Override
    public void addTerms(double[] dArray, IloNumVar[] iloNumVarArray, IloNumVar[] iloNumVarArray2, int n, int n2) throws IloException {
        if (n2 > 0) {
            this.makeSpace(n2);
            System.arraycopy(dArray, n, this._val, this._num, n2);
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this._var1[this._num] = (CpxNumVar)iloNumVarArray[i];
                this._var2[this._num] = (CpxNumVar)iloNumVarArray2[i];
                ++this._num;
            }
        }
    }

    @Override
    public void addTerms(double[] dArray, IloNumVar[] iloNumVarArray, IloNumVar[] iloNumVarArray2) throws IloException {
        this.addTerms(dArray, iloNumVarArray, iloNumVarArray2, 0, dArray.length);
    }

    @Override
    public void remove(IloNumVar iloNumVar) throws IloException {
        super.remove((CpxNumVar)iloNumVar);
    }

    @Override
    public void remove(IloNumVar[] iloNumVarArray) throws IloException {
        this.remove(iloNumVarArray, 0, iloNumVarArray.length);
    }

    @Override
    public void remove(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int n3;
        int n4 = n + n2;
        for (n3 = n; n3 < n4; ++n3) {
            ((CpxNumVar)iloNumVarArray[n3]).mark(-1);
        }
        this.removeMarked();
        for (n3 = n; n3 < n4; ++n3) {
            ((CpxNumVar)iloNumVarArray[n3]).unmark();
        }
    }

    class QuadNumIterator
    extends CpxQExpr.QuadIterator
    implements IloQuadNumExprIterator {
        QuadNumIterator(CpxQuadNumExpr cpxQuadNumExpr2) {
            super(cpxQuadNumExpr2);
        }

        @Override
        public IloNumVar getNumVar1() throws NoSuchElementException {
            return this.getCpxVar1();
        }

        @Override
        public IloNumVar getNumVar2() throws NoSuchElementException {
            return this.getCpxVar2();
        }

        public Object next() throws NoSuchElementException {
            return this.nextCpxVar1();
        }

        @Override
        public void setNumVar1(IloNumVar iloNumVar) {
            super.setNumVar1(iloNumVar);
        }

        @Override
        public void setNumVar2(IloNumVar iloNumVar) {
            super.setNumVar2(iloNumVar);
        }

        @Override
        public double getValue() throws IllegalStateException {
            return this.getCpxValue();
        }

        @Override
        public void setValue(double d) throws IllegalStateException {
            this.setCpxValue(d);
        }
    }
}

