/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.cplex.CpxConstExpr;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxLinearExpr;
import ilog.cplex.CpxLinkedExpr;
import ilog.cplex.CpxMult;
import ilog.cplex.CpxNegative;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxQExpr;
import ilog.cplex.CpxQLExpr;
import ilog.cplex.CpxQTerm;

class CpxQTermExtractor
implements CpxExprVisitor {
    CpxNumVar var1;
    CpxNumVar var2;
    double val;

    CpxQTermExtractor() {
    }

    public void clear() {
        this.var1 = null;
        this.var2 = null;
        this.val = 1.0;
    }

    @Override
    public Object visitNumVar(CpxNumVar cpxNumVar) throws IloException {
        if (this.var1 == null) {
            this.var1 = cpxNumVar;
        } else if (this.var2 == null) {
            this.var2 = cpxNumVar;
        } else {
            return null;
        }
        return this;
    }

    @Override
    public Object visitLinearExpr(CpxLinearExpr cpxLinearExpr) throws IloException {
        if (cpxLinearExpr.getNum() == 0) {
            this.val *= cpxLinearExpr._const;
        } else {
            if (cpxLinearExpr._const != 0.0 || cpxLinearExpr.getNum() != 1) {
                return null;
            }
            this.visitNumVar(cpxLinearExpr.getNumVars()[0]);
            this.val *= cpxLinearExpr.getValues()[0];
        }
        return this;
    }

    @Override
    public Object visitNegative(CpxNegative cpxNegative) throws IloException {
        this.val *= -1.0;
        return cpxNegative.getExpr().accept(this);
    }

    @Override
    public Object visitLinkedExpr(CpxLinkedExpr cpxLinkedExpr) throws IloException {
        return null;
    }

    @Override
    public Object visitMult(CpxMult cpxMult) throws IloException {
        if (cpxMult.getRight().accept(this) != null) {
            return cpxMult.getLeft().accept(this);
        }
        return null;
    }

    @Override
    public Object visitQTerm(CpxQTerm cpxQTerm) throws IloException {
        if (this.var1 != null || this.var2 != null) {
            return null;
        }
        this.var1 = cpxQTerm.getVar1();
        this.var2 = cpxQTerm.getVar2();
        this.val *= cpxQTerm.getVal();
        return this;
    }

    @Override
    public Object visitQExpr(CpxQExpr cpxQExpr) throws IloException {
        if (cpxQExpr.getNum() > 1) {
            return null;
        }
        if (cpxQExpr.getNum() == 1) {
            if (this.var1 != null || this.var2 != null) {
                return null;
            }
            this.var1 = cpxQExpr.getNumVar1()[0];
            this.var2 = cpxQExpr.getNumVar2()[0];
            this.val *= cpxQExpr.getValues()[0];
        }
        return this;
    }

    @Override
    public Object visitQLExpr(CpxQLExpr cpxQLExpr) throws IloException {
        if (this.visitLinearExpr(cpxQLExpr._lin) != null) {
            return this.visitQExpr(cpxQLExpr._quad);
        }
        return null;
    }

    @Override
    public Object visitConst(CpxConstExpr cpxConstExpr) throws IloException {
        this.val *= cpxConstExpr.getValue();
        return this;
    }

    public void install(CpxLinearExpr cpxLinearExpr, CpxQExpr cpxQExpr) throws IloException {
        if (this.var1 == null) {
            if (this.var2 == null) {
                cpxLinearExpr._const += this.val;
            } else {
                cpxLinearExpr.addCoef(this.var2, this.val);
            }
        } else if (this.var2 == null) {
            cpxLinearExpr.addCoef(this.var1, this.val);
        } else {
            cpxQExpr.addCoef(this.var1, this.var2, this.val);
        }
    }
}

