/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloMPModeler;
import ilog.concert.IloNumExpr;
import ilog.concert.IloQuadNumExpr;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxLinearExpr;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxQExpr;
import java.io.Serializable;

public abstract class CpxQLExpr
implements CpxNumExpr,
Serializable {
    private static final long serialVersionUID = 12080000L;
    CpxLinearExpr _lin;
    CpxQExpr _quad;

    @Override
    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        throw check;
    }

    @Override
    public Object accept(CpxExprVisitor cpxExprVisitor) throws IloException {
        return cpxExprVisitor.visitQLExpr(this);
    }

    public abstract CpxQLExpr makeCopy();

    @Override
    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloMPModeler iloMPModeler = (IloMPModeler)iloCopyManager.getModeler();
        IloLinearNumExpr iloLinearNumExpr = (IloLinearNumExpr)iloCopyManager.getCopy(this._lin);
        IloQuadNumExpr iloQuadNumExpr = (IloQuadNumExpr)iloCopyManager.getCopy(this._quad);
        return iloMPModeler.sum((IloNumExpr)iloLinearNumExpr, (IloNumExpr)iloQuadNumExpr);
    }

    public void clear() throws IloException {
        this._lin.clear();
        this._quad.clear();
    }

    public void remove(CpxNumVar cpxNumVar) throws IloException {
        this._quad.remove(cpxNumVar);
        this._lin.remove(cpxNumVar);
    }

    final void removeDuplicates() throws IloException {
        this._lin.removeDuplicates();
        this._quad.removeDuplicates();
    }

    final void removeMarked() {
        this._lin.removeMarked();
        this._quad.removeMarked();
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        this._lin.removeVars(cplexIndex);
        this._quad.removeVars(cplexIndex);
    }

    final double getConst() {
        return this._lin.getConst();
    }

    final int getLinearNum() {
        return this._lin.getNum();
    }

    final double[] getLinearVals() {
        return this._lin.getValues();
    }

    final CpxNumVar[] getLinearVars() {
        return this._lin.getNumVars();
    }

    public final void addCoef(CpxNumVar cpxNumVar, double d) {
        this._lin.addCoef(cpxNumVar, d);
    }

    public final void addCoefs(CpxNumVar[] cpxNumVarArray, double[] dArray, int n, int n2) {
        this._lin.addCoefs(cpxNumVarArray, dArray, n, n2);
    }

    final int getQuadNum() {
        return this._quad.getNum();
    }

    final double[] getQuadVals() {
        return this._quad.getValues();
    }

    final CpxNumVar[] getQuadVar1() {
        return this._quad.getNumVar1();
    }

    final CpxNumVar[] getQuadVar2() {
        return this._quad.getNumVar2();
    }

    public String toString() {
        if (this.getQuadNum() > 0) {
            if (this.getLinearNum() > 0 || this.getConst() != 0.0) {
                return "(" + this._lin.toString() + " + " + this._quad.toString() + ")";
            }
            return this._quad.toString();
        }
        return this._lin.toString();
    }
}

