/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloNumVar;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxSubVar;
import ilog.cplex.TmpIndex;
import java.io.Serializable;
import java.util.NoSuchElementException;

public abstract class CpxQExpr
implements CpxNumExpr,
Serializable {
    private static final long serialVersionUID = 12080000L;
    int _num = 0;
    double[] _val = new double[8];
    CpxNumVar[] _var1 = new CpxNumVar[8];
    CpxNumVar[] _var2 = new CpxNumVar[8];

    public CpxQExpr() {
    }

    public CpxQExpr(double[] dArray, CpxNumVar[] cpxNumVarArray, CpxNumVar[] cpxNumVarArray2, int n, int n2) {
        this();
        this.addCoefs(cpxNumVarArray, cpxNumVarArray2, dArray, 0, n2);
    }

    public CpxQExpr(int[] nArray, CpxNumVar[] cpxNumVarArray, CpxNumVar[] cpxNumVarArray2, int n, int n2) {
        this();
        this.addCoefs(cpxNumVarArray, cpxNumVarArray2, nArray, 0, n2);
    }

    public abstract CpxQExpr makeCopy();

    @Override
    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        throw check;
    }

    @Override
    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        return null;
    }

    @Override
    public Object accept(CpxExprVisitor cpxExprVisitor) throws IloException {
        return cpxExprVisitor.visitQExpr(this);
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        int n = 0;
        for (int i = 0; i < this._num; ++i) {
            if (this._var1[i] instanceof CpxSubVar) {
                this._var1[i].removeVars(cplexIndex);
            }
            if (this._var2[i] instanceof CpxSubVar) {
                this._var2[i].removeVars(cplexIndex);
            }
            if (this._var1[i]._varIndex == cplexIndex || this._var2[i]._varIndex == cplexIndex) continue;
            if (n < i) {
                this._var1[n] = this._var1[i];
                this._var2[n] = this._var2[i];
                this._val[n] = this._val[i];
            }
            ++n;
        }
        for (int i = n; i < this._num; ++i) {
            this._var1[i] = null;
            this._var2[i] = null;
            this._val[i] = 0.0;
        }
        this._num = n;
    }

    public final int getNum() {
        return this._num;
    }

    public final double[] getValues() {
        return this._val;
    }

    public final CpxNumVar[] getNumVar1() {
        return this._var1;
    }

    public final CpxNumVar[] getNumVar2() {
        return this._var2;
    }

    void makeSpace(int n) {
        int n2 = this._val.length;
        if (this._num + n >= n2) {
            while (this._num + n >= n2) {
                n2 *= 2;
            }
            double[] dArray = new double[n2];
            CpxNumVar[] cpxNumVarArray = new CpxNumVar[n2];
            CpxNumVar[] cpxNumVarArray2 = new CpxNumVar[n2];
            System.arraycopy(this._val, 0, dArray, 0, this._num);
            System.arraycopy(this._var1, 0, cpxNumVarArray, 0, this._num);
            System.arraycopy(this._var2, 0, cpxNumVarArray2, 0, this._num);
            this._val = dArray;
            this._var1 = cpxNumVarArray;
            this._var2 = cpxNumVarArray2;
        }
    }

    public CpxQExpr copyTo(CpxQExpr cpxQExpr) {
        cpxQExpr._num = this._num;
        cpxQExpr._val = new double[this._val.length];
        cpxQExpr._var1 = new CpxNumVar[this._var1.length];
        cpxQExpr._var2 = new CpxNumVar[this._var2.length];
        System.arraycopy(this._val, 0, cpxQExpr._val, 0, this._num);
        System.arraycopy(this._var1, 0, cpxQExpr._var1, 0, this._num);
        System.arraycopy(this._var2, 0, cpxQExpr._var2, 0, this._num);
        return cpxQExpr;
    }

    final void add(CpxQExpr cpxQExpr) {
        this.addCoefs(cpxQExpr._var1, cpxQExpr._var2, cpxQExpr._val, 0, cpxQExpr._num);
    }

    void addCoef(CpxNumVar cpxNumVar, CpxNumVar cpxNumVar2, double d) {
        this.makeSpace(1);
        this._var1[this._num] = cpxNumVar;
        this._var2[this._num] = cpxNumVar2;
        this._val[this._num] = d;
        ++this._num;
    }

    void addCoefs(CpxNumVar[] cpxNumVarArray, CpxNumVar[] cpxNumVarArray2, double[] dArray, int n, int n2) {
        if (n2 > 0) {
            this.makeSpace(n2);
            System.arraycopy(cpxNumVarArray, n, this._var1, this._num, n2);
            System.arraycopy(cpxNumVarArray2, n, this._var2, this._num, n2);
            System.arraycopy(dArray, n, this._val, this._num, n2);
            this._num += n2;
        }
    }

    void addCoefs(CpxNumVar[] cpxNumVarArray, CpxNumVar[] cpxNumVarArray2, int[] nArray, int n, int n2) {
        if (n2 > 0) {
            this.makeSpace(n2);
            System.arraycopy(cpxNumVarArray, n, this._var1, this._num, n2);
            System.arraycopy(cpxNumVarArray2, n, this._var2, this._num, n2);
            for (int i = 0; i < n2; ++i) {
                this._val[this._num + i] = nArray[n + i];
            }
            this._num += n2;
        }
    }

    void addCoefs(CpxQExpr cpxQExpr) {
        this.addCoefs(cpxQExpr._var1, cpxQExpr._var2, cpxQExpr._val, 0, cpxQExpr._num);
    }

    void scaleBy(double d) {
        int n = 0;
        while (n < this._num) {
            int n2 = n++;
            this._val[n2] = this._val[n2] * d;
        }
    }

    final void remove(int n) {
        int n2 = --this._num;
        this._val[n] = this._val[n2];
        this._var1[n] = this._var1[n2];
        this._var2[n] = this._var2[n2];
        this._var1[n2] = null;
        this._var2[n2] = null;
    }

    final void removeMarked() {
        int n;
        int n2 = 0;
        for (n = 0; n < this._num; ++n) {
            if (this._var1[n].isMarked() || this._var2[n].isMarked()) continue;
            this._var1[n2] = this._var1[n];
            this._var2[n2] = this._var2[n];
            this._val[n2] = this._val[n];
            ++n2;
        }
        for (n = n2; n < this._num; ++n) {
            this._var1[n] = null;
            this._var2[n] = null;
        }
        this._num = n2;
    }

    public void remove(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int n3;
        int n4 = n + n2;
        for (n3 = n; n3 < n4; ++n3) {
            ((CpxNumVar)iloNumVarArray[n3]).mark(-1);
        }
        this.removeMarked();
        for (n3 = n; n3 < n4; ++n3) {
            ((CpxNumVar)iloNumVarArray[n3]).unmark();
        }
    }

    void remove(CpxNumVar cpxNumVar) throws IloException {
        int n;
        int n2 = 0;
        for (n = 0; n < this._num; ++n) {
            if (this._var1[n] == cpxNumVar || this._var2[n] == cpxNumVar) continue;
            this._val[n2] = this._val[n];
            this._var1[n2] = this._var1[n];
            this._var2[n2] = this._var2[n];
            ++n2;
        }
        for (n = n2; n < this._num; ++n) {
            this._var1[n] = null;
            this._var2[n] = null;
        }
        this._num = n2;
    }

    public void clear() throws IloException {
        for (int i = 0; i < this._num; ++i) {
            this._var1[i] = null;
            this._var2[i] = null;
        }
        this._num = 0;
    }

    static int sortQ(int n, double[] dArray, CpxNumVar[] cpxNumVarArray, CpxNumVar[] cpxNumVarArray2) throws IloException {
        int n2;
        int n3;
        if (n < 2) {
            return n;
        }
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = 0; j < n - i; ++j) {
                n2 = n3 + i;
                for (n3 = j; n3 >= 0 && (cpxNumVarArray[n3].getVarIndexValue() > cpxNumVarArray[n2].getVarIndexValue() || cpxNumVarArray[n3].getVarIndexValue() == cpxNumVarArray[n2].getVarIndexValue() && cpxNumVarArray2[n3].getVarIndexValue() > cpxNumVarArray2[n2].getVarIndexValue()); n3 -= i) {
                    double d = dArray[n3];
                    dArray[n3] = dArray[n2];
                    dArray[n2] = d;
                    CpxNumVar cpxNumVar = cpxNumVarArray[n3];
                    cpxNumVarArray[n3] = cpxNumVarArray[n2];
                    cpxNumVarArray[n2] = cpxNumVar;
                    cpxNumVar = cpxNumVarArray2[n3];
                    cpxNumVarArray2[n3] = cpxNumVarArray2[n2];
                    cpxNumVarArray2[n2] = cpxNumVar;
                    n2 = n3;
                }
            }
        }
        n2 = 0;
        for (n3 = 1; n3 < n; ++n3) {
            if (cpxNumVarArray2[n3].getVarIndexValue() != cpxNumVarArray2[n2].getVarIndexValue() || cpxNumVarArray[n3].getVarIndexValue() != cpxNumVarArray[n2].getVarIndexValue()) {
                dArray[++n2] = dArray[n3];
                cpxNumVarArray[n2] = cpxNumVarArray[n3];
                cpxNumVarArray2[n2] = cpxNumVarArray2[n3];
                continue;
            }
            int n4 = n2;
            dArray[n4] = dArray[n4] + dArray[n3];
        }
        return n2 + 1;
    }

    void removeDuplicates() throws IloException {
        int n;
        for (n = 0; n < this._num; ++n) {
            Serializable serializable;
            if (!(this._var1[n].getVarIndex() instanceof TmpIndex)) {
                serializable = new TmpIndex(n + 1);
                serializable.install(this._var1[n]);
            }
            if (!(this._var2[n].getVarIndex() instanceof TmpIndex)) {
                serializable = new TmpIndex(-n - 1);
                serializable.install(this._var2[n]);
            }
            if (this._var1[n].getVarIndexValue() >= this._var2[n].getVarIndexValue()) continue;
            serializable = this._var1[n];
            this._var1[n] = this._var2[n];
            this._var2[n] = serializable;
        }
        this._num = CpxQExpr.sortQ(this._num, this._val, this._var1, this._var2);
        for (n = 0; n < this._num; ++n) {
            if (this._var1[n].getVarIndex() instanceof TmpIndex) {
                ((TmpIndex)this._var1[n].getVarIndex()).uninstall(this._var1[n]);
            }
            if (!(this._var2[n].getVarIndex() instanceof TmpIndex)) continue;
            ((TmpIndex)this._var2[n].getVarIndex()).uninstall(this._var2[n]);
        }
    }

    public final int findCoef(CpxNumVar cpxNumVar, CpxNumVar cpxNumVar2, int n) {
        for (int i = n; i < this._num; ++i) {
            if (this._var1[i] != cpxNumVar || this._var2[i] != cpxNumVar2) continue;
            return i;
        }
        return -1;
    }

    public final void setCoef(int n, double d) {
        this._val[n] = d;
    }

    public final void setCoef(CpxNumVar cpxNumVar, CpxNumVar cpxNumVar2, double d) {
        int n = this.findCoef(cpxNumVar, cpxNumVar2, 0);
        if (n < 0) {
            if (d != 0.0) {
                this.addCoef(cpxNumVar, cpxNumVar2, d);
            }
        } else if (d == 0.0) {
            this.remove(n);
        } else {
            this._val[n] = d;
        }
    }

    public final int findSymmetricCoef(CpxNumVar cpxNumVar, CpxNumVar cpxNumVar2, int n) {
        for (int i = n; i < this._num; ++i) {
            if ((this._var1[i] != cpxNumVar || this._var2[i] != cpxNumVar2) && (this._var1[i] != cpxNumVar2 || this._var2[i] != cpxNumVar)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._num > 0) {
            stringBuffer.append("(");
            for (int i = 0; i < this._num; ++i) {
                double d = this._val[i];
                if (i == 0) {
                    stringBuffer.append(d);
                } else if (d < 0.0) {
                    stringBuffer.append(" - ");
                    stringBuffer.append(-d);
                } else {
                    stringBuffer.append(" + ");
                    stringBuffer.append(d);
                }
                stringBuffer.append("*");
                stringBuffer.append(this._var1[i]);
                stringBuffer.append("*");
                stringBuffer.append(this._var2[i]);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public static class QuadIterator {
        CpxQExpr _qe;
        int _i;

        public QuadIterator(CpxQExpr cpxQExpr) {
            this._qe = cpxQExpr;
            this._i = -1;
        }

        public double getCpxValue() throws IllegalStateException {
            if (this._qe != null && this._i >= 0 && this._i < this._qe._num) {
                return this._qe._val[this._i];
            }
            throw new NoSuchElementException();
        }

        public void setCpxValue(double d) throws IllegalStateException {
            if (this._qe == null || this._i < 0 || this._i >= this._qe._num) {
                throw new NoSuchElementException();
            }
            this._qe._val[this._i] = d;
        }

        public CpxNumVar getCpxVar1() throws NoSuchElementException {
            if (this._qe != null && this._i >= 0 && this._i < this._qe._num) {
                return this._qe._var1[this._i];
            }
            throw new NoSuchElementException();
        }

        public CpxNumVar getCpxVar2() throws NoSuchElementException {
            if (this._qe != null && this._i >= 0 && this._i < this._qe._num) {
                return this._qe._var2[this._i];
            }
            throw new NoSuchElementException();
        }

        public CpxNumVar nextCpxVar1() throws NoSuchElementException {
            ++this._i;
            return this.getCpxVar1();
        }

        public CpxNumVar nextCpxVar2() throws NoSuchElementException {
            ++this._i;
            return this.getCpxVar2();
        }

        public boolean hasNext() {
            return this._qe != null && this._i + 1 < this._qe._num;
        }

        public void remove() throws IllegalStateException {
            if (this._qe == null || this._i < 0 || this._i >= this._qe._num) {
                throw new IllegalStateException();
            }
            this._qe.remove(this._i--);
        }

        public boolean MoveNext() {
            ++this._i;
            return this._qe != null && this._i < this._qe._num;
        }

        public Object getCurrent() {
            if (this._qe != null && this._i >= 0 && this._i < this._qe._num) {
                return this._qe._var1[this._i];
            }
            return null;
        }

        public void Reset() {
            this._i = -1;
        }

        public void setNumVar1(IloNumVar iloNumVar) throws IllegalStateException {
            CpxNumVar cpxNumVar;
            if (this._qe == null || this._i < 0 || this._i >= this._qe._num) {
                throw new IllegalStateException();
            }
            this._qe._var1[this._i] = cpxNumVar = (CpxNumVar)iloNumVar;
        }

        public void setNumVar2(IloNumVar iloNumVar) throws IllegalStateException {
            CpxNumVar cpxNumVar;
            if (this._qe == null || this._i < 0 || this._i >= this._qe._num) {
                throw new IllegalStateException();
            }
            this._qe._var2[this._i] = cpxNumVar = (CpxNumVar)iloNumVar;
        }
    }
}

