/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloColumn;
import ilog.concert.IloColumnArray;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloMPModeler;
import ilog.concert.IloModeler;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloObjective;
import ilog.concert.IloObjectiveSense;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxQExpr;
import ilog.cplex.CpxQLExpr;
import ilog.cplex.CpxQLNumExpr;
import ilog.cplex.CpxQextractor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CpxObjective
extends CpxExtractable
implements IloObjective {
    private static final long serialVersionUID = 12080000L;
    IloObjectiveSense _sense;
    CpxQLExpr _expr;

    @Override
    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloModeler iloModeler = iloCopyManager.getModeler();
        if (iloModeler instanceof IloMPModeler) {
            IloLinearNumExpr iloLinearNumExpr = (IloLinearNumExpr)iloCopyManager.getCopy(this._expr._lin);
            CpxQExpr cpxQExpr = this._expr._quad.makeCopy();
            CpxObjective cpxObjective = (CpxObjective)iloModeler.objective(this._sense, iloLinearNumExpr, this.getName());
            cpxObjective._expr._quad = cpxQExpr;
            return cpxObjective;
        }
        return iloModeler.objective(this._sense, (IloNumExpr)iloCopyManager.getCopy(this.getExpr()), this.getName());
    }

    @Override
    void end() throws IloException {
        if (this.isInstalledExt()) {
            this.getCplexI().setObjective(this.getSense(), 0, null, null, 0, null, null, null, 0.0);
            this.setCplexI(null);
        }
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.isInstalledExt()) {
            this.getCplexI().setObjName(string);
        }
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        this._expr._lin.removeVars(cplexIndex);
        this._expr._quad.removeVars(cplexIndex);
    }

    @Override
    public IloObjectiveSense getSense() {
        return this._sense;
    }

    @Override
    public void setSense(IloObjectiveSense iloObjectiveSense) throws IloException {
        if (this.isInstalledExt()) {
            this.getCplexI().setSense(iloObjectiveSense.getValue());
        }
        this._sense = iloObjectiveSense;
    }

    @Override
    public IloNumExpr getExpr() throws IloException {
        return this._expr.makeCopy();
    }

    @Override
    public void setExpr(IloNumExpr iloNumExpr) throws IloException {
        CplexI cplexI = this.getCplexI();
        this.uninstallCon();
        this._expr.clear();
        if (iloNumExpr != null) {
            CpxQextractor cpxQextractor = new CpxQextractor(this);
            if (((CpxNumExpr)iloNumExpr).accept(cpxQextractor) == null) {
                throw new UnsupportedOperationException("CpxObjective for general expressions");
            }
            this._expr._lin.removeDuplicates();
            this._expr._quad.removeDuplicates();
        }
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    public void setLinearCoef(double d, IloNumVar iloNumVar) throws IloException {
        this.setLinearCoef(iloNumVar, d);
    }

    public void setLinearCoef(IloNumVar iloNumVar, double d) throws IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        int n = this._expr._lin.find(cpxNumVar);
        if (n < 0) {
            if (this.isInstalledExt()) {
                this.getCplexI().useVar(cpxNumVar, true);
            }
            n = this._expr._lin.getNum();
            if (d != 0.0) {
                this._expr._lin.addCoef(cpxNumVar, d);
            }
        } else if (d != 0.0) {
            this._expr._lin.setCoef(n, d);
        } else {
            this._expr._lin.remove(n);
        }
        if (this.isInstalledExt()) {
            this.getCplexI().setObjCoef(cpxNumVar.getVarIndex(), d);
        }
    }

    public void setQuadCoef(double d, CpxNumVar cpxNumVar, CpxNumVar cpxNumVar2) throws IloException {
        int n = this._expr._quad.findSymmetricCoef(cpxNumVar, cpxNumVar2, 0);
        if (n < 0) {
            if (d != 0.0) {
                this._expr._quad.addCoef(cpxNumVar, cpxNumVar2, d);
                if (this.isInstalledExt()) {
                    if (this._expr.getQuadNum() > 1) {
                        this.getCplexI().useVar(cpxNumVar, true);
                        if (cpxNumVar != cpxNumVar2) {
                            this.getCplexI().useVar(cpxNumVar2, true);
                        }
                        this.getCplexI().setObjQCoef(cpxNumVar.getVarIndex(), cpxNumVar2.getVarIndex(), d);
                    } else {
                        CplexI cplexI = this.getCplexI();
                        this.uninstallCon();
                        this.installCon(cplexI);
                    }
                }
            }
        } else if (d != 0.0) {
            this._expr._quad.setCoef(n, d);
            if (this.isInstalledExt()) {
                this.getCplexI().setObjQCoef(cpxNumVar.getVarIndex(), cpxNumVar2.getVarIndex(), d);
            }
        } else {
            this._expr._quad.remove(n);
            if (this.isInstalledExt()) {
                if (this._expr.getQuadNum() > 0) {
                    this.getCplexI().setObjQCoef(cpxNumVar.getVarIndex(), cpxNumVar2.getVarIndex(), 0.0);
                    this.getCplexI().unUseVar(cpxNumVar);
                    if (cpxNumVar != cpxNumVar2) {
                        this.getCplexI().unUseVar(cpxNumVar2);
                    }
                } else {
                    CplexI cplexI = this.getCplexI();
                    this.uninstallCon();
                    this.installCon(cplexI);
                }
            }
        }
    }

    public void setLinearCoefs(double[] dArray, IloNumVar[] iloNumVarArray) throws IloException {
        this.setLinearCoefs(iloNumVarArray, dArray, 0, iloNumVarArray.length);
    }

    public void setLinearCoefs(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this.setLinearCoefs(iloNumVarArray, dArray, 0, iloNumVarArray.length);
    }

    public void setLinearCoefs(double[] dArray, IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        this.setLinearCoefs(iloNumVarArray, dArray, n, n2);
    }

    public void setLinearCoefs(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2) throws IloException {
        int n3;
        CpxNumVar[] cpxNumVarArray;
        this._expr._lin.markVars();
        CplexIndex[] cplexIndexArray = new CplexIndex[n2 + n];
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            cpxNumVarArray = (CpxNumVar[])iloNumVarArray[i];
            if (cpxNumVarArray.isMarked()) {
                this._expr._lin.setCoef(cpxNumVarArray.getVarIndexValue(), dArray[i]);
                cplexIndexArray[i] = cpxNumVarArray.getOriginalIndex();
                continue;
            }
            if (this.isInstalledExt()) {
                this.getCplexI().useVar((CpxNumVar)cpxNumVarArray, true);
                cplexIndexArray[i] = cpxNumVarArray.getVarIndex();
            }
            cpxNumVarArray.mark(-1);
            this._expr._lin.addCoef((CpxNumVar)cpxNumVarArray, dArray[i]);
        }
        this._expr._lin.unmarkVars();
        if (this.isInstalledExt()) {
            this.getCplexI().setObjCoefs(cplexIndexArray, dArray, n, n2);
        }
        double[] dArray2 = this._expr._lin.getValues();
        cpxNumVarArray = this._expr._lin.getNumVars();
        int n5 = this._expr._lin.getNum();
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (dArray2[n3] == 0.0) continue;
            dArray2[n6] = dArray2[n3];
            cpxNumVarArray[n6] = cpxNumVarArray[n3];
            ++n6;
        }
        this._expr._lin._num = n6;
        for (n3 = n6; n3 < n5; ++n3) {
            cpxNumVarArray[n3] = null;
        }
    }

    public void addToExpr(IloNumExpr iloNumExpr) throws IloException {
        CplexI cplexI = this.getCplexI();
        this.uninstallCon();
        CpxQextractor cpxQextractor = new CpxQextractor(this);
        if (((CpxNumExpr)iloNumExpr).accept(cpxQextractor) == null) {
            throw new UnsupportedOperationException("CpxObjective for general expressions");
        }
        this._expr._lin.removeDuplicates();
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    @Override
    public void clearExpr() throws IloException {
        CplexI cplexI = this.getCplexI();
        this.uninstallCon();
        this._expr._lin.clear();
        this._expr._quad.clear();
        this._expr._lin._const = 0.0;
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    public IloColumn makeColumn(double d) throws IloException {
        return new ObjColumn(this, d);
    }

    public IloColumnArray makeColumnArray(double[] dArray, int n, int n2) throws IloException {
        return new ObjColumnArray(this, dArray, n, n2);
    }

    protected CpxObjective(IloObjectiveSense iloObjectiveSense, CpxNumExpr cpxNumExpr, String string) throws IloException {
        super(string);
        this._sense = iloObjectiveSense;
        this._expr = new CpxQLNumExpr();
        if (cpxNumExpr != null) {
            this.setExpr(cpxNumExpr);
        }
    }

    void deleteColumn(CpxNumVar cpxNumVar) throws IloException {
        this._expr.remove(cpxNumVar);
    }

    public void deleteColumns(CpxNumVar[] cpxNumVarArray, int n, int n2) throws IloException {
        int n3;
        int n4 = n + n2;
        for (n3 = n; n3 < n4; ++n3) {
            cpxNumVarArray[n3].mark(-1);
        }
        this._expr._lin.removeMarked();
        this._expr._quad.removeMarked();
        for (n3 = n; n3 < n4; ++n3) {
            cpxNumVarArray[n3].unmark();
        }
    }

    CpxNumVar[] getVars() throws IloException {
        int n = this._expr.getLinearNum();
        int n2 = this._expr.getQuadNum();
        CpxNumVar[] cpxNumVarArray = new CpxNumVar[n + 2 * n2];
        if (n > 0) {
            System.arraycopy(this._expr.getLinearVars(), 0, cpxNumVarArray, 0, n);
        }
        if (n2 > 0) {
            System.arraycopy(this._expr.getQuadVar1(), 0, cpxNumVarArray, n, n2);
            System.arraycopy(this._expr.getQuadVar2(), 0, cpxNumVarArray, n + n2, n2);
        }
        return cpxNumVarArray;
    }

    void addNewToExpr(CpxNumVar cpxNumVar, double d) throws IloException {
        this._expr._lin.addCoef(cpxNumVar, d);
        if (this.isInstalledExt()) {
            this.getCplexI().useVar(cpxNumVar, true);
            this.getCplexI().setObjCoef(cpxNumVar.getVarIndex(), d);
        }
    }

    void addNewToExpr(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        CpxNumVar[] cpxNumVarArray = new CpxNumVar[n3];
        for (int i = n; i < n3; ++i) {
            cpxNumVarArray[i] = (CpxNumVar)iloNumVarArray[i];
        }
        this._expr._lin.addCoefs(cpxNumVarArray, dArray, n, n2);
        if (this.isInstalledExt()) {
            this.getCplexI().useVars(cpxNumVarArray, n, n2, true);
            CplexIndex[] cplexIndexArray = new CplexIndex[n3];
            for (int i = n; i < n3; ++i) {
                cplexIndexArray[i] = cpxNumVarArray[i].getVarIndex();
            }
            this.getCplexI().setObjCoefs(cplexIndexArray, dArray, n, n2);
        }
    }

    @Override
    void installCon(CplexI cplexI) throws IloException {
        int n;
        cplexI.checkCplexI(this);
        if (this.isInstalledExt()) {
            return;
        }
        this.setCplexI(cplexI);
        CpxNumVar[] cpxNumVarArray = this.getVars();
        if (cpxNumVarArray != null) {
            cplexI.useVars(cpxNumVarArray, 0, cpxNumVarArray.length, true);
        }
        int n2 = this._expr._lin.getNum();
        CplexIndex[] cplexIndexArray = new CplexIndex[n2];
        CpxNumVar[] cpxNumVarArray2 = this._expr._lin.getNumVars();
        for (n = 0; n < n2; ++n) {
            cplexIndexArray[n] = cpxNumVarArray2[n].getVarIndex();
        }
        n = this._expr._quad.getNum();
        if (n > 0) {
            CpxNumVar[] cpxNumVarArray3 = this._expr._quad.getNumVar1();
            CpxNumVar[] cpxNumVarArray4 = this._expr._quad.getNumVar2();
            CplexIndex[] cplexIndexArray2 = new CplexIndex[n];
            CplexIndex[] cplexIndexArray3 = new CplexIndex[n];
            for (int i = 0; i < n; ++i) {
                cplexIndexArray2[i] = cpxNumVarArray3[i].getVarIndex();
                cplexIndexArray3[i] = cpxNumVarArray4[i].getVarIndex();
            }
            cplexI.setObjective(this.getSense(), n2, cplexIndexArray, this._expr.getLinearVals(), n, this._expr.getQuadVals(), cplexIndexArray2, cplexIndexArray3, this._expr._lin._const);
        } else {
            cplexI.setObjective(this.getSense(), n2, cplexIndexArray, this._expr._lin.getValues(), 0, null, null, null, this._expr._lin._const);
        }
    }

    @Override
    void uninstallCon() throws IloException {
        if (this.isInstalledExt()) {
            this.getCplexI().setObjective(this.getSense(), 0, null, null, 0, null, null, null, 0.0);
            CpxNumVar[] cpxNumVarArray = this.getVars();
            if (cpxNumVarArray != null) {
                this.getCplexI().unUseVars(cpxNumVarArray, 0, cpxNumVarArray.length);
            }
            this.setCplexI(null);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._sense == IloObjectiveSense.Minimize) {
            stringBuffer.append("IloMinimize ");
        } else {
            stringBuffer.append("IloMaximize ");
        }
        if (this.getName() != null) {
            stringBuffer.append(this.getName());
        }
        stringBuffer.append(" : ");
        stringBuffer.append(this._expr._lin);
        for (int i = 0; i < this._expr._quad._num; ++i) {
            stringBuffer.append(" ");
            double d = this._expr._quad._val[i];
            if (d < 0.0) {
                stringBuffer.append(d);
            } else {
                stringBuffer.append("+");
                stringBuffer.append(d);
            }
            stringBuffer.append("*");
            stringBuffer.append(this._expr._quad._var1[i]);
            stringBuffer.append("*");
            stringBuffer.append(this._expr._quad._var2[i]);
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this._sense == IloObjectiveSense.Minimize) {
            objectOutputStream.writeInt(1);
        } else {
            objectOutputStream.writeInt(-1);
        }
        objectOutputStream.writeObject(this._expr);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._sense = objectInputStream.readInt() > 0 ? IloObjectiveSense.Minimize : IloObjectiveSense.Maximize;
        this._expr = (CpxQLExpr)objectInputStream.readObject();
    }

    private class ObjColumnArray
    extends IloColumnArray {
        CpxObjective _obj;
        double[] _val;
        int _start;
        int _num;

        ObjColumnArray(CpxObjective cpxObjective2, double[] dArray, int n, int n2) throws IloException {
            this._obj = cpxObjective2;
            this._val = dArray;
            this._start = n;
            this._num = n2;
        }

        @Override
        public int getSize() {
            return this._num;
        }

        @Override
        public void install(IloNumVar[] iloNumVarArray) throws IloException {
            double[] dArray = new double[this._num];
            System.arraycopy(this._val, this._start, dArray, 0, this._num);
            this._obj.addNewToExpr(iloNumVarArray, dArray, 0, this._num);
        }
    }

    private class ObjColumn
    extends IloColumn {
        CpxObjective _obj;
        double _val;

        ObjColumn(CpxObjective cpxObjective2, double d) throws IloException {
            this._obj = cpxObjective2;
            this._val = d;
        }

        @Override
        public void install(IloNumVar iloNumVar) throws IloException {
            this._obj.addNewToExpr((CpxNumVar)iloNumVar, this._val);
        }
    }
}

