/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloColumn;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntVar;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxConversion;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.IloCplex;
import ilog.cplex.MultipleConversionException;
import ilog.cplex.TmpIndex;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class CpxNumVar
extends CpxExtractable
implements CpxNumExpr,
IloNumVar,
IloIntVar {
    private static final long serialVersionUID = 12080000L;
    double _lb;
    double _ub;
    byte _type;
    CplexIndex _varIndex;
    private IloNumVarType _conv;
    private static byte[] _TypeByte = new byte[]{67, 73, 66};

    @Override
    void end() throws IloException {
        if (this.getCplexI() != null && this._varIndex != null) {
            this.getCplexI().delColumn(this._varIndex);
            this._varIndex = null;
        }
        super.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        CplexIndex cplexIndex = this._varIndex;
        try {
            this._varIndex = null;
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this._varIndex = cplexIndex;
        }
    }

    @Override
    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        return iloCopyManager.getModeler().numVar(this.getLB(), this.getUB(), this.getType(), this.getName());
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        throw new UnsupportedOperationException("this should not happen");
    }

    @Override
    public Object accept(CpxExprVisitor cpxExprVisitor) throws IloException {
        return cpxExprVisitor.visitNumVar(this);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        if (this.isInstalledExt() && this._varIndex != null) {
            this.getCplexI().setColName(this._varIndex, string);
        }
    }

    @Override
    public double getLB() throws IloException {
        return this._lb;
    }

    @Override
    public int getMin() throws IloException {
        if (this._lb >= 0.0) {
            return (int)(this._lb + 1.0 - 1.0E-10);
        }
        if (this._lb > -2.147483647E9) {
            return (int)this._lb;
        }
        return -2147483647;
    }

    @Override
    public double getUB() throws IloException {
        return this._ub;
    }

    @Override
    public int getMax() throws IloException {
        if (this._ub < 0.0) {
            return (int)(this._ub - 1.0 + 1.0E-10);
        }
        if (this._ub < 2.147483647E9) {
            return (int)this._ub;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public IloNumVarType getType() throws IloException {
        if (this._type == 83 || this._type == 67) {
            return IloNumVarType.Float;
        }
        if (this._type == 78 || this._type == 73) {
            return IloNumVarType.Int;
        }
        return IloNumVarType.Bool;
    }

    @Override
    public void setLB(double d) throws IloException {
        this._lb = d <= -1.0E20 ? -1.0E20 : d;
        if (this.getCplexI() != null) {
            this.getCplexI().setLB(this._varIndex, this.getCpxLB());
        }
    }

    @Override
    public void setMin(int n) throws IloException {
        if (n <= -2147483647) {
            this.setLB(-1.0E20);
        } else {
            this.setLB(n);
        }
    }

    @Override
    public void setUB(double d) throws IloException {
        this._ub = d >= 1.0E20 ? 1.0E20 : d;
        if (this.getCplexI() != null) {
            this.getCplexI().setUB(this._varIndex, d);
        }
    }

    @Override
    public void setMax(int n) throws IloException {
        if (n >= Integer.MAX_VALUE) {
            this.setUB(1.0E20);
        } else {
            this.setUB(n);
        }
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (this._lb <= -1.0E20) {
            stringBuffer.append("-infinity");
        } else if (this._type == 67) {
            stringBuffer.append(this._lb);
        } else {
            stringBuffer.append((long)this._lb);
        }
        stringBuffer.append("..");
        if (this._ub >= 1.0E20) {
            stringBuffer.append("infinity");
        } else if (this._type == 67) {
            stringBuffer.append(this._ub);
        } else {
            stringBuffer.append((long)this._ub);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected CpxNumVar(double d, double d2, IloNumVarType iloNumVarType, String string) throws IloException {
        super(string);
        this._lb = d;
        this._ub = d2;
        this._type = CpxNumVar.getTypeByte(iloNumVarType);
    }

    protected CpxNumVar(IloColumn iloColumn, double d, double d2, IloNumVarType iloNumVarType, String string) throws IloException {
        this(d, d2, iloNumVarType, string);
        if (iloColumn != null) {
            iloColumn.install(this);
        }
    }

    protected CpxNumVar(IloColumn iloColumn, double d, double d2, byte by, String string) throws IloException {
        super(string);
        this._lb = d;
        this._ub = d2;
        this._type = by;
        if (iloColumn != null) {
            iloColumn.install(this);
        }
    }

    double getCpxLB() throws IloException {
        return this._lb;
    }

    double getCpxUB() throws IloException {
        return this._ub;
    }

    byte getCpxType() throws IloException {
        return this.getConvType();
    }

    static byte getTypeByte(IloNumVarType iloNumVarType) {
        return _TypeByte[iloNumVarType.getTypeValue()];
    }

    byte getTypeByte() {
        return this._type;
    }

    final byte getConvType() {
        if (this._conv != null) {
            return CpxNumVar.getTypeByte(this._conv);
        }
        return this.getTypeByte();
    }

    static void setConversions(CpxConversion cpxConversion, CpxNumVar[] cpxNumVarArray, IloNumVarType[] iloNumVarTypeArray) throws MultipleConversionException, IloException {
        if (cpxNumVarArray.length > 0) {
            double[] dArray = new double[cpxNumVarArray.length];
            byte[] byArray = new byte[cpxNumVarArray.length];
            CplexIndex[] cplexIndexArray = new CplexIndex[cpxNumVarArray.length];
            for (int i = 0; i < cpxNumVarArray.length; ++i) {
                if (iloNumVarTypeArray != null) {
                    if (cpxNumVarArray[i]._conv != null) {
                        throw new MultipleConversionException(cpxNumVarArray[i]);
                    }
                    cpxNumVarArray[i]._conv = iloNumVarTypeArray[i];
                    byArray[i] = CpxNumVar.getTypeByte(iloNumVarTypeArray[i]);
                    dArray[i] = cpxNumVarArray[i]._lb;
                } else {
                    cpxNumVarArray[i]._conv = null;
                    byArray[i] = cpxNumVarArray[i].getCpxType();
                    dArray[i] = cpxNumVarArray[i].getCpxLB();
                }
                cplexIndexArray[i] = cpxNumVarArray[i]._varIndex;
            }
            if (cpxConversion.getCplexI() != null) {
                cpxConversion.getCplexI().setTypes(cplexIndexArray, byArray);
                cpxConversion.getCplexI().setLBs(cplexIndexArray, dArray);
            }
        }
    }

    synchronized void setIndex(CplexIndex cplexIndex, CplexI cplexI) throws IloException {
        this._varIndex = cplexIndex;
        this.setCplexI(cplexI);
    }

    synchronized CplexIndex getVarIndex() {
        return this._varIndex;
    }

    synchronized int getVarIndexValue() throws IloException {
        if (this._varIndex == null) {
            throw new IloCplex.UnknownObjectException(this);
        }
        return this._varIndex._index;
    }

    synchronized CplexIndex getOriginalIndex() throws IloException {
        if (this._varIndex == null) {
            throw new IloCplex.UnknownObjectException(this);
        }
        return ((TmpIndex)this._varIndex)._orig;
    }

    synchronized int getModelIndex() throws IloException {
        if (this._varIndex == null) {
            throw new IloCplex.UnknownObjectException(this);
        }
        if (this._varIndex instanceof TmpIndex) {
            return ((TmpIndex)this._varIndex)._orig._index;
        }
        return this._varIndex._index;
    }

    synchronized boolean isMarked() {
        return this._varIndex instanceof TmpIndex;
    }

    synchronized void mark(int n) {
        TmpIndex tmpIndex = new TmpIndex(n);
        tmpIndex.install(this);
    }

    synchronized void unmark() {
        if (this._varIndex != null && this._varIndex instanceof TmpIndex) {
            ((TmpIndex)this._varIndex).uninstall(this);
        }
    }
}

