/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloConversion;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloMPModeler;
import ilog.concert.IloModeler;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxNumVar;

public class CpxConversion
extends CpxExtractable
implements IloConversion {
    private static final long serialVersionUID = 12080000L;
    CpxNumVar[] _var;
    IloNumVarType[] _type;

    private final void makeArrays(int n) {
        this._var = new CpxNumVar[n];
        this._type = new IloNumVarType[n];
    }

    protected CpxConversion(int n, CpxNumVar[] cpxNumVarArray, IloNumVarType[] iloNumVarTypeArray, String string) {
        super(string);
        this.makeArrays(n);
        System.arraycopy(iloNumVarTypeArray, 0, this._type, 0, n);
        System.arraycopy(cpxNumVarArray, 0, this._var, 0, n);
    }

    protected CpxConversion(int n, CpxNumVar[] cpxNumVarArray, IloNumVarType iloNumVarType, String string) {
        super(string);
        this.makeArrays(n);
        for (int i = 0; i < n; ++i) {
            this._type[i] = iloNumVarType;
        }
        System.arraycopy(cpxNumVarArray, 0, this._var, 0, n);
    }

    protected CpxConversion(CpxNumVar cpxNumVar, IloNumVarType iloNumVarType, String string) {
        super(string);
        this.makeArrays(1);
        this._var[0] = cpxNumVar;
        this._type[0] = iloNumVarType;
    }

    @Override
    public IloNumVarType getType(IloNumVar iloNumVar) {
        int n = this._var.length;
        for (int i = 0; i < n; ++i) {
            if (this._var[i] != iloNumVar) continue;
            return this._type[i];
        }
        return null;
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        CplexI cplexI = this.getCplexI();
        if (cplexI != null) {
            this.uninstallCon();
        }
        int n = this._var.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this._var[i]._varIndex == cplexIndex) continue;
            if (n2 < i) {
                this._var[n2] = this._var[i];
                this._type[n2] = this._type[i];
            }
            ++n2;
        }
        if (n2 < n) {
            CpxNumVar[] cpxNumVarArray = new CpxNumVar[n2];
            IloNumVarType[] iloNumVarTypeArray = new IloNumVarType[n2];
            System.arraycopy(cpxNumVarArray, 0, this._var, 0, n2);
            System.arraycopy(iloNumVarTypeArray, 0, this._type, 0, n2);
            this._var = cpxNumVarArray;
            this._type = iloNumVarTypeArray;
        }
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    @Override
    void installCon(CplexI cplexI) throws IloException {
        cplexI.checkCplexI(this);
        if (!this.isInstalledExt()) {
            this.setCplexI(cplexI);
            cplexI.useVars(this._var, 0, this._var.length, true);
            CpxNumVar.setConversions(this, this._var, this._type);
        }
    }

    @Override
    void uninstallCon() throws IloException {
        if (this.isInstalledExt()) {
            CpxNumVar.setConversions(this, this._var, null);
            this.getCplexI().unUseVars(this._var, 0, this._var.length);
            this.setCplexI(null);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IloConversion");
        if (this.getName() != null) {
            stringBuffer.append(" " + this.getName() + "[");
        } else {
            stringBuffer.append("_" + super.toString() + "[");
        }
        int n = this._var.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this._var[i]);
            stringBuffer.append(":");
            stringBuffer.append(this._type[i]);
            if (i >= n - 1) continue;
            stringBuffer.append(",\n               ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloModeler iloModeler = iloCopyManager.getModeler();
        if (iloModeler instanceof IloMPModeler) {
            return ((IloMPModeler)iloModeler).conversion((IloNumVar[])this._var, this._type, this.getName());
        }
        throw new UnsupportedOperationException();
    }
}

