/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.cplex.Cplex;
import ilog.cplex.CpxMIPCallback;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.EvalVisitor;
import ilog.cplex.IloCplex;

abstract class CpxControlCallback
extends CpxMIPCallback {
    int[] _userAction;

    final void setUserAction(int[] nArray) {
        this._userAction = nArray;
    }

    final void setUserAction(int n) {
        this._userAction[0] = n;
    }

    final int getUserAction() {
        return this._userAction[0];
    }

    @Override
    void abort() {
        this.setUserAction(1);
    }

    CpxControlCallback(IloCplex.Callback callback) {
        super(callback);
    }

    final long getNodeId() throws IloException {
        return this.getLongNodeInfo(220, 0L);
    }

    double getValue(CpxNumExpr cpxNumExpr) throws IloException {
        int n = this.getCplexI().getNcols();
        double[] dArray = new double[n];
        this.getX(dArray, 0, n - 1);
        EvalVisitor evalVisitor = new EvalVisitor(dArray);
        cpxNumExpr.accept(evalVisitor);
        return evalVisitor.getValue();
    }

    final long getNodeLP() throws IloException {
        this.CALL(Cplex.CPXgetcallbacknodelp(this.getEnv(), this.getCBdata(), this.getWherefrom(), this._ptrAux));
        return this._ptrAux[0];
    }

    final int getSOSInfo(int n) throws IloException {
        this.CALL(Cplex.CPXgetcallbacksosinfo(this._env, this._cbdata, this._wherefrom, 0, 0, n, this._intAux));
        return this._intAux[0];
    }

    final int getSOSInfo(int n, int n2) throws IloException {
        this.CALL(Cplex.CPXgetcallbacksosinfo(this._env, this._cbdata, this._wherefrom, n2, 0, n, this._intAux));
        return this._intAux[0];
    }

    final void getFeasibilities(int[] nArray, int n, int n2) throws IloException {
        this.CALL(Cplex.CPXgetcallbacknodeintfeas(this.getEnv(), this.getCBdata(), this.getWherefrom(), nArray, n, n2));
    }

    final void getX(double[] dArray, int n, int n2) throws IloException {
        this.CALL(Cplex.CPXgetcallbacknodex(this.getEnv(), this.getCBdata(), this.getWherefrom(), dArray, n, n2));
    }

    final void getSlacks(double[] dArray, double[] dArray2) throws IloException {
        int n = this.getNcols();
        double[] dArray3 = new double[n];
        this.CALL(Cplex.CPXgetcallbacknodex(this.getEnv(), this.getCBdata(), this.getWherefrom(), dArray3, 0, n - 1));
        if (dArray != null) {
            this.CALL(Cplex.CPXslackfromx(this.getCplexI().getEnv(), this.getCplexI().getLP(), dArray3, dArray));
        }
        if (dArray2 != null) {
            this.CALL(Cplex.CPXqconstrslackfromx(this.getCplexI().getEnv(), this.getCplexI().getLP(), dArray3, dArray2));
        }
    }

    final void getLBs(double[] dArray, int n, int n2) throws IloException {
        this.CALL(Cplex.CPXgetcallbacknodelb(this.getEnv(), this.getCBdata(), this.getWherefrom(), dArray, n, n2));
    }

    final void getUBs(double[] dArray, int n, int n2) throws IloException {
        this.CALL(Cplex.CPXgetcallbacknodeub(this.getEnv(), this.getCBdata(), this.getWherefrom(), dArray, n, n2));
    }

    final int getSOSFeasibility(int n) throws IloException {
        return this.getSOSInfo(242, n);
    }

    final int getFeasibility(int n) throws IloException {
        this.getFeasibilities(this._intAux, n, n);
        return this._intAux[0];
    }

    final void getFeasibilities(int[] nArray, int[] nArray2) throws IloException {
        int n;
        int n2 = nArray2[0];
        int n3 = nArray2[0];
        int n4 = nArray2.length;
        for (n = 1; n < n4; ++n) {
            if (nArray2[n] > n2) {
                n2 = nArray2[n];
                continue;
            }
            if (nArray2[n] >= n3) continue;
            n3 = nArray2[n];
        }
        int[] nArray3 = new int[n2 - n3 + 1];
        this.getFeasibilities(nArray3, n3, n2);
        for (n = 0; n < n4; ++n) {
            nArray[n] = nArray3[nArray2[n] - n3];
        }
    }

    final double getLB(int n) throws IloException {
        this.getLBs(this._doubleAux, n, n);
        return this._doubleAux[0];
    }

    final double getUB(int n) throws IloException {
        this.getUBs(this._doubleAux, n, n);
        return this._doubleAux[0];
    }

    final void getLBs(double[] dArray, int[] nArray) throws IloException {
        int n;
        int n2 = nArray[0];
        int n3 = nArray[0];
        int n4 = nArray.length;
        for (n = 1; n < n4; ++n) {
            if (nArray[n] > n2) {
                n2 = nArray[n];
                continue;
            }
            if (nArray[n] >= n3) continue;
            n3 = nArray[n];
        }
        double[] dArray2 = new double[n2 - n3 + 1];
        this.getLBs(dArray2, n3, n2);
        for (n = 0; n < n4; ++n) {
            dArray[n] = dArray2[nArray[n] - n3];
        }
    }

    final void getUBs(double[] dArray, int[] nArray) throws IloException {
        int n;
        int n2 = nArray[0];
        int n3 = nArray[0];
        int n4 = nArray.length;
        for (n = 1; n < n4; ++n) {
            if (nArray[n] > n2) {
                n2 = nArray[n];
                continue;
            }
            if (nArray[n] >= n3) continue;
            n3 = nArray[n];
        }
        double[] dArray2 = new double[n2 - n3 + 1];
        this.getUBs(dArray2, n3, n2);
        for (n = 0; n < n4; ++n) {
            dArray[n] = dArray2[nArray[n] - n3];
        }
    }

    final double getObjValue() throws IloException {
        this.CALL(Cplex.CPXgetcallbacknodeobjval(this.getEnv(), this.getCBdata(), this.getWherefrom(), this._doubleAux));
        return this._doubleAux[0];
    }

    final double getX(int n) throws IloException {
        this.getX(this._doubleAux, n, n);
        return this._doubleAux[0];
    }

    final void getX(double[] dArray) throws IloException {
        int n = this.getNcols();
        this.getX(dArray, 0, n - 1);
    }

    final void getX(double[] dArray, int[] nArray) throws IloException {
        int n;
        int n2 = nArray[0];
        int n3 = nArray[0];
        int n4 = nArray.length;
        for (n = 1; n < n4; ++n) {
            if (nArray[n] > n2) {
                n2 = nArray[n];
                continue;
            }
            if (nArray[n] >= n3) continue;
            n3 = nArray[n];
        }
        double[] dArray2 = new double[n2 - n3 + 1];
        this.getX(dArray2, n3, n2);
        for (n = 0; n < n4; ++n) {
            dArray[n] = dArray2[nArray[n] - n3];
        }
    }

    final double getDownPseudoCost(int n) throws IloException {
        this.CALL(Cplex.CPXgetcallbackpseudocosts(this.getEnv(), this.getCBdata(), this.getWherefrom(), null, this._doubleAux, n, n));
        return this._doubleAux[0];
    }

    final double getUpPseudoCost(int n) throws IloException {
        this.CALL(Cplex.CPXgetcallbackpseudocosts(this.getEnv(), this.getCBdata(), this.getWherefrom(), this._doubleAux, null, n, n));
        return this._doubleAux[0];
    }

    final Object getNodeData() throws IloException {
        return this.getObjectNodeInfo(210, 0L);
    }

    final Object setNodeData(Object object) throws IloException {
        Object[] objectArray = new Object[1];
        this.CALL(Cplex.CPXScallbacksetuserhandle(this.getEnv(), this.getCBdata(), this.getWherefrom(), object, objectArray));
        return objectArray[0];
    }
}

