/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloRange;
import ilog.cplex.CplexI;
import ilog.cplex.CpxCutCallback;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxRange;
import ilog.cplex.EvalVisitor;
import ilog.cplex.IloCplex;

final class CpxCallbackContext
extends IloCplex.Callback.Context {
    private IloCplex cpx;
    private CplexI.ContextPointer contextPtr;
    private long contextId;
    private Marker mark;
    private double[] candidateX = null;
    private double[] relaxationX = null;
    private double[] incumbentX = null;
    private static final byte[] E = new byte[]{69};
    private static final byte[] L = new byte[]{76};
    private static final byte[] G = new byte[]{71};
    private static final int[] rmatbeg = new int[]{0};

    public CpxCallbackContext(IloCplex iloCplex, long l, long l2, Marker marker) {
        this.cpx = iloCplex;
        this.contextPtr = new CplexI.ContextPointer(l);
        this.contextId = l2;
        this.mark = marker;
    }

    CplexI.ContextPointer getContextPointer() {
        return this.contextPtr;
    }

    private synchronized double[] getCandidateX() throws IloException {
        if (this.candidateX == null) {
            this.candidateX = this.cpx._cplexi.callbackGetCandidatePoint(this.contextPtr, 0, this.cpx._cplexi.getNcols() - 1);
        }
        return (double[])this.candidateX.clone();
    }

    private synchronized double[] getIncumbentX() throws IloException {
        if (this.incumbentX == null) {
            this.incumbentX = this.cpx._cplexi.callbackGetIncumbent(this.contextPtr, 0, this.cpx._cplexi.getNcols() - 1);
        }
        return (double[])this.incumbentX.clone();
    }

    private synchronized double[] getRelaxationPointX() throws IloException {
        if (this.relaxationX == null) {
            this.relaxationX = this.cpx._cplexi.callbackGetRelaxationPoint(this.contextPtr, 0, this.cpx._cplexi.getNcols() - 1);
        }
        return (double[])this.relaxationX.clone();
    }

    private static double evaluate(IloNumExpr iloNumExpr, double[] dArray) throws IloException {
        EvalVisitor evalVisitor = new EvalVisitor(dArray);
        ((CpxNumExpr)iloNumExpr).accept(evalVisitor);
        return evalVisitor.getValue();
    }

    @Override
    public long getId() {
        return this.contextId;
    }

    @Override
    public IloCplex getCplex() {
        return this.cpx;
    }

    @Override
    public void abort() throws IloException {
        this.cpx._cplexi.callbackAbort(this.contextPtr);
    }

    private static final int info2int(IloCplex.Callback.Context.Info info) {
        return info.cpxid;
    }

    @Override
    public int getIntInfo(IloCplex.Callback.Context.Info info) throws IloException {
        return this.cpx._cplexi.callbackGetIntInfo(this.contextPtr, CpxCallbackContext.info2int(info));
    }

    @Override
    public long getLongInfo(IloCplex.Callback.Context.Info info) throws IloException {
        return this.cpx._cplexi.callbackGetLongInfo(this.contextPtr, CpxCallbackContext.info2int(info));
    }

    @Override
    public double getDoubleInfo(IloCplex.Callback.Context.Info info) throws IloException {
        return this.cpx._cplexi.callbackGetDoubleInfo(this.contextPtr, CpxCallbackContext.info2int(info));
    }

    @Override
    public void postHeuristicSolution(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2, double d, IloCplex.Callback.Context.SolutionStrategy solutionStrategy) throws IloException {
        double[] dArray2;
        int n3 = solutionStrategy.cpxid;
        if (n == 0) {
            dArray2 = dArray;
        } else {
            dArray2 = new double[n2];
            System.arraycopy(dArray2, 0, dArray, n, n2);
        }
        this.cpx._cplexi.callbackPostHeuristicSolution(this.contextPtr, n2, IloCplex.var2ind(iloNumVarArray, n, n2), dArray2, d, n3);
    }

    @Override
    public boolean isCandidatePoint() throws IloException {
        return this.cpx._cplexi.callbackIsCandidatePoint(this.contextPtr);
    }

    @Override
    public double[] getCandidatePoint(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        if (n2 == 0) {
            return new double[0];
        }
        int[] nArray = IloCplex.var2ind(iloNumVarArray, n, n2);
        int[] nArray2 = this.getVarRange(nArray);
        return this.mapVarRange(nArray, this.cpx._cplexi.callbackGetCandidatePoint(this.contextPtr, nArray2[0], nArray2[1]), nArray2[0]);
    }

    @Override
    public boolean isCandidateRay() throws IloException {
        return this.cpx._cplexi.callbackIsCandidateRay(this.contextPtr);
    }

    @Override
    public IloLinearNumExpr getCandidateRay() throws IloException {
        int n = this.cpx._cplexi.getNcols();
        return this.cpx._cplexi.makeRay(this.cpx._cplexi.callbackGetCandidateRay(this.contextPtr, 0, n - 1));
    }

    @Override
    public double getCandidateValue(IloNumExpr iloNumExpr) throws IloException {
        return CpxCallbackContext.evaluate(iloNumExpr, this.getCandidateX());
    }

    @Override
    public double getCandidateObjective() throws IloException {
        return this.cpx._cplexi.callbackGetCandidateObjective(this.contextPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rejectCandidate(IloRange[] iloRangeArray) throws IloException {
        if (iloRangeArray == null || iloRangeArray.length == 0) {
            this.cpx._cplexi.callbackRejectCandidate(this.contextPtr, 0, 0, null, null, null, null, null);
        } else {
            int[][] nArrayArray = new int[1][];
            double[][] dArrayArray = new double[1][];
            for (IloRange iloRange : iloRangeArray) {
                double d = iloRange.getLB();
                double d2 = iloRange.getUB();
                Marker marker = this.mark;
                synchronized (marker) {
                    int n = CpxCutCallback.cut2lin((CpxRange)iloRange, this.mark.get(), nArrayArray, dArrayArray);
                }
                if (d == d2) {
                    this.cpx._cplexi.callbackRejectCandidate(this.contextPtr, 1, nArrayArray[0].length, new double[]{d}, E, rmatbeg, nArrayArray[0], dArrayArray[0]);
                    continue;
                }
                if (d2 < 1.0E20) {
                    this.cpx._cplexi.callbackRejectCandidate(this.contextPtr, 1, nArrayArray[0].length, new double[]{d2}, L, rmatbeg, nArrayArray[0], dArrayArray[0]);
                }
                if (!(d > -1.0E20)) continue;
                this.cpx._cplexi.callbackRejectCandidate(this.contextPtr, 1, nArrayArray[0].length, new double[]{d}, G, rmatbeg, nArrayArray[0], dArrayArray[0]);
            }
        }
    }

    @Override
    public double[] getRelaxationPoint(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        if (n2 == 0) {
            return new double[0];
        }
        int[] nArray = IloCplex.var2ind(iloNumVarArray, n, n2);
        int[] nArray2 = this.getVarRange(nArray);
        return this.mapVarRange(nArray, this.cpx._cplexi.callbackGetRelaxationPoint(this.contextPtr, nArray2[0], nArray2[1]), nArray2[0]);
    }

    @Override
    public double getRelaxationValue(IloNumExpr iloNumExpr) throws IloException {
        return CpxCallbackContext.evaluate(iloNumExpr, this.getRelaxationPointX());
    }

    @Override
    public double getRelaxationObjective() throws IloException {
        return this.cpx._cplexi.callbackGetRelaxationObjective(this.contextPtr);
    }

    @Override
    public double[] getIncumbent(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        if (n2 == 0) {
            return new double[0];
        }
        int[] nArray = IloCplex.var2ind(iloNumVarArray, n, n2);
        int[] nArray2 = this.getVarRange(nArray);
        return this.mapVarRange(nArray, this.cpx._cplexi.callbackGetIncumbent(this.contextPtr, nArray2[0], nArray2[1]), nArray2[0]);
    }

    @Override
    public double getIncumbentValue(IloNumExpr iloNumExpr) throws IloException {
        return CpxCallbackContext.evaluate(iloNumExpr, this.getIncumbentX());
    }

    @Override
    public double getIncumbentObjective() throws IloException {
        return this.cpx._cplexi.callbackGetIncumbentObjective(this.contextPtr);
    }

    @Override
    public double[] getLocalLB(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        if (n2 == 0) {
            return new double[0];
        }
        int[] nArray = IloCplex.var2ind(iloNumVarArray, n, n2);
        int[] nArray2 = this.getVarRange(nArray);
        return this.mapVarRange(nArray, this.cpx._cplexi.callbackGetLocalLB(this.contextPtr, nArray2[0], nArray2[1]), nArray2[0]);
    }

    @Override
    public double[] getLocalUB(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        if (n2 == 0) {
            return new double[0];
        }
        int[] nArray = IloCplex.var2ind(iloNumVarArray, n, n2);
        int[] nArray2 = this.getVarRange(nArray);
        return this.mapVarRange(nArray, this.cpx._cplexi.callbackGetLocalUB(this.contextPtr, nArray2[0], nArray2[1]), nArray2[0]);
    }

    @Override
    public double[] getGlobalLB(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        if (n2 == 0) {
            return new double[0];
        }
        int[] nArray = IloCplex.var2ind(iloNumVarArray, n, n2);
        int[] nArray2 = this.getVarRange(nArray);
        return this.mapVarRange(nArray, this.cpx._cplexi.callbackGetGlobalLB(this.contextPtr, nArray2[0], nArray2[1]), nArray2[0]);
    }

    @Override
    public double[] getGlobalUB(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        if (n2 == 0) {
            return new double[0];
        }
        int[] nArray = IloCplex.var2ind(iloNumVarArray, n, n2);
        int[] nArray2 = this.getVarRange(nArray);
        return this.mapVarRange(nArray, this.cpx._cplexi.callbackGetGlobalUB(this.contextPtr, nArray2[0], nArray2[1]), nArray2[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUserCuts(IloRange[] iloRangeArray, int[] nArray, boolean[] blArray) throws IloException {
        if (iloRangeArray == null) {
            return;
        }
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[][] nArrayArray = new int[1][];
        double[][] dArrayArray = new double[1][];
        for (int i = 0; i < iloRangeArray.length; ++i) {
            IloRange iloRange = iloRangeArray[i];
            double d = iloRange.getLB();
            double d2 = iloRange.getUB();
            int n = nArray2[0] = nArray != null ? nArray[i] : 0;
            nArray3[0] = blArray != null ? (blArray[i] ? 1 : 0) : 0;
            Marker marker = this.mark;
            synchronized (marker) {
                int n2 = CpxCutCallback.cut2lin((CpxRange)iloRange, this.mark.get(), nArrayArray, dArrayArray);
            }
            if (d == d2) {
                this.cpx._cplexi.callbackAddUserCuts(this.contextPtr, 1, nArrayArray[0].length, new double[]{d}, E, rmatbeg, nArrayArray[0], dArrayArray[0], nArray2, nArray3);
                continue;
            }
            if (d2 < 1.0E20) {
                this.cpx._cplexi.callbackAddUserCuts(this.contextPtr, 1, nArrayArray[0].length, new double[]{d2}, L, rmatbeg, nArrayArray[0], dArrayArray[0], nArray2, nArray3);
            }
            if (!(d > -1.0E20)) continue;
            this.cpx._cplexi.callbackAddUserCuts(this.contextPtr, 1, nArrayArray[0].length, new double[]{d}, G, rmatbeg, nArrayArray[0], dArrayArray[0], nArray2, nArray3);
        }
    }

    private int[] getVarRange(int[] nArray) {
        if (nArray.length == 0) {
            return new int[]{0, -1};
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (int n3 : nArray) {
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return new int[]{n, n2};
    }

    private double[] mapVarRange(int[] nArray, double[] dArray, int n) {
        double[] dArray2 = new double[nArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[nArray[i] - n];
        }
        return dArray2;
    }

    public static final class Marker {
        private int n = -1;
        private int[] mark = null;

        void set(int n) {
            if (n < 0) {
                this.mark = null;
            }
            this.n = n;
        }

        int[] get() {
            if (this.mark == null || this.mark.length != this.n) {
                this.mark = new int[this.n];
            }
            return this.mark;
        }
    }
}

