﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="tabstrip_animation.aspx.cs" Inherits="FineUIPro.Examples.mobile.tabstrip.tabstrip_animation" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" AutoSizePanelID="TabStrip1" runat="server" />
        <f:TabStrip ID="TabStrip1" ShowBorder="false" runat="server" ActiveTabIndex="0" ShowTabHeader="false">
            <Toolbars>
                <f:Toolbar runat="server" HeaderStyle="true" Layout="HBox" BoxConfigChildMargin="0 5 0 0">
                    <Items>
                        <f:ButtonGroup ID="ButtonGroup1" EnablePressGroup="true" BoxFlex="1" Layout="HBox" runat="server">
                            <Items>
                                <f:Button ID="Button1" runat="server" Text="标签一" BoxFlex="1" EnablePress="true" Pressed="true" EnablePostBack="false">
                                </f:Button>
                                <f:Button ID="Button2" runat="server" Text="标签二" BoxFlex="1" EnablePress="true" EnablePostBack="false">
                                </f:Button>
                                <f:Button ID="Button3" runat="server" Text="标签三" BoxFlex="1" EnablePress="true" EnablePostBack="false">
                                </f:Button>
                            </Items>
                            <Listeners>
                                <f:Listener Event="presschange" Handler="onButtonGroupPressChange" />
                            </Listeners>
                        </f:ButtonGroup>
                        <f:Button ID="Button4" runat="server" Margin="0" IconFont="_List" EnablePostBack="false" ShowMenuIcon="false">
                            <Menu runat="server">
                                <Items>
                                    <f:MenuCheckBox ID="cbxNone" Text="无动画" AttributeDataTag="none" GroupName="Animation" runat="server">
                                    </f:MenuCheckBox>
                                    <f:MenuCheckBox ID="cbxSlide" Text="水平滑动" AttributeDataTag="slideX" Checked="true" GroupName="Animation" runat="server">
                                    </f:MenuCheckBox>
                                    <f:MenuCheckBox ID="MenuCheckBox1" Text="垂直滑动" AttributeDataTag="slideY" GroupName="Animation" runat="server">
                                    </f:MenuCheckBox>
                                    <f:MenuCheckBox ID="cbxFade" Text="淡出" AttributeDataTag="fade" GroupName="Animation" runat="server">
                                    </f:MenuCheckBox>
                                    <f:MenuCheckBox ID="cbxPop" Text="弹出" AttributeDataTag="pop" GroupName="Animation" runat="server">
                                    </f:MenuCheckBox>
                                    <f:MenuCheckBox ID="cbxFlip" Text="翻转" AttributeDataTag="flip" GroupName="Animation" runat="server">
                                    </f:MenuCheckBox>
                                </Items>
                                <Listeners>
                                    <f:Listener Event="checkchange" Handler="onAnimationCheckChange" />
                                </Listeners>
                            </Menu>
                        </f:Button>
                    </Items>
                </f:Toolbar>
            </Toolbars>
            <Tabs>
                <f:Tab ID="Tab1" BodyPadding="10px" Layout="VBox" BoxConfigChildMargin="0 0 10 0" runat="server">
                    <Items>
                        <f:ContentPanel ID="ContentPanel3" runat="server" ShowBorder="false" ShowHeader="false">
                            <p>
                                <a href="http://baike.baidu.com/view/1299586.htm" target="_blank"><b>马克·扎克伯格</b></a>
                            </p>
                            <p>
                                马克·艾略特·扎克伯格（Mark Elliot Zuckerberg），美国社交网站Facebook的创办人，被人们冠以“第二盖茨”的美誉。哈佛大学计算机和心理学专业辍学生。据《福布斯》杂志保守估计，马克·扎克伯格拥有135亿美元身家，是2008年全球最年轻的巨富，也是历来全球最年轻的自行创业亿万富豪。
                            </p>
                            <p>
                                2014年2月10日，马克·扎克伯格及其华裔妻子普莉希拉·陈登上美国《慈善纪事报》2013年年度慈善排行榜榜首。
                            </p>
                        </f:ContentPanel>
                        <f:Button ID="Button5" Text="按钮一" runat="server" EnablePostBack="false" />
                    </Items>
                </f:Tab>
                <f:Tab ID="Tab2" BodyPadding="10px" runat="server" Layout="VBox" BoxConfigChildMargin="0 0 10 0">
                    <Items>
                        <f:ContentPanel ID="ContentPanel2" runat="server" ShowBorder="false" ShowHeader="false">
                            <p>
                                <a href="http://baike.baidu.com/view/3645.htm" target="_blank"><b>比尔·盖茨</b></a>
                            </p>
                            <p>
                                比尔·盖茨（Bill Gates），全名威廉·亨利·盖茨三世，简称比尔或盖茨。1955年10月28日出生于美国华盛顿州西雅图，13岁开始计算机编程设计，18岁考入哈佛大学，一年后从哈佛退学，1975年与好友保罗·艾伦一起创办了微软公司，比尔盖茨担任微软公司董事长、CEO和首席软件设计师。
                            </p>
                            <p>
                                比尔·盖茨1995-2007年连续13年成为《福布斯》全球富翁榜首富，连续20年成为《福布斯》美国富翁榜首富。
                            </p>
                        </f:ContentPanel>
                        <f:Button ID="Button6" Text="按钮二" runat="server" EnablePostBack="false" />
                    </Items>
                </f:Tab>
                <f:Tab ID="Tab3" BodyPadding="10px" runat="server" Layout="VBox" BoxConfigChildMargin="0 0 10 0">
                    <Items>
                        <f:ContentPanel ID="ContentPanel1" runat="server" ShowBorder="false" ShowHeader="false">
                            <p>
                                <a href="http://tech.163.com/special/jobsdead/" target="_blank"><b>乔布斯</b></a>
                            </p>
                            <p>
                                乔布斯于1955年2月24日出生，苹果创始人之一。今年8月苹果超越埃克森美孚成为全球最大市值企业，截止上季度持有现金达到762亿美金，甚至超过了美国政府国库存款。 
                            </p>
                            <p>
                                遗憾的是，苹果的取得巨大成功还是无法给乔布斯一个健康的身体，乔布斯2003年被发现患有胰脏癌，随后又查出肝癌，危在旦夕的乔布斯在经历了8年的抗癌斗争、3次病休、若干次手术后，于2011年8月25日正式宣布从CEO位置辞职。2011年10月6日，乔布斯在苹果发布iPhone 4S后的第二天与世长辞。
                            </p>
                        </f:ContentPanel>
                        <f:Button ID="Button7" Text="按钮三" runat="server" EnablePostBack="false" />
                    </Items>
                </f:Tab>
            </Tabs>
        </f:TabStrip>

    </form>
    <script>

        var tabStrip1 = '<%= TabStrip1.ClientID %>';


        function onButtonGroupPressChange(event, btn) {
            var btnIndex = btn.el.index('.f-btn');

            // 激活相应的选项卡
            F(tabStrip1).getItem(btnIndex).active();
        }



        // 更改选项卡的动画类型
        function onAnimationCheckChange(event, menucheckbox, checked) {
            var tabstrip = F(tabStrip1);
            var animationType = menucheckbox.getAttr('data-tag');

            if (animationType === 'none') {
                tabstrip.enableAnimation = false;
            } else {
                tabstrip.enableAnimation = true;
                tabstrip.animationType = animationType;
            }
        }

    </script>
</body>
</html>
