﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="main.aspx.cs" Inherits="FineUIPro.Examples.mobile.main" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <style>
        .mywindow,
        .mywindow > .f-panel-bodyct > .f-panel-body {
            background-image: none;
            background-color: transparent;
            -moz-box-shadow: none;
            -webkit-box-shadow: none;
            box-shadow: none;
        }

        #themecontainer {
            background: none;
            background-color: #000;
            padding-top: 5px;
        }

            #themecontainer ul {
                list-style-type: none;
                margin: 10px 0 0;
                padding: 0;
            }

                #themecontainer ul li {
                    display: inline-block;
                    margin: 0 0 10px 10px;
                    padding: 0;
                }

                    #themecontainer ul li .title {
                        text-align: center;
                        color: #666;
                        font-size: 12px;
                        display: none;
                    }

                    #themecontainer ul li.hover,
                    #themecontainer ul li.active {
                        border-bottom-color: #fff;
                    }

                        #themecontainer ul li.hover .title,
                        #themecontainer ul li.active .title {
                            color: #fff;
                            font-weight: bold;
                        }

                    #themecontainer ul li img {
                        width: 50px;
                    }

            #themecontainer .grouptitle {
                color: #ccc;
                font-size: 16px;
                border-bottom: solid 1px #333;
                padding: 5px;
                margin: 10px;
                margin-top: 0;
            }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Panel ID="Panel1" CssClass="mypanel" IsViewPort="true" AutoScroll="true"
            ShowBorder="false" ShowHeader="false" runat="server">
            <Toolbars>
                <f:Toolbar ID="Toolbar1" Title="FineUIPro 移动示例" runat="server" ToolbarAlign="Right" HeaderStyle="true">
                    <Items>
                        <f:Button ID="Button1" runat="server" Size="Small" EnablePostBack="false"
                            IconFont="_MoreVertical" ShowMenuIcon="false" EnableDefaultState="false">
                            <Menu runat="server">
                                <f:MenuButton runat="server" EnablePostBack="false" Text="主题仓库">
                                    <Listeners>
                                        <f:Listener Event="click" Handler="onThemeSelectClick" />
                                    </Listeners>
                                </f:MenuButton>
                                <f:MenuSeparator runat="server"></f:MenuSeparator>
                                <f:MenuButton EnablePostBack="false" runat="server" Text="示例首页"
                                    OnClientClick="top.window.location.href='../';">
                                </f:MenuButton>
                            </Menu>
                        </f:Button>
                    </Items>
                </f:Toolbar>
            </Toolbars>
            <Items>
                <f:DataList runat="server" ID="DataList1" CssClass="mydatalist">
                </f:DataList>
            </Items>
        </f:Panel>
        <f:Panel ID="Panel2" CssClass="mypanel" runat="server" ShowHeader="false" ShowBorder="false" Hidden="true"
            IsViewPort="true" AutoScroll="true">
            <Toolbars>
                <f:Toolbar ID="Toolbar2" runat="server" HeaderStyle="true">
                    <Items>
                        <f:Button ID="Button4" runat="server" Size="Small" Text="后退" EnablePostBack="false">
                            <Listeners>
                                <f:Listener Event="click" Handler="onBacktoPanel1Click" />
                            </Listeners>
                        </f:Button>
                    </Items>
                </f:Toolbar>
            </Toolbars>
            <Items>
                <f:DataList runat="server" ID="DataList2" CssClass="mydatalist">
                </f:DataList>
            </Items>
        </f:Panel>
        <f:Panel ID="Panel3" CssClass="mypanel" runat="server" ShowHeader="false" ShowBorder="false" Hidden="true"
            IsViewPort="true" AutoScroll="true">
            <Toolbars>
                <f:Toolbar ID="Toolbar3" runat="server" HeaderStyle="true">
                    <Items>
                        <f:Button ID="Button2" runat="server" Size="Small" Text="后退" EnablePostBack="false">
                            <Listeners>
                                <f:Listener Event="click" Handler="onBacktoPanel2Click" />
                            </Listeners>
                        </f:Button>
                    </Items>
                </f:Toolbar>
            </Toolbars>
            <Items>
                <f:DataList runat="server" ID="DataList3">
                </f:DataList>
            </Items>
        </f:Panel>
        <f:Window runat="server" ID="Window1" CssClass="mywindow" ShowHeader="false" ShowBorder="false" Hidden="true" HideOnMaskClick="true"
            IsModal="true" BodyPadding="10px" Layout="VBox" PercentWidth="100%" EnableDefaultCorner="false" PositionY="Bottom">
            <Items>
                <f:ContentPanel ID="ContentPanel1" CssClass="f-corner-all" Height="340px" AutoScroll="true" ShowHeader="false" runat="server">
                    <div id="themecontainer">
                        <div class="grouptitle">
                            Metro
                        </div>
                        <ul>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/default.png" alt="Default" data-value="default" /></a>
                                <div class="title">Default</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/metro_blue.png" alt="Metro Blue" data-value="metro_blue" /></a>
                                <div class="title">Metro Blue</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/metro_dark_blue.png" alt="Metro Dark Blue" data-value="metro_dark_blue" /></a>
                                <div class="title">Metro Dark Blue</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/metro_gray.png" alt="Metro Gray" data-value="metro_gray" /></a>
                                <div class="title">Metro Gray</div>
                            </li>
                            <li class="">
                                <a href="javascript:;">
                                    <img src="../res/images/themes/metro_green.png" alt="Metro Green" data-value="metro_green" /></a>
                                <div class="title">Metro Green</div>
                            </li>
                            <li class="">
                                <a href="javascript:;">
                                    <img src="../res/images/themes/metro_orange.png" alt="Metro Orange" data-value="metro_orange" /></a>
                                <div class="title">Metro Orange</div>
                            </li>
                        </ul>
                        <div class="grouptitle">
                            jQuery UI
                        </div>
                        <ul>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/black_tie.png" alt="Black Tie" data-value="black_tie" /></a>
                                <div class="title">Black Tie</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/blitzer.png" alt="Blitzer" data-value="blitzer" /></a>
                                <div class="title">Blitzer</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/cupertino.png" alt="Cupertino" data-value="cupertino" /></a>
                                <div class="title">Cupertino</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/dark_hive.png" alt="Dark Hive" data-value="dark_hive" /></a>
                                <div class="title">Dark Hive</div>
                            </li>
                            <li class="">
                                <a href="javascript:;">
                                    <img src="../res/images/themes/dot_luv.png" alt="Dot Luv" data-value="dot_luv" /></a>
                                <div class="title">Dot Luv</div>
                            </li>
                            <li class="">
                                <a href="javascript:;">
                                    <img src="../res/images/themes/eggplant.png" alt="Eggplant" data-value="eggplant" /></a>
                                <div class="title">Eggplant</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/excite_bike.png" alt="Excite Bike" data-value="excite_bike" /></a>
                                <div class="title">Excite Bike</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/flick.png" alt="Flick" data-value="flick" /></a>
                                <div class="title">Flick</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/hot_sneaks.png" alt="Hot Sneaks" data-value="hot_sneaks" /></a>
                                <div class="title">Hot Sneaks</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/humanity.png" alt="Humanity" data-value="humanity" /></a>
                                <div class="title">Humanity</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/le_frog.png" alt="Le Frog" data-value="le_frog" /></a>
                                <div class="title">Le Frog</div>
                            </li>
                            <li class="">
                                <a href="javascript:;">
                                    <img src="../res/images/themes/mint_choc.png" alt="Mint Choc" data-value="mint_choc" /></a>
                                <div class="title">Mint Choc</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/overcast.png" alt="Overcast" data-value="overcast" /></a>
                                <div class="title">Overcast</div>
                            </li>
                            <li class="">
                                <a href="javascript:;">
                                    <img src="../res/images/themes/pepper_grinder.png" alt="Pepper Grinder" data-value="pepper_grinder" /></a>
                                <div class="title">Pepper Grinder</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/redmond.png" alt="Redmond" data-value="redmond" /></a>
                                <div class="title">Redmond</div>
                            </li>
                            <li class="">
                                <a href="javascript:;">
                                    <img src="../res/images/themes/smoothness.png" alt="Smoothness" data-value="smoothness" /></a>
                                <div class="title">Smoothness</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/south_street.png" alt="South Street" data-value="south_street" /></a>
                                <div class="title">South Street</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/start.png" alt="Start" data-value="start" /></a>
                                <div class="title">Start</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/sunny.png" alt="Sunny" data-value="sunny" /></a>
                                <div class="title">Sunny</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/swanky_purse.png" alt="Swanky Purse" data-value="swanky_purse" /></a>
                                <div class="title">Swanky Purse</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/trontastic.png" alt="Trontastic" data-value="trontastic" /></a>
                                <div class="title">Trontastic</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/ui_darkness.png" alt="UI Darkness" data-value="ui_darkness" /></a>
                                <div class="title">UI Darkness</div>
                            </li>
                            <li class="">
                                <a href="javascript:;">
                                    <img src="../res/images/themes/ui_lightness.png" alt="UI Lightness" data-value="ui_lightness" /></a>
                                <div class="title">UI Lightness</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/vader.png" alt="Vader" data-value="vader" /></a>
                                <div class="title">Vader</div>
                            </li>
                        </ul>
                        <div class="grouptitle">
                            Custom
                        </div>
                        <ul>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/custom_default.png" alt="Custom Default" data-value="custom_default" /></a>
                                <div class="title">Custom Default</div>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <img src="../res/images/themes/bootstrap_pure.png" alt="Bootstrap Pure" data-value="bootstrap_pure" /></a>
                                <div class="title">Bootstrap Pure</div>
                            </li>
                        </ul>
                    </div>
                </f:ContentPanel>
            </Items>
        </f:Window>
        <asp:XmlDataSource ID="XmlDataSource1" runat="server" EnableCaching="false" DataFile="~/res/menu.xml"></asp:XmlDataSource>
    </form>
    <script>

        var panel1ClientID = '<%= Panel1.ClientID %>';
        var dataList1ClientID = '<%= DataList1.ClientID %>';

        var panel2ClientID = '<%= Panel2.ClientID %>';
        var dataList2ClientID = '<%= DataList2.ClientID %>';
        var toolbar2ClientID = '<%= Toolbar2.ClientID %>';

        var panel3ClientID = '<%= Panel3.ClientID %>';
        var dataList3ClientID = '<%= DataList3.ClientID %>';
        var toolbar3ClientID = '<%= Toolbar3.ClientID %>';

        var window1ClientID = '<%= Window1.ClientID %>';



        // 从二级菜单返回
        function onBacktoPanel1Click() {
            // 改变网址的HASH值（hashchange驱动页面变化）
            window.location.hash = '';

            // 仅在桌面版Chrome出现的问题：改变当前页的哈希值为空时，父页面的滚动条会改变
            if (F.isChrome()) {
                parent && parent.$('body').scrollTop(0);
            }
        }

        // 从三级菜单返回
        function onBacktoPanel2Click() {
            // 改变网址的HASH值（hashchange驱动页面变化）
            var level = decodeURIComponent(window.location.hash.substr(1));
            var levelItems = level.split('-');
            if (levelItems.length) {
                window.location.hash = levelItems[0];
            }

            // 仅在桌面版Chrome出现的问题：改变当前页的哈希值为空时，父页面的滚动条会改变
            if (F.isChrome()) {
                parent && parent.$('body').scrollTop(0);
            }
        }


        // 显示主题设置窗体
        function onThemeSelectClick() {
            F(window1ClientID).show();
        }

        function getMenu(level) {
            var data;
            if (level) {
                var levelItems = level.split('-');
                if (levelItems.length === 1) {
                    data = MENUSOURCE[levelItems[0]];
                } else {
                    data = MENUSOURCE[levelItems[0]].children[levelItems[1]];
                }
            }
            return data;
        }

        function getMenuData(level) {
            var children, data = getMenu(level);
            if (!data) {
                children = MENUSOURCE;
            } else {
                children = data.children;
            }

            var subMenus = [];
            $.each(children, function (index, menu) {
                // fields: ['text', 'href', 'hrefTarget', 'arrow', 'level']
                subMenus.push([menu.text, menu.navigateUrl, '_self', true, level ? (level + '-' + index) : index]);
            });
            return subMenus;
        }



        function checkHashChange() {
            // 根据HASH值在顶层菜单和二级菜单之间切换
            var level = decodeURIComponent(window.location.hash.substr(1));
            var visiblePanelID = $('.mypanel:visible').attr('id');

            if (!level) {
                // 返回顶级菜单
                F.slideRight(visiblePanelID, panel1ClientID);
            } else {
                var levelItems = level.split('-');
                var levelMenuText = getMenu(level).text;

                if (levelItems.length === 1) {
                    // 设置二级菜单的标题
                    F(toolbar2ClientID).setTitle(levelMenuText);

                    // 绑定二级菜单
                    F(dataList2ClientID).fields = ['text', 'href', 'hrefTarget', 'arrow', 'level'];
                    F(dataList2ClientID).loadData(getMenuData(level));

                    // 转到二级菜单
                    if (visiblePanelID === panel3ClientID) {
                        F.slideRight(visiblePanelID, panel2ClientID);
                    } else {
                        F.slideLeft(visiblePanelID, panel2ClientID);
                    }
                } else {
                    // 设置三级菜单的标题
                    F(toolbar3ClientID).setTitle(levelMenuText);

                    // 绑定三级菜单
                    F(dataList3ClientID).fields = ['text', 'href', 'hrefTarget', 'arrow', 'level'];
                    F(dataList3ClientID).loadData(getMenuData(level));

                    // 转到三级菜单
                    F.slideLeft(visiblePanelID, panel3ClientID);
                }
            }
        }



        F.ready(function () {

            var dataList1 = F(dataList1ClientID);

            // 基础版不支持DataList
            if (!dataList1) {
                return;
            }

            // 点击一级菜单和二级菜单
            $('.mydatalist').on('click', '.f-datalist-item', function (event) {
                var itemEl = $(this), datalist = F(itemEl.closest('.f-datalist').attr('id'));
                var itemData = datalist.getItemData(itemEl);

                // 这是一个目录，则改变网址的HASH值（hashchange驱动页面变化）
                if (!itemData.href) {
                    window.location.hash = '#' + encodeURIComponent(itemData.level);
                }
            });

            // 绑定一级菜单
            dataList1.fields = ['text', 'href', 'hrefTarget', 'arrow', 'level'];
            dataList1.loadData(getMenuData(''));



            // 页面第一次加载时，转到二级菜单不需要动画效果
            F.noAnimation(function () {
                checkHashChange();
            });


            // hashchange驱动页面变化
            $(window).on('hashchange', function (event) {
                checkHashChange();
            });


            // 选中某个主题
            $('#themecontainer li').on('click', function (event) {
                var imgNode = $(this).find('img');

                var themeName = imgNode.attr('data-value');
                F.cookie('Theme', themeName, {
                    expires: 100  // 单位：天
                });

                var themeTitle = imgNode.attr('alt');
                F.cookie('Theme_Title', themeTitle, {
                    expires: 100  // 单位：天
                });

                top.window.location.reload();
            });
        });

    </script>
</body>
</html>
