﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;

namespace FineUIPro.Examples.mobile.datalist
{
    public partial class datalist_linktopanel : PageBaseMobile
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                LoadData();
            }
        }


        private void LoadData()
        {
            DataList1.DataSource = DataSourceUtil.GetCountryTable();
            DataList1.DataBind();
        }


        protected void DataList1_ItemDataBound(object sender, DataListItemEventArgs e)
        {
            DataRowView row = e.DataItem as DataRowView;

            string name = row["Name"].ToString();

            e.Item.Text = String.Format(DATALIST_ITEM_TEMPLATE, 
                PageContext.ResolveUrl("~/res/icon/flag_" + row["Image"] + ".png"), 
                row["Name"], 
                row["Desc"]);

            e.Item.NavigateUrl = "javascript:;";
            e.Item.ShowArrow = true;

        }
 
    }
}
