﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;

namespace FineUIPro.Examples.mobile.datalist
{
    public partial class datalist_image_title_button : PageBaseMobile
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                LoadData();
            }
        }


        private void LoadData()
        {
            DataList1.DataSource = DataSourceUtil.GetCountryTable();
            DataList1.DataBind();
        }


        protected static readonly string DATALIST_ITEM_TEMPLATE_ACTIONS = "<table class=\"item-table\"><tr><td><img class=\"item-img\" src=\"{0}\"><div class=\"item-text\">{1}</div><div class=\"item-desc\">{2}</div></td><td class=\"actions\"></td></tr></table>";

        protected void DataList1_ItemDataBound(object sender, DataListItemEventArgs e)
        {
            DataRowView row = e.DataItem as DataRowView;

            e.Item.Text = String.Format(DATALIST_ITEM_TEMPLATE_ACTIONS, 
                PageContext.ResolveUrl("~/res/icon/flag_" + row["Image"] + ".png"), 
                row["Name"], 
                row["Desc"]);
        }
 
    }
}
