﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace FineUIPro.Examples
{
    public partial class index : PageBase
    {
        #region EnableFStatePersistence

        /// <summary>
        /// 首页没有回发操作，所以无需在服务器端保存FState
        /// </summary>
        protected override bool SaveFStateToServer
        {
            get
            {
                return false;
            }
        }

        #endregion

        #region Page_Init

        private string _menuType = "tree";
        private bool _showOnlyBase = false;
        private string _searchText = "";

        // 主选项卡标签页
        private string _mainTabs = "multi";

        // 示例数
        private int _examplesCount = 0;


        #region Page_Init

        protected void Page_Init(object sender, EventArgs e)
        {
            ////////////////////////////////////////////////////////////////
            string themeStr = Request.QueryString["theme"];
            string menuStr = Request.QueryString["menu"];
            if (!String.IsNullOrEmpty(themeStr) || !String.IsNullOrEmpty(menuStr))
            {
                if (!String.IsNullOrEmpty(themeStr))
                {
                    if (themeStr == "bootstrap1")
                    {
                        themeStr = "bootstrap_pure";
                    }
                    HttpCookie cookie = new HttpCookie("Theme", themeStr);
                    cookie.Expires = DateTime.Now.AddYears(1);
                    Response.Cookies.Add(cookie);
                }

                if (!String.IsNullOrEmpty(menuStr))
                {
                    HttpCookie cookie = new HttpCookie("MenuStyle", menuStr);
                    cookie.Expires = DateTime.Now.AddYears(1);
                    Response.Cookies.Add(cookie);
                }

                PageContext.Redirect("~/default.aspx");
                return;
            }
            ////////////////////////////////////////////////////////////////



            // 从Cookie中读取 - 左侧菜单类型
            HttpCookie menuCookie = Request.Cookies["MenuStyle"];
            if (menuCookie != null)
            {
                _menuType = menuCookie.Value;
            }

            // 新版首页不再支持手风琴+树控件的情况，这样会增加复杂度
            if (_menuType == "accordion")
            {
                _menuType = "tree";
            }

            // 从Cookie中读取 - 是否仅显示基础版示例
            HttpCookie menuShowOnlyBase = Request.Cookies["ShowOnlyBase"];
            if (menuShowOnlyBase != null)
            {
                _showOnlyBase = Convert.ToBoolean(menuShowOnlyBase.Value);
            }

            // 从Cookie中读取 - 搜索文本
            HttpCookie searchText = Request.Cookies["SearchText"];
            if (searchText != null)
            {
                _searchText = HttpUtility.UrlDecode(searchText.Value);
            }

            //if (_showOnlyBase || Constants.IS_BASE)
            //{
            //    _menuType = "plaintree";
            //}

            // 从Cookie中读取 - 是否单标签页
            HttpCookie mainTabs = Request.Cookies["MainTabs"];
            if (mainTabs != null)
            {
                _mainTabs = mainTabs.Value;
            }


            InitTreeMenu();

        }

        #endregion

        #region InitTreeMenu

        private Tree InitTreeMenu()
        {
            treeMenu.MiniModePopWidth = Unit.Pixel(260);

            if (_menuType == "tree")
            {
                treeMenu.HideHScrollbar = true;
                treeMenu.HideVScrollbar = true;
                treeMenu.ExpanderToRight = true;
                treeMenu.HeaderStyle = true;
                treeMenu.AllHeaderStyle = true;
            }

            XmlDocument doc = XmlDataSource1.GetXmlDocument();
            ResolveXmlDocument(doc);

            // 绑定 XML 数据源到树控件
            treeMenu.NodeDataBound += treeMenu_NodeDataBound;
            treeMenu.PreNodeDataBound += treeMenu_PreNodeDataBound;
            treeMenu.DataSource = doc;
            treeMenu.DataBind();

            return treeMenu;
        }

        #endregion

        #region ResolveXmlDocument

        private void ResolveXmlDocument(XmlDocument doc)
        {
            ResolveXmlDocument(doc, doc.DocumentElement.ChildNodes);
        }

        private int ResolveXmlDocument(XmlDocument doc, XmlNodeList nodes)
        {
            // nodes 中渲染到页面上的节点个数
            int nodeVisibleCount = 0;

            foreach (XmlNode node in nodes)
            {
                // Only process Xml elements (ignore comments, etc)
                if (node.NodeType == XmlNodeType.Element)
                {
                    XmlAttribute removedAttr;

                    // 是否叶子节点
                    bool isLeaf = node.ChildNodes.Count == 0;


                    // 所有过滤条件均是对叶子节点而言，而是否显示目录，要看是否存在叶子节点
                    if (isLeaf)
                    {
                        // 存在搜索关键字
                        if (!String.IsNullOrEmpty(_searchText))
                        {
                            XmlAttribute textAttr = node.Attributes["Text"];
                            if (textAttr != null)
                            {
                                if (!textAttr.Value.Contains(_searchText) && isLeaf)
                                {
                                    removedAttr = doc.CreateAttribute("Removed");
                                    removedAttr.Value = "true";

                                    node.Attributes.Append(removedAttr);
                                }
                            }
                        }

                        // 如果仅显示基础版示例
                        if (_showOnlyBase)
                        {
                            XmlAttribute isCorpAttr = node.Attributes["IsCorp"];
                            if (isCorpAttr != null)
                            {
                                removedAttr = doc.CreateAttribute("Removed");
                                removedAttr.Value = "true";

                                node.Attributes.Append(removedAttr);

                            }
                        }
                    }

                    // 存在子节点
                    if (!isLeaf)
                    {
                        // 递归
                        int childVisibleCount = ResolveXmlDocument(doc, node.ChildNodes);

                        if (childVisibleCount == 0)
                        {
                            removedAttr = doc.CreateAttribute("Removed");
                            removedAttr.Value = "true";

                            node.Attributes.Append(removedAttr);
                        }
                    }


                    removedAttr = node.Attributes["Removed"];
                    if (removedAttr == null)
                    {
                        nodeVisibleCount++;
                    }
                }
            }

            return nodeVisibleCount;
        }

        #endregion

        #region treeMenu_NodeDataBound treeMenu_PreNodeDataBound
        /// <summary>
        /// 树节点的绑定后事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeMenu_NodeDataBound(object sender, TreeNodeEventArgs e)
        {
            // 是否叶子节点
            bool isLeaf = e.XmlNode.ChildNodes.Count == 0;

            //string isNewHtml = GetIsCorpHtml(e.XmlNode);
            //if (!String.IsNullOrEmpty(isNewHtml))
            //{
            //    e.Node.Text += isNewHtml;
            //}
            // 企业版
            if (GetIsCorp(e.XmlNode))
            {
                e.Node.IconFont = IconFont._Pro;
            }


            if (isLeaf)
            {
                // 设置节点的提示信息
                e.Node.ToolTip = e.Node.Text;
            }

            // 存在搜索文本
            if (!String.IsNullOrEmpty(_searchText))
            {
                e.Node.Expanded = true;
            }
        }

        /// <summary>
        /// 树节点的预绑定事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeMenu_PreNodeDataBound(object sender, TreePreNodeEventArgs e)
        {
            // 是否叶子节点
            bool isLeaf = e.XmlNode.ChildNodes.Count == 0;

            XmlAttribute removedAttr = e.XmlNode.Attributes["Removed"];
            if (removedAttr != null)
            {
                e.Cancelled = true;
            }

            if (isLeaf && !e.Cancelled)
            {
                _examplesCount++;
            }
        }

        #endregion

        #region GetIsCorpHtml

        //private string GetIsCorpHtml(XmlNode node)
        //{
        //    string result = String.Empty;

        //    XmlAttribute isCorpAttr = node.Attributes["IsCorp"];
        //    if (isCorpAttr != null)
        //    {
        //        if (Convert.ToBoolean(isCorpAttr.Value))
        //        {
        //            result = "&nbsp;<span class=\"iscorp\">Corp</span>";
        //        }
        //    }
        //    return result;
        //}

        private bool GetIsCorp(XmlNode node)
        {
            XmlAttribute isCorpAttr = node.Attributes["IsCorp"];
            if (isCorpAttr != null)
            {
                if (Convert.ToBoolean(isCorpAttr.Value))
                {
                    return true;
                }
            }

            return false;
        }


        #endregion

        #endregion

        #region Page_Load

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                InitSearchBox();

                if (_showOnlyBase || Constants.IS_BASE)
                {
                    MenuDisplayMode.Hidden = true;
                    btnBaseDownload.Badge = false;
                }
                else
                {
                    InitMenuDisplayModeButton();
                }

                InitMenuStyleButton();
                InitLangMenuButton();
                InitMenuRegionButton();

                cbxShowOnlyBase.Checked = _showOnlyBase;

                menuTextCopyright.Text = "<div class=\"copyright\">" +
                    "<div class=\"version\"><a target=\"_blank\" href=\"http://fineui.com/pro/\"><img src=\"./res/images/logo/logo_small.png\" alt=\"logo\"/></a>" +
                    "<br/><span>FineUIPro v" + GlobalConfig.ProductVersion + "</span></div>" +
                    "<div class=\"actions\"><a target=\"_blank\" href=\"http://wpa.qq.com/msgrd?v=3&uin=2877408506&site=qq&menu=yes\">在线咨询</a>" +
                    "&nbsp;&nbsp;&nbsp;&nbsp;<a target=\"_blank\" href=\"http://fineui.com/pro/version/\">更新记录</a></div>" +
                    "</div>";

                hfExamplesCount.Text = _examplesCount.ToString();

                // 为CSS样式文件添加版本号，防止版本更新时客户端缓存
                linkIndexCSS.Href = "~/res/css/index.css?v" + GlobalConfig.ProductVersion;
                linkMobileViewCss.Href = "~/res/css/mobileview.css?v" + GlobalConfig.ProductVersion;
                //litScriptIndex.Text = String.Format("<script src=\"{0}\"></script>", PageContext.ResolveUrl("~/res/js/index.js?v" + GlobalConfig.ProductVersion));

                // 单标签页
                if (_mainTabs == "single")
                {
                    mainTabStrip.ShowTabHeader = false;
                }

                // 对图片背景的主题做特殊处理
                if (!String.IsNullOrEmpty(PageManager1.CustomTheme))
                {
                    if (PageManager1.CustomTheme.StartsWith("image_"))
                    {
                        bodyRegion.CssClass += " bgpanel";
                    }
                }
            }

        }


        private void InitSearchBox()
        {
            if (!String.IsNullOrEmpty(_searchText))
            {
                ttbxSearch.Text = _searchText;
                ttbxSearch.ShowTrigger1 = true;
                ttbxSearch.Width = 200;
                ttbxSearch.CssClass = "searchbox expanded";
            }
        }





        private void InitMenuStyleButton()
        {
            string menuStyle = "tree";

            HttpCookie menuStyleCookie = Request.Cookies["MenuStyle"];
            if (menuStyleCookie != null)
            {
                menuStyle = menuStyleCookie.Value;
            }

            SetSelectedMenuItem(MenuStyle, menuStyle);
        }

        private void InitMenuDisplayModeButton()
        {
            string displayMode = "normal";

            HttpCookie displayModeCookie = Request.Cookies["DisplayMode"];
            if (displayModeCookie != null)
            {
                displayMode = displayModeCookie.Value;
            }

            SetSelectedMenuItem(MenuDisplayMode, displayMode);
        }


        private void InitLangMenuButton()
        {
            string language = "zh_CN";

            HttpCookie languageCookie = Request.Cookies["Language"];
            if (languageCookie != null)
            {
                language = languageCookie.Value;
            }

            SetSelectedMenuItem(MenuLang, language);
        }

        private void InitMenuRegionButton()
        {
            string mainTabs = "multi";

            HttpCookie mainTabsCookie = Request.Cookies["MainTabs"];
            if (mainTabsCookie != null)
            {
                mainTabs = mainTabsCookie.Value;
            }

            SetSelectedMenuItem(MenuMainTabs, mainTabs);
        }

        private void SetSelectedMenuItem(MenuButton menuButton, string selectedDataTag)
        {
            foreach (MenuItem item in menuButton.Menu.Items)
            {
                MenuCheckBox checkbox = (item as MenuCheckBox);
                if (checkbox != null)
                {
                    checkbox.Checked = checkbox.AttributeDataTag == selectedDataTag;
                }
            }
        }

        #endregion

    }
}
