﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="index.aspx.cs" Inherits="FineUIPro.Examples.index" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title>FineUIPro 在线示例 - 基于 jQuery 的专业 ASP.NET 控件库</title>
    <link rel="shortcut icon" type="image/x-icon" href="favicon.ico" />
    <meta name="Title" content="基于 jQuery 的专业 ASP.NET 控件库(jQuery based professional ASP.NET Controls)" />
    <meta name="Description" content="FineUI 的使命是创建 No JavaScript，No CSS，No UpdatePanel，No ViewState，No WebServices 的网站应用程序" />
    <meta name="Keywords" content="jQuery,jQueryUI,FineUI,ASP.NET,控件库,AJAX,Web2.0" />
    <link type="text/css" rel="stylesheet" id="linkIndexCSS" runat="server" href="~/res/css/index.css" />
    <link type="text/css" rel="stylesheet" id="linkMobileViewCss" runat="server" href="~/res/css/mobileview.css" />
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" AutoSizePanelID="mainPanel" runat="server"></f:PageManager>
        <f:Panel ID="mainPanel" Layout="Region" CssClass="mainpanel" ShowBorder="false" ShowHeader="false" runat="server">
            <Items>
                <f:Panel ID="sidebarRegion" CssClass="sidebarregion bgpanel" RegionPosition="Left"
                    ShowBorder="false" Width="260" ShowHeader="false"
                    EnableCollapse="false" Collapsed="false" Layout="VBox" runat="server"
                    RegionSplit="true" RegionSplitIcon="false" RegionSplitWidth="3" RegionSplitTransparent="true">
                    <Items>
                        <f:ContentPanel CssClass="topregion" ShowBorder="false" ShowHeader="false" runat="server">
                            <div id="sideheader" class="f-widget-header f-mainheader">
                                <a class="logo" href="./" title="FineUI Pro" id="logoTitle" runat="server">FineUI Pro</a>
                            </div>
                        </f:ContentPanel>
                        <f:Panel ID="leftPanel" CssClass="leftregion" BoxFlex="1" ShowBorder="false" ShowHeader="false" Layout="Fit" runat="server">
                            <Items>
                                <f:Tree ID="treeMenu" ShowBorder="false" ShowHeader="false" EnableSingleClickExpand="true" runat="server"></f:Tree>
                            </Items>
                        </f:Panel>
                    </Items>
                    <Listeners>
                        <f:Listener Event="splitdrag" Handler="onSidebarSplitDrag" />
                    </Listeners>
                </f:Panel>
                <f:Panel ID="bodyRegion" CssClass="bodyregion" RegionPosition="Center" ShowBorder="false" ShowHeader="false" Layout="VBox" runat="server">
                    <Items>
                        <f:ContentPanel ID="topPanel" CssClass="topregion" ShowBorder="false" ShowHeader="false" runat="server">
                            <div id="header" class="f-widget-header f-mainheader">
                                <div class="header-left">
                                    <f:Button runat="server" ID="btnCollapseSidebar" CssClass="icononlyaction" ToolTip="折叠/展开侧边栏" IconAlign="Top" IconFont="_Fold"
                                        EnablePostBack="false" EnableDefaultState="false" TabIndex="-1">
                                        <Listeners>
                                            <f:Listener Event="click" Handler="onFoldClick" />
                                        </Listeners>
                                    </f:Button>
                                    <div id="breadcrumb">
                                        <div class="breadcrumb-inner">
                                            <span class="breadcrumb-last">首页</span>
                                        </div>
                                        <div class="breadcrumb-icons">
                                            <a data-qtip="查看源代码" href="javascript:onToolSourceCodeClick();"><i class="f-icon f-iconfont f-iconfont-code"></i></a>
                                            <a data-qtip="刷新本页" href="javascript:onToolRefreshClick();"><i class="f-icon f-iconfont f-iconfont-refresh"></i></a>
                                            <a data-qtip="在新标签页中打开" href="javascript:onToolNewWindowClick();"><i class="f-icon f-iconfont f-iconfont-new-tab"></i></a>
                                        </div>
                                    </div>
                                </div>
                                <div class="header-right">
                                    <f:TwinTriggerBox ID="ttbxSearch" CssClass="searchbox collapsed" ShowLabel="false" Trigger1Icon="Clear" ShowTrigger1="false"
                                        EmptyText="搜索示例" Trigger2Icon="Search"
                                        EnableTrigger1PostBack="false" EnableTrigger2PostBack="false" runat="server" Width="24px">
                                        <Listeners>
                                            <f:Listener Event="trigger1click" Handler="onSearchTrigger1Click" />
                                            <f:Listener Event="trigger2click" Handler="onSearchTrigger2Click" />
                                            <f:Listener Event="blur" Handler="onSearchBlur" />
                                        </Listeners>
                                    </f:TwinTriggerBox>
                                    <f:Button ID="btnBaseDownload" runat="server" CssClass="icononlyaction btn-apply-trial" ToolTip="基础版下载" IconAlign="Top" IconFont="_Download"
                                        EnablePostBack="false" EnableDefaultState="false" TabIndex="-1"
                                        Badge="true" BadgeType="Warning" BadgeAnimationType="Processing">
                                        <Listeners>
                                            <f:Listener Event="click" Handler="onBaseDownloadClick" />
                                        </Listeners>
                                    </f:Button>
                                    <f:Button runat="server" CssClass="icononlyaction" ID="btnThemeSelect" ToolTip="主题仓库" IconAlign="Top" IconFont="_Skin"
                                        EnablePostBack="false" EnableDefaultState="false" TabIndex="-1">
                                        <Listeners>
                                            <f:Listener Event="click" Handler="onThemeSelectClick" />
                                        </Listeners>
                                    </f:Button>
                                    <f:Button runat="server" CssClass="userpicaction" Text="三生石上" IconUrl="~/res/images/my_face_80.jpg" IconAlign="Left"
                                        EnablePostBack="false" EnableDefaultState="false">
                                        <Menu runat="server" ID="menuSettings">
                                            <f:MenuCheckBox runat="server" ID="cbxShowOnlyBase" Text="仅显示基础版示例">
                                                <Listeners>
                                                    <f:Listener Event="click" Handler="onShowOnlyBaseClick" />
                                                </Listeners>
                                            </f:MenuCheckBox>
                                            <f:MenuButton runat="server" CssClass="icononlyaction" Text="企业版试用" IconFont="_Pro" EnablePostBack="false">
                                                <Listeners>
                                                    <f:Listener Event="click" Handler="onApplyTrialClick" />
                                                </Listeners>
                                            </f:MenuButton>
                                            <f:MenuSeparator runat="server">
                                            </f:MenuSeparator>
                                            <f:MenuButton runat="server" EnablePostBack="false" ID="MenuDisplayMode" Text="显示模式">
                                                <Menu runat="server">
                                                    <Items>
                                                        <f:MenuCheckBox Text="紧凑模式" ID="MenuDisplayModeCompact" AttributeDataTag="compact" GroupName="MenuDisplayMode" runat="server">
                                                        </f:MenuCheckBox>
                                                        <f:MenuCheckBox Text="小字体模式" ID="MenuDisplayModeSmall" AttributeDataTag="small" GroupName="MenuDisplayMode" runat="server">
                                                        </f:MenuCheckBox>
                                                        <f:MenuCheckBox Text="普通模式" ID="MenuDisplayModeNormal" AttributeDataTag="normal" Checked="true" GroupName="MenuDisplayMode" runat="server">
                                                        </f:MenuCheckBox>
                                                        <f:MenuCheckBox Text="大字体模式" ID="MenuDisplayModeLarge" AttributeDataTag="large" GroupName="MenuDisplayMode" runat="server">
                                                        </f:MenuCheckBox>
                                                        <f:MenuCheckBox Text="大间距模式" ID="MenuDisplayModeLargeSpace" AttributeDataTag="largeSpace" GroupName="MenuDisplayMode" runat="server">
                                                        </f:MenuCheckBox>
                                                    </Items>
                                                    <Listeners>
                                                        <f:Listener Event="checkchange" Handler="onMenuDisplayModeCheckChange" />
                                                    </Listeners>
                                                </Menu>
                                            </f:MenuButton>
                                            <f:MenuButton EnablePostBack="false" Text="菜单样式" ID="MenuStyle" runat="server">
                                                <Menu runat="server">
                                                    <Items>
                                                        <f:MenuCheckBox Text="智能树菜单" ID="MenuStyleTree" AttributeDataTag="tree" Checked="true" GroupName="MenuStyle" runat="server">
                                                        </f:MenuCheckBox>
                                                        <f:MenuCheckBox Text="树菜单" ID="MenuStylePlainTree" AttributeDataTag="plaintree" GroupName="MenuStyle" runat="server">
                                                        </f:MenuCheckBox>
                                                    </Items>
                                                    <Listeners>
                                                        <f:Listener Event="checkchange" Handler="onMenuStyleCheckChange" />
                                                    </Listeners>
                                                </Menu>
                                            </f:MenuButton>
                                            <f:MenuButton EnablePostBack="false" Text="主选项卡标签" ID="MenuMainTabs" runat="server">
                                                <Menu runat="server">
                                                    <Items>
                                                        <f:MenuCheckBox Text="多标签页" ID="MenuMainTabsMulti" AttributeDataTag="multi" Checked="true" GroupName="MenuMainTabs" runat="server">
                                                        </f:MenuCheckBox>
                                                        <f:MenuCheckBox Text="单标签页" ID="MenuMainTabsSingle" AttributeDataTag="single" GroupName="MenuMainTabs" runat="server">
                                                        </f:MenuCheckBox>
                                                    </Items>
                                                    <Listeners>
                                                        <f:Listener Event="checkchange" Handler="onMenuMainTabsCheckChange" />
                                                    </Listeners>
                                                </Menu>
                                            </f:MenuButton>
                                            <f:MenuButton EnablePostBack="false" Text="语言" ID="MenuLang" runat="server">
                                                <Menu ID="Menu2" runat="server">
                                                    <Items>
                                                        <f:MenuCheckBox Text="简体中文" ID="MenuLangZHCN" AttributeDataTag="zh_CN" Checked="true" GroupName="MenuLang" runat="server">
                                                        </f:MenuCheckBox>
                                                        <f:MenuCheckBox Text="繁體中文" ID="MenuLangZHTW" AttributeDataTag="zh_TW" GroupName="MenuLang" runat="server">
                                                        </f:MenuCheckBox>
                                                        <f:MenuCheckBox Text="English" ID="MenuLangEN" AttributeDataTag="en" GroupName="MenuLang" runat="server">
                                                        </f:MenuCheckBox>
                                                        <f:MenuCheckBox Text="ئۇيغۇر تىلى" ID="MenuLangZHUEY" AttributeDataTag="zh_UEY" GroupName="MenuLang" runat="server">
                                                        </f:MenuCheckBox>
                                                    </Items>
                                                    <Listeners>
                                                        <f:Listener Event="checkchange" Handler="onMenuLangCheckChange" />
                                                    </Listeners>
                                                </Menu>
                                            </f:MenuButton>
                                            <f:MenuButton runat="server" Text="CSS加载动画" EnablePostBack="false">
                                                <Listeners>
                                                    <f:Listener Event="click" Handler="onLoadingSelectClick" />
                                                </Listeners>
                                            </f:MenuButton>
                                            <f:MenuSeparator runat="server">
                                            </f:MenuSeparator>
                                            <f:MenuButton EnablePostBack="false" Text="在线示例" runat="server" ID="MenuExamples">
                                                <Menu runat="server">
                                                    <Items>
                                                        <f:MenuHyperLink runat="server" Text="FineUI Pro <div class='online-examples-subtitle'>(ASP.NET WebForms)</div>" NavigateUrl="http://pro.fineui.com/" Target="_blank">
                                                        </f:MenuHyperLink>
                                                        <f:MenuHyperLink runat="server" Text="FineUI MVC <div class='online-examples-subtitle'>(ASP.NET MVC 5)</div>" NavigateUrl="http://mvc.fineui.com/" Target="_blank">
                                                        </f:MenuHyperLink>
                                                        <f:MenuHyperLink runat="server" Text="FineUI Core <div class='online-examples-subtitle'>(ASP.NET Core)</div>" NavigateUrl="http://core.fineui.com/" Target="_blank">
                                                        </f:MenuHyperLink>
                                                        <f:MenuHyperLink runat="server" Text="FineUI Core <div class='online-examples-subtitle'>(ASP.NET Core with Razor Pages & Tag Helpers)</div>" NavigateUrl="http://pages.fineui.com/" Target="_blank">
                                                        </f:MenuHyperLink>
                                                        <f:MenuHyperLink runat="server" Text="FineUI JS <div class='online-examples-subtitle'>(Pure JavaScript Library)</div>" NavigateUrl="http://js.fineui.com/" Target="_blank">
                                                        </f:MenuHyperLink>
                                                    </Items>
                                                </Menu>
                                            </f:MenuButton>
                                            <f:MenuSeparator runat="server">
                                            </f:MenuSeparator>
                                            <f:MenuText runat="server" ID="menuTextCopyright" HideOnClick="false" CssClass="copyright-menutext">
                                            </f:MenuText>
                                        </Menu>
                                    </f:Button>
                                </div>
                            </div>
                        </f:ContentPanel>
                        <f:TabStrip ID="mainTabStrip" CssClass="centerregion" ShowInkBar="true" BoxFlex="1" ShowBorder="true" EnableTabCloseMenu="true" runat="server">
                            <Tabs>
                                <f:Tab ID="tabHomepage" Title="首页" IconFont="_Home" EnableIFrame="true" IFrameUrl="~/common/main.aspx" runat="server">
                                </f:Tab>
                            </Tabs>
                            <Tools>
                                <f:Tool runat="server" EnablePostBack="false" IconFont="_Code" CssClass="tabtool viewcode" ToolTip="查看源代码" ID="toolSourceCode">
                                    <Listeners>
                                        <f:Listener Event="click" Handler="onToolSourceCodeClick" />
                                    </Listeners>
                                </f:Tool>
                                <f:Tool runat="server" EnablePostBack="false" IconFont="_Refresh" CssClass="tabtool" ToolTip="刷新本页" ID="toolRefresh">
                                    <Listeners>
                                        <f:Listener Event="click" Handler="onToolRefreshClick" />
                                    </Listeners>
                                </f:Tool>
                                <f:Tool runat="server" EnablePostBack="false" IconFont="_NewTab" CssClass="tabtool" ToolTip="在新标签页中打开" ID="toolNewWindow">
                                    <Listeners>
                                        <f:Listener Event="click" Handler="onToolNewWindowClick" />
                                    </Listeners>
                                </f:Tool>
                            </Tools>
                        </f:TabStrip>
                    </Items>
                </f:Panel>
            </Items>
        </f:Panel>
        <f:Window ID="windowSourceCode" IconFont="_Code" Title="源代码" Hidden="true" EnableIFrame="true"
            runat="server" IsModal="true" Width="1000px" Height="600px" EnableClose="true"
            EnableMaximize="true" EnableResize="true">
        </f:Window>
        <f:Window ID="windowThemeRoller" Title="主题仓库" Hidden="true" EnableIFrame="true" IFrameUrl="./common/themes.aspx" ClearIFrameAfterClose="false"
            runat="server" IsModal="true" Width="1000px" Height="600px" EnableClose="true"
            EnableMaximize="true" EnableResize="true" WindowPosition="Center">
        </f:Window>
        <f:Window ID="windowLoadingSelector" Title="CSS加载动画" Hidden="true" EnableIFrame="true" IFrameUrl="./common/loading_css.aspx" ClearIFrameAfterClose="false"
            runat="server" IsModal="true" Width="500px" Height="400px" EnableClose="true"
            EnableMaximize="true" EnableResize="true">
        </f:Window>

        <f:Window ID="windowApplyTrial" Title="企业版试用" Hidden="true"
            runat="server" IsModal="true" Width="450px" EnableClose="true"
            EnableMaximize="false" BodyPadding="15px" IconFont="_Mail">
            <Content>
                <div>
                    <div>
                        请填写如下资料发送到邮箱：2877408506@qq.com
                    </div>
                    <ul class="applytrial">
                        <li>产品名称：FineUIPro（企业版）</li>
                        <li>单位全称：XXX单位</li>
                        <li>申请人邮箱：XXX</li>
                        <li>申请人QQ：XXX</li>
                        <li>申请人姓名：XXX</li>
                        <li>申请人地址：XX省XX市</li>
                        <li>申请人电话：XXXXXXX</li>
                    </ul>
                </div>
            </Content>
        </f:Window>

        <asp:XmlDataSource ID="XmlDataSource1" runat="server" EnableCaching="false" DataFile="~/res/menu.xml"></asp:XmlDataSource>

        <f:HiddenField runat="server" ID="hfExamplesCount"></f:HiddenField>
    </form>

    <script>
        var PARAMS = {
            mainPanel: '<%= mainPanel.ClientID %>',
            mainTabStrip: '<%= mainTabStrip.ClientID %>',
            treeMenu: '<%= treeMenu.ClientID %>',
            sidebarRegion: '<%= sidebarRegion.ClientID %>',
            btnCollapseSidebar: '<%= btnCollapseSidebar.ClientID %>',
            tabHomepage: '<%= tabHomepage.ClientID %>',
            windowSourceCode: '<%= windowSourceCode.ClientID %>',
            windowThemeRoller: '<%= windowThemeRoller.ClientID %>',
            windowLoadingSelector: '<%= windowLoadingSelector.ClientID %>',
            windowApplyTrial: '<%= windowApplyTrial.ClientID %>',
            hfExamplesCount: '<%= hfExamplesCount.ClientID %>',
            sourceUrl: '<%= PageContext.ResolveUrl("~/common/source.aspx") %>',
            dashboardUrl: '<%= PageContext.ResolveUrl("~/block/dashboard.aspx") %>',
            mainUrl: '<%= PageContext.ResolveUrl("~/common/main.aspx") %>',
            processNewWindowUrl: function (url) {
                return url.replace(/\/mobile\/\?file=/ig, '/mobile/');
            }
        };
    </script>

    <script type="text/javascript" src="/res/js/index.js?v=<%= GlobalConfig.ProductVersion %>"></script>
    <script type="text/javascript" src="/res/js/mobileview.js?v=<%= GlobalConfig.ProductVersion %>"></script>

</body>
</html>
