﻿using System;
using System.Collections.Generic;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;

namespace FineUIPro.Examples.iframe.topmenu3
{
    public partial class leftmenu : PageBase
    {
        // 动态创建控件代码放在Page_Init里面
        protected void Page_Init(object sender, EventArgs e)
        {
            string menuType = Request.QueryString["menu"];

            BindLeftAccordion(menuType);
        }


        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                
            }
        }


        private void BindLeftAccordion(string menuType)
        {
            if (String.IsNullOrEmpty(menuType))
            {
                menuType = "mail";
            }

            if (menuType == "mail")
            {
                XmlDataSource1.DataFile = "~/iframe/topmenu3/data/menuMail.xml";
            }
            else if (menuType == "sys")
            {
                XmlDataSource1.DataFile = "~/iframe/topmenu3/data/menuSYS.xml";
            }
            else if (menuType == "sms")
            {
                XmlDataSource1.DataFile = "~/iframe/topmenu3/data/menuSMS.xml";
            }

            BindLeftAccordion();
        }

        private void BindLeftAccordion()
        {
            XmlDocument xmlDoc = XmlDataSource1.GetXmlDocument();
            XmlNodeList xmlNodes = xmlDoc.SelectNodes("/Tree/TreeNode");
            foreach (XmlNode xmlNode in xmlNodes)
            {
                if (xmlNode.HasChildNodes)
                {
                    AccordionPane accordionPane = new AccordionPane();
                    accordionPane.Title = xmlNode.Attributes["Text"].Value;
                    accordionPane.Layout = LayoutType.Fit;
                    accordionPane.ShowBorder = false;
                    //accordionPane.BodyPadding = "2px 0 0 0";
                    leftAccordion.Items.Add(accordionPane);

                    Tree innerTree = new Tree();
                    innerTree.ShowBorder = false;
                    innerTree.ShowHeader = false;
                    innerTree.EnableIcons = true;
                    innerTree.AutoScroll = true;
                    innerTree.EnableNodeHyperLink = true;
                    accordionPane.Items.Add(innerTree);

                    XmlDocument innerXmlDoc = new XmlDocument();
                    innerXmlDoc.LoadXml(String.Format("<?xml version=\"1.0\" encoding=\"utf-8\" ?><Tree>{0}</Tree>", xmlNode.InnerXml));

                    // 绑定AccordionPane内部的树控件
                    innerTree.DataSource = innerXmlDoc;
                    innerTree.DataBind();

                }
            }
        }

    }
}