﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="gridtree_paging_summarydata.aspx.cs" Inherits="FineUIPro.Examples.gridtree.gridtree_paging_summarydata" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <style>
        .f-grid-row-summary .f-grid-cell-inner {
            font-weight: bold;
            color: red;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" ShowBorder="true" ShowHeader="true" Title="树表格" Height="400px" runat="server" EnableCollapse="false"
            DataKeyNames="Id,Name" EnableCheckBoxSelect="true"
            EnableTree="true" TreeColumn="Name" DataIDField="Id" DataParentIDField="ParentId"
            OnRowDataBound="Grid1_RowDataBound"
            AllowPaging="true" IsDatabasePaging="true" PageSize="2" OnPageIndexChange="Grid1_PageIndexChange"
            EnableSummary="true" SummaryPosition="Bottom">
            <Columns>
                <f:RowNumberField />
                <f:BoundField ColumnID="Name" ExpandUnusedSpace="true" MinWidth="150px" DataField="Name" HeaderText="名称" />
                <f:BoundField Width="100px" DataField="Type" HeaderText="类型" />
                <f:BoundField ColumnID="Size" Width="150px" DataField="Size" HeaderText="大小" />
                <f:BoundField Width="150px" DataField="ModifyDate" DataFormatString="{0:yyyy-MM-dd}" HeaderText="修改日期" />
            </Columns>
            <PageItems>
                <f:ToolbarSeparator runat="server"></f:ToolbarSeparator>
                <f:Button runat="server" ID="btnExpandAll" EnablePostBack="false" Text="展开全部">
                    <Listeners>
                        <f:Listener Event="click" Handler="onExpandAllClick" />
                    </Listeners>
                </f:Button>
                <f:Button runat="server" ID="btnCollapseAll" EnablePostBack="false" Text="折叠全部">
                    <Listeners>
                        <f:Listener Event="click" Handler="onCollapseAllClick" />
                    </Listeners>
                </f:Button>
            </PageItems>
        </f:Grid>
        <br />
        <f:Button ID="Button1" runat="server" Text="选中了哪些行" OnClick="Button1_Click">
        </f:Button>
        <br />
        <f:Label ID="labResult" EncodeText="false" runat="server">
        </f:Label>
        <br />
        <br />
    </form>
    <script>

        var gridID = '<%= Grid1.ClientID %>';

        function onExpandAllClick(event) {
            F(gridID).expandRows();
        }


        function onCollapseAllClick(event) {
            F(gridID).collapseRows();
        }

    </script>
</body>
</html>
