﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.IO;
using Newtonsoft.Json.Linq;

namespace FineUIPro.Examples.gridtree
{
    public partial class gridtree_celleditor_clientdelete : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // 重置表格
                btnReset.OnClientClick = Confirm.GetShowReference("确定要重置表格数据？", String.Empty, Grid1.GetRejectChangesReference(), String.Empty);

                // 删除选中行按钮
                btnDelete.OnClientClick = Grid1.GetNoSelectionAlertReference("请至少选择一项！") + GetDeleteScript();


                BindGrid();
            }
        }

        #region BindGrid

        // 删除选中行的脚本
        private string GetDeleteScript()
        {
            return Confirm.GetShowReference("删除选中行？", String.Empty, MessageBoxIcon.Question, Grid1.GetDeleteSelectedRowsReference(), String.Empty);
        }


        private void BindGrid()
        {
            DataTable table = GetSourceData();

            Grid1.DataSource = table;
            Grid1.DataBind();

        }


        #endregion

        #region Events

        protected void Grid1_PreDataBound(object sender, EventArgs e)
        {
            // 设置LinkButtonField的点击客户端事件
            LinkButtonField deleteField = Grid1.FindColumn("Delete") as LinkButtonField;
            deleteField.OnClientClick = GetDeleteScript();
        }


        protected void Grid1_RowDataBound(object sender, GridRowEventArgs e)
        {
            if (e.RowID == "50" || e.RowID == "60")
            {
                e.TreeNodeExpanded = true;
            }
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            JArray modifiedData = Grid1.GetModifiedData();

            foreach (JObject modifiedRow in modifiedData)
            {
                string status = modifiedRow.Value<string>("status");
                int rowID = Convert.ToInt32(modifiedRow.Value<string>("id"));

                if (status == "modified")
                {
                    UpdateDataRow(modifiedRow.Value<JObject>("values"), rowID);
                }
                else if (status == "deleted")
                {
                    DeleteRowByID(rowID);
                }
            }

            BindGrid();

            labResult.Text = String.Format("用户修改的数据：<pre>{0}</pre>", Grid1.GetModifiedData().ToString(Newtonsoft.Json.Formatting.Indented));

            ShowNotify("数据保存成功！（表格数据已重新绑定）");
        }

        private void UpdateDataRow(JObject rowObj, int rowID)
        {
            DataRow rowData = FindRowByID(rowID);

            // 名称
            var name = rowObj["Name"];
            if (name != null)
            {
                rowData["Name"] = (name as JValue).Value;
            }

            // 类型
            var type = rowObj["Type"];
            if (type != null)
            {
                rowData["Type"] = (type as JValue).Value;
            }

            // 大小
            var size = rowObj["Size"];
            if (size != null)
            {
                rowData["Size"] = (size as JValue).Value;
            }

            // 修改日期
            var modifyDate = rowObj["ModifyDate"];
            if (modifyDate != null)
            {
                rowData["ModifyDate"] = (modifyDate as JValue).Value;
            }

        }


        #endregion

        #region Data

        private static readonly string KEY_FOR_DATASOURCE_SESSION = "datatable_for_gridtree_celleditor_clientdelete";

        // 模拟在服务器端保存数据
        // 特别注意：在真实的开发环境中，不要在Session放置大量数据，否则会严重影响服务器性能
        private DataTable GetSourceData()
        {
            if (Session[KEY_FOR_DATASOURCE_SESSION] == null)
            {
                Session[KEY_FOR_DATASOURCE_SESSION] = DataSourceUtil.GetTreeDataTable();
            }
            return (DataTable)Session[KEY_FOR_DATASOURCE_SESSION];
        }

        // 根据行ID来获取行数据
        private DataRow FindRowByID(int rowID)
        {
            DataTable table = GetSourceData();
            foreach (DataRow row in table.Rows)
            {
                if (Convert.ToInt32(row["Id"]) == rowID)
                {
                    return row;
                }
            }
            return null;
        }


        // 根据行ParentID来获取行数据
        private DataTable FindRowByParentID(DataTable table, int rowParentID)
        {
            DataTable result = table.Clone();
            foreach (DataRow row in table.Rows)
            {
                if (Convert.ToInt32(row["ParentId"]) == rowParentID)
                {
                    result.ImportRow(row);
                }
            }
            return result;
        }

        // 根据行ID来删除行数据（同时递归删除所有子节点）
        private void DeleteRowByIDInternal(DataTable table, int rowID)
        {
            DataRow found = FindRowByID(rowID);
            if (found != null)
            {
                // 删除本行
                table.Rows.Remove(found);

                // 查找并删除所有子项
                DataTable children = FindRowByParentID(table, rowID);
                foreach (DataRow row in children.Rows)
                {
                    DeleteRowByIDInternal(table, Convert.ToInt32(row["Id"]));
                }
            }
        }


        // 根据行ID来删除行数据（同时递归删除所有子节点）
        private void DeleteRowByID(int rowID)
        {
            DataTable table = GetSourceData();

            DeleteRowByIDInternal(table, rowID);
        }
        #endregion
    }
}
