﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="gridrowgroup_summary_total.aspx.cs"
    Inherits="FineUIPro.Examples.gridrowgrouprowgroup.gridrowgroup_summary_total" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <style>
        .f-grid-rowgroup-summary .f-grid-cell-Major .f-grid-cell-inner {
            text-align: right;
        }

        .f-grid-rowgroup-summary .f-grid-cell-inner {
            font-style: italic;
        }

        .f-grid-row-summary .f-grid-cell-Major .f-grid-cell-inner {
            text-align: right;
        }

        .f-grid-row-summary .f-grid-cell-inner {
            font-weight: bold;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" Height="500px" ShowBorder="true" ShowHeader="true" Title="表格" runat="server" EnableCollapse="false" DataKeyNames="Id,Name"
            EnableSummary="true" SummaryPosition="Bottom"
            DataIDField="Id" DataTextField="Name" EnableRowGroup="true" DataRowGroupField="EntranceYear" RowGroupSummary="true">
            <Columns>
                <f:RowNumberField />
                <f:BoundField Width="100px" DataField="Name" DataFormatString="{0}"
                    HeaderText="姓名" />
                <f:TemplateField Width="100px" HeaderText="性别">
                    <ItemTemplate>
                        <asp:Label ID="Label2" runat="server" Text='<%# GetGender(Eval("Gender")) %>'></asp:Label>
                    </ItemTemplate>
                </f:TemplateField>
                <f:BoundField Width="100px" DataField="EntranceYear" HeaderText="入学年份" />
                <f:CheckBoxField Width="100px" RenderAsStaticField="true" DataField="AtSchool" HeaderText="是否在校" />
                <f:RenderField ColumnID="Major" DataField="Major" RendererFunction="renderMajor"
                    ExpandUnusedSpace="true" MinWidth="150px" HeaderText="所学专业" SummaryText="平均（汇总）：" RowGroupSummaryText="平均（分组）：">
                </f:RenderField>
                <f:RenderField Width="100px" DataField="ChineseScore" FieldType="Int" ColumnID="ChineseScore" HeaderText="语文成绩" SummaryType="Avg" RowGroupSummaryType="Avg" />
                <f:RenderField Width="100px" DataField="MathScore" FieldType="Int" ColumnID="MathScore" HeaderText="数学成绩" SummaryType="Avg" RowGroupSummaryType="Avg" />
            </Columns>
        </f:Grid>
        <br />
        <f:Button ID="Button1" runat="server" Text="选中了哪些行" OnClick="Button1_Click">
        </f:Button>
        <br />
        <f:Label ID="labResult" EncodeText="false" runat="server">
        </f:Label>
    </form>
    <script src="../res/js/grid.js"></script>
</body>
</html>
