﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="gridrowgroup_summary_multi.aspx.cs"
    Inherits="FineUIPro.Examples.gridrowgroup.gridrowgroup_summary_multi" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <style>
        .f-grid-rowgroup-summary .f-grid-cell-Major .f-grid-cell-inner {
            text-align: right;
        }

        .f-grid-rowgroup-summary .f-grid-cell-inner {
            font-style: italic;
        }

        .f-grid-row-summary .f-grid-cell-Major .f-grid-cell-inner {
            text-align: right;
        }

        .f-grid-row-summary .f-grid-cell-inner {
            font-weight: bold;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" Height="500px" ShowBorder="true" ShowHeader="true" Title="表格" runat="server" EnableCollapse="false" DataKeyNames="Id,Name" 
            EnableSummary="true" SummaryPosition="Bottom" SummaryRowCount="3"
            DataIDField="Id" DataTextField="Name" EnableRowGroup="true" DataRowGroupField="EntranceYear" RowGroupSummary="true" RowGroupSummaryRowCount="3">
            <Columns>
                <f:RowNumberField />
                <f:BoundField Width="100px" DataField="Name" DataFormatString="{0}"
                    HeaderText="姓名" />
                <f:TemplateField Width="100px" HeaderText="性别">
                    <ItemTemplate>
                        <asp:Label ID="Label2" runat="server" Text='<%# GetGender(Eval("Gender")) %>'></asp:Label>
                    </ItemTemplate>
                </f:TemplateField>
                <f:BoundField Width="100px" DataField="EntranceYear" HeaderText="入学年份" />
                <f:CheckBoxField Width="100px" RenderAsStaticField="true" DataField="AtSchool" HeaderText="是否在校" />
                <f:RenderField ColumnID="Major" DataField="Major" RendererFunction="renderMajor"
                    ExpandUnusedSpace="true" MinWidth="150px" HeaderText="所学专业" SummaryRendererFunction="majorSummaryRenderer" RowGroupSummaryRendererFunction="majorRowGroupSummaryRenderer">
                </f:RenderField>
                <f:RenderField Width="100px" DataField="ChineseScore" FieldType="Int" ColumnID="ChineseScore" HeaderText="语文成绩" SummaryRendererFunction="chineseScoreSummaryRenderer" RowGroupSummaryRendererFunction="chineseScoreRowGroupSummaryRenderer" />
                <f:RenderField Width="100px" DataField="MathScore" FieldType="Int" ColumnID="MathScore" HeaderText="数学成绩" SummaryRendererFunction="mathScoreSummaryRenderer" RowGroupSummaryRendererFunction="mathScoreRowGroupSummaryRenderer" />
            </Columns>
        </f:Grid>
        <br />
        <f:Button ID="Button1" runat="server" Text="选中了哪些行" OnClick="Button1_Click">
        </f:Button>
        <br />
        <f:Label ID="labResult" EncodeText="false" runat="server">
        </f:Label>
    </form>
    <script src="../res/js/grid.js"></script>
    <script>

        function majorSummaryRenderer(summaryRowIndex) {
            if (summaryRowIndex == 0) {
                return "最小值：";
            } else if (summaryRowIndex == 1) {
                return "最大值：";
            } else if (summaryRowIndex == 2) {
                return "平均值：";
            }
        }

        function chineseScoreSummaryRenderer(summaryRowIndex) {
            var grid1 = this, result;

            if (summaryRowIndex == 0) {
                result = grid1.calcSummaryValue('ChineseScore', 'min');
            } else if (summaryRowIndex == 1) {
                result = grid1.calcSummaryValue('ChineseScore', 'max');
            } else if (summaryRowIndex == 2) {
                result = grid1.calcSummaryValue('ChineseScore', 'avg');
            }
            return result;
        }

        function mathScoreSummaryRenderer(summaryRowIndex) {
            var grid1 = this, result;

            if (summaryRowIndex == 0) {
                result = grid1.calcSummaryValue('MathScore', 'min');
            } else if (summaryRowIndex == 1) {
                result = grid1.calcSummaryValue('MathScore', 'max');
            } else if (summaryRowIndex == 2) {
                result = grid1.calcSummaryValue('MathScore', 'avg');
            }
            return result;
        }






        function majorRowGroupSummaryRenderer(summaryRowIndex) {
            if (summaryRowIndex == 0) {
                return "最小值：";
            } else if (summaryRowIndex == 1) {
                return "最大值：";
            } else if (summaryRowIndex == 2) {
                return "平均值：";
            }
        }

        function chineseScoreRowGroupSummaryRenderer(summaryRowIndex, rowGroupData) {
            var grid1 = this, result;

            if (summaryRowIndex == 0) {
                result = grid1.calcSummaryValue('ChineseScore', 'min', rowGroupData);
            } else if (summaryRowIndex == 1) {
                result = grid1.calcSummaryValue('ChineseScore', 'max', rowGroupData);
            } else if (summaryRowIndex == 2) {
                result = grid1.calcSummaryValue('ChineseScore', 'avg', rowGroupData);
            }
            return result;
        }

        function mathScoreRowGroupSummaryRenderer(summaryRowIndex, rowGroupData) {
            var grid1 = this, result;

            if (summaryRowIndex == 0) {
                result = grid1.calcSummaryValue('MathScore', 'min', rowGroupData);
            } else if (summaryRowIndex == 1) {
                result = grid1.calcSummaryValue('MathScore', 'max', rowGroupData);
            } else if (summaryRowIndex == 2) {
                result = grid1.calcSummaryValue('MathScore', 'avg', rowGroupData);
            }
            return result;
        }

    </script>
</body>
</html>
