﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.IO;
using Newtonsoft.Json.Linq;

namespace FineUIPro.Examples.grid
{
    public partial class grid_filter_dropdownlist_noforceselection : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindGrid();
            }
        }

        #region BindGrid

        private void BindGrid()
        {
            FilteredTable filteredTable = new FilteredTable();
            filteredTable.NewFilterDataRowItem = NewFilterDataRowItemImplement;

            DataTable table = filteredTable.GetFilteredTable(Grid1.FilteredData);

            Grid1.DataSource = table;
            Grid1.DataBind();

        }


        #endregion

        #region Events

        protected void Grid1_FilterChange(object sender, EventArgs e)
        {
            BindGrid();

            labResult.Text = String.Format("过滤参数：<pre>{0}</pre>", Grid1.FilteredData.ToString());
        }

        #endregion

        #region FilterDataRowItemImplement

        private bool NewFilterDataRowItemImplement(object sourceObj, string itemOperator, JToken itemValue, string itemText, string column)
        {
            bool valid = false;

            if (column == "Major")
            {
                string sourceValue = sourceObj.ToString();

                // 下拉列表的值是数组，并且数组不为空
                if (itemValue is JArray && (itemValue as JArray).Count > 0)
                {
                    JArray fillteredValue = (JArray)itemValue;

                    foreach (string filltereditem in fillteredValue)
                    {
                        if (filltereditem == sourceValue)
                        {
                            valid = true;
                            break;
                        }
                    }
                }
                else
                {
                    // 下拉列表，用户输入值
                    //string fillteredValue = fillteredObj.Value<string>();
                    if (sourceValue.Contains(itemText))
                    {
                        valid = true;
                    }
                }

            }

            return valid;
        }

        #endregion

    }
}
