﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.IO;

using Newtonsoft.Json.Linq;

namespace FineUIPro.Examples.grideditor
{
    public partial class grideditor_decimal : PageBase
    {
        private bool AppendToEnd = true;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // 删除选中单元格的客户端脚本
                string deleteScript = GetDeleteScript();

                // 新增数据初始值
                JObject defaultObj = new JObject();
                defaultObj.Add("Name", "新用户");
                defaultObj.Add("Gender", "1");
                defaultObj.Add("Major", "化学系");
                defaultObj.Add("ChineseScore", "");
                defaultObj.Add("MathScore", "");
                defaultObj.Add("Delete", String.Format("<a href=\"javascript:;\" onclick=\"{0}\"><img src=\"{1}\"/></a>", deleteScript, IconHelper.GetResolvedIconUrl(Icon.Delete)));

                // 在第一行新增一条数据
                btnNew.OnClientClick = Grid1.GetAddNewRecordReference(defaultObj, AppendToEnd);

                // 重置表格
                btnReset.OnClientClick = Confirm.GetShowReference("确定要重置表格数据？", String.Empty, Grid1.GetRejectChangesReference(), String.Empty);

                
                // 删除选中行按钮
                btnDelete.OnClientClick = Grid1.GetNoSelectionAlertReference("请至少选择一项！") + deleteScript;


                // 绑定表格
                BindGrid();
            }
        }

        // 删除选中行的脚本
        private string GetDeleteScript()
        {
            return Confirm.GetShowReference("删除选中行？", String.Empty, MessageBoxIcon.Question, Grid1.GetDeleteSelectedRowsReference(), String.Empty);
        }
        

        #region BindGrid

        private void BindGrid()
        {
            DataTable table = GetSourceData();

            Grid1.DataSource = table;
            Grid1.DataBind();
        }



        #endregion

        #region Events

        protected void Grid1_PreDataBound(object sender, EventArgs e)
        {
            // 设置LinkButtonField的点击客户端事件
            LinkButtonField deleteField = Grid1.FindColumn("Delete") as LinkButtonField;
            deleteField.OnClientClick = GetDeleteScript();
        }

        private DataRow CreateNewData(DataTable table, Dictionary<string, object> newAddedData)
        {
            DataRow rowData = table.NewRow();

            // 设置行ID（模拟数据库的自增长列）
            rowData["Id"] = GetNextRowID();
            UpdateDataRow(newAddedData, rowData);

            return rowData;
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            // 修改的现有数据
            Dictionary<int, Dictionary<string, object>> modifiedDict = Grid1.GetModifiedDict();
            foreach (int rowIndex in modifiedDict.Keys)
            {
                int rowID = Convert.ToInt32(Grid1.DataKeys[rowIndex][0]);
                DataRow row = FindRowByID(rowID);

                UpdateDataRow(modifiedDict[rowIndex], row);
            }


            // 删除现有数据
            List<int> deletedRows = Grid1.GetDeletedList();
            foreach (int rowIndex in deletedRows)
            {
                int rowID = Convert.ToInt32(Grid1.DataKeys[rowIndex][0]);
                DeleteRowByID(rowID);
            }

            
            // 新增数据
            List<Dictionary<string, object>> newAddedList = Grid1.GetNewAddedList();
            DataTable table = GetSourceData();
            if (AppendToEnd)
            {
                for (int i = 0; i < newAddedList.Count; i++)
                {
                    DataRow rowData = CreateNewData(table, newAddedList[i]);
                    table.Rows.Add(rowData);
                }
            }
            else
            {
                for (int i = newAddedList.Count - 1; i >= 0; i--)
                {
                    DataRow rowData = CreateNewData(table, newAddedList[i]);
                    table.Rows.InsertAt(rowData, 0);
                }
            }


            labResult.Text = String.Format("修改的数据：<pre>{0}</pre>", Grid1.GetModifiedData().ToString(Newtonsoft.Json.Formatting.Indented));
                

            BindGrid();

            ShowNotify("数据保存成功！（表格数据已重新绑定）");
        }

        private void UpdateDataRow(Dictionary<string, object> rowDict, DataRow rowData)
        {
            // 姓名
            UpdateDataRow("Name", rowDict, rowData);

            // 性别
            UpdateDataRow("Gender", rowDict, rowData);

            // 所学专业
            UpdateDataRow("Major", rowDict, rowData);

            // 语文成绩
            UpdateDataRow("ChineseScore", rowDict, rowData);

            // 数学成绩
            UpdateDataRow("MathScore", rowDict, rowData);

        }

        private void UpdateDataRow(string columnName, Dictionary<string, object> rowDict, DataRow rowData)
        {
            if (rowDict.ContainsKey(columnName))
            {
                rowData[columnName] = rowDict[columnName];
            }
        }


        #endregion

        #region Data

        private static readonly string KEY_FOR_DATASOURCE_SESSION = "datatable_for_grideditor_decimal";

        // 模拟在服务器端保存数据
        // 特别注意：在真实的开发环境中，不要在Session放置大量数据，否则会严重影响服务器性能
        private DataTable GetSourceData()
        {
            if (Session[KEY_FOR_DATASOURCE_SESSION] == null)
            {
                DataTable table = new DataTable();
                table.Columns.Add(new DataColumn("Id", typeof(int)));
                table.Columns.Add(new DataColumn("Name", typeof(String)));
                table.Columns.Add(new DataColumn("EntranceYear", typeof(int)));
                table.Columns.Add(new DataColumn("AtSchool", typeof(bool)));
                table.Columns.Add(new DataColumn("Major", typeof(String)));
                table.Columns.Add(new DataColumn("Group", typeof(int)));
                table.Columns.Add(new DataColumn("Gender", typeof(int)));
                table.Columns.Add(new DataColumn("LogTime", typeof(DateTime)));
                table.Columns.Add(new DataColumn("Desc", typeof(string)));
                table.Columns.Add(new DataColumn("Guid", typeof(Guid)));

                // Hobby：reading,basketball,travel,movie,music
                // 爱好：读书, 篮球, 旅游, 电影, 音乐
                table.Columns.Add(new DataColumn("Hobby", typeof(String)));
                table.Columns.Add(new DataColumn("EntranceDate", typeof(String)));

                // 考试成绩
                table.Columns.Add(new DataColumn("ChineseScore", typeof(float)));
                table.Columns.Add(new DataColumn("MathScore", typeof(float)));
                table.Columns.Add(new DataColumn("TotalScore", typeof(float)));



                DataRow row = table.NewRow();
                row[0] = 101;
                row[1] = "张萍萍";
                row[2] = 2000;
                row[3] = true;
                row[4] = "材料科学与工程系";
                row[5] = 1;
                row[6] = 0;
                row[7] = DateTime.Now.AddDays(-100); // DBNull.Value;
                row[8] = "张萍萍，女，20岁，出生于中国南方的一个小山村，毕业于中国科学技术大学。毕业后就职于某大型国有企业，任部门经理，连续三年获得企业优秀员工称号。aaaaaaaaaaabbbbbbbbbbbbcccccccccccdddddddddddddeeeeeeeeeeeeffffffffffff";
                row[9] = Guid.NewGuid();
                row[10] = "reading,travel,music";
                row[11] = "2000-09-01";
                row[12] = 80;
                row[13] = 90;
                table.Rows.Add(row);

                row = table.NewRow();
                row[0] = 102;
                row[1] = "陈飞";
                row[2] = 2000;
                row[3] = false;
                row[4] = "化学系";
                row[5] = 1;
                row[6] = 1;
                row[7] = DateTime.Now.AddDays(-100);
                row[8] = "陈飞，男，20岁，出生于中国北方的一个小山村，毕业于南方科学技术大学。";
                row[9] = Guid.NewGuid();
                row[10] = "basketball,travel,movie,reading,music";
                row[11] = "2001-09-01";
                row[12] = 85.8;
                row[13] = 90.2;
                table.Rows.Add(row);

                row = table.NewRow();
                row[0] = 103;
                row[1] = "董婷婷";
                row[2] = 2000;
                row[3] = true;
                row[4] = "化学系";
                row[5] = 2;
                row[6] = 0;
                row[7] = DateTime.Now.AddDays(-100);
                row[8] = "董婷婷，女，18岁，出生于中国海南岛的一个小山村，毕业于中国科学技术大学。董婷婷是在学校认识丈夫刘国的，有一天晚上下自习后，董婷婷发短信给刘国说“做我男朋友吧！”，然后他们就走到了一起。";
                row[9] = Guid.NewGuid();
                row[10] = "basketball,movie,music";
                row[11] = "2008-09-01";
                row[12] = 90.5;
                row[13] = 90.5;
                table.Rows.Add(row);


                row = table.NewRow();
                row[0] = 104;
                row[1] = "刘国";
                row[2] = 2002;
                row[3] = false;
                row[4] = "化学系";
                row[5] = 2;
                row[6] = 1;
                row[7] = DateTime.Now.AddDays(-100);
                row[8] = "刘国，男，22岁，出生于中国澳门的一个小山村，毕业于中国科学技术大学。刘国是作为交换生来中科大学习，在校期间认识了妻子董婷婷，虽然是被追到手了，不过在人前却总是说“老婆是我千辛万苦追来的！”。";
                row[9] = Guid.NewGuid();
                row[10] = "reading,basketball,movie";
                row[11] = "2002-09-01";
                // 默认为空
                row[12] = DBNull.Value;
                row[13] = DBNull.Value;
                table.Rows.Add(row);


                row = table.NewRow();
                row[0] = 105;
                row[1] = "康颖颖";
                row[2] = 2008;
                row[3] = true;
                row[4] = "数学系";
                row[5] = 3;
                row[6] = 0;
                row[7] = DateTime.Now.AddDays(-60);
                row[8] = "康颖颖，女，26岁，出生于中国福建的一个小山村，毕业于香港科学技术大学。";
                row[9] = Guid.NewGuid();
                row[10] = "reading,travel,movie,music";
                row[11] = "2008-09-01";
                // 默认为空
                row[12] = DBNull.Value;
                row[13] = DBNull.Value;
                table.Rows.Add(row);


                Session[KEY_FOR_DATASOURCE_SESSION] = table;
            }
            return (DataTable)Session[KEY_FOR_DATASOURCE_SESSION];
        }

        // 根据行ID来获取行数据
        private DataRow FindRowByID(int rowID)
        {
            DataTable table = GetSourceData();
            foreach (DataRow row in table.Rows)
            {
                if (Convert.ToInt32(row["Id"]) == rowID)
                {
                    return row;
                }
            }
            return null;
        }

        // 根据行ID来删除行数据
        private void DeleteRowByID(int rowID)
        {
            DataTable table = GetSourceData();

            DataRow found = FindRowByID(rowID);
            if (found != null)
            {
                table.Rows.Remove(found);
            }
        }

        // 模拟数据库的自增长列
        private int GetNextRowID()
        {
            int maxID = 0;
            DataTable table = GetSourceData();
            foreach (DataRow row in table.Rows)
            {
                int currentRowID = Convert.ToInt32(row["Id"]);
                if (currentRowID > maxID)
                {
                    maxID = currentRowID;
                }
            }
            return maxID + 1;
        }

        #endregion
    }
}
