﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="grideditor_datachange.aspx.cs"
    Inherits="FineUIPro.Examples.grideditor.grideditor_datachange" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" ShowBorder="true" ShowHeader="true" Title="表格（双击编辑）" EnableCollapse="false"
            runat="server" DataKeyNames="Id,Name" AllowCellEditing="true" ClicksToEdit="2"  OnPreDataBound="Grid1_PreDataBound">
            <Toolbars>
                <f:Toolbar ID="Toolbar1" runat="server">
                    <Items>
                        <f:Button ID="btnNew" Text="新增数据" Icon="Add" EnablePostBack="false" runat="server">
                        </f:Button>
                        <f:Button ID="btnDelete" Text="删除选中行" Icon="Delete" EnablePostBack="false" runat="server">
                        </f:Button>
                        <f:ToolbarFill runat="server">
                        </f:ToolbarFill>
                        <f:Button ID="btnReset" Text="重置表格数据" EnablePostBack="false" runat="server">
                        </f:Button>
                    </Items>
                </f:Toolbar>
            </Toolbars>
            <Columns>
                <f:RowNumberField />
                <f:RenderField Width="100px" ColumnID="Name" DataField="Name"
                    HeaderText="姓名">
                    <Editor>
                        <f:TextBox ID="tbxEditorName" runat="server">
                        </f:TextBox>
                    </Editor>
                </f:RenderField>
                <f:RenderField Width="100px" ColumnID="Gender" DataField="Gender" FieldType="Int"
                    RendererFunction="renderGender" HeaderText="性别">
                    <Editor>
                        <f:DropDownList Required="true" runat="server">
                            <f:ListItem Text="男" Value="1" />
                            <f:ListItem Text="女" Value="0" />
                        </f:DropDownList>
                    </Editor>
                </f:RenderField>
                <f:RenderField Width="100px" ColumnID="EntranceYear" DataField="EntranceYear" FieldType="Int"
                    HeaderText="入学年份">
                    <Editor>
                        <f:NumberBox ID="tbxEditorEntranceYear" NoDecimal="true" NoNegative="true" MinValue="2000"
                            MaxValue="2025" runat="server">
                        </f:NumberBox>
                    </Editor>
                </f:RenderField>
                <f:RenderField Width="120px" ColumnID="EntranceDate" DataField="EntranceDate" FieldType="Date"
                    Renderer="Date" RendererArgument="yyyy-MM-dd" HeaderText="入学日期">
                    <Editor>
                        <f:DatePicker ID="DatePicker1" Required="true" runat="server">
                        </f:DatePicker>
                    </Editor>
                </f:RenderField>
                <f:RenderCheckField Width="100px" ColumnID="AtSchool" DataField="AtSchool" HeaderText="是否在校" />
                <f:RenderField ColumnID="Major" DataField="Major" ExpandUnusedSpace="true" MinWidth="150px" HeaderText="所学专业">
                    <Editor>
                        <f:TextBox ID="tbxEditorMajor" Required="true" runat="server">
                        </f:TextBox>
                    </Editor>
                </f:RenderField>
                <f:LinkButtonField ColumnID="Delete" Width="100px" EnablePostBack="false"
                    Icon="Delete" />
            </Columns>
            <Listeners>
                <f:Listener Event="datachange" Handler="checkSubmitBtnStatus" />
            </Listeners>
        </f:Grid>
        <br />
        <f:Button ID="Button2" runat="server" Text="保存数据" Enabled="false" OnClick="Button2_Click">
        </f:Button>
        <br />
        <br />
        <f:Label ID="labResult" EncodeText="false" runat="server">
        </f:Label>
        <br />
        注：
        <ul>
            <li>[保存数据]按钮默认禁用，当有数据变化时（删除行，新增行，修改单元格）启用</li>
            <li>数据重新绑定后，重新检查[保存数据]按钮的启用状态</li>
        </ul>
        
    </form>
    <script>
        var gridClientID = '<%= Grid1.ClientID %>';
        var btnClientID = '<%= Button2.ClientID %>';

        function checkSubmitBtnStatus() {
            var grid = F(gridClientID);
            var submitBtn = F(btnClientID);

            // 如果没有删除行，没有新增行，没有修改的数据
            if (!grid.getModifiedData().length) {
                submitBtn.disable();
            } else {
                submitBtn.enable();
            }
        }

        
        function renderGender(value) {
            return value == 1 ? '男' : '女';
        }



    </script>
</body>
</html>
