﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.IO;

namespace FineUIPro.Examples.grideditor
{
    public partial class grideditor_databind : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindDropDownList();

                BindGrid();
            }
        }

        
        #region BindGrid

        private void BindDropDownList()
        {
            List<string> majors = new List<string>();
            majors.Add("材料科学与工程系");
            majors.Add("化学系");
            majors.Add("数学系");
            majors.Add("物理系");
            majors.Add("自动化系");
            majors.Add("计算机科学与工程系");

            ddlMajor.DataSource = majors;
            ddlMajor.DataBind();
        }

        private void BindGrid()
        {
            DataTable table = GetSourceData();

            Grid1.DataSource = table;
            Grid1.DataBind();
        }

        
        #endregion

        #region Events

        protected void Button2_Click(object sender, EventArgs e)
        {
            Dictionary<int, Dictionary<string, object>> modifiedDict = Grid1.GetModifiedDict();

            for (int i = 0, count = Grid1.Rows.Count; i < count; i++)
            {
                if (modifiedDict.ContainsKey(i))
                {
                    Dictionary<string, object> rowDict = modifiedDict[i];

                    // 更新数据源
                    DataTable table = GetSourceData();

                    DataRow rowData = table.Rows[i];

                    // 姓名
                    if (rowDict.ContainsKey("Name"))
                    {
                        rowData["Name"] = rowDict["Name"];
                    }
                    // 性别
                    if (rowDict.ContainsKey("Gender"))
                    {
                        rowData["Gender"] = rowDict["Gender"];
                    }
                    // 入学年份
                    if (rowDict.ContainsKey("EntranceYear"))
                    {
                        rowData["EntranceYear"] = rowDict["EntranceYear"];
                    }
                    // 入学日期
                    if (rowDict.ContainsKey("EntranceDate"))
                    {
                        rowData["EntranceDate"] = rowDict["EntranceDate"];
                    }
                    // 是否在校
                    if (rowDict.ContainsKey("AtSchool"))
                    {
                        rowData["AtSchool"] = rowDict["AtSchool"];
                    }
                    // 所学专业
                    if (rowDict.ContainsKey("Major"))
                    {
                        rowData["Major"] = rowDict["Major"];
                    }

                }
            }

            labResult.Text = String.Format("用户修改的数据：<pre>{0}</pre>", Grid1.GetModifiedData().ToString(Newtonsoft.Json.Formatting.Indented));

            BindGrid();

            ShowNotify("数据保存成功！（表格数据已重新绑定）");
        }




        #endregion

        #region Data

        private static readonly string KEY_FOR_DATASOURCE_SESSION = "datatable_for_grideditor_databind";

        // 模拟在服务器端保存数据
        // 特别注意：在真实的开发环境中，不要在Session放置大量数据，否则会严重影响服务器性能
        private DataTable GetSourceData()
        {
            if (Session[KEY_FOR_DATASOURCE_SESSION] == null)
            {
                Session[KEY_FOR_DATASOURCE_SESSION] = DataSourceUtil.GetDataTable();
            }
            return (DataTable)Session[KEY_FOR_DATASOURCE_SESSION];
        }

        #endregion
    }
}
