﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="grid_500_lockcolumn_rowheight_delayrender.aspx.cs"
    Inherits="FineUIPro.Examples.gridrowheight.grid_500_lockcolumn_rowheight_delayrender" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" ShowBorder="true" ShowHeader="true" Height="500px" Title="500行（行高固定，列锁定，延迟渲染）"
            EnableCollapse="false" AllowColumnLocking="true" runat="server" DataKeyNames="Id"
            FixedRowHeight="true" EnableDelayRender="true">
            <Columns>
                <f:RowNumberField />
                <f:BoundField Width="100px" EnableLock="true" Locked="true" DataField="ID" HeaderText="标识" />
                <f:BoundField Width="150px" EnableLock="true" Locked="true" DataField="Name" DataFormatString="{0}" HeaderText="姓名" />
                <f:TemplateField Width="100px" EnableLock="true" HeaderText="性别">
                    <ItemTemplate>
                        <%-- Container.DataItem 的类型是 System.Data.DataRowView 或者用户自定义类型 --%>
                        <%--<asp:Label ID="Label2" runat="server" Text='<%# GetGender(DataBinder.Eval(Container.DataItem, "Gender")) %>'></asp:Label>--%>
                        <asp:Label ID="Label3" runat="server" Text='<%# GetGender(Eval("Gender")) %>'></asp:Label>
                    </ItemTemplate>
                </f:TemplateField>
                <f:BoundField Width="100px" EnableLock="true" DataField="EntranceYear" HeaderText="入学年份" />
                <f:CheckBoxField Width="100px" EnableLock="true" RenderAsStaticField="true" DataField="AtSchool" HeaderText="是否在校" />
                <f:HyperLinkField Width="120px" EnableLock="true" HeaderText="所学专业" DataToolTipField="Major" DataTextField="Major"
                    DataTextFormatString="{0}" DataNavigateUrlFields="Major" DataNavigateUrlFormatString="http://gsa.ustc.edu.cn/search?q={0}"
                    UrlEncode="true" Target="_blank" />
                <f:ImageField Width="100px" DataImageUrlField="Group" DataImageUrlFormatString="~/res/images/16/{0}.png"
                    HeaderText="分组">
                </f:ImageField>
                <f:BoundField Width="300px" DataField="GUID" HeaderText="GUID" />
                <f:TemplateField Width="200px" EnableLock="true" HeaderText="爱好">
                    <ItemTemplate>
                        <%# GetHobby(Eval("Hobby")) %>
                    </ItemTemplate>
                </f:TemplateField>
                <f:BoundField Width="100px" EnableLock="true" DataField="EntranceDate" HeaderText="入学时间" />
                <f:BoundField Width="100px" EnableLock="true" DataField="ChineseScore" HeaderText="语文成绩" />
                <f:BoundField Width="100px" EnableLock="true" DataField="MathScore" HeaderText="数学成绩" />
                <f:BoundField Width="100px" EnableLock="true" DataField="TotalScore" HeaderText="总成绩" />
                <f:BoundField Width="100px" EnableLock="true" DataField="ShenGao" HeaderText="身高" />
                <f:BoundField Width="100px" EnableLock="true" DataField="TiZhong" HeaderText="体重" />
                <f:BoundField Width="100px" EnableLock="true" DataField="XueYaDi" HeaderText="血压（低）" />
                <f:BoundField Width="100px" EnableLock="true" DataField="XueYaGao" HeaderText="血压（高）" />
                <f:BoundField Width="100px" EnableLock="true" DataField="ShiLiZuo" HeaderText="视力（左）" />
                <f:BoundField Width="100px" EnableLock="true" DataField="ShiLiYou" HeaderText="视力（右）" />
                <f:BoundField Width="120px" EnableLock="true" DataField="ShiLiZuoJiaoZhen" HeaderText="矫正视力（左）" />
                <f:BoundField Width="120px" EnableLock="true" DataField="ShiLiYouJiaoZhen" HeaderText="矫正视力（右）" />
            </Columns>
            <Listeners>
                <f:Listener Event="render" Handler="onGridRender" />
            </Listeners>
        </f:Grid>
        <br />
        <br />
    </form>
    <script>
        // 等所有JS资源下载完毕后开始
        var __STARTTIME = new Date();

        // 表格渲染完毕后结束
        function onGridRender() {
            F.ui.Grid1.setTitle(F.ui.Grid1.getTitle() + ' - 渲染时间：' + ((new Date() - __STARTTIME) / 1000).toFixed(2));
        }
    </script>
</body>
</html>
