﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="griddataurl_iframe.aspx.cs"
    Inherits="FineUIPro.Examples.griddataurl.griddataurl_iframe" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <meta name="sourcefiles" content="~/griddataurl/griddataurl.ashx" />
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" ShowBorder="true" ShowHeader="true" Title="表格" EnableCollapse="false" EnableCheckBoxSelect="true"
            runat="server" DataIDField="Id" DataTextField="Name" DataUrl="~/griddataurl/griddataurl.ashx">
            <Columns>
                <f:RowNumberField></f:RowNumberField>
                <f:RenderField Width="100px" ColumnID="Name" DataField="Name" HeaderText="姓名">
                </f:RenderField>
                <f:RenderField Width="100px" ColumnID="Gender" DataField="Gender" FieldType="Int"
                    RendererFunction="renderGender" HeaderText="性别">
                </f:RenderField>
                <f:RenderField Width="100px" ColumnID="EntranceYear" DataField="EntranceYear" FieldType="Int"
                    HeaderText="入学年份">
                </f:RenderField>
                <f:RenderCheckField Width="100px" ColumnID="AtSchool" DataField="AtSchool" RenderAsStaticField="true" HeaderText="是否在校" />
                <f:RenderField ColumnID="Major" DataField="Major" RendererFunction="renderMajor"
                    ExpandUnusedSpace="true" MinWidth="150px" HeaderText="所学专业">
                </f:RenderField>
                <f:RenderField Width="100px" ColumnID="Group" DataField="Group" RendererFunction="renderGroup"
                    HeaderText="分组">
                </f:RenderField>
                <f:RenderField Width="50px" ColumnID="Actions" RendererFunction="renderActions" HeaderText="">
                </f:RenderField>
            </Columns>
        </f:Grid>
        <f:Window ID="Window1" Title="审批" Hidden="true" EnableIFrame="true" runat="server"
            EnableMaximize="true" EnableResize="true" Target="Top" OnClose="Window1_Close"
            IsModal="true" Width="850px" Height="500px">
        </f:Window>
        <br />
    </form>
    <script>

        function renderGender(value) {
            return value == 1 ? '男' : '女';
        }

        function renderGroup(value) {
            return '<img src="../res/images/16/' + value + '.png"/>'
        }

        function renderMajor(value) {
            return F.formatString('<a href="http://gsa.ustc.edu.cn/search?q={0}" target="_blank" data-qtip="{1}">{1}</a>', encodeURIComponent(value), value);
        }



        function renderActions(value, params) {
            return '<a class="action editit" href="javascript:;">' +
                        '<img class="f-grid-imagefield" src="../res/icon/pencil.png">' +
                   '</a>';
        }


        var basePath = '<%= PageContext.ResolveUrl("~/grid/") %>';
        var grid1ClientID = '<%= Grid1.ClientID %>';
        var window1ClientID = '<%= Window1.ClientID %>';

        F.ready(function () {

            var grid1 = F(grid1ClientID);
            var window1 = F(window1ClientID);

            grid1.el.on('click', '.f-grid-cell-Actions .action.editit', function (event) {
                var targetEl = $(this);
                var rowEl = targetEl.parents('.f-grid-row');
                var rowData = grid1.getRowData(rowEl);
                var rowId = rowData.id;
                var rowText = rowData.text;


                // grid_iframe_window.aspx?id=104&name=刘国
                var iframeUrl = basePath + 'grid_iframe_window.aspx?id=' + rowId + '&name=' + encodeURIComponent(rowText);
                // 显示窗体
                window1.show(iframeUrl, '审批 - ' + rowText);
            });



        });

    </script>
</body>
</html>
