﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="grid_summary_multiline_client.aspx.cs"
    Inherits="FineUIPro.Examples.grid.grid_summary_multiline_client" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <style>
        .f-grid-row-summary .f-grid-cell-Major .f-grid-cell-inner {
            text-align: right;
        }

        .f-grid-row-summary .f-grid-cell-inner {
            font-weight: bold;
        }

        .f-grid-row-summary:first-child .f-grid-cell-inner,
        .f-grid-row-summary:nth-child(2) .f-grid-cell-inner {
            font-weight: normal;
            font-style: italic;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" Title="表格" EnableCollapse="false" Height="450px"
            PageSize="15" ShowBorder="true"
            ShowHeader="true" AllowPaging="true" IsDatabasePaging="true" runat="server" EnableCheckBoxSelect="true"
            DataKeyNames="Id,Name" OnPageIndexChange="Grid1_PageIndexChange"
            EnableSummary="true" SummaryPosition="Bottom" SummaryRowCount="3">
            <Columns>
                <f:RowNumberField />
                <f:BoundField Width="100px" DataField="Name" DataFormatString="{0}"
                    HeaderText="姓名" />
                <f:TemplateField Width="100px" HeaderText="性别">
                    <ItemTemplate>
                        <asp:Label ID="Label2" runat="server" Text='<%# GetGender(Eval("Gender")) %>'></asp:Label>
                    </ItemTemplate>
                </f:TemplateField>
                <f:BoundField Width="100px" DataField="EntranceYear" HeaderText="入学年份" />
                <f:CheckBoxField Width="100px" RenderAsStaticField="true" DataField="AtSchool" HeaderText="是否在校" />
                <f:RenderField ColumnID="Major" DataField="Major" RendererFunction="renderMajor"
                    ExpandUnusedSpace="true" MinWidth="150px" HeaderText="所学专业" SummaryRendererFunction="majorSummaryRenderer">
                </f:RenderField>
                <f:RenderField Width="100px" DataField="Fee" FieldType="Int" ColumnID="Fee" HeaderText="学费" SummaryRendererFunction="feeSummaryRenderer" />
                <f:RenderField Width="100px" DataField="Donate" FieldType="Int" ColumnID="Donate" HeaderText="捐赠金额" SummaryRendererFunction="donateSummaryRenderer" />
            </Columns>
        </f:Grid>
        <br />
        <f:Button ID="Button1" runat="server" Text="选中了哪些行" OnClick="Button1_Click">
        </f:Button>
        <br />
        <f:Label ID="labResult" EncodeText="false" runat="server">
        </f:Label>
    </form>
    <script src="../res/js/grid.js"></script>
    <script>

        function majorSummaryRenderer(summaryRowIndex) {
            if (summaryRowIndex == 0) {
                return "最小值：";
            } else if (summaryRowIndex == 1) {
                return "最大值：";
            } else if (summaryRowIndex == 2) {
                return "合计：";
            }
        }

        function feeSummaryRenderer(summaryRowIndex) {
            var grid1 = this, result;

            if (summaryRowIndex == 0) {
                result = grid1.calcSummaryValue('Fee', 'min');
            } else if (summaryRowIndex == 1) {
                result = grid1.calcSummaryValue('Fee', 'max');
            } else if (summaryRowIndex == 2) {
                result = grid1.calcSummaryValue('Fee', 'sum');
            }
            // 千分位
            return F.addCommas(result);
        }

        function donateSummaryRenderer(summaryRowIndex) {
            var grid1 = this, result;

            if (summaryRowIndex == 0) {
                result = grid1.calcSummaryValue('Donate', 'min');
            } else if (summaryRowIndex == 1) {
                result = grid1.calcSummaryValue('Donate', 'max');
            } else if (summaryRowIndex == 2) {
                result = grid1.calcSummaryValue('Donate', 'sum');
            }
            // 千分位
            return F.addCommas(result);
        }

    </script>
</body>
</html>
