﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="grid_rowselect_client.aspx.cs"
    Inherits="FineUIPro.Examples.grid.grid_rowselect_client" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" Title="表格（多选）" EnableCollapse="false" ShowBorder="true" ShowHeader="true"
            runat="server" EnableCheckBoxSelect="true" DataKeyNames="Id,Name"
            EnableMultiSelect="true">
            <Columns>
                <f:RowNumberField />
                <f:BoundField Width="100px" DataField="Name" DataFormatString="{0}" HeaderText="姓名" />
                <f:TemplateField Width="100px" HeaderText="性别">
                    <ItemTemplate>
                        <asp:Label ID="Label2" runat="server" Text='<%# GetGender(Eval("Gender")) %>'></asp:Label>
                    </ItemTemplate>
                </f:TemplateField>
                <f:BoundField Width="100px" DataField="EntranceYear" HeaderText="入学年份" />
                <f:CheckBoxField Width="100px" RenderAsStaticField="true" DataField="AtSchool" HeaderText="是否在校" />
                <f:HyperLinkField HeaderText="所学专业" DataToolTipField="Major" DataTextField="Major"
                    DataTextFormatString="{0}" DataNavigateUrlFields="Major" DataNavigateUrlFormatString="http://gsa.ustc.edu.cn/search?q={0}"
                    UrlEncode="true" Target="_blank" ExpandUnusedSpace="true" MinWidth="150px" />
                <f:ImageField Width="100px" DataImageUrlField="Group" DataImageUrlFormatString="~/res/images/16/{0}.png"
                    HeaderText="分组">
                </f:ImageField>
            </Columns>
            <Listeners>
                <f:Listener Event="rowselect" Handler="onGrid1RowSelect" />
                <f:Listener Event="rowdeselect" Handler="onGrid1RowDeselect" />
                <f:Listener Event="selectionchange" Handler="onGrid1SelectionChange" />
            </Listeners>
        </f:Grid>
        <br />
        事件列表（<a onclick="javascript:$('#result').html('');" href="javascript:;">clear</a>）：
        <ul id="result"></ul>
        <br />
        注：
        <ul>
            <li>通过键盘SHIFT，表头复选框多选时，会触发多次 rowselect 事件。</li>
        </ul>
    </form>
    <script>

        function onGrid1RowSelect(event, rowId) {
            var date = new Date();
            $('#result').append(F.formatString('<li>[{0}:{1}] rowselect：{2}</li>',
                date.getMinutes(),
                date.getSeconds(),
                rowId));
        }

        function onGrid1RowDeselect(event, rowId) {
            var date = new Date();
            $('#result').append(F.formatString('<li>[{0}:{1}] rowdeselect：{2}</li>',
                date.getMinutes(),
                date.getSeconds(),
                rowId));
        }

        function onGrid1SelectionChange(event) {
            var date = new Date();
            $('#result').append(F.formatString('<li>[{0}:{1}] selectionchange</li>',
                date.getMinutes(),
                date.getSeconds()));
        }

    </script>
</body>
</html>
