﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.IO;
using Newtonsoft.Json.Linq;

namespace FineUIPro.Examples.grid
{
    public partial class grid_rowmove_columnconfig : PageBase
    {
        //[{
        //    "columnId": "RowNumber",
        //    "hidden": true,
        //    "text": ""
        //}, {
        //    "columnId": "Name",
        //    "hidden": false,
        //    "text": "姓名"
        //}, {
        //    "columnId": "Gender",
        //    "hidden": false,
        //    "text": "性别"
        //}, {
        //    "columnId": "EntranceYear",
        //    "hidden": false,
        //    "text": "入学年份"
        //}, {
        //    "columnId": "AtSchool",
        //    "hidden": false,
        //    "text": "是否在校"
        //}, {
        //    "columnId": "Major",
        //    "hidden": false,
        //    "text": "所学专业"
        //}, {
        //    "columnId": "LogTime",
        //    "hidden": false,
        //    "text": "注册日期"
        //}]
        private static readonly string GRID_COLUMNCONFIG_DEFAULT = "[{\"columnId\":\"RowNumber\",\"hidden\":false,\"text\":\"\"},{\"columnId\":\"Name\",\"hidden\":false,\"text\":\"姓名\"},{\"columnId\":\"Gender\",\"hidden\":false,\"text\":\"性别\"},{\"columnId\":\"EntranceYear\",\"hidden\":false,\"text\":\"入学年份\"},{\"columnId\":\"AtSchool\",\"hidden\":false,\"text\":\"是否在校\"},{\"columnId\":\"Major\",\"hidden\":false,\"text\":\"所学专业\"},{\"columnId\":\"LogTime\",\"hidden\":false,\"text\":\"注册日期\"}]";

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // 模拟操作数据库中的数据
                JArray savedColumns = GetSavedColumns();

                // 将数据库保存的列顺序应用到表格列上
                int order = 0;
                foreach (JObject column in savedColumns)
                {
                    GridColumn foundColumn = Grid1.FindColumn(column.Value<string>("columnId"));
                    if (foundColumn != null)
                    {
                        foundColumn.ColumnOrder = order;

                        // 约定：hidden 属性一定存在
                        bool hidden = column.Value<bool>("hidden");
                        foundColumn.Hidden = hidden;

                        // 约定：text 属性一定存在
                        string text = column.Value<string>("text");
                        foundColumn.HeaderText = text;
                    }
                    order++;
                }

                BindGrid();

                // 输出JS变量
                PageContext.RegisterStartupScript(String.Format("window.GRID_COLUMNCONFIG_DEFAULT={0};", GRID_COLUMNCONFIG_DEFAULT));
            }
            else
            {
                string arg = GetRequestEventArgument(); // 此函数所在文件：PageBase.cs

                // 模拟操作数据库中的数据
                if (arg.StartsWith("ColumnConfig_"))
                {
                    string columnsStr = arg.Substring("ColumnConfig_".Length);

                    Session[KEY_FOR_DATASOURCE_SESSION] = JArray.Parse(columnsStr);
                }
            }
        }

        #region BindGrid

        private void BindGrid()
        {
            DataTable table = DataSourceUtil.GetDataTable();

            Grid1.DataSource = table;
            Grid1.DataBind();

        }



        #endregion

        #region Data

        private static readonly string KEY_FOR_DATASOURCE_SESSION = "grid_rowmove_columnconfig_savedcolumns";

        // 模拟在服务器端保存数据
        // 特别注意：在真实的开发环境中，不要在Session放置大量数据，否则会严重影响服务器性能
        private JArray GetSavedColumns()
        {
            if (Session[KEY_FOR_DATASOURCE_SESSION] == null)
            {
                Session[KEY_FOR_DATASOURCE_SESSION] = JArray.Parse(GRID_COLUMNCONFIG_DEFAULT);
            }
            return (JArray)Session[KEY_FOR_DATASOURCE_SESSION];
        }


        #endregion


    }
}
