﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;

namespace FineUIPro.Examples.grid
{
    public partial class grid_multiactions_column_menubutton : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindGrid();
            }
            else
            {
                string arg = GetRequestEventArgument(); // 此函数所在文件：PageBase.cs
                string[] args = arg.Split('$');
                if (args.Length > 0)
                {
                    var commandName = args[0];

                    if (commandName == "Deleteit")
                    {
                        int rowIndex = Convert.ToInt32(args[1]);

                        ShowNotify(String.Format("你点击了第 {0} 行的删除按钮，行ID：{1}，姓名：{2}", rowIndex + 1, args[2], args[3]));
                    }
                    else if (commandName == "Editit")
                    {
                        string actionName = args[1];
                        int rowIndex = Convert.ToInt32(args[2]);

                        ShowNotify(String.Format("你点击了第 {0} 行的菜单项 {3}，行ID：{1}，姓名：{2}", rowIndex + 1, args[3], args[4], actionName));
                    }
                }
            }
        }

        #region BindGrid

        private void BindGrid()
        {
            ViewState["UseDataSource1"] = true;

            DataTable table = DataSourceUtil.GetDataTable();

            Grid1.DataSource = table;
            Grid1.DataBind();
        }


        #endregion

        #region Events


        protected void Button1_Click(object sender, EventArgs e)
        {
            DataTable table;
            if (Convert.ToBoolean(ViewState["UseDataSource1"]))
            {
                ViewState["UseDataSource1"] = false;
                table = DataSourceUtil.GetDataTable2();
            }
            else
            {
                ViewState["UseDataSource1"] = true;
                table = DataSourceUtil.GetDataTable();
            }

            Grid1.DataSource = table;
            Grid1.DataBind();
        }


        protected void Window1_Close(object sender, EventArgs e)
        {

        }

        #endregion

    }
}
