﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.IO;

namespace FineUIPro.Examples.grid
{
    public partial class grid_lockcolumn_savetodb : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                List<string> lockedColumns = GetLockedColumns();
                foreach (GridColumn column in Grid1.Columns)
                {
                    column.Locked = lockedColumns.Contains(column.ColumnID);
                }


                BindGrid();
            }
            else
            {
                string arg = GetRequestEventArgument(); // 此函数所在文件：PageBase.cs

                // 模拟操作数据库中的数据
                List<string> lockedColumns = GetLockedColumns();
                if (arg.StartsWith("ColumnLock_"))
                {
                    string columnId = arg.Substring("ColumnLock_".Length);
                    if (!lockedColumns.Contains(columnId))
                    {
                        lockedColumns.Add(columnId);
                    }
                }
                else if (arg.StartsWith("ColumnUnlock_"))
                {
                    string columnId = arg.Substring("ColumnUnlock_".Length);
                    if (lockedColumns.Contains(columnId))
                    {
                        lockedColumns.Remove(columnId);
                    }
                } 
            }
        }

        #region BindGrid

        private void BindGrid()
        {
            DataTable table = DataSourceUtil.GetDataTable();

            Grid1.DataSource = table;
            Grid1.DataBind();

        }

        

        #endregion

        #region Data

        private static readonly string KEY_FOR_DATASOURCE_SESSION = "grid_lockcolumn_savetodb_lockedcolumns";

        // 模拟在服务器端保存数据
        // 特别注意：在真实的开发环境中，不要在Session放置大量数据，否则会严重影响服务器性能
        private List<string> GetLockedColumns()
        {
            if (Session[KEY_FOR_DATASOURCE_SESSION] == null)
            {
                Session[KEY_FOR_DATASOURCE_SESSION] = new List<string>() { "RowNumber", "Name" };
            }
            return (List<string>)Session[KEY_FOR_DATASOURCE_SESSION];
        }

        
        #endregion

    }
}
