﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="grid_iframe.aspx.cs" Inherits="FineUIPro.Examples.grid.grid_iframe" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <meta name="sourcefiles" content="~/grid/grid_iframe_window.aspx" />
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" Title="表格" EnableCollapse="false" ShowBorder="true" ShowHeader="true"
            PageSize="3" runat="server" EnableCheckBoxSelect="true" DataKeyNames="Id,Name"
            EnableRowDoubleClickEvent="true" OnRowDoubleClick="Grid1_RowDoubleClick">
            <Columns>
                <f:RowNumberField />
                <f:BoundField Width="100px" DataField="Name" DataFormatString="{0}" HeaderText="姓名" />
                <f:TemplateField Width="100px" Hidden="true" HeaderText="性别">
                    <ItemTemplate>
                        <asp:Label ID="Label2" runat="server" Text='<%# GetGender(Eval("Gender")) %>'></asp:Label>
                    </ItemTemplate>
                </f:TemplateField>
                <f:BoundField Width="100px" Hidden="true" DataField="EntranceYear" HeaderText="入学年份" />
                <f:CheckBoxField Width="100px" RenderAsStaticField="true" DataField="AtSchool" HeaderText="是否在校" />
                <f:HyperLinkField HeaderText="所学专业" DataToolTipField="Major" DataTextField="Major"
                    DataTextFormatString="{0}" DataNavigateUrlFields="Major" DataNavigateUrlFormatString="http://gsa.ustc.edu.cn/search?q={0}"
                    UrlEncode="true" Target="_blank" ExpandUnusedSpace="true" MinWidth="150px" />
                <f:ImageField Width="100px" DataImageUrlField="Group" DataImageUrlFormatString="~/res/images/16/{0}.png"
                    HeaderText="分组">
                </f:ImageField>
                <f:WindowField ColumnID="myWindowField3" Width="60px" WindowID="Window1" HeaderText="窗口列"
                    Text="编辑" ToolTip="编辑" DataTextFormatString="{0}" DataIFrameUrlFields="Id,Name"
                    DataIFrameUrlFormatString="grid_iframe_window.aspx?id={0}&name={1}" DataWindowTitleField="Name"
                    DataWindowTitleFormatString="编辑 - {0}" />
                <f:WindowField ColumnID="myWindowField2" Width="60px" WindowID="Window1" HeaderText="窗口列"
                    IconFont="_Edit" ToolTip="编辑" DataTextFormatString="{0}" DataIFrameUrlFields="Id,Name"
                    DataIFrameUrlFormatString="grid_iframe_window.aspx?id={0}&name={1}" DataWindowTitleField="Name"
                    DataWindowTitleFormatString="编辑 - {0}" />
                <f:WindowField ColumnID="myWindowField" Width="60px" WindowID="Window1" HeaderText="窗口列"
                    Icon="Pencil" ToolTip="编辑" DataTextFormatString="{0}" DataIFrameUrlFields="Id,Name"
                    DataIFrameUrlFormatString="grid_iframe_window.aspx?id={0}&name={1}" DataWindowTitleField="Name"
                    DataWindowTitleFormatString="编辑 - {0}" />
                <f:TemplateField HeaderText="模板列" Width="60px">
                    <ItemTemplate>
                        <a href="javascript:;" onclick="<%# GetEditUrl(Eval("Id"), Eval("Name")) %>">编辑</a>
                    </ItemTemplate>
                </f:TemplateField>
            </Columns>
        </f:Grid>
        <br />
        <br />
        注：双击行同样可以弹出编辑窗体。
        <br />
        <f:Window ID="Window1" Title="编辑" Hidden="true" EnableIFrame="true" runat="server"
            CloseAction="HidePostBack"
            EnableMaximize="true" EnableResize="true" OnClose="Window1_Close" Target="Top"
            IsModal="true" Width="850px" Height="500px">
        </f:Window>
    </form>
</body>
</html>
