﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.IO;

namespace FineUIPro.Examples.grid
{
    public partial class grid_groupfield_complex : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindGrid();
            }
        }

        #region BindGrid

        private void BindGrid()
        {

            Grid1.DataSource = GetDataTable();
            Grid1.DataBind();
        }

        protected DataTable GetDataTable()
        {
            DataTable table = new DataTable();
            table.Columns.Add(new DataColumn("Id", typeof(int)));
            table.Columns.Add(new DataColumn("Guid", typeof(Guid)));
            table.Columns.Add(new DataColumn("Year", typeof(int)));
            table.Columns.Add(new DataColumn("HSData", typeof(int)));
            table.Columns.Add(new DataColumn("HFData", typeof(int)));
            table.Columns.Add(new DataColumn("HF_SHData", typeof(int)));
            table.Columns.Add(new DataColumn("HF_BHData", typeof(int)));
            table.Columns.Add(new DataColumn("LHData", typeof(int)));
            table.Columns.Add(new DataColumn("ZMDData", typeof(int)));
            table.Columns.Add(new DataColumn("ZMD_SPData", typeof(int)));
            table.Columns.Add(new DataColumn("ZMD_XPData", typeof(int)));
            table.Columns.Add(new DataColumn("LogTime", typeof(DateTime)));


            DataRow row;

            Random rd = new Random();
            for (int i = 0; i < 10; i++)
            {
                int year = 2000 + i;

                row = table.NewRow();
                row[0] = 100 + i;
                row[1] = Guid.NewGuid();
                row[2] = year;
                row[3] = rd.Next(1000, 9999);
                row[4] = rd.Next(1000, 9999);
                row[5] = rd.Next(1000, 9999);
                row[6] = rd.Next(1000, 9999);
                row[7] = rd.Next(1000, 9999);
                row[8] = rd.Next(1000, 9999);
                row[9] = rd.Next(1000, 9999);
                row[10] = rd.Next(1000, 9999);
                row[11] = DateTime.Parse(String.Format("{0}-09-01", year));

                table.Rows.Add(row);
            }

            return table;
        }
        

        #endregion



    }
}
