﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="grid_columnmove_orderwidthhidden.aspx.cs" Inherits="FineUIPro.Examples.grid.grid_columnmove_orderwidthhidden" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" ShowBorder="true" ShowHeader="true" Title="表格" runat="server" EnableCollapse="false"
            DataKeyNames="Id" EnableColumnMove="true">
            <Columns>
                <f:RowNumberField ColumnID="RowNumber" />
                <f:BoundField ColumnID="Name" Width="100px" DataField="Name" DataFormatString="{0}" HeaderText="姓名" />
                <f:TemplateField ColumnID="Gender" Width="100px" HeaderText="性别">
                    <ItemTemplate>
                        <%-- Container.DataItem 的类型是 System.Data.DataRowView 或者用户自定义类型 --%>
                        <%--<asp:Label ID="Label2" runat="server" Text='<%# GetGender(DataBinder.Eval(Container.DataItem, "Gender")) %>'></asp:Label>--%>
                        <asp:Label ID="Label3" runat="server" Text='<%# GetGender(Eval("Gender")) %>'></asp:Label>
                    </ItemTemplate>
                </f:TemplateField>
                <f:BoundField ColumnID="EntranceYear" Width="100px" DataField="EntranceYear" HeaderText="入学年份" />
                <f:CheckBoxField ColumnID="AtSchool" Width="100px" RenderAsStaticField="true" DataField="AtSchool" HeaderText="是否在校" />
                <f:HyperLinkField ColumnID="Major" HeaderText="所学专业" DataToolTipField="Major" DataTextField="Major"
                    DataTextFormatString="{0}" DataNavigateUrlFields="Major" DataNavigateUrlFormatString="http://gsa.ustc.edu.cn/search?q={0}"
                    UrlEncode="true" Target="_blank" BoxFlex="1" />
                <%--<f:ImageField Width="100px" DataImageUrlField="Group" DataImageUrlFormatString="~/res/images/16/{0}.png"
                    HeaderText="分组"></f:ImageField>--%>
                <f:BoundField ColumnID="LogTime" Width="100px" DataField="LogTime" DataFormatString="{0:yyyy-MM-dd}" HeaderText="注册日期" />
            </Columns>
            <Listeners>
                <f:Listener Event="columnmove" Handler="onGridColumnMove" />
                <f:Listener Event="columnresize" Handler="onGridColumnResize" />
                <f:Listener Event="columnhide" Handler="onGridColumnHide" />
                <f:Listener Event="columnshow" Handler="onGridColumnShow" />
            </Listeners>
        </f:Grid>
        <br />
        <br />
        <f:Button runat="server" ID="btnRefresh" Text="刷新本页面（保持列顺序+宽度+隐藏）" EnablePostBack="false">
            <Listeners>
                <f:Listener Event="click" Handler="onRefreshClick" />
            </Listeners>
        </f:Button>
    </form>
    <script>

        function onRefreshClick(event) {
            window.location.reload();
        }

        function saveToDB(grid) {
            // 列顺序数组
            var columnIds = $.map(grid.columns, function (item, index) {
                return {
                    'columnId': item.columnId,
                    'hidden': item.hidden,
                    'width': item.width,
                    'flex': item.flex
                };
            });

            // 保存到数据库
            __doPostBack('', 'ColumnMove_' + JSON.stringify(columnIds));
        }

        function onGridColumnMove(event, targetColumnId, sourceColumnId, operation) {
            saveToDB(this);
        }

        function onGridColumnResize(event, columnId, newColumnWidth) {
            saveToDB(this);
        }

        function onGridColumnHide(event, columnId) {
            saveToDB(this);
        }

        function onGridColumnShow(event, columnId) {
            saveToDB(this);
        }

    </script>
</body>
</html>
