﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="grid_checkboxfield_columnheader.aspx.cs"
    Inherits="FineUIPro.Examples.grid.grid_checkboxfield_columnheader" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Grid ID="Grid1" IsFluid="true" Title="表格" EnableCollapse="false" ShowBorder="true" ShowHeader="true"
            runat="server" DataKeyNames="Id,Name">
            <Columns>
                <f:RowNumberField />
                <f:BoundField ExpandUnusedSpace="true" MinWidth="150px" DataField="Name" DataFormatString="{0}"
                    HeaderText="姓名" />
                <f:TemplateField Width="100px" HeaderText="性别">
                    <ItemTemplate>
                        <asp:Label ID="Label2" runat="server" Text='<%# GetGender(Eval("Gender")) %>'></asp:Label>
                    </ItemTemplate>
                </f:TemplateField>
                <f:BoundField Width="100px" DataField="EntranceYear" HeaderText="入学年份" />
                <f:CheckBoxField Width="100px" RenderAsStaticField="true" DataField="AtSchool" HeaderText="是否在校1" />
                <f:CheckBoxField ColumnID="CheckBoxField1" Width="120px" RenderAsStaticField="false"
                    DataField="AtSchool" HeaderText="是否在校1" />
                <f:CheckBoxField ColumnID="CheckBoxField2" Width="120px" RenderAsStaticField="false"
                    DataField="AtSchool" HeaderText="是否在校2" />
                <f:CheckBoxField ColumnID="CheckBoxField3" Width="120px" RenderAsStaticField="false"
                    DataField="AtSchool" HeaderText="是否在校3" />
            </Columns>
        </f:Grid>
        <br />
        <br />
        <f:Button ID="Button1" runat="server" Text="选中行复选框的状态" OnClick="Button1_Click">
        </f:Button>
        <br />
        <f:Label ID="labResult" EncodeText="false" runat="server">
        </f:Label>
    </form>
    <script>

        var grid1ClientID = '<%= Grid1.ClientID %>';

        F.ready(function () {

            var grid1 = F(grid1ClientID);

            // 将事件注册到 .f-grid-inner 节点，并阻止事件传播（stopPropagation），防止和表头排序事件冲突
            grid1.el.find('.f-grid-inner').on('click', '.myheadercheckbox', function (event) {
                var checked =  $(this).hasClass('f-checked'), thIndex = $(this).parents('th').index();
                
                // nth-child选择器是从 1 开始的
                var checkboxEls = grid1.el.find('.f-grid-row td:nth-child(' + (thIndex + 1) + ') .f-grid-checkbox');
                checkboxEls.toggleClass('f-checked', checked);

                // 阻止事件传播
                event.stopPropagation();
            });

        });

    </script>
</body>
</html>
