﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="tablestyle_layout_info.aspx.cs"
    Inherits="FineUIPro.Examples.form.tablestyle_layout_info" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <style>
        .userphoto {
            text-align: center;
        }

        .uploadbutton .f-field-body-cell-rightpart {
            padding: 5px 20px !important;
        }

        .uploadbutton .f-btn {
            width: 100%;
        }
    </style>
</head>
<body>
    <form id="_form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:Window ID="Window1" runat="server" Title="信息录入" IsModal="false" EnableClose="false" EnableResize="true"
            Width="850px" BodyPadding="10px" AutoScroll="true">
            <Items>
                <f:Form ID="Form1" LabelAlign="Right" RedStarPosition="BeforeText" LabelWidth="90px"
                    ShowBorder="false" ShowHeader="false" runat="server" 
                    EnableTableStyle="true" MessageTarget="Qtip">
                    <Items>
                        <f:Panel ID="Panel2" runat="server" ShowBorder="false" ShowHeader="false" Layout="HBox" BoxConfigAlign="StretchMax">
                            <Items>
                                <f:Panel ID="Panel1" Title="面板1" BoxFlex="5" runat="server" ShowBorder="false" ShowHeader="false">
                                    <Items>
                                        <f:TextBox ID="tbxName" runat="server" Label="会员姓名" ShowRedStar="true" Required="true"></f:TextBox>
                                        <f:DropDownList ID="ddlSex" Label="性别" runat="server" ShowRedStar="true" Required="true" CompareMessage="性别不能为空！">
                                            <f:ListItem Text="男" Value="男" Selected="true" />
                                            <f:ListItem Text="女" Value="女" />
                                        </f:DropDownList>
                                        <f:DatePicker ID="dpBirthDay" Label="出生日期" EmptyText="请选择日期" runat="server" EnableEdit="false" ShowRedStar="true" Required="true"></f:DatePicker>
                                        <f:TextBox ID="tbxAge" runat="server" Label="年龄" Required="true" ShowRedStar="true" CompareMessage="年龄不能为空！"></f:TextBox>
                                        <f:DropDownList ID="ddlMarriage" Label="婚姻状况" ShowRedStar="true" Required="true" runat="server">
                                            <f:ListItem Text="未婚" Value="0" Selected="true" />
                                            <f:ListItem Text="已婚" Value="1" />
                                            <f:ListItem Text="离异" Value="2" />
                                            <f:ListItem Text="丧偶" Value="3" />
                                            <f:ListItem Text="未说明" Value="4" />
                                        </f:DropDownList>
                                        <f:DropDownList ID="ddlNation" Label="民族" ShowRedStar="true" Required="true" runat="server">
                                            <f:ListItem Text="汉族" Value="汉族" Selected="true" />
                                            <f:ListItem Text="回族" Value="回族" />
                                            <f:ListItem Text="壮族" Value="壮族" />
                                            <f:ListItem Text="回族" Value="回族" />
                                            <f:ListItem Text="苗族" Value="苗族" />
                                            <f:ListItem Text="维吾尔族" Value="维吾尔族" />
                                            <f:ListItem Text="土家族" Value="土家族" />
                                            <f:ListItem Text="彝族" Value="彝族" />
                                            <f:ListItem Text="蒙古族" Value="蒙古族" />
                                            <f:ListItem Text="藏族" Value="藏族" />
                                            <f:ListItem Text="布依族" Value="布依族" />
                                            <f:ListItem Text="侗族" Value="侗族" />
                                            <f:ListItem Text="瑶族" Value="瑶族" />
                                            <f:ListItem Text="朝鲜族" Value="朝鲜族" />
                                            <f:ListItem Text="白族" Value="白族" />
                                            <f:ListItem Text="其他" Value="其他" />
                                        </f:DropDownList>
                                    </Items>
                                </f:Panel>
                                <f:Panel ID="Panel4" runat="server" BoxFlex="3" ShowBorder="false" ShowHeader="false" Layout="VBox">
                                    <Items>
                                        <f:TextBox ID="tbxArchivesNum" runat="server" Label="档案号" ShowRedStar="true" Required="true" EmptyText="不填自动生成"></f:TextBox>
                                        <f:DropDownList ID="ddlReasonsFile" Label="建档原因" ShowRedStar="true" Required="true" runat="server">
                                            <f:ListItem Text="" Value="0" Selected="true" />
                                            <f:ListItem Text="糖尿病" Value="1" Selected="true" />
                                            <f:ListItem Text="糖尿病高危个体" Value="2" />
                                            <f:ListItem Text="动脉硬化临床前期" Value="3" />
                                            <f:ListItem Text="肥胖" Value="4" />
                                            <f:ListItem Text="高血压" Value="5" />
                                            <f:ListItem Text="代谢综合征" Value="6" />
                                            <f:ListItem Text="冠心病" Value="7" />
                                            <f:ListItem Text="血脂异常" Value="8" />
                                            <f:ListItem Text="亚健康" Value="9" />
                                            <f:ListItem Text="脂肪肝" Value="10" />
                                            <f:ListItem Text="痛风" Value="11" />
                                        </f:DropDownList>
                                        <f:TextArea ID="tbxConfName" Label="并发症" runat="server" BoxFlex="1"></f:TextArea>
                                    </Items>
                                </f:Panel>
                                <f:Panel ID="Panel5" CssClass="nolabelpanel" Title="面板1" BoxFlex="2" runat="server" ShowBorder="false" ShowHeader="false" Layout="VBox">
                                    <Items>
                                        <f:Image ID="Image1" ImageUrl="~/res/images/blank_180.png" ImageHeight="120px" runat="server" BoxFlex="1" CssClass="userphoto">
                                        </f:Image>
                                        <f:FileUpload ID="FileUpload1" runat="server" ButtonText="上传照片" ButtonOnly="true" CssClass="uploadbutton"></f:FileUpload>
                                    </Items>
                                </f:Panel>
                            </Items>
                        </f:Panel>
                        <f:Form ID="Form7" ShowBorder="false" ShowHeader="false" runat="server"
                            MessageTarget="Qtip">
                            <Rows>
                                <f:FormRow>
                                    <Items>
                                        <f:TextBox ID="tbxPassWord" runat="server" Label="密码" EmptyText="默认为手机号码后6位"></f:TextBox>
                                        <f:DropDownList ID="ddlLevel" Label="会员级别" AutoPostBack="false" CompareMessage="类型不能为空！" runat="server">
                                            <f:ListItem Text="普通会员" Value="0" Selected="true" />
                                            <f:ListItem Text="银牌会员" Value="1" />
                                            <f:ListItem Text="金牌会员" Value="2" />
                                            <f:ListItem Text="钻石会员" Value="3" />
                                        </f:DropDownList>
                                    </Items>
                                </f:FormRow>
                                <f:FormRow>
                                    <Items>
                                        <f:TextBox ID="ManageShow" Label="健康顾问" runat="server"></f:TextBox>
                                        <f:DropDownList ID="ddlCardType" Label="卡类型" runat="server">
                                            <f:ListItem Text="主卡" Value="0" Selected="true" />
                                            <f:ListItem Text="副卡" Value="1" />
                                        </f:DropDownList>
                                    </Items>
                                </f:FormRow>
                                <f:FormRow>
                                    <Items>
                                        <f:TextBox ID="tbxOwnCardID" runat="server" Label="会员卡号"></f:TextBox>
                                        <f:TextBox ID="tbxHostCardID" runat="server" Label="主卡号"></f:TextBox>
                                    </Items>
                                </f:FormRow>
                                <f:FormRow>
                                    <Items>
                                        <f:TextBox ID="tbxRecommender" runat="server" Label="推荐人卡号"></f:TextBox>
                                        <f:TextBox ID="tbxRecomName" runat="server" Label="推荐人姓名"></f:TextBox>
                                    </Items>
                                </f:FormRow>
                                <f:FormRow>
                                    <Items>
                                        <f:NumberBox ID="nbxShoukaSum" runat="server" Label="售卡金额" NoDecimal="true" MinValue="0"></f:NumberBox>
                                        <f:DropDownList ID="ddlPayType" Label="支付方式" runat="server">
                                            <f:ListItem Text="现金支付" Value="0" Selected="true" />
                                            <f:ListItem Text="银行卡支付" Value="1" />
                                            <f:ListItem Text="支票支付" Value="2" />
                                            <f:ListItem Text="信用卡支付" Value="3" />
                                        </f:DropDownList>
                                    </Items>
                                </f:FormRow>
                                <f:FormRow>
                                    <Items>
                                        <f:DropDownList ID="ddlCertificates" Label="证件类别" runat="server">
                                            <f:ListItem Text="身份证" Value="0" Selected="true" />
                                            <f:ListItem Text="军官证" Value="1" />
                                            <f:ListItem Text="护照" Value="2" />
                                            <f:ListItem Text="驾驶证" Value="3" />
                                        </f:DropDownList>
                                        <f:TextBox ID="tbxIDCardEdit" runat="server" Label="证件号"></f:TextBox>
                                    </Items>
                                </f:FormRow>
                                <f:FormRow ColumnWidths="50% 50%">
                                    <Items>
                                        <f:TextBox ID="tbxCustomerEmail" runat="server" Label="邮箱" RegexPattern="EMAIL" RegexMessage="请输入有效的邮箱地址"></f:TextBox>
                                        <f:TextBox ID="tbxCustomerTel" runat="server" Label="手机号" Regex="^[1]+[358]+\d{9}$"></f:TextBox>
                                    </Items>
                                </f:FormRow>
                                <f:FormRow>
                                    <Items>
                                        <f:DropDownList ID="ddlEducation" Label="文化程度" runat="server">
                                            <f:ListItem Text="研究生" Value="研究生" Selected="true" />
                                            <f:ListItem Text="大学本科" Value="大学本科" />
                                            <f:ListItem Text="大学专科" Value="大学专科 " />
                                            <f:ListItem Text="中等职业" Value="中等职业" />
                                            <f:ListItem Text="普通高级中学" Value="普通高级中学" />
                                            <f:ListItem Text="初级中学" Value="初级中学" />
                                            <f:ListItem Text="小学" Value="小学" />
                                            <f:ListItem Text="小学以下" Value="小学以下" />
                                        </f:DropDownList>
                                        <f:DropDownList ID="ddlProfession" Label="职业" runat="server">
                                            <f:ListItem Text="国家机关、党群组织、企业、事业单位负责人" Value="国家机关、党群组织、企业、事业单位负责人" Selected="true" />
                                            <f:ListItem Text="专业技术人员" Value="专业技术人员" />
                                            <f:ListItem Text="办事人员和有关人员 " Value="办事人员和有关人员 " />
                                            <f:ListItem Text="商业、服务业人员" Value="商业、服务业人员" />
                                            <f:ListItem Text="农、林、牧、渔、水利业生产人员" Value="农、林、牧、渔、水利业生产人员" />
                                            <f:ListItem Text="生产、运输设备操作人员及有关人员" Value="生产、运输设备操作人员及有关人员" />
                                            <f:ListItem Text="军人" Value="军人" />
                                            <f:ListItem Text="不便分类的其他从业人员" Value="不便分类的其他从业人员" />
                                            <f:ListItem Text="婴幼儿、学龄前儿童" Value="婴幼儿、学龄前儿童" />
                                            <f:ListItem Text="学生" Value="学生" />
                                            <f:ListItem Text="家务" Value="家务" />
                                            <f:ListItem Text="无业或待业" Value="无业或待业" />
                                            <f:ListItem Text="其他" Value="其他" />
                                        </f:DropDownList>
                                    </Items>
                                </f:FormRow>
                                <f:FormRow>
                                    <Items>
                                        <f:TextBox ID="tbxNativePlace" runat="server" Label="籍贯"></f:TextBox>
                                        <f:DropDownList ID="ddlUserState" Label="会员状态" runat="server" CompareMessage="会员状态不能为空！">
                                            <f:ListItem Text="启用" Value="0" Selected="true" />
                                            <f:ListItem Text="禁用" Value="1" />
                                        </f:DropDownList>
                                    </Items>
                                </f:FormRow>
                            </Rows>
                        </f:Form>
                    </Items>
                </f:Form>
            </Items>
            <Toolbars>
                <f:Toolbar ID="Toolbar1" runat="server" ToolbarAlign="Right" Position="Bottom">
                    <Items>
                        <f:Button ID="Button1" IconFont="_Save" Text="保存信息" ValidateForms="Form1" ValidateMessageBox="false" runat="server">
                        </f:Button>
                    </Items>
                </f:Toolbar>
            </Toolbars>
        </f:Window>
        <br />
        <br />
    </form>
</body>
</html>
