﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace FineUIPro.Examples.form
{
    public partial class twintriggerbox_clearicon : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
            }
            else
            {
                string eventArg = GetRequestEventArgument(); // 此函数所在文件：PageBase.cs
                if (eventArg == "TriggerBoxChange")
                {
                    if (!String.IsNullOrEmpty(ttbxMyBox.Text))
                    {
                        ttbxMyBox_Trigger2Click(null, null);
                    }
                    else
                    {
                        ttbxMyBox_Trigger1Click(null, null);
                    }
                }
            }
        }

        // 点击 TwinTriggerBox 的搜索按钮
        protected void ttbxMyBox_Trigger2Click(object sender, EventArgs e)
        {
            if (!String.IsNullOrEmpty(ttbxMyBox.Text))
            {
                // 执行搜索动作
                ShowNotify(String.Format("在关键词[{0}]中搜索", ttbxMyBox.Text));

                UpdateClientJSParameter(ttbxMyBox.Text);
            }
            else
            {
                ShowNotify("请输入你要搜索的关键词！");
            }
        }

        // 点击 TwinTriggerBox 的取消按钮
        protected void ttbxMyBox_Trigger1Click(object sender, EventArgs e)
        {
            // 执行清空动作
            ShowNotify("取消搜索！");

            UpdateClientJSParameter("");
        }

        // 更新客户端变量
        private void UpdateClientJSParameter(string text)
        {
            PageContext.RegisterStartupScript(String.Format("updateLastTriggerBoxValue({0});", JsHelper.Enquote(text)));
        }

    }
}
