﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="twintriggerbox_clearicon.aspx.cs"
    Inherits="FineUIPro.Examples.form.twintriggerbox_clearicon" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:SimpleForm ID="SimpleForm1" IsFluid="true" BodyPadding="10px" EnableCollapse="false"
            Title="表单" ShowHeader="true" runat="server">
            <Items>
                <f:TwinTriggerBox ID="ttbxMyBox" ShowLabel="false" OnTrigger1Click="ttbxMyBox_Trigger1Click" OnTrigger2Click="ttbxMyBox_Trigger2Click"
                    Trigger1Icon="Clear" EmptyText="搜索用户名" Trigger2Icon="Search" runat="server"
                    AutoShowClearIcon="true">
                    <Listeners>
                        <f:Listener Event="change" Handler="onTriggerBoxChange" />
                    </Listeners>
                </f:TwinTriggerBox>
            </Items>
        </f:SimpleForm>
    </form>
    <script>
        var ttbxMyBoxClientID = '<%= ttbxMyBox.ClientID %>';

        // 记录上一次 ttbxMyBox 的值
        var __lastTriggerBoxValue;
        var __changeTimer;

        function onTriggerBoxChange(event) {
            if (__changeTimer) {
                window.clearTimeout(__changeTimer);
                __changeTimer = undefined;
            }
            __changeTimer = window.setTimeout(postBackTriggerBoxChange, 1000);
        }

        function postBackTriggerBoxChange() {
            var value = F(ttbxMyBoxClientID).getValue();
            // 值改变时才回发
            if (value !== __lastTriggerBoxValue) {
                __lastTriggerBoxValue = value;

                __doPostBack('', 'TriggerBoxChange');
            }
        }

        function updateLastTriggerBoxValue(text) {
            __lastTriggerBoxValue = text;
        }

        // 设置 __lastTriggerBoxValue 初始值
        F.ready(function () {
            __lastTriggerBoxValue = F(ttbxMyBoxClientID).getValue();
        });

    </script>
</body>
</html>
