﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="twintriggerbox_blur.aspx.cs"
    Inherits="FineUIPro.Examples.form.twintriggerbox_blur" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server" />
        <f:SimpleForm ID="SimpleForm1" IsFluid="true" BodyPadding="10px" EnableCollapse="false"
            Title="表单" ShowHeader="true" runat="server">
            <Items>
                <f:TwinTriggerBox ID="ttbxMyBox" ShowLabel="false" OnTrigger1Click="ttbxMyBox_Trigger1Click" OnTrigger2Click="ttbxMyBox_Trigger2Click"
                    Trigger1Icon="Clear" ShowTrigger1="False" EmptyText="搜索用户名" Trigger2Icon="Search" runat="server">
                    <Listeners>
                        <f:Listener Event="blur" Handler="onTriggerBoxBlur" />
                    </Listeners>
                </f:TwinTriggerBox>
            </Items>
        </f:SimpleForm>
        <br />
        <br />
        注：文本输入框失去焦点时，触发后台搜索事件。
    </form>

    <script>
        
        // 记录上一次 ttbxMyBox 的值
        var __lastTriggerBoxValue;

        function onTriggerBoxBlur(event) {
            var value = this.getValue();
            // 值改变时才回发
            if (value !== __lastTriggerBoxValue) {
                __lastTriggerBoxValue = value;

                __doPostBack('', 'TriggerBoxBlur');
            }
        }

        function updateLastTriggerBoxValue(text) {
            __lastTriggerBoxValue = text;
        }

        // 设置 __lastTriggerBoxValue 初始值
        var ttbxMyBoxClientID = '<%= ttbxMyBox.ClientID %>';
        F.ready(function () {
            __lastTriggerBoxValue = F(ttbxMyBoxClientID).getValue();
        });

    </script>
</body>
</html>
