﻿using System;
using System.Collections.Generic;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace FineUIPro.Examples.form
{
    public partial class fileupload_toolbar : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }


        protected void filePhoto_FileSelected(object sender, EventArgs e)
        {
            if (filePhoto.HasFile)
            {
                string fileName = filePhoto.ShortFileName;

                if (!ValidateFileType(fileName))
                {
                    // 清空文件上传控件
                    filePhoto.Reset();

                    ShowNotify("无效的文件类型！");
                    return;
                }


                fileName = fileName.Replace(":", "_").Replace(" ", "_").Replace("\\", "_").Replace("/", "_");
                fileName = DateTime.Now.Ticks.ToString() + "_" + fileName;

                filePhoto.SaveAs(Server.MapPath("~/upload/" + fileName));

                imgPhoto.ImageUrl = "~/upload/" + fileName;

                // 清空文件上传组件（上传后要记着清空，否则点击提交表单时会再次上传！！）
                filePhoto.Reset();
            }

        }


        protected void btnSubmit_Click(object sender, EventArgs e)
        {
            if (imgPhoto.ImageUrl == "~/res/images/blank.png")
            {
                filePhoto.MarkInvalid("请先上传个人头像！");

                ShowNotify("请先上传个人头像！");

                return;
            }

            labResult.Text = "用户名：" + tbxUserName.Text + "<br/>" +
                    "邮箱：" + tbxEmail.Text + "<br/>" +
                    "<p>头像：<br /><img src=\"" + PageContext.ResolveUrl(imgPhoto.ImageUrl) + "\" /></p>";

            // 清空表单字段
            imgPhoto.ImageUrl = "~/res/images/blank.png";
            filePhoto.Reset();
            tbxEmail.Reset();
            tbxUserName.Reset();


        }

    }
}