﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="themes.aspx.cs" Inherits="FineUIPro.Examples.common.themes" %>

<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <style>
        /*body {
            background: none !important;
            background-color: #000 !important;
            padding: 0 !important;
        }*/
        body.f-body {
            padding: 10px;
        }

        ul.main {
            list-style-type: none;
            padding: 0;
            margin: 0;
            margin-bottom: 15px;
            border-bottom-left-radius: 5px;
            border-bottom-right-radius: 5px;
        }

            ul.main li {
                display: inline-block;
                margin: 5px;
                border-width: 0;
                padding: 10px;
                border-radius: 10px;
                text-align: center;
                cursor: pointer;
            }

                ul.main li.f-state-hover,
                ul.main li.f-state-active {
                    border-style: solid;
                    border-width: 3px;
                    padding: 7px;
                }

                ul.main li .title {
                    text-align: center;
                    font-size: 13px;
                    margin-top: 10px;
                }

                ul.main li.f-state-active .title {
                    font-weight: bold;
                }

                ul.main li img {
                    width: 125px;
                    border-radius: 5px;
                    box-shadow: 2px 2px 5px 0 rgba(0, 0, 0, 0.2);
                }

                ul.main li.f-state-hover img,
                ul.main li.f-state-active img {
                    box-shadow: none;
                }

        #themecontainer .grouptitle {
            font-size: 16px;
            border-bottom-style: solid;
            border-bottom-width: 1px;
            padding: 5px;
            border-top-left-radius: 5px;
            border-top-right-radius: 5px;
        }

        #themecontainer .note {
            font-size: 11px;
            margin-left: 10px;
            display: inline-block;
        }

    </style>
</head>
<body>
    <form id="form1" runat="server">
        <f:PageManager ID="PageManager1" runat="server"></f:PageManager>
        <div id="themecontainer">
            <div class="grouptitle f-widget-content">
                内置（纯色背景）
            </div>
            <ul class="main f-widget-content">
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/pure_black.png" alt="Pure Black" data-value="Pure_Black" />
                    </a>
                    <div class="title">Pure Black</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/pure_green.png" alt="Pure Green" data-value="Pure_Green" />
                    </a>
                    <div class="title">Pure Green</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/pure_blue.png" alt="Pure Blue" data-value="Pure_Blue" />
                    </a>
                    <div class="title">Pure Blue</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/pure_purple.png" alt="Pure Purple" data-value="Pure_Purple" />
                    </a>
                    <div class="title">Pure Purple</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/pure_orange.png" alt="Pure Orange" data-value="Pure_Orange" />
                    </a>
                    <div class="title">Pure Orange</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/pure_red.png" alt="Pure Red" data-value="Pure_Red" />
                    </a>
                    <div class="title">Pure Red</div>
                </li>
            </ul>
            <div class="grouptitle f-widget-content">
                内置（Metro）
            </div>
            <ul class="main f-widget-content">
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/default.png" alt="Default" data-value="Default" /></a>
                    <div class="title">Default</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/metro_blue.png" alt="Metro Blue" data-value="Metro_Blue" /></a>
                    <div class="title">Metro Blue</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/metro_dark_blue.png" alt="Metro Dark Blue" data-value="Metro_Dark_Blue" /></a>
                    <div class="title">Metro Dark Blue</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/metro_gray.png" alt="Metro Gray" data-value="Metro_Gray" /></a>
                    <div class="title">Metro Gray</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/metro_green.png" alt="Metro Green" data-value="Metro_Green" /></a>
                    <div class="title">Metro Green</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/metro_orange.png" alt="Metro Orange" data-value="Metro_Orange" /></a>
                    <div class="title">Metro Orange</div>
                </li>
            </ul>
            <div class="grouptitle f-widget-content">
                内置（jQuery UI）
            </div>
            <ul class="main f-widget-content">
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/black_tie.png" alt="Black Tie" data-value="Black_Tie" /></a>
                    <div class="title">Black Tie</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/blitzer.png" alt="Blitzer" data-value="Blitzer" /></a>
                    <div class="title">Blitzer</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/cupertino.png" alt="Cupertino" data-value="Cupertino" /></a>
                    <div class="title">Cupertino</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/dark_hive.png" alt="Dark Hive" data-value="Dark_Hive" /></a>
                    <div class="title">Dark Hive</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/dot_luv.png" alt="Dot Luv" data-value="Dot_Luv" /></a>
                    <div class="title">Dot Luv</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/eggplant.png" alt="Eggplant" data-value="Eggplant" /></a>
                    <div class="title">Eggplant</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/excite_bike.png" alt="Excite Bike" data-value="Excite_Bike" /></a>
                    <div class="title">Excite Bike</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/flick.png" alt="Flick" data-value="Flick" /></a>
                    <div class="title">Flick</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/hot_sneaks.png" alt="Hot Sneaks" data-value="Hot_Sneaks" /></a>
                    <div class="title">Hot Sneaks</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/humanity.png" alt="Humanity" data-value="Humanity" /></a>
                    <div class="title">Humanity</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/le_frog.png" alt="Le Frog" data-value="Le_Frog" /></a>
                    <div class="title">Le Frog</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/mint_choc.png" alt="Mint Choc" data-value="Mint_Choc" /></a>
                    <div class="title">Mint Choc</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/overcast.png" alt="Overcast" data-value="Overcast" /></a>
                    <div class="title">Overcast</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/pepper_grinder.png" alt="Pepper Grinder" data-value="Pepper_Grinder" /></a>
                    <div class="title">Pepper Grinder</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/redmond.png" alt="Redmond" data-value="Redmond" /></a>
                    <div class="title">Redmond</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/smoothness.png" alt="Smoothness" data-value="Smoothness" /></a>
                    <div class="title">Smoothness</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/south_street.png" alt="South Street" data-value="South_Street" /></a>
                    <div class="title">South Street</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/start.png" alt="Start" data-value="Start" /></a>
                    <div class="title">Start</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/sunny.png" alt="Sunny" data-value="Sunny" /></a>
                    <div class="title">Sunny</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/swanky_purse.png" alt="Swanky Purse" data-value="Swanky_Purse" /></a>
                    <div class="title">Swanky Purse</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/trontastic.png" alt="Trontastic" data-value="Trontastic" /></a>
                    <div class="title">Trontastic</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/ui_darkness.png" alt="UI Darkness" data-value="UI_Darkness" /></a>
                    <div class="title">UI Darkness</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/ui_lightness.png" alt="UI Lightness" data-value="UI_Lightness" /></a>
                    <div class="title">UI Lightness</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/vader.png" alt="Vader" data-value="Vader" /></a>
                    <div class="title">Vader</div>
                </li>
            </ul>
            <div class="grouptitle f-widget-content">
                自定义
            </div>
            <ul class="main f-widget-content">
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/customtheme.png" alt="Custom Default" data-value="custom_default" /></a>
                    <div class="title">Custom Default</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/customtheme.png" alt="Bootstrap Pure" data-value="bootstrap_pure" /></a>
                    <div class="title">Bootstrap Pure</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/customtheme.png" alt="Custom Light Green" data-value="custom_light_green" /></a>
                    <div class="title">Custom Light Green</div>
                </li>
            </ul>

        <div class="grouptitle f-widget-content">
            自定义（图片背景）
            <span class="note">
                注：本分组的背景图片来自网络，版权归原作者！
            </span>
        </div>
            <ul class="main f-widget-content">
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_black_sky.png" alt="Image Black Sky" data-value="image_black_sky" />
                    </a>
                    <div class="title">Image Black Sky</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_green_rain.png" alt="Image Green Rain" data-value="image_green_rain" />
                    </a>
                    <div class="title">Image Green Rain</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_green_drip.png" alt="Image Green Drip" data-value="image_green_drip" />
                    </a>
                    <div class="title">Image Green Drip</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_green_poppy.png" alt="Image Green Poppy" data-value="image_green_poppy" />
                    </a>
                    <div class="title">Image Green Poppy</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_green_lotus.png" alt="Image Green Lotus" data-value="image_green_lotus" />
                    </a>
                    <div class="title">Image Green Lotus</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_blue_sky.png" alt="Image Blue Sky" data-value="image_blue_sky" />
                    </a>
                    <div class="title">Image Blue Sky</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_blue_star.png" alt="Image Blue Star" data-value="image_blue_star" />
                    </a>
                    <div class="title">Image Blue Star</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_blue_moon.png" alt="Image Blue Moon" data-value="image_blue_moon" />
                    </a>
                    <div class="title">Image Blue Moon</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_blue_drip.png" alt="Image Blue Drip" data-value="image_blue_drip" />
                    </a>
                    <div class="title">Image Blue Drip</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_purple_fog.png" alt="Image Purple Fog" data-value="image_purple_fog" />
                    </a>
                    <div class="title">Image Purple Fog</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_orange_light.png" alt="Image Orange Light" data-value="image_orange_light" />
                    </a>
                    <div class="title">Image Orange Light</div>
                </li>
                <li>
                    <a href="javascript:;">
                        <img src="../res/images/themes/image_red_dawn.png" alt="Image Red Dawn" data-value="image_red_dawn" />
                    </a>
                    <div class="title">Image Red Dawn</div>
                </li>
            </ul>
        </div>

        <div style="display: none;">
            <!-- 缓存背景图片 -->
            <img src="../res/themes/image_black_sky/sky.jpg" />
            <img src="../res/themes/image_blue_drip/drip.jpg" />
            <img src="../res/themes/image_blue_moon/moon.jpg" />
            <img src="../res/themes/image_blue_sky/sky.jpg" />
            <img src="../res/themes/image_blue_star/star.jpg" />
            <img src="../res/themes/image_green_drip/drip.jpg" />
            <img src="../res/themes/image_green_lotus/lotus.jpg" />
            <img src="../res/themes/image_green_poppy/poppy.jpg" />
            <img src="../res/themes/image_green_rain/rain.jpg" />
            <img src="../res/themes/image_orange_light/light.jpg" />
            <img src="../res/themes/image_purple_fog/fog.jpg" />
            <img src="../res/themes/image_red_dawn/dawn.jpg" />
        </div>

    </form>
    <script>
        F.ready(function () {
            // 选择主题窗口
            $('#themecontainer li').hover(function () {
                $(this).addClass('f-state-hover');
            }, function () {
                $(this).removeClass('f-state-hover');
            }).click(function () {
                //var imgSrcRegex = /([^\.\/]+)\.png$/.exec(imgSrc);
                var imgNode = $(this).find('img');

                var themeName = imgNode.attr('data-value');
                F.cookie('Theme', themeName, {
                    expires: 100  // 单位：天
                });

                var themeTitle = imgNode.attr('alt');
                F.cookie('Theme_Title', themeTitle, {
                    expires: 100  // 单位：天
                });

                top.window.location.reload();
            });


            // 初始化
            var themeName = F.cookie('Theme');
            if (!themeName) {
                themeName = 'Pure_Black';
            }
            themeName = themeName.toLowerCase();
            $('#themecontainer li').each(function () {
                var cnode = $(this);
                if (cnode.find('img').attr('data-value').toLowerCase() === themeName) {
                    cnode.addClass('f-state-active');
                } else {
                    cnode.removeClass('f-state-active');
                }
            });
        });
    </script>
</body>
</html>
