﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace FineUIPro.Examples.button
{
    public partial class button_buttongroup_pressgroup : PageBase
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
            }
            else
            {
                var arg = GetRequestEventArgument(); // 此函数所在文件：PageBase.cs
                if (arg.StartsWith("ButtonGroupItemPress$"))
                {
                    string buttonGroupID = arg.Substring("ButtonGroupItemPress$".Length);
                    ShowNotify(String.Format("分组 {0} 中按下的按钮：{1}", buttonGroupID, GetPressedButton(buttonGroupID)));
                }
            }
        }

        private string GetPressedButton(string buttonGroupID)
        {
            StringBuilder sb = new StringBuilder();

            ButtonGroup theGroup = FindControl(buttonGroupID) as ButtonGroup;

            if (theGroup != null)
            {
                sb.Append("<ul>");
                foreach (Button btn in theGroup.Items)
                {
                    if (btn.Pressed)
                    {
                        sb.AppendFormat("<li>{0}</li>", btn.Text);
                    }
                }
                sb.Append("</ul>");
            }

            return sb.ToString();
        }

    }
}
