import React from "react";
import Header from "../Components/header";

import "../Styles/pages/terms.css";

export default function TermsOfUsePage(){
  return(
    <div className="terms-page-content">
      <Header />
      <main>
        <h1>Política de privacidade e Termos de aceite</h1>
        <h2>última atualização: 09/02/2022</h2>
        <p>
          O REACLOUD, ferramenta elaborada pela organização acadêmica CRIE (Laboratório de Criatividade e Inovação para Educação) situada no endereço Rua Benjamin Constant, 989 - Porto, Pelotas - RS, Brasil - 96010-020 é uma plataforma online que permite ao Professores e Alunos (o “Usuário”) compartilharem Recursos Educacionais Abertos e consumirem os materiais educacionais publicados também licenciados de maneira aberta, onde a licença DEVE pertencer ao grupo de Licenças <a href="https://creativecommons.org/" target="_blank" rel="noreferrer">Creative Commons</a> as quais todas permitem ao mínimo que outros distribuam, remixem, adaptem ou criem obras derivadas.
        </p>
        <br/>
        <p>Este documento (a “Política de Privacidade”) estabelece as regras sobre a obtenção, o acesso, o armazenamento, a transferência, o uso e o enriquecimento de bases dos dados coletados dos USUÁRIOS, (as “Informações Pessoais”), por meio da adesão e da utilização da plataforma  REACLOUD.</p>
        <br/>
        <b>O ACESSO, CADASTRO E USO DA PLATAFORMA , MEDIANTE ACEITAÇÃO EXPRESSA DESTA POLÍTICA DE PRIVACIDADE, IMPLICAM A ACEITAÇÃO TOTAL DE SUAS DISPOSIÇÕES.</b>
        <br/>
        <section>
          <h3>OBTENÇÃO DOS DADOS</h3>
          <br />
          <ul>
            <li>Ao aceitar a Política de Privacidade, o USUÁRIO manifesta seu livre, expresso e informado consentimento com os termos aqui estipulados, a fim de permitir a obtenção, a utilização, o acesso, o uso, o compartilhamento, o armazenamento, a transferência e o enriquecimento das bases de dados do REACLOUD., e das empresas que pertencem ao mesmo grupo econômico, de acordo com as finalidades específicas descritas nesta Política.</li>
            <li>Os dados pessoais dos USUÁRIOS serão obtidos das seguintes maneiras:
              (i) No momento do cadastro do USUÁRIO na ferramenta através da autenticação externa do Google, onde o mesmo fornecerá se concordar com o cadastro seus dados de E-MAIL, NOME E FOTO (os mesmos cadastrados na plataforma Google).
              (ii) Quando inseridos ou submetidos voluntariamente pelo USUÁRIO ao utilizarem a Plataforma ;
            </li>
            <li>O REACLOUD também poderá utilizar tecnologias para coletar dados de comportamento dos USUÁRIOS visitando as páginas, sendo que nesse caso a instalação de arquivos nos equipamentos poderá não ser necessária. Esses dados incluem, dados da sessão como versão de sistema operacional, localização do dispositivo, navegador, horário de acesso, dentre outros aplicativos e softwares instalados. Além disso, ações efetuadas pelo usuário, páginas acessadas e datas e horários de cada ação também podem ser coletados.</li>
            <li>O REACLOUD não é responsável pela veracidade das informações prestadas pelo USUÁRIO ou pela sua desatualização, sendo de responsabilidade do USUÁRIO prestá-las com exatidão ou atualizá-las.</li>
            Obtemos os dados dos USUÁRIOS nos exatos termos descritos nesta Política de privacidade e para as finalidades nele indicadas.
          </ul>
        </section>
        <br/>
        <section>
          <h3>ARMAZENAMENTO DOS DADOS</h3>
          <br />
          <ul>
            <li>Os dados coletados serão armazenados em ambiente seguro e controlado. O REACLOUD se exime de quaisquer responsabilidades por eventuais danos e/ou prejuízos decorrentes de acessos não autorizados ocasionados por falhas, vírus ou quaisquer outras técnicas de invasão do banco de dados da Plataforma , salvo nos casos em que tiver dolo ou culpa, observado o estado da técnica disponível.</li>
            <li>Os dados obtidos do USUÁRIO poderão ser armazenados em servidor próprio do REACLOUD ou de terceiro contratado para esse fim, sejam eles alocados no Brasil ou no exterior, podendo ainda ser armazenados em nuvem (cloud computing) e/ou outras que surjam futuramente, visando sempre a melhoria e aperfeiçoamento das atividades da plataforma.</li>
            <li>Quando os dados forem armazenados em servidores localizados no exterior, o REACLOUD se compromete a respeitar todos os requisitos de transferência internacional de dados pessoais previstos na Lei Geral de Proteção de Dados e demais legislações vigentes.</li>
            <li>O REACLOUD poderá, para fins de auditoria e preservação de direitos, permanecer com o histórico de registro dos dados do USUÁRIO por períodos superiores a 5 (cinco) anos após a saída do mesmo da ferramenta, podendo excluí-los definitivamente segundo sua conveniência em prazo menor. Este prazo poderá ser estendido nas hipóteses em que a lei ou norma regulatória assim estabelecer, para atendimento a ordens judiciais ou para preservação de direitos.</li>
          </ul>
        </section>
        <br />
        <section>
          <h3>DISPOSIÇÕES GERAIS</h3>
          <br />
          <ul>
            <li>O USUÁRIO deverá entrar em contato em caso de qualquer dúvida com relação às disposições constantes desta Política de Privacidade por meio da Central de Suporte disponível no tiago.primo@inf.ufpel.edu.br</li>
            <li>O teor desta Política de Privacidade poderá ser atualizado ou modificado a qualquer momento, para esclarecer qualquer alteração nas regras da plataforma, ou para adequação e conformidade legal de disposição de lei ou norma que tenha força jurídica equivalente. Nestes casos, o USUÁRIO será notificado a respeito das mudanças para demonstrar seu consentimento com as alterações. </li>
          </ul>
        </section>
        <br />
        <section>
          <h3>UTILIZAÇÃO DOS DADOS</h3>
          <br />
          <ul>
            <li>Os dados do usuário listados acima serão utilizados para identificar sua identidade no momento de compartilhamento de recursos na plataforma.</li>
            <li>Os dados do usuário também serão utilizado para identificar sua identidade no momento de publicação de avaliações de recursos disponíveis na plataforma.</li>
            <li>Por fim, os dados serão também utilizados para otimização da experiência do usuário ao utilizar a plataforma, através de algorítimos de recomendação que através dos dados do usuário irão prever preferências do usuário para que recomendações personalizadas sejam realizadas.</li>
          </ul>
        </section>
        <br/>
        <section>
          <h3>SITES DE TERCEIRO</h3>
          <br />
          <ul>
            <li> Esta Política de Privacidade não contempla sites de terceiros. Não somos responsáveis pela privacidade, informações ou outras práticas de qualquer terceiro, incluindo qualquer terceiro operando qualquer site, ainda que acessível via link em nosso Site. A inclusão de um link no Site não implica endosso desse site por nós ou por nossas afiliadas.</li>
          </ul>
        </section>
      </main>
    </div>
  )
}