# fish completion for clight

complete -c clight -o f -x -d "Frames taken for each capture, Between 1 and 20"
complete -c clight -l frames -x -d "Frames taken for each capture, Between 1 and 20"
complete -c clight -o d -r -d "Path to webcam device. If empty, first matching device is used"
complete -c clight -l device -r -d "Path to webcam device. If empty, first matching device is used"
complete -c clight -l no-backlight-smooth -f -d "Disable smooth backlight transitions"
complete -c clight -l no-gamma-smooth -f  -d "Disable smooth gamma transitions"
complete -c clight -l no-dimmer-smooth-enter -f -d "Disable smooth dimmer transitions while entering dimmed state"
complete -c clight -l no-dimmer-smooth-exit -f -d "Disable smooth dimmer transitions while leaving dimmed state"
complete -c clight -l day-temp -x -d "Daily gamma temperature, between 1000 and 10000"
complete -c clight -l night-temp -x -d "Nightly gamma temperature, between 1000 and 10000"
complete -c clight -l lat -x -d "Your desired latitude"
complete -c clight -l lon -x -d "Your desired longitude"
complete -c clight -l sunrise -x -d "Force sunrise time for gamma correction"
complete -c clight -l sunset -x -d "Force sunset time for gamma correction"
complete -c clight -l no-gamma -f -d "Disable gamma correction tool"
complete -c clight -l no-dimmer -f -d "Disable dimmer tool"
complete -c clight -l no-dpms -f -d "Disable dpms tool"
complete -c clight -l no-backlight -f -d "Disable backlight module"
complete -c clight -l no-screen -f -d "Disable screen module (screen content based backlight adjustment)"
complete -c clight -l no-kbd -f -d "Disable keyboard backlight calibration"
complete -c clight -l dimmer-pct -x -d "Backlight level used while screen is dimmed, in percentage"
complete -c clight -l verbose -f -d "Enable verbose mode"
complete -c clight -l no-auto-calib -f -d "Disable screen backlight automatic calibration"
complete -c clight -l shutter-thres -x -d "Threshold to consider a capture as clogged"
complete -c clight -o v -f -d "Show version info"
complete -c clight -l version -f -d "Show version info"
complete -c clight -o c -r -d "Specify a conf file to be parsed"
complete -c clight -l conf-file -r -d "Specify a conf file to be parsed"
complete -c clight -l gamma-long-transition -f -d "Enable a very long smooth transition for gamma"
complete -c clight -l ambient-gamma -f -d "Enable screen temperature matching ambient brightness instead of time"
complete -c clight -o w -f -d "Enable wizard mode"
complete -c clight -l wizard -f -d "Enable wizard mode"
complete -c clight -o "?" -f -d "Show help message"
complete -c clight -l help -f -d "Show help message"
complete -c clight -l usage -f -d "Display brief usage message"
