---- Ukrainian language strings

local L = LANG.CreateLanguage("Українська")

--- General text used in various places
L.traitor    = "Зрадник"
L.detective  = "Детектив"
L.innocent   = "Невинний"
L.last_words = "Останні слова"

L.terrorists = "Терористи"
L.spectators = "Спостерігачі"

--- Round status messages
L.round_minplayers = "Недостатньо гравців, щоб розпочати новий раунд..."
L.round_voting     = "Триває голосування, новий раунд відкладено на {num} секунд..."
L.round_begintime  = "Новий раунд розпочнеться через {num} секунд. Приготуйтесь."
L.round_selected   = "Зрадників було обрано."
L.round_started    = "Раунд розпочато!"
L.round_restart    = "Раунд перезавантажено адміністратором."

L.round_traitors_one  = "Зрадник, ти один."
L.round_traitors_more = "Зрадник, ось твої союзники: {names}"

L.win_time         = "Час вичерпано. Зрадники програли."
L.win_traitor      = "Зрадники перемогли!"
L.win_innocent     = "Зрадники зазнали поразки!"
L.win_showreport   = "Подивімось на звіт раунду протягом {num} секунд."

L.limit_round      = "Ліміт раундів досягнуто. {mapname} завантажиться скоро."
L.limit_time       = "Ліміт часу вичерпано. {mapname} завантажиться скоро."
L.limit_left       = "Залишилося {num} раундів чи {time} хвилин перед зміною мапи на {mapname}."

--- Credit awards
L.credit_det_all   = "Детективи, ви були нагороджені {num} кредитами обладнання за вашу продуктивність."
L.credit_tr_all    = "Зрадники, ви були нагороджені {num} кредитами обладнання за вашу продуктивність."

L.credit_kill      = "Ви отримали {num} кредитів за вбивство {role}."

--- Karma
L.karma_dmg_full   = "Ваша карма складає {amount}, отже ви можете заподіяти максимальну шкоду у цьому раунді!"
L.karma_dmg_other  = "Ваша карма складає {amount}. У підсумку вся завдана вами шкода буде зменшена на {num}%"

--- Body identification messages
L.body_found       = "{finder} знаходить тіло {victim}. {role}"

-- The {role} in body_found will be replaced by one of the following:
L.body_found_t     = "Це був Зрадник!"
L.body_found_d     = "Це був Детектив."
L.body_found_i     = "Це був Невинний."

L.body_confirm     = "{finder} підтверджує смерть {victim}."

L.body_call        = "{player} викликає Детектива до тіла {victim}!"
L.body_call_error  = "Ви повинні підтвердити смерть цього гравця перед тим, як викликати Детектива!"

L.body_burning     = "Дідько! Це тіло все у вогні!"
L.body_credits     = "Ви знайшли {num} кредитів на цьому тілі!"

--- Menus and windows
L.close = "Закрити"
L.cancel = "Скасувати"

-- For navigation buttons
L.next = "Далі"
L.prev = "Назад"

-- Equipment buying menu
L.equip_title     = "Обладнання"
L.equip_tabtitle  = "Замовлення обладнання"

L.equip_status    = "Стан замовлення"
L.equip_cost      = "У вас залишилося {num} кредитів."
L.equip_help_cost = "Кожне обладнання, яке ви купуєте, коштує 1 кредит."

L.equip_help_carry = "Ви можете купувати лише те, для чого у вас достатньо місця."
L.equip_carry      = "Ви можете отримати це обладнання."
L.equip_carry_own  = "Ви вже отримали це обладнання."
L.equip_carry_slot = "Ви вже маєте зброю у слоті {slot}."

L.equip_help_stock = "Деяке обладнання ви можете купити лише один раз за раунд."
L.equip_stock_deny = "Цього обладнання більше немає."
L.equip_stock_ok   = "Це обладнання досі присутнє."

L.equip_custom     = "Користувацьке обладнання, додане цим сервером."

L.equip_spec_name  = "Ім’я"
L.equip_spec_type  = "Тип"
L.equip_spec_desc  = "Опис"

L.equip_confirm    = "Придбати"

-- Disguiser tab in equipment menu
L.disg_name      = "Маскування"
L.disg_menutitle = "Керування Маскуванням"
L.disg_not_owned = "У вас немає Маскування!"
L.disg_enable    = "Застосувати Маскування"

L.disg_help1     = "Коли ваше маскування активне, ваше ім’я, здоров’я та карма не буде показуватися коли хтось дивиться на вас. Ви також будете сховані від радара Детектива."
L.disg_help2     = "Натисніть Numpad Enter, щоб увімкнути маскування без використання меню. Ви також можете призначити іншу клавішу для 'ttt_toggle_disguise' використовуючи консоль розробника."

-- Radar tab in equipment menu
L.radar_name      = "Радар"
L.radar_menutitle = "Керування Радаром"
L.radar_not_owned = "У вас немає Радара!"
L.radar_scan      = "Виконати сканування"
L.radar_auto      = "Автоматичне сканування"
L.radar_help      = "Результати сканування показуватимуться {num} секунд, після чого Радар буде перезаряджено і його можна буде використати знову."
L.radar_charging  = "Ваш Радар досі перезаряджається!"

-- Transfer tab in equipment menu
L.xfer_name       = "Переказ"
L.xfer_menutitle  = "Переказ кредитів"
L.xfer_no_credits = "У вас немає кредитів для переказу!"
L.xfer_send       = "Переказати кредит"
L.xfer_help       = "Ви можете переказувати кредити лише іншому {role}."

L.xfer_no_recip   = "Одержувач недійсний, переказ кредиту скасовано."
L.xfer_no_credits = "Недостатньо кредитів для переказу."
L.xfer_success    = "Переказ кредитів гравцю {player} виконано."
L.xfer_received   = "{player} надав вам кредити в розмірі {num} штук."

-- Radio tab in equipment menu
L.radio_name      = "Радіо"
L.radio_help      = "Натисніть кнопку, щоб радіо відтворювало обраний звук."
L.radio_notplaced = "Ви повинні розташувати Радіо, щоб відтворювати на ньому звук."

-- Radio soundboard buttons
L.radio_button_scream  = "Крик"
L.radio_button_expl    = "Вибух"
L.radio_button_pistol  = "Постріли пістолета"
L.radio_button_m16     = "Постріли M16"
L.radio_button_deagle  = "Постріли Deagle"
L.radio_button_mac10   = "Постріли MAC10"
L.radio_button_shotgun = "Вогонь з дробовика"
L.radio_button_rifle   = "Постріли гвинтівки"
L.radio_button_huge    = "Вогонь з H.U.G.E"
L.radio_button_c4      = "Пікання C4"
L.radio_button_burn    = "Горіння"
L.radio_button_steps   = "Кроки"


-- Intro screen shown after joining
L.intro_help     = "Якщо ви новачок, то натисніть F1 задля інструкції!"

-- Radiocommands/quickchat
L.quick_title   = "Швидкі повідомлення"

L.quick_yes     = "Так."
L.quick_no      = "Ні."
L.quick_help    = "Допоможіть!"
L.quick_imwith  = "Я поряд з {player}."
L.quick_see     = "Я бачу {player}."
L.quick_suspect = "{player} виглядає підозріло."
L.quick_traitor = "{player} є зрадником!"
L.quick_inno    = "{player} є невинним."
L.quick_check   = "Є хто живий?"

-- {player} in the quickchat text normally becomes a player nickname, but can
-- also be one of the below.  Keep these lowercase.
L.quick_nobody    = "ніхто"
L.quick_disg      = "хтось замаскований"
L.quick_corpse    = "невпізнане тіло"
L.quick_corpse_id = "Тіло {player}"


--- Body search window
L.search_title  = "Результати Огляду Тіла"
L.search_info   = "Інформація"
L.search_confirm = "Підтвердити Смерть"
L.search_call   = "Викликати Детектива"

-- Descriptions of pieces of information found
L.search_nick   = "Це тіло {player}."

L.search_role_t = "Ця особа була Зрадником!"
L.search_role_d = "Ця особа була Детективом."
L.search_role_i = "Ця особа була невинним терористом."

L.search_words  = "Щось вам підказує, що одними з останніх слів цієї особи були: '{lastwords}'"
L.search_armor  = "Ця особа носила особливий бронежилет."
L.search_disg   = "Ця особа мала при собі пристрій, який міг приховати її дані."
L.search_radar  = "Ця особа мала деякий прилад, схожий на радар. Цей пристрій більше не працює."
L.search_c4     = "У кишені ви знайшли нотатку. Воно затверджує, що вам необхідно обрізати провід {num}, щоб безпечно знешкодити вибухівку."

L.search_dmg_crush  = "Багато кісток цієї особи зламані. Схоже на те, що удар важкого предмета вбив її."
L.search_dmg_bullet = "Очевидно, що цю особу розстріляли."
L.search_dmg_fall   = "Ця особа розбилася об землю."
L.search_dmg_boom   = "Рани та обпалений одяг цієї особи вказують на те, що її смерть є наслідком від вибуху."
L.search_dmg_club   = "Тіло в синцях і побоях. Цю особу неодмінно забили до смерті."
L.search_dmg_drown  = "Тіло має ознаки утоплення."
L.search_dmg_stab   = "Ця особа отримала ножові поранення і порізи, перш ніж встигла стекти кров."
L.search_dmg_burn   = "Пахне смаженим терористом десь поряд..."
L.search_dmg_tele   = "Схоже, ДНК цієї особи було зашифровано випромінюванням тахіонів!"
L.search_dmg_car    = "Коли цей терорист переходив дорогу, на нього наїхав безрозсудний водій."
L.search_dmg_other  = "Ви не можете визначити конкретну причину смерті цього терориста."

L.search_weapon = "Ви дослідили, що для вбивства було використано {weapon}."
L.search_head   = "Смертельний постріл – постріл у голову. Навіть й немає часу закричати"
L.search_time   = "Ця особа померла приблизно за {time} перед тим, як ви її оглянули."
L.search_dna    = "Отримайте зразок ДНК вбивці за допомогою сканера ДНК. Зразок ДНК розпадеться приблизно через {time}."

L.search_kills1 = "Ви знайшли список вбивств, який підтверджує смерть {player}."
L.search_kills2 = "Ви знайшли список вбивств із цими іменами:"
L.search_eyes   = "Використовуючи свої навички детектива, ви дізналися останнього, кого бачила ця особа: {player}. Убивця чи збіг обставин?"


-- Scoreboard
L.sb_playing    = "Ви граєте на..."
L.sb_mapchange  = "Мапа зміниться через {num} раундів або через {time}"

L.sb_mia        = "Зниклі безвісти"
L.sb_confirmed  = "Смерть підтверджено"

L.sb_ping       = "Пінг"
L.sb_deaths     = "Смерті"
L.sb_score      = "Рахунок"
L.sb_karma      = "Карма"

L.sb_info_help  = "Огляньте тіло цього гравця, і ви зможете переглянути результати тут."

L.sb_tag_friend = "ДРУГ"
L.sb_tag_susp   = "ПІДОЗРЮВАНИЙ"
L.sb_tag_avoid  = "УНИКАТИ"
L.sb_tag_kill   = "ВБИТИ"
L.sb_tag_miss   = "ЗНИКЛИЙ"

--- Help and settings menu (F1)

L.help_title = "Допомога та Налаштування"

-- Tabs
L.help_tut     = "Посібник"
L.help_tut_tip = "Як працює TTT: 6 кроків"

L.help_settings = "Налаштування"
L.help_settings_tip = "Налаштування на стороні клієнта"

-- Settings
L.set_title_gui = "Налаштування інтерфейсу"

L.set_tips      = "Показувати підказки щодо гри внизу екрана під час спостерігання"

L.set_startpopup = "Тривалість вікна, що спливає на початку раунду"
L.set_startpopup_tip = "Коли розпочинається раунд, унизу екрана на кілька секунд з’явиться вікно, що спливає. Змініть час, який воно буде показуватися тут."

L.set_cross_opacity   = "Непрозорість прицілу під час прицілювання"
L.set_cross_disable   = "Повністю вимкнути приціл"
L.set_minimal_id      = "Мінімалістична ідентифікація цілі на прицілі (не показувати карму, підказки тощо)"
L.set_healthlabel     = "Показувати стан здоров’я на панелі здоров’я"
L.set_lowsights       = "Опускати зброю при застосуванні прицілу"
L.set_lowsights_tip   = "Увімкнути спускання моделі зброї униз під час використання прицілу. Це полегшить спостереження за вашою ціллю, але виглядатиме менш реалістично."
L.set_fastsw          = "Швидке перемикання зброї"
L.set_fastsw_tip      = "Увімкнути перемикання між зброєю без підтверджувального натискання."
L.set_fastsw_menu     = "Увімкнути меню перемикання зброї зі швидкою зміною зброї"
L.set_fastswmenu_tip  = "Коли ввімкнено швидке перемикання зброї, буде з’являтися меню перемикача."
L.set_wswitch         = "Вимкнути автоматичне закриття меню перемикання зброї"
L.set_wswitch_tip     = "За замовчуванням меню перемикання зброї автоматично закривається через кілька секунд після останнього прокручування. Увімкніть це, щоб воно не закривалося."
L.set_cues            = "Відтворювати звукові сигнали, коли раунд починається або закінчується"


L.set_title_play    = "Налаштування гри"

L.set_specmode      = "Режим Спостерігача (завжди залишатися спостерігачем)"
L.set_specmode_tip  = "Цей режим не дозволить вам відродитися, коли починається новий раунд, натомість ви залишатиметеся спостерігачем."
L.set_mute          = "Заглушити живих гравців після смерті"
L.set_mute_tip      = "Увімкніть, щоб заглушити живих гравців коли ви мертві або спостерігаєте."


L.set_title_lang    = "Налаштування мови"

-- It may be best to leave this next one english, so english players can always
-- find the language setting even if it's set to a language they don't know.
L.set_lang          = "Вибрати мову:"


--- Weapons and equipment, HUD and messages

-- Equipment actions, like buying and dropping
L.buy_no_stock    = "Цієї зброї більше немає: ви вже купували її цього раунду."
L.buy_pending     = "Ви зараз маєте замовлення, очікуйте отримання."
L.buy_received    = "Ви отримали своє особливе обладнання."

L.drop_no_room    = "Немає місця, щоб викинути вашу зброю!"

L.disg_turned_on  = "Маскування активовано!"
L.disg_turned_off = "Маскування деактивовано."

-- Equipment item descriptions
L.item_passive    = "Предмет з пасивним ефектом"
L.item_active     = "Предмет активного користування"
L.item_weapon     = "Зброя"

L.item_armor      = "Бронежилет"
L.item_armor_desc = [[
Зменшує шкоду від куль на 30%, коли
ви його маєте.
Стандартне обладнання для Детективів.]]

L.item_radar      = "Радар"
L.item_radar_desc = [[
Дозволяє сканувати ознаки життя.
Починає автоматичне сканування, щойно ви
придбаєте його. Додатково налаштуйте його у
вкладці Радара.]]

L.item_disg       = "Маскування"
L.item_disg_desc  = [[
При вмиканні приховує вашу інформацію. Також 
уникає бути людиною, яку востаннє бачила
жертва. Перемикайте маскування у відповідній 
вкладці цього меню або натисніть 
клавішу Numpad Enter.]]

-- C4
L.c4_hint         = "Натисніть {usekey}, щоб закласти або знешкодити."
L.c4_no_disarm    = "Ви не можете знешкодити С4 іншого зрадника поки він не загинув."
L.c4_disarm_warn  = "Вибухівку C4, яку ви заклали, знешкодили."
L.c4_armed        = "Ви успішно заклали бомбу."
L.c4_disarmed     = "Ви успішно знешкодили бомбу."
L.c4_no_room      = "Ви не можете переносити цю C4."

L.c4_desc         = "Потужна вибухівка з годинниковим механізмом."

L.c4_arm          = "Закласти C4"
L.c4_arm_timer    = "Таймер"
L.c4_arm_seconds  = "Секунд до вибуху:"
L.c4_arm_attempts = "У разі спроби знешкодити, перерізання {num} з 6 дротів приведе до миттєвого вибуху."

L.c4_remove_title    = "Видалення"
L.c4_remove_pickup   = "Підняти C4"
L.c4_remove_destroy1 = "Знищити C4"
L.c4_remove_destroy2 = "Підтвердити"

L.c4_disarm       = "Знешкодити C4"
L.c4_disarm_cut   = "Натисніть, щоб перерізати {num} дріт"

L.c4_disarm_t     = "Переріжте дріт, щоб знешкодити вибухівку. Ви граєте за зрадника, отже кожен дріт буде безпечним."
L.c4_disarm_owned = "Переріжте дріт, щоб знешкодити вибухівку. Це ваша вибухівка, отже кожен перерізаний дріт знешкодить її."
L.c4_disarm_other = "Переріжте дріт, щоб знешкодити вибухівку. Вона вибухне, якщо ви зробите помилку!"

L.c4_status_armed    = "ЗАКЛАДЕНА"
L.c4_status_disarmed = "ЗНЕШКОД-\nЖЕНА"

-- Visualizer
L.vis_name        = "Візуалізатор"
L.vis_hint        = "Натисніть {usekey}, щоб підібрати (Лише для Детективів)."

L.vis_help_pri    = "{primaryfire} кинути активований пристрій."

L.vis_desc        = [[
Пристрій, який вміє візуалізувати злочини.
Проаналізуйте тіло, щоб дізнатися 
як жертва була вбита, але тільки у випадку,
якщо особа загинула від пострілу.]]

-- Decoy
L.decoy_name      = "Приманка"
L.decoy_no_room   = "Ви не можете переносити цю приманку."
L.decoy_broken    = "Вашу Приманку знищено!"

L.decoy_help_pri  = "{primaryfire} встановити Приманку."

L.decoy_desc      = [[
Показує хибну мітку на радарі детективів,
ламає ДНК сканери таким чином, щоб вони 
вказували на місце приманки, а не на 
ваше справжнє місце перебування.]]

-- Defuser
L.defuser_name    = "Знешкоджувач"
L.defuser_help    = "{primaryfire} знешкоджує вибрану вибухівку C4."

L.defuser_desc    = [[
Миттєво знешкоджує вибухівку C4.
Користуйтесь скільки забажаєте. Вибухівку C4 
буде легше помітити якщо ви маєте це при собі.]]

-- Flare gun
L.flare_name      = "Сигнальний пістолет"
L.flare_desc      = [[
Можна використовувати для спалювання тіл,
щоб їх ніколи більше не знайшли. Обмежена
кількість набоїв.
Спалення тіл створює характерний звук.]]

-- Health station
L.hstation_name   = "Оздоровча Станція"
L.hstation_hint   = "Натисніть {usekey}, щоб вилікуватися. Залишок: {num}."
L.hstation_broken = "Вашу Оздоровчу Станцію знищено!"
L.hstation_help   = "{primaryfire}, щоб розташувати Оздоровчу Станцію."

L.hstation_desc   = [[
Розташувавши це ви зможете лікувати інших
людей. Повільна регенерація. Кожен може 
користуватися нею, та вона може бути зламана.
Використовуйте її, щоб зібрати
ДНК користувачів.]]

-- Knife
L.knife_name      = "Ніж"
L.knife_thrown    = "Кинутий ніж"

L.knife_desc      = [[
Миттєво та тихо вбиває поранені цілі,
але має лише одноразове використання.
Може бути кинутим за допомогою 
альтернативної атаки.]]

-- Poltergeist
L.polter_desc     = [[
Встановлює двигуни на об’єкти та 
насильно штовхає їх навколо.
Енергетичні вибухи завдають шкоди
людям, які знаходяться поряд.]]

-- Radio
L.radio_broken    = "Ваше Радіо знищено!"
L.radio_help_pri  = "{primaryfire} встановити Радіо."

L.radio_desc      = [[
Відтворює звуки, щоб відвернути увагу гравців.
Поставте Радіо десь неподалік, а потім 
відтворюйте на ньому звуки за допомогою 
відповідної вкладки.]]

-- Silenced pistol
L.sipistol_name   = "Пістолет із глушником"

L.sipistol_desc   = [[
Малошумний пістолет, використовує звичайні
пістолетні набої.
Жертви не кричатимуть, коли їх вбиватимуть.]]

-- Newton launcher
L.newton_name     = "Гармата Ньютона"

L.newton_desc     = [[
Відштовхує людей з безпечної відстані.
Нескінченні набої, але повільне перезавантаження.]]

-- Binoculars
L.binoc_name      = "Окуляр"
L.binoc_desc      = [[
Дозволяє бачити та розпізнавати тіла
на великій відстані.
Необмежене використання, але ідентифікація
займає декілька секунд.]]

L.binoc_help_pri  = "{primaryfire} ідентифікувати тіло."
L.binoc_help_sec  = "{secondaryfire} змінити режим приближення."

-- UMP
L.ump_desc        = [[
Експериментальний SMG, що дезорієнтує цілі.
Використовує стандартні набої SMG.]]

-- DNA scanner
L.dna_name        = "Сканер ДНК"
L.dna_identify    = "Тіло необхідно ідентифікувати, щоб отримати ДНК убивці."
L.dna_notfound    = "Зразок ДНК на цілі не знайдено."
L.dna_limit       = "Досягнуто ліміт пам’яті. Видаліть старі зразки, щоб додати нові."
L.dna_decayed     = "Зразок ДНК вбивці розпався."
L.dna_killer      = "З тіла взято зразок ДНК вбивці!"
L.dna_no_killer   = "ДНК не вдалося відновити (вбивця вийшов з гри?)."
L.dna_armed       = "Ця бомба працює! Спочатку знешкодьте його!"
L.dna_object      = "Зібрано {num} нових зразків ДНК з об’єкта."
L.dna_gone        = "ДНК поряд не виявлено."

L.dna_desc        = [[
Збирайте зразки ДНК і використовуйте 
їх, щоб знайти власника ДНК.
Використовуйте на свіжих тілах,
щоб отримати ДНК убивці й знайти його.]]

L.dna_menu_title  = "Керувати скануванням ДНК"
L.dna_menu_sample = "Зразок ДНК знайдено на {source}"
L.dna_menu_remove = "Видалити вибране"
L.dna_menu_help1  = "Це зразки ДНК, які ви зібрали."
L.dna_menu_help2  = [[
Після заряджання ви можете просканувати місце
перебування гравця, якому належить обраний 
зразок ДНК. Пошук віддалених цілей забирає 
більше енергії.]]

L.dna_menu_scan   = "Сканувати"
L.dna_menu_repeat = "Автоматизація"
L.dna_menu_ready  = "ГОТОВИЙ"
L.dna_menu_charge = "ЗАРЯДЖАЄТЬСЯ"
L.dna_menu_select = "ВИБЕРІТЬ ЗРАЗОК"

L.dna_help_primary   = "Використовуйте {primaryfire}, щоб зібрати зразок ДНК"
L.dna_help_secondary = "Використовуйте {secondaryfire}, щоб відкрити панель сканування"

-- Magneto stick
L.magnet_name     = "Магнітна палиця"
L.magnet_help     = "Використовуйте {primaryfire}, щоб прикріпити тіло до поверхні."

-- Grenades and misc
L.grenade_smoke   = "Димова шашка"
L.grenade_fire    = "Запалювальна граната"

L.unarmed_name    = "Сховати все"
L.crowbar_name    = "Лом"
L.pistol_name     = "Пістолет"
L.rifle_name      = "Гвинтівка"
L.shotgun_name    = "Дробовик"

-- Teleporter
L.tele_name       = "Телепорт"
L.tele_failed     = "Телепортування невдале."
L.tele_marked     = "Локація телепортації встановлена."

L.tele_no_ground  = "Телепортація неможлива поки під ногами немає поверхні!"
L.tele_no_crouch  = "Телепортація неможлива навсидячки!"
L.tele_no_mark    = "Локація телепортації не встановлена. Позначте пункт призначення перед телепортацією."

L.tele_no_mark_ground = "Неможливо позначити локацію телепортації поки під ногами немає поверхні!"
L.tele_no_mark_crouch = "Неможливо позначити локацію телепортації навсидячки!"

L.tele_help_pri   = "Використовуйте {primaryfire}, щоб телепортуватися до позначеної локації."
L.tele_help_sec   = "Використовуйте {secondaryfire}, щоб позначити поточну локацію."

L.tele_desc       = [[
Телепортація до попередньо позначеного місця.
Телепортація відтворює шум.
Кількість використань обмежена.]]

-- Ammo names, shown when picked up
L.ammo_pistol     = "Набої 9 мм"

L.ammo_smg1       = "SMG набої"
L.ammo_buckshot   = "Набої до дробовика"
L.ammo_357        = "Набої до гвинтівки"
L.ammo_alyxgun    = "Набої до Deagle"
L.ammo_ar2altfire = "Набої сигнального пістолета"
L.ammo_gravity    = "Набої Полтергейста"


--- HUD interface text

-- Round status
L.round_wait   = "Очікування"
L.round_prep   = "Підготовка"
L.round_active = "В процесі"
L.round_post   = "Кінець"

-- Health, ammo and time area
L.overtime     = "ОВЕРТАЙМ"
L.hastemode    = "РЕЖИМ ПОСПІХУ"

-- TargetID health status
L.hp_healthy   = "Здоровий"
L.hp_hurt      = "Ушкоджений"
L.hp_wounded   = "Поранений"
L.hp_badwnd    = "Важко поранений"
L.hp_death     = "При смерті"


-- TargetID karma status
L.karma_max    = "Поважний"
L.karma_high   = "Неотесаний"
L.karma_med    = "Дурний"
L.karma_low    = "Небезпечний"
L.karma_min    = "Безвідповідальний"

-- TargetID misc
L.corpse       = "Тіло"
L.corpse_hint  = "Натисніть {usekey}, щоб оглянути. {walkkey} + {usekey}, щоб оглянути непомітно."

L.target_disg  = " (ЗАМАСКОВАНИЙ)"
L.target_unid  = "Невпізнане тіло"

L.target_traitor = "ЗРАДНИК"
L.target_detective = "ДЕТЕКТИВ"

L.target_credits = "Огляньте, щоб отримати невитрачені кредити"

-- Traitor buttons (HUD buttons with hand icons that only traitors can see)
L.tbut_single  = "Одноразове використання"
L.tbut_reuse   = "Багаторазове використання"
L.tbut_retime  = "Можна використати ще раз через {num} секунд"
L.tbut_help    = "Натисніть {key}, щоб активувати"

-- Equipment info lines (on the left above the health/ammo panel)
L.disg_hud     = "Замаскований. Ваше ім’я приховано."
L.radar_hud    = "Радар придатний до сканування через: {time}"

-- Spectator muting of living/dead
L.mute_living  = "Живі гравці заглушені"
L.mute_specs   = "Спостерігачі заглушені"
L.mute_all     = "Всі заглушені"
L.mute_off     = "Ніхто не заглушений"

-- Spectators and prop possession
L.punch_title  = "ШТОВХ-О-МЕТР"
L.punch_help   = "Клавіші пересування або стрибка: штовхнути об’єкт. Клавіша присідання: залишити предмет."
L.punch_bonus  = "Ваш поганий рахунок знизив ваш ліміт штовх-о-метра на {num}"
L.punch_malus  = "Ваш хороший рахунок збільшив ваш ліміт штовх-о-метра на {num}!"

L.spec_help    = "Клацніть, щоб спостерігати за гравцями, або натисніть {usekey} на фізичний об’єкт, щоб керувати ним."

--- Info popups shown when the round starts

-- These are spread over multiple lines, hence the square brackets instead of
-- quotes. That's a Lua thing. Every line break (enter) will show up in-game.
L.info_popup_innocent = [[Ви невинний терорист! Але навколо є Зрадники...
Кому можна довіряти, а хто нашпигує вас кулями?
Бережіть себе та працюйте разом із товаришами, щоб залишитися живим!]]

L.info_popup_detective = [[Ви детектив! Штаб Терористів надав вам спеціальні ресурси для пошуку зрадників.
Використовуйте їх, щоб допомогти невинним, але будьте обережні:
зрадники будуть шукати вас, щоб знищити першими!
Натисніть {menukey}, щоб отримати своє обладнання!]]

L.info_popup_traitor_alone = [[Ви ЗРАДНИК! У цьому раунді у вас немає побратимів-зрадників.
Вбийте всіх інших, щоб перемогти!
Натисніть {menukey}, щоб отримати спеціальне обладнання!]]

L.info_popup_traitor = [[Ви ЗРАДНИК! Працюйте з побратимами-зрадниками, щоб вбити всіх інших.
Але будьте обережні, в інакшому випадку вас можуть розкрити...
Це ваші товариші:
{traitorlist}
Натисніть {menukey}, щоб отримати спеціальне обладнання!]]

--- Various other text
L.name_kick = "Гравця автоматично видалено з гри через зміну імені під час раунду."

L.idle_popup = [[Ви були неактивні протягом {num} секунд і в результаті були переведені в режим Спостерігача. Поки ви перебуваєте в цьому режимі, ви не з’явитися у грі з початком нового раунду.
Ви можете будь-коли перемкнути режим Спостерігача, натиснувши {helpkey} і знявши прапорець у вкладці Налаштувань. Ви також можете зняти його прямо зараз.]]

L.idle_popup_close = "Нічого не робити"
L.idle_popup_off   = "Вимкнути режим спостерігача зараз же"

L.idle_warning = "Попередження: ви виглядаєте неактивним/відсутнім, вас змусять спостерігати поки ви не проявите активність!"

L.spec_mode_warning = "Ви перебуваєте в режимі Спостерігача і не з’явиться з початком раунду. Щоб вимкнути цей режим, натисніть F1, перейдіть до налаштувань і зніміть прапорець з «Режим Спостерігача»."


--- Tips, shown at bottom of screen to spectators

-- Tips panel
L.tips_panel_title = "Поради"
L.tips_panel_tip   = "Порада:"

-- Tip texts

L.tip1 = "Зрадники можуть тихо оглянути тіло без підтвердження смерті. Для цього утримуйте {walkkey} і натисніть {usekey} дивлячись на тіло."

L.tip2 = "Закладення вибухівки C4 з довшим таймером збільшить кількість дротів, які змусять її миттєво вибухнути, коли невинний спробує її знешкодити. Крім того, звуковий сигнал буде тихіше і рідше."

L.tip3 = "Детективи можуть оглянути тіло, щоб знайти «відбиток вбивці в очах жертви». Цим відбитком буде остання людина, яку бачив мертвий. Це не обов’язково повинен бути вбивця, якщо жертву вбили зі спини."

L.tip4 = "Ніхто окрім зрадників не дізнається, що ви померли, доки не знайдуть ваше тіло та не ідентифікують його."

L.tip5 = "Коли Зрадник вбиває Детектива, він миттєво отримує винагороду у вигляді кредитів."

L.tip6 = "Коли Зрадник помирає, усі Детективи отримують кредити обладнання."

L.tip7 = "Коли Зрадники досягнуть значного прогресу у вбивстві невинних, вони отримають кредити обладнання як винагороду."

L.tip8 = "Зрадники та Детективи можуть збирати невитрачені кредити обладнання з мертвих тіл інших Зрадників та Детективів."

L.tip9 = "Полтергейст може перетворити будь-який фізичний об’єкт на смертоносний снаряд. Кожен удар супроводжується вибухом енергії, що завдає шкоди будь-кому поблизу."

L.tip10 = "Як Зрадник або Детектив, слідкуйте за червоними повідомленнями у верхньому правому куті. Вони можуть бути важливими для вас."

L.tip11 = "Майте на увазі, що як зрадник або як детектив ви отримаєте додаткові кредити обладнання, якщо ви та ваші товариші будуть мати успіх у виконанні своїх завдань. Не забудьте їх витратити!"

L.tip12 = "Сканер ДНК детективів можна використовувати, щоб зібрати зразки ДНК зі зброї та предметів, проаналізувавши їх, знайти місцеперебування гравця, який їх використовував. Корисно, коли ви можете отримати зразок з тіла або знешкодженої вибухівки C4!"

L.tip13 = "Коли ви поблизу людини, яку вбиваєте, частина вашої ДНК залишається на тілі жертви. Цю ДНК можна використати за допомогою сканера ДНК детектива, щоб визначити ваше поточне місцеперебування. Краще сховати тіло після того, як ви когось зарізали!"

L.tip14 = "Чим далі ви знаходитесь від того, кого вбиваєте, тим швидше ваш зразок ДНК на його тілі розпадеться."

L.tip15 = "Ви зрадник і збираєтесь стріляти? Спробуйте Маскування. Якщо ви промахнулися, біжіть у безпечне місце, вимкніть Маскування, і ніхто не дізнається, що це ви стріляли в них."

L.tip16 = "Як Зрадник, Телепорт може допомогти вам втекти, коли вас переслідують, і дозволяє швидко подорожувати великою мапою. Переконайтеся, що у вас завжди є позначена безпечна локація."

L.tip17 = "Всі невинні згруповані і їх важко розділити? Спробуйте за допомогою Радіо відтворити звуки C4 або перестрілки, щоб відвести деяких із них."

L.tip18 = "Як Зрадник, ви можете відтворювати звуки через меню обладнання після розміщення Радіо. Додайте кілька звуків у чергу, натиснувши кілька кнопок у потрібному вам порядку."

L.tip19 = "Як Детектив, якщо у вас залишилися кредити, ви можете дати надійному Невинному Знешкоджувач. Тоді ви можете витратити свій час на більш серйозне розслідування та залишити ризиковане знешкодження бомби йому."

L.tip20 = "Окуляр Детектива дозволяє здійснювати пошук та ідентифікацію тіл на великій відстані. Погана новина, якщо зрадники сподівалися використати тіло як приманку. Користуючись окуляром, детектив неозброєний і розсіяний, користуйтеся цим!"

L.tip21 = "Оздоровча Станція Детективів дозволяє пораненим гравцям лікуватися. Звичайно, ті поранені могли бути зрадниками..."

L.tip22 = "Оздоровча Станція записує зразок ДНК кожного, хто нею користувався. Детективи можуть використовувати сканер ДНК, щоб дізнатися, хто зцілявся."

L.tip23 = "На відміну від зброї та вибухівки C4, радіообладнання Зрадників не містить зразки ДНК людини, яка його підклала. Не хвилюйтеся, що детективи знайдуть їх та розкриють ваше прикриття."

L.tip24 = "Натисніть {helpkey}, щоб переглянути короткий посібник або змінити деякі специфічні налаштування TTT. Наприклад, ви можете назавжди вимкнути ці підказки саме там."

L.tip25 = "Коли детектив огляне тіло, результат дослідження стане доступним для всіх гравців через табло рахунку. Для цього натисніть на ім’я померлої людини."

L.tip26 = "На табло рахунку лупа поруч з іменем гравця вказує на те, що у вас є інформація про нього. Якщо значок яскравий, дані надходять від детектива та можуть містити додаткову інформацію."

L.tip27 = "Тіла з лупою після імені гравця вказують на те, що їх було оглянуто детективом. Інформація про огляд доступна всім іншим гравцям через табло рахунку."

L.tip28 = "Спостерігачі можуть натискати {mutekey}, щоб вибрати заглушку іншим спостерігачам або живим гравцям."

L.tip29 = "Якщо на сервері встановлено додаткову мову, ви можете будь-коли перемкнутися на неї у меню «Налаштування»."

L.tip30 = "Швидкі повідомлення або радіокоманди можна використовувати, натиснувши {zoomkey}."

L.tip31 = "Як спостерігач натисніть {duckkey}, щоб розблокувати курсор миші й мати можливість натискати кнопки на цій панелі підказок. Натисніть {duckkey} ще раз, щоб повернутися до керування мишею."

L.tip32 = "Альтернативна атака лома штовхає інших гравців."

L.tip33 = "Стрільба через приціл зброї дещо збільшить вашу точність і зменшить віддачу. Присідання такого не робить."

L.tip34 = "Димові шашки ефективні в закритих приміщеннях для створення плутанини в людних місцях."

L.tip35 = "Як Зрадник, пам’ятайте, що ви можете носити тіла та ховати їх від допитливих очей невинних та детективів."

L.tip36 = "Посібник, доступний у розділі {helpkey}, містить огляд найважливіших клавіш у грі."

L.tip37 = "На табло рахунку клацніть ім’я живого гравця, щоб ви могли вибрати для нього тег, наприклад «підозрюваний» або «друг». Цей тег з’явиться, коли вони будуть знаходитись під прицілом."

L.tip38 = "Багато предметів розміщеного обладнання (наприклад, C4, радіо) можна прикріпити до стін за допомогою альтернативної атаки."

L.tip39 = "Вибухівка C4, яка вибухає через помилку під час знешкодження, має менший вибух, ніж C4, яка досягає нуля на своєму часовому пристрої."

L.tip40 = "Якщо над таймером раунду написано «РЕЖИМ ПОСПІХУ», раунд спочатку триватиме лише кілька хвилин, але з кожною смертю доступний час буде збільшуватися (як для захоплення точки в TF2). Цей режим чинить тиск на зрадників, щоб вони продовжували діяти."

--- Round report

L.report_title = "Доповідь про раунд"

-- Tabs
L.report_tab_hilite = "Основні моменти"
L.report_tab_hilite_tip = "Основні моменти раунду"
L.report_tab_events = "Події"
L.report_tab_events_tip = "Журнал подій, які відбулися в цьому раунді"
L.report_tab_scores = "Результати гравців"
L.report_tab_scores_tip = "Рахунок, набраний кожним гравцем у цьому раунді"

-- Event log saving
L.report_save     = "Зберегти .txt"
L.report_save_tip = "Зберігає журнал подій у текстовий файл"
L.report_save_error  = "Немає даних журналу подій для збереження."
L.report_save_result = "Журнал подій збережено в:"

-- Big title window
L.hilite_win_traitors = "ЗРАДНИКИ ПЕРЕМОГЛИ"
L.hilite_win_innocent = "НЕВИННІ ПЕРЕМОГЛИ"

L.hilite_players1 = "{numplayers} гравців взяло участь, {numtraitors} з яких були зрадниками"
L.hilite_players2 = "{numplayers} гравців взяло участь, один з них був зрадником"

L.hilite_duration = "Раунд тривав {time}"

-- Columns
L.col_time   = "Час"
L.col_event  = "Подія"
L.col_player = "Гравець"
L.col_role   = "Роль"
L.col_kills1 = "Невинних убито"
L.col_kills2 = "Зрадників убито"
L.col_points = "Рахунок"
L.col_team   = "Командний бонус"
L.col_total  = "Загальний рахунок"

-- Name of a trap that killed us that has not been named by the mapper
L.something      = "чимось"

-- Kill events
L.ev_blowup      = "{victim} підірвав себе"
L.ev_blowup_trap = "{victim} вибухнув завдяки {trap}"

L.ev_tele_self   = "{victim} вбив себе телепортацією"
L.ev_sui         = "{victim} не витримав тиску та вчинив самогубство"
L.ev_sui_using   = "{victim} вбив себе використовуючи {tool}"

L.ev_fall        = "{victim} розбився"
L.ev_fall_pushed = "{victim} розбився після того, як {attacker} скинув його"
L.ev_fall_pushed_using = "{victim} розбився після того, як {attacker} використав {trap}, щоб скинути його"

L.ev_shot        = "{victim} був застрелений {attacker}"
L.ev_shot_using  = "{victim} був застрелений {attacker} використавши {weapon}"

L.ev_drown       = "{victim} був втоплений {attacker}"
L.ev_drown_using = "{victim} був втоплений {trap}, яку використав {attacker}"

L.ev_boom        = "{victim} був підірваний {attacker}"
L.ev_boom_using  = "{victim} був підірваним {attacker} за допомогою {trap}"

L.ev_burn        = "{victim} був підсмажений {attacker}"
L.ev_burn_using  = "{victim} згорів завдяки {trap}, яку використав {attacker}"

L.ev_club        = "{victim} був забитий {attacker}"
L.ev_club_using  = "{victim} був забитий {attacker} за допомогою {trap}"

L.ev_slash       = "{victim} був зарізаний {attacker}"
L.ev_slash_using = "{victim} був зарізаний {attacker} за допомогою {trap}"

L.ev_tele        = "{victim} був вбитий телепортацією завдяки {attacker}"
L.ev_tele_using  = "{victim} був розпилений {trap} завдяки {attacker}"

L.ev_goomba      = "{victim} був розчавлений великою масою {attacker}"

L.ev_crush       = "{victim} був розчавлений {attacker}"
L.ev_crush_using = "{victim} був розчавлений {trap} завдяки {attacker}"

L.ev_other       = "{victim} був убитий {attacker}"
L.ev_other_using = "{victim} був убитий {attacker} використовуючи {trap}"

-- Other events
L.ev_body        = "{finder} знайшов тіло {victim}"
L.ev_c4_plant    = "{player} заклав вибухівку C4"
L.ev_c4_boom     = "Вибухівка C4, закладена {player} вибухнула"
L.ev_c4_disarm1  = "{player} знешкодив вибухівку C4, закладену {owner}"
L.ev_c4_disarm2  = "{player} невдало знешкодив вибухівку C4, закладену {owner}"
L.ev_credit      = "{finder} знайшов {num} кредитів на тілі {player}"

L.ev_start       = "Раунд розпочато"
L.ev_win_traitor = "Підлі зрадники виграли раунд!"
L.ev_win_inno    = "Милі невинні терористи виграли раунд!"
L.ev_win_time    = "Зрадники втратили весь свій час і програли!"

--- Awards/highlights

L.aw_sui1_title = "Лідер Культу самогубців"
L.aw_sui1_text  = "показав іншим самогубцям, як це робиться, покинувши цей світ першим."

L.aw_sui2_title = "Самотній і пригнічений"
L.aw_sui2_text  = "був єдиним, хто вбив себе."

L.aw_exp1_title = "Грант на дослідження вибухових речовин"
L.aw_exp1_text  = "отримав визнання за дослідження вибухів. {num} суб’єктів допомогли з тестуванням."

L.aw_exp2_title = "Польові дослідження"
L.aw_exp2_text  = "перевірив власну стійкість до вибухів. Її було недостатньо."

L.aw_fst1_title = "Перша кров"
L.aw_fst1_text  = "завдав першої смерті невинному від рук зрадника."

L.aw_fst2_title = "Перше криваве дурне вбивство"
L.aw_fst2_text  = "зробив перше вбивство, вистріливши в товариша-зрадника. Хороша робота."

L.aw_fst3_title = "Перша помилка"
L.aw_fst3_text  = "був першим, хто вчинив убивство. Шкода, що це був невинний товариш."

L.aw_fst4_title = "Перший постріл"
L.aw_fst4_text  = "зробив перший постріл на користь невинних терористів, вбивши зрадника"

L.aw_all1_title = "Найсмертоносніший серед рівних"
L.aw_all1_text  = "ніс відповідальність за кожне вбивство, скоєне невинними у цьому раунді."

L.aw_all2_title = "Одинокий вовк"
L.aw_all2_text  = "ніс відповідальність за кожне вбивство скоєне зрадниками в цьому раунді."

L.aw_nkt1_title = "Один є, Бос!"
L.aw_nkt1_text  = "зумів вбити одного невинного. Молодець!"

L.aw_nkt2_title = "Куля для двох"
L.aw_nkt2_text  = "показав, що перший постріл не був вдалим, убивши іншого."

L.aw_nkt3_title = "Серійний зрадник"
L.aw_nkt3_text  = "сьогодні поклав кінець життя трьом невинним терористам."

L.aw_nkt4_title = "Вовк серед більш вівцеподібних вовків"
L.aw_nkt4_text  = "їсть невинних терористів на вечерю. Вечеря складає {num} тіл."

L.aw_nkt5_title = "Контртерористична операція"
L.aw_nkt5_text  = "отримує гроші за вбивства. Тепер можна купити ще одну розкішну яхту."

L.aw_nki1_title = "Зрадь це"
L.aw_nki1_text  = "знайшов зрадника. Застрелив зрадника. Питання?"

L.aw_nki2_title = "Звернувся до Ліги Справедливості"
L.aw_nki2_text  = "провів двох зрадників на той світ."

L.aw_nki3_title = "Чи мріють зрадники про зрадливих овець?"
L.aw_nki3_text  = "відправив трьох зрадників відпочивати."

L.aw_nki4_title = "Співробітник внутрішніх справ"
L.aw_nki4_text  = "отримує гроші за вбивства. Тепер можна замовити свій п’ятий басейн."

L.aw_fal1_title = "Ні, містере Бонд, я очікую, що ви це впадете"
L.aw_fal1_text  = "штовхнув когось із великої висоти."

L.aw_fal2_title = "На саме дно"
L.aw_fal2_text  = "дозволив своєму тілу вдаритися об землю після падіння зі значної висоти."

L.aw_fal3_title = "Людський метеорит"
L.aw_fal3_text  = "роздавив когось, впавши на нього з великої висоти."

L.aw_hed1_title = "Вправність"
L.aw_hed1_text  = "відкрив для себе радість у {num} пострілах у голову."

L.aw_hed2_title = "Неврологія"
L.aw_hed2_text  = "видалив мізки з {num} голів для детальнішого дослідження."

L.aw_hed3_title = "Відеоігри змусили зробити мене це"
L.aw_hed3_text  = "застосував свої знання з симулятора вбивств та вбив {num} ворогів пострілами в голову."

L.aw_cbr1_title = "Тук-тук-тук"
L.aw_cbr1_text  = "має середній замах ломом, як з’ясували {num} жертв."

L.aw_cbr2_title = "Фрімен"
L.aw_cbr2_text  = "прикрасив свій лом залишками мізків не менше ніж {num} людей."

L.aw_pst1_title = "Наполегливий маленький дурник"
L.aw_pst1_text  = "здійснив {num} вбивств із пістолета. Потім він вирушив обіймати когось до смерті."

L.aw_pst2_title = "Забій малого калібру"
L.aw_pst2_text  = "убив невелику армію з {num} людей використавши лише пістолет. Імовірно він встановив крихітний дробовик всередину ствола."

L.aw_sgn1_title = "Легкий режим"
L.aw_sgn1_text  = "застосовує картеч там, де боляче, вбивши {num} цілей."

L.aw_sgn2_title = "Тисяча маленьких гранул"
L.aw_sgn2_text  = "не дуже сподобалися своя картеч, тому він віддав її. {num} одержувачів, на жаль, не вижили."

L.aw_rfl1_title = "Цілься, стріляй"
L.aw_rfl1_text  = "показав, що все, що вам потрібно для {num} вбивств, це гвинтівка та тверда рука."

L.aw_rfl2_title = "Я бачу твою голову звідси"
L.aw_rfl2_text  = "знає свою гвинтівку. Тепер {num} інших людей також знають цю гвинтівку."

L.aw_dgl1_title = "Це як маленька гвинтівка"
L.aw_dgl1_text  = "опанував Deagle і вбив {num} людей."

L.aw_dgl2_title = "Майстер Орла"
L.aw_dgl2_text  = "прибив {num} людей завдяки Deagle."

L.aw_mac1_title = "Моліться і вбивайте"
L.aw_mac1_text  = "убив {num} людей за допомогою MAC10, але не каже, скільки набоїв на це витратив."

L.aw_mac2_title = "Мак і сир"
L.aw_mac2_text  = "цікаво, скільки людей загинуло, якби ця особа могла володіти двома MAC10? {num} треба помножити на два?"

L.aw_sip1_title = "Слово — срібло, мовчання — золото"
L.aw_sip1_text  = "заткнув {num} людей за допомогою пістолета з глушником."

L.aw_sip2_title = "Тихий вбивця"
L.aw_sip2_text  = "вбив {num} людей, які навіть не чули, як померли."

L.aw_knf1_title = "Ніж впізнав тебе"
L.aw_knf1_text  = "встромив комусь ніж в обличчя через Інтернет."

L.aw_knf2_title = "Звідки ти це взяв?"
L.aw_knf2_text  = "не був зрадником, але все одно вбив когось ножем."

L.aw_knf3_title = "Людина як ніж"
L.aw_knf3_text  = "знайшов {num} викинутих ножів і використав їх."

L.aw_knf4_title = "Найгостріша людина у світі"
L.aw_knf4_text  = "вбив {num} людей ножем. Не запитуйте мене як це він зробив."

L.aw_flg1_title = "На допомогу"
L.aw_flg1_text  = "використав свій сигнальний пістолет, щоб просигналізувати {num} смертей."

L.aw_flg2_title = "Сигнальний пістолет показав нам пожежу"
L.aw_flg2_text  = "навчив {num} чоловіків про небезпеку носіння легкозаймистого одягу."

L.aw_hug1_title = "H.U.G.E Розмах"
L.aw_hug1_text  = "був у гармонії зі своїм H.U.G.E, якимось чином йому навіть вдалося змусити кулі вразити {num} людей."

L.aw_hug2_title = "Вперта пара"
L.aw_hug2_text  = "просто продовжував стріляти з H.U.G.E., і побачив, що його H.U.G.E. терпіння було винагороджено {num} вбивствами."

L.aw_msx1_title = "Пів-пав"
L.aw_msx1_text  = "забрав {num} людей з M16."

L.aw_msx2_title = "Божевілля середньої дальності"
L.aw_msx2_text  = "знає, як знищувати цілі з M16, показавши {num} вбивств."

L.aw_tkl1_title = "Ой, не то"
L.aw_tkl1_text  = "зажав свій палець саме тоді, коли цілився в приятеля."

L.aw_tkl2_title = "Подвійна помилка"
L.aw_tkl2_text  = "думав, що двічі знайшов зрадника, але обидва рази помилився."

L.aw_tkl3_title = "Усвідомив значення карми"
L.aw_tkl3_text  = "не міг зупинитися після вбивства двох товаришів по команді. Три — його щасливе число."

L.aw_tkl4_title = "Вбивця товаришів"
L.aw_tkl4_text  = "вбив всю свою команду. Бог ти мій, БАНБАНБАН!"

L.aw_tkl5_title = "Рольовий гравець"
L.aw_tkl5_text  = "грав роль божевільного, я не жартую. Саме тому він вбив більшу частину своєї команди."

L.aw_tkl6_title = "Придурок"
L.aw_tkl6_text  = "не зміг зрозуміти, на чиєму боці він, і вбив більш ніж половину своїх товаришів."

L.aw_tkl7_title = "Селюк"
L.aw_tkl7_text  = "добре захистив свій газон, убивши понад чверті своїх товаришів по команді."

L.aw_brn1_title = "За рецептом бабусі"
L.aw_brn1_text  = "засмажив кілька людей до відмінної скоринки."

L.aw_brn2_title = "Палій"
L.aw_brn2_text  = "почув голосне реготання після спалення однієї зі своїх численних жертв."

L.aw_brn3_title = "Піррове спалювання"
L.aw_brn3_text  = "спалив їх усіх, але запалювальні гранати закінчилися! Як він впорається!?"

L.aw_fnd1_title = "Слідчий"
L.aw_fnd1_text  = "знайшов {num} тіл, що лежать навколо."

L.aw_fnd2_title = "Треба спіймати їх усіх"
L.aw_fnd2_text  = "знайшов {num} тіл для своєї колекції."

L.aw_fnd3_title = "Запах смерті"
L.aw_fnd3_text  = "раз за разом натикався на випадкові тіла. Нарахував {num} разів у цьому раунді."

L.aw_crd1_title = "Переробник"
L.aw_crd1_text  = "підібрав {num} кредитів обладнання, що залишилися на тілах."

L.aw_tod1_title = "Піррова перемога"
L.aw_tod1_text  = "помер за кілька секунд до того, як його команда перемогла раунд."

L.aw_tod2_title = "Я ненавиджу цю гру"
L.aw_tod2_text  = "помер одразу ж на початку раунду."


--- New and modified pieces of text are placed below this point, marked with the
--- version or the date in which they were added, to make updating translations easier.


--- v23
L.set_avoid_det     = "Уникати бути обраним детективом"
L.set_avoid_det_tip = "Увімкніть це, щоб наказати серверу не обирати вас як детектива, якщо це можливо. Це не означає, що ви будете частіше Зрадником."

--- v24
L.drop_no_ammo = "Недостатньо набоїв у обоймі вашої зброї, щоб викинути їх у вигляді коробки."

--- v31
L.set_cross_brightness = "Яскравість прицілу"
L.set_cross_size = "Розмір прицілу"

--- 2015-05-25
L.hat_retrieve = "Ви взяли Капелюх детектива."

--- 2017-03-09
L.sb_sortby = "Сортувати за:"

--- 2018-07-24
L.equip_tooltip_main = "Меню обладнання"
L.equip_tooltip_radar = "Керування радаром"
L.equip_tooltip_disguise = "Керування маскуванням"
L.equip_tooltip_radio = "Керування радіо"
L.equip_tooltip_xfer = "Переказ кредитів"

L.confgrenade_name = "Дискомбобулятор"
L.polter_name = "Полтергейст"
L.stungun_name = "Прототип UMP"

L.knife_instant = "МИТТЄВЕ ВБИВСТВО"

L.dna_hud_type = "ТИП"
L.dna_hud_body = "ТІЛО"
L.dna_hud_item = "РІЧ"

L.binoc_zoom_level = "РІВЕНЬ"
L.binoc_body = "ТІЛО ЗНАЙДЕНО"

L.idle_popup_title = "Бездіяльність"

--- 2021-06-07
L.sb_playervolume = "Гучність гравця"

--- 2021-09-22
L.tip41 = "Ви можете відрегулювати гучність мікрофона гравця, клацнувши правою кнопкою миші значок вимкнення звуку на табло рахунку."