---- Russian language strings

local L = LANG.CreateLanguage("Русский")

--- General text used in various places
L.traitor    = "Предатель"
L.detective  = "Детектив"
L.innocent   = "Невиновный"
L.last_words = "Последние слова"

L.terrorists = "Террористы"
L.spectators = "Наблюдатели"

--- Round status messages
L.round_minplayers = "Недостаточно игроков для начала раунда..."
L.round_voting     = "Идёт голосование, начало раунда отложено на {num} сек..."
L.round_begintime  = "Новый раунд начнётся через {num} сек. Приготовьтесь."
L.round_selected   = "Предатели выбраны."
L.round_started    = "Раунд начался!"
L.round_restart    = "Раунд перезапущен администратором."

L.round_traitors_one  = "Предатель, сейчас ты один."
L.round_traitors_more = "Предатель, вот твои товарищи: {names}"

L.win_time         = "Время вышло. Предатели проиграли."
L.win_traitor      = "Предатели победили!"
L.win_innocent     = "Предатели побеждены!"
L.win_showreport   = "Давайте посмотрим на результаты раунда в течение {num} сек."

L.limit_round      = "Достигнут лимит раундов. {mapname} скоро загрузится."
L.limit_time       = "Достигнут лимит времени. {mapname} скоро загрузится."
L.limit_left       = "Осталось {num} раунд (а/ов) или {time} мин. до смены карты на {mapname}."

--- Credit awards
L.credit_det_all   = "Детективы, вы награждены кредитами ({num}) за ваши действия."
L.credit_tr_all    = "Предатели, вы награждены кредитами ({num}) за ваши действия."

L.credit_kill      = "Получено кредитов за убийство игрока в роли {role}: {num}."

--- Karma
L.karma_dmg_full   = "У вас {amount} кармы, поэтому вы наносите максимальный урон в этом раунде!"
L.karma_dmg_other  = "У вас {amount} кармы, поэтому весь ваш урон снижен на {num}%."

--- Body identification messages
L.body_found       = "{finder} находит тело {victim}. {role}"

-- The {role} in body_found will be replaced by one of the following:
L.body_found_t     = "Он был предателем!"
L.body_found_d     = "Он был детективом."
L.body_found_i     = "Он был невиновным."

L.body_confirm     = "{finder} подтверждает смерть {victim}."

L.body_call        = "{player} зовёт детектива к телу {victim}!"
L.body_call_error  = "Вы должны подтвердить смерть игрока, прежде чем звать детектива!"

L.body_burning     = "Ай! Это тело горит!"
L.body_credits     = "Найдено кредитов на теле: {num}."

--- Menus and windows
L.close = "Закрыть"
L.cancel = "Отмена"

-- For navigation buttons
L.next = "Далее"
L.prev = "Назад"

-- Equipment buying menu
L.equip_title     = "Снаряжение"
L.equip_tabtitle  = "Покупка снаряжения"

L.equip_status    = "Статус заказа"
L.equip_cost      = "Осталось кредитов: {num}."
L.equip_help_cost = "Любое снаряжение стоит 1 кредит."

L.equip_help_carry = "Вы можете купить только те предметы, для которых у вас есть место."
L.equip_carry      = "Вы можете купить этот предмет."
L.equip_carry_own  = "У вас уже есть этот предмет."
L.equip_carry_slot = "У вас уже есть оружие в слоте {slot}."

L.equip_help_stock = "Некоторые предметы можно купить только один раз за раунд."
L.equip_stock_deny = "Этого предмета нет в наличии."
L.equip_stock_ok   = "Этот предмет есть в наличии."

L.equip_custom     = "Этот предмет добавлен сервером."

L.equip_spec_name  = "Имя"
L.equip_spec_type  = "Тип"
L.equip_spec_desc  = "Описание"

L.equip_confirm    = "Купить"

-- Disguiser tab in equipment menu
L.disg_name      = "Маскировка"
L.disg_menutitle = "Управление Маскировкой"
L.disg_not_owned = "У вас нет Маскировки!"
L.disg_enable    = "Включить Маскировку."

L.disg_help1     = "Когда Маскировка включена, ваше имя, здоровье и карма не показывается тем, кто смотрит на вас. В дополнение к этому, вы будете скрыты от радара детектива."
L.disg_help2     = "Нажмите Numpad Enter, чтобы включить или выключить Маскировку без использования меню. Также вы можете назначить другую клавишу для 'ttt_toggle_disguise' через консоль."

-- Radar tab in equipment menu
L.radar_name      = "Радар"
L.radar_menutitle = "Управление радаром"
L.radar_not_owned = "У вас нет радара!"
L.radar_scan      = "Поиск"
L.radar_auto      = "Автоповтор поиска."
L.radar_help      = "Результаты поиска показываются в течение {num} сек., после чего радар перезарядиться и может быть использовать вновь."
L.radar_charging  = "Радар всё ещё заряжается!"

-- Transfer tab in equipment menu
L.xfer_name       = "Передача"
L.xfer_menutitle  = "Передача кредитов"
L.xfer_no_credits = "У вас нет кредитов!"
L.xfer_send       = "Передать кредит"
L.xfer_help       = "Вы можете передавать кредиты только игрокам в роли {role}."

L.xfer_no_recip   = "Передача кредита отменена: получатель недействителен."
L.xfer_no_credits = "Недостаточно кредитов для передачи."
L.xfer_success    = "Передача кредитов игроку {player} завершена."
L.xfer_received   = "{player} передаёт вам {num} кредит."

-- Radio tab in equipment menu
L.radio_name      = "Радио"
L.radio_help      = "Нажмите на кнопку, чтобы воспроизвести выбранный звук."
L.radio_notplaced = "Вы должны поместить Радио, чтобы воспроизводить звуки."

-- Radio soundboard buttons
L.radio_button_scream  = "Крик"
L.radio_button_expl    = "Взрыв"
L.radio_button_pistol  = "Пистолет"
L.radio_button_m16     = "M16"
L.radio_button_deagle  = "Deagle"
L.radio_button_mac10   = "МАС10"
L.radio_button_shotgun = "Дробовик"
L.radio_button_rifle   = "Винтовка"
L.radio_button_huge    = "H.U.G.E"
L.radio_button_c4      = "Пиканье С4"
L.radio_button_burn    = "Горение"
L.radio_button_steps   = "Шаги"


-- Intro screen shown after joining
L.intro_help     = "Если вы новичок, нажмите F1 для открытия руководства!"

-- Radiocommands/quickchat
L.quick_title   = "Быстрые сообщения"

L.quick_yes     = "Да."
L.quick_no      = "Нет."
L.quick_help    = "На помощь!"
L.quick_imwith  = "Я с {player}."
L.quick_see     = "Я вижу {player}."
L.quick_suspect = "{player} ведёт себя подозрительно."
L.quick_traitor = "{player} – предатель!"
L.quick_inno    = "{player} – невиновный."
L.quick_check   = "Есть кто живой?"

-- {player} in the quickchat text normally becomes a player nickname, but can
-- also be one of the below.  Keep these lowercase.
L.quick_nobody    = "никто"
L.quick_disg      = "кто-то замаскированный"
L.quick_corpse    = "неопознанное тело"
L.quick_corpse_id = "{player} (тело)"


--- Body search window
L.search_title  = "Результаты осмотра тела"
L.search_info   = "Информация"
L.search_confirm = "Подтвердить смерть"
L.search_call   = "Позвать детектива"

-- Descriptions of pieces of information found
L.search_nick   = "Это труп {player}."

L.search_role_t = "Этот человек был предателем!"
L.search_role_d = "Этот человек был детективом."
L.search_role_i = "Этот человек был невиновным."

L.search_words  = "Что-то подсказывает вам, что его последними словами были: «{lastwords}»"
L.search_armor  = "Он носил нестандартный бронежилет."
L.search_disg   = "Он носил устройство, которое могло скрыть его личность."
L.search_radar  = "Он носил некое подобие радара, которое больше не работает."
L.search_c4     = "В кармане вы нашли записку. В ней сказано, что можно безопасно обезвредить бомбу, перерезав {num}-й провод."

L.search_dmg_crush  = "Много костей было сломано. Видимо, удар чего-то тяжёлого послужил причиной смерти."
L.search_dmg_bullet = "Очевидно, его застрелили."
L.search_dmg_fall   = "Он разбился насмерть."
L.search_dmg_boom   = "Полученные ранения и опалённая одежда свидетельствуют о том, что причиной смерти был взрыв."
L.search_dmg_club   = "Всё тело в синяках и побоях. Его явно забили до смерти."
L.search_dmg_drown  = "На теле видны явные признаки утопления."
L.search_dmg_stab   = "Он был зарезан и умер, прежде чем истёк кровью."
L.search_dmg_burn   = "Здесь пахнет жареным террористом..."
L.search_dmg_tele   = "Похоже, ДНК было зашифровано тахионным излучением!"
L.search_dmg_car    = "Когда этот террорист переходил дорогу, его переехал лихач."
L.search_dmg_other  = "Невозможно определить конкретную причину смерти этого террориста."

L.search_weapon = "Похоже, для убийства использовался (-ась) {weapon}."
L.search_head   = "Смертельным ранением был выстрел в голову. Не было времени на крики."
L.search_time   = "Он умер примерно за {time} до того, как вы его осмотрели."
L.search_dna    = "Соберите образец ДНК убийцы с помощью Сканера ДНК. Образец ДНК разложится примерно через {time}."

L.search_kills1 = "Вы нашли список убийств, подтверждающий смерть {player}."
L.search_kills2 = "Вы нашли список убийств, подтверждающий смерть:"
L.search_eyes   = "Используя свои детективные навыки вы выяснили, что последним, кого он видел, был {player}. Убийца или совпадение?"


-- Scoreboard
L.sb_playing    = "Вы играете на..."
L.sb_mapchange  = "Карта сменится через {num} раунд (а/ов) или {time}"

L.sb_mia        = "Пропавшие без вести"
L.sb_confirmed  = "Мёртвые"

L.sb_ping       = "Пинг"
L.sb_deaths     = "Смертей"
L.sb_score      = "Счёт"
L.sb_karma      = "Карма"

L.sb_info_help  = "Осмотрите тело этого игрока, и сможете пересмотреть результаты здесь."

L.sb_tag_friend = "ДРУГ"
L.sb_tag_susp   = "ПОДОЗРЕВАЕМЫЙ"
L.sb_tag_avoid  = "ИЗБЕГАТЬ"
L.sb_tag_kill   = "УБИТЬ"
L.sb_tag_miss   = "ПРОПАЛ"

--- Help and settings menu (F1)

L.help_title = "Руководство и настройки"

-- Tabs
L.help_tut     = "Руководство"
L.help_tut_tip = "Как играть в ТТТ в шести шагах"

L.help_settings = "Настройки"
L.help_settings_tip = "Клиентские настройки"

-- Settings
L.set_title_gui = "Настройки интерфейса"

L.set_tips      = "Показывать советы внизу экрана во время наблюдения."

L.set_startpopup = "Длительность всплывающего окна в начале раунда"
L.set_startpopup_tip = "Когда начинается раунд, небольшое всплывающее окно появляется внизу экрана на несколько секунд. Здесь можно изменить длительность его отображения."

L.set_cross_opacity   = "Непрозрачность прицела при прицеливании"
L.set_cross_disable   = "Выключить прицел."
L.set_minimal_id      = "Минималистичная информация о цели под прицелом (без текста о карме, подсказок и т.д.)."
L.set_healthlabel     = "Показывать состояние здоровья на полоске здоровья."
L.set_lowsights       = "Опускать оружие при прицеливании."
L.set_lowsights_tip   = "Если вы включите эту функцию, модель оружия будет опускаться при прицеливании. Вам будет легче видеть свою цель, но будет выглядеть менее реалистично."
L.set_fastsw          = "Быстрая смена оружия."
L.set_fastsw_tip      = "Включите, чтобы переключаться между оружием без подтверждающего нажатия для его переключения."
L.set_fastsw_menu     = "Включить меню переключения оружия с быстрой сменой оружия."
L.set_fastswmenu_tip  = "Когда включена быстрая смена оружия, меню переключения будет появляться."
L.set_wswitch         = "Выключить автозакрытие меню переключения оружия."
L.set_wswitch_tip     = "По умолчанию меню переключения автоматически закрывается через несколько секунд после последней прокрутки. Если вы включите эту функцию, оно не будет закрываться."
L.set_cues            = "Проигрывать звуки начала и конца раунда."
L.set_msg_cue         = "Проигрывать звук при появлении уведомлений."


L.set_title_play    = "Настройки игры"

L.set_specmode      = "Режим наблюдения (всегда быть наблюдателем)."
L.set_specmode_tip  = "Режим наблюдения не даст вам возродиться в начале раунда, вместо этого вы будете наблюдателем."
L.set_mute          = "Заглушать живых игроков после смерти."
L.set_mute_tip      = "Эта функция будет заглушать живых игроков, когда вы мертвы/наблюдатель."


L.set_title_lang    = "Настройки языка"

-- It may be best to leave this next one english, so english players can always
-- find the language setting even if it's set to a language they don't know.
L.set_lang          = "Выберите язык (Select language):"


--- Weapons and equipment, HUD and messages

-- Equipment actions, like buying and dropping
L.buy_no_stock    = "Этого предмета нет в наличии: вы уже купили его в этом раунде."
L.buy_pending     = "У вас уже есть заказ, дождитесь его получения."
L.buy_received    = "Вы получили ваше особое снаряжение."

L.drop_no_room    = "Здесь нет места, чтобы выбросить оружие!"

L.disg_turned_on  = "Маскировка включена!"
L.disg_turned_off = "Маскировка выключена."

-- Equipment item descriptions
L.item_passive    = "Предмет с пассивным эффектом"
L.item_active     = "Предмет с активным эффектом"
L.item_weapon     = "Оружие"

L.item_armor      = "Бронежилет"
L.item_armor_desc = [[
Уменьшает урон от пуль на 30%.

Стандартное снаряжение детективов.]]

L.item_radar      = "Радар"
L.item_radar_desc = [[
Позволяет находить живых существ.

Автопоиск начнётся как только как только вы
его купите. Настройки доступны во вкладке 
«Радар» этого меню.]]

L.item_disg       = "Маскировка"
L.item_disg_desc  = [[
При включении, скрывает информацию о вас. 
Также вы не будете отображаться как последний
человек, которого видел погибший.
Включить/выключить Маскировку можно во 
вкладке «Маскировка» или нажав Numpad Enter.]]

-- C4
L.c4_hint         = "Нажмите {usekey}, чтобы заложить/обезвредить."
L.c4_no_disarm    = "Вы не можете обезвредить С4 другого предателя до тех пор, пока он жив."
L.c4_disarm_warn  = "С4, заложенная вами, была обезврежена."
L.c4_armed        = "Вы заложили бомбу."
L.c4_disarmed     = "Вы успешно обезвредили бомбу."
L.c4_no_room      = "Вы не можете подобрать C4."

L.c4_desc         = "Мощная бомба с таймером."

L.c4_arm          = "Заложить"
L.c4_arm_timer    = "Таймер"
L.c4_arm_seconds  = "Секунд до взрыва:"
L.c4_arm_attempts = "При попытке обезвреживания перерезание {num} из 6 проводов вызовет взрыв."

L.c4_remove_title    = "Удаление"
L.c4_remove_pickup   = "Подобрать"
L.c4_remove_destroy1 = "Уничтожить"
L.c4_remove_destroy2 = "Подтвердить"

L.c4_disarm       = "Обезвредить"
L.c4_disarm_cut   = "Нажмите, чтобы перерезать {num}-й провод."

L.c4_disarm_t     = "Перережьте провод, чтобы обезвредить бомбу. Для предателей любой провод безопасен. Невиновным это не так просто!"
L.c4_disarm_owned = "Перережьте провод, чтобы обезвредить бомбу. Это ваша бомба, поэтому любой провод безопасен."
L.c4_disarm_other = "Перережьте безопасный провод, чтобы обезвредить бомбу. Она взорвётся, если вы ошибётесь!"

L.c4_status_armed    = "ЗАЛОЖЕНА"
L.c4_status_disarmed = "ОБЕЗВРЕ-\nЖЕНА"

-- Visualizer
L.vis_name        = "Визуализатор"
L.vis_hint        = "Нажмите {usekey}, чтобы подобрать. (только для детективов)"

L.vis_help_pri    = "{primaryfire}: бросить активированное устройство."

L.vis_desc        = [[
Устройство, визуализирующее сцену преступления.

Анализирует тело, чтобы показать как жертва
была убита, но только если она была застрелена.]]

-- Decoy
L.decoy_name      = "Приманка"
L.decoy_no_room   = "Вы не можете подобрать эту Приманку."
L.decoy_broken    = "Ваша Приманка уничтожена!"

L.decoy_help_pri  = "{primaryfire}: установить Приманку."

L.decoy_desc      = [[
Показывает фальшивую метку на радарах 
детективов и заставляет Сканеры ДНК 
показывать местоположение вашей Приманки,
если они ищут по вашему ДНК.]]

-- Defuser
L.defuser_name    = "Набор сапёра"
L.defuser_help    = "{primaryfire}: обезвредить С4."

L.defuser_desc    = [[
Мгновенно обезвреживает С4.

Неограниченное использование. C4 будет легче
заметить, если у вас есть этот предмет.]]

-- Flare gun
L.flare_name      = "Ракетница"
L.flare_desc      = [[
Может быть использована для сжигания тел,
чтобы их никогда не нашли. Ограниченное
количество патрон.

Горящие тела издают отчётливый звук.]]

-- Health station
L.hstation_name   = "Лечебная станция"
L.hstation_hint   = "Нажмите {usekey}, чтобы восстановить здоровье. Заряд: {num}."
L.hstation_broken = "Ваша Лечебная станция уничтожена!"
L.hstation_help   = "{primaryfire}: разместить Лечебную станцию."

L.hstation_desc   = [[
Позволяет игрокам восстанавливать здоровье.
Медленная перезарядка.
Любой может её использовать и она может быть
уничтожена. Также вы можете собрать с неё 
образцы ДНК людей, использовавших её.]]

-- Knife
L.knife_name      = "Нож"
L.knife_thrown    = "Брошенный нож"

L.knife_desc      = [[
Мгновенно и бесшумно убивает раненные цели,
но может быть использован лишь один раз.

Может быть брошен клавишей дополнительной
атаки.]]

-- Poltergeist
L.polter_desc     = [[
Устанавливает ускорители на предметы, а
затем яростно толкает их по сторонам.

Энергетические взрывы наносят урон всем
поблизости.]]

-- Radio
L.radio_broken    = "Ваше Радио уничтожено!"
L.radio_help_pri  = "{primaryfire}: поместить Радио."

L.radio_desc      = [[
Воспроизводит звуки для отвлечения или обмана.

Поместите его где-нибудь, а затем
выберите желаемый звук во вкладке «Радио»
этого меню.]]

-- Silenced pistol
L.sipistol_name   = "Пистолет с глушителем"

L.sipistol_desc   = [[
Тихий пистолет, использующий обычные
пистолетные патроны.

Жертвы не будут кричать после смерти.]]

-- Newton launcher
L.newton_name     = "Пушка Ньютона"

L.newton_desc     = [[
Толкайте людей с безопасного расстояния.

Бесконечные патроны, но медленная
перезарядка.]]

-- Binoculars
L.binoc_name      = "Бинокль"
L.binoc_desc      = [[
Посмотрите на тело через Бинокль, чтобы 
опознать и осмотреть его с дальнего расстояния.

Неограниченное использование, но осмотр тела 
занимает некоторое время.]]

L.binoc_help_pri  = "{primaryfire}: осмотреть тело."
L.binoc_help_sec  = "{secondaryfire}: изменить уровень приближения."

-- UMP
L.ump_desc        = [[
Экспериментальный пистолет-пулемёт,
дезориентирующий цель.

Использует обычные патроны для ПП.]]

-- DNA scanner
L.dna_name        = "Сканер ДНК"
L.dna_identify    = "Тело должно быть опознано, чтобы собрать образец ДНК убийцы."
L.dna_notfound    = "Образцов ДНК не обнаружено."
L.dna_limit       = "Не хватает места. Избавьтесь от старых образцов, чтобы добавить новые."
L.dna_decayed     = "Образец ДНК убийцы разложился."
L.dna_killer      = "Вы собрали образец ДНК убийцы с этого тела!"
L.dna_no_killer   = "Образец ДНК не может быть собран (убийца покинул сервер?)."
L.dna_armed       = "Бомба все ещё работает! Сначала обезвредьте её!"
L.dna_object      = "Собрано новых образцов ДНК: {num}."
L.dna_gone        = "ДНК не обнаружено в этой области."

L.dna_desc        = [[ 
Соберите образцы ДНК с предметов и
используйте их, чтобы найти владельцев.

Используйте Сканер на свежих телах, чтобы
собрать образец ДНК убийцы и найти его.]]

L.dna_menu_title  = "Управление поиском ДНК"
L.dna_menu_sample = "Источник ДНК: {source}"
L.dna_menu_remove = "Удалить"
L.dna_menu_help1  = "Это образцы ДНК, которые вы собрали."
L.dna_menu_help2  = [[
Когда заряжен, вы можете найти местоположение
игрока, образец ДНК которого был выбран.
Чем дальше цель, тем больше требуется энергии.]]

L.dna_menu_scan   = "Поиск"
L.dna_menu_repeat = "Автоповтор"
L.dna_menu_ready  = "ГОТОВ"
L.dna_menu_charge = "ЗАРЯДКА"
L.dna_menu_select = "ВЫБЕРИТЕ ОБРАЗЕЦ"

L.dna_help_primary   = "{primaryfire}: собрать образец ДНК."
L.dna_help_secondary = "{secondaryfire}: открыть меню управления."

-- Magneto stick
L.magnet_name     = "Магнитопалка"
L.magnet_help     = "{primaryfire}: прикрепить тело к поверхности."

-- Grenades and misc
L.grenade_smoke   = "Дымовая граната"
L.grenade_fire    = "Зажигательная граната"

L.unarmed_name    = "Ничего"
L.crowbar_name    = "Монтировка"
L.pistol_name     = "Пистолет"
L.rifle_name      = "Винтовка"
L.shotgun_name    = "Дробовик"

-- Teleporter
L.tele_name       = "Телепорт"
L.tele_failed     = "Не удалось телепортироваться."
L.tele_marked     = "Место телепортации отмечено."

L.tele_no_ground  = "Телепортация возможна только на твёрдой поверхности!"
L.tele_no_crouch  = "Телепортация возможна только в положении стоя!"
L.tele_no_mark    = "Место телепортации не отмечено! Отметьте его перед телепортацией."

L.tele_no_mark_ground = "Отметить место телепортации можно только на твёрдой поверхности!"
L.tele_no_mark_crouch = "Отметить место телепортации можно только в положении стоя!"

L.tele_help_pri   = "{primaryfire}: телепортироваться к отмеченному месту."
L.tele_help_sec   = "{secondaryfire}: отметить текущее место как место телепортации."

L.tele_desc       = [[
Телепортирует в ранее отмеченное место.

Телепортация издаёт звук, а количество
использований ограничено.]]

-- Ammo names, shown when picked up
L.ammo_pistol     = "9 мм патроны"

L.ammo_smg1       = "Патроны для ПП"
L.ammo_buckshot   = "Патроны для дробовика"
L.ammo_357        = "Патроны для винтовки"
L.ammo_alyxgun    = "Патроны для Deagle"
L.ammo_ar2altfire = "Патроны для Ракетницы"
L.ammo_gravity    = "Патроны для Полтергейста"


--- HUD interface text

-- Round status
L.round_wait   = "Ожидание"
L.round_prep   = "Подготовка"
L.round_active = "В процессе"
L.round_post   = "Конец"

-- Health, ammo and time area
L.overtime     = "ДОП. ВРЕМЯ"
L.hastemode    = "РЕЖИМ СПЕШКИ"

-- TargetID health status
L.hp_healthy   = "Здоров"
L.hp_hurt      = "Слегка ранен"
L.hp_wounded   = "Ранен"
L.hp_badwnd    = "Тяжело ранен"
L.hp_death     = "При смерти"


-- TargetID karma status
L.karma_max    = "Уважаемый"
L.karma_high   = "Малоуважаемый"
L.karma_med    = "Легкомысленный"
L.karma_low    = "Опасный"
L.karma_min    = "Безответственный"

-- TargetID misc
L.corpse       = "Тело"
L.corpse_hint  = "{usekey}: осмотреть тело. {walkkey} + {usekey}: скрытно осмотреть тело."

L.target_disg  = " (ЗАМАСКИРОВАН)"
L.target_unid  = "Неопознанное тело"

L.target_traitor = "ПРЕДАТЕЛЬ"
L.target_detective = "ДЕТЕКТИВ"

L.target_credits = "Осмотрите тело, чтобы получить неиспользованные кредиты."

-- Traitor buttons (HUD buttons with hand icons that only traitors can see)
L.tbut_single  = "Одноразовое использование."
L.tbut_reuse   = "Многоразовое использование."
L.tbut_retime  = "Можно использовать повторно через {num} сек."
L.tbut_help    = "Нажмите {key}, чтобы активировать."

-- Equipment info lines (on the left above the health/ammo panel)
L.disg_hud     = "Вы замаскированы. Информация о вас скрыта."
L.radar_hud    = "Радар перезарядиться через {time}"

-- Spectator muting of living/dead
L.mute_living  = "Заглушены: живые"
L.mute_specs   = "Заглушены: мёртвые"
L.mute_all     = "Заглушены: все"
L.mute_off     = "Никто не заглушён"

-- Spectators and prop possession
L.punch_title  = "ТОЛКОМЕТР"
L.punch_help   = "Клавиши управления или прыжок: толкнуть предмет. Клавиша приседания: покинуть предмет."
L.punch_bonus  = "Ваш плохой счёт понизил предел толкометра на {num}."
L.punch_malus  = "Ваш хороший счёт повысил предел толкометра на {num}!"

L.spec_help    = "Щёлкните мышью, чтобы наблюдать за игроками, или нажмите {usekey}, чтобы вселиться в предмет, на который вы смотрите."

--- Info popups shown when the round starts

-- These are spread over multiple lines, hence the square brackets instead of
-- quotes. That's a Lua thing. Every line break (enter) will show up in-game.
L.info_popup_innocent = [[Вы невиновный террорист! Но вокруг есть предатели...
Кому вы можете доверять, а кого стоит опасаться?

Оглядывайтесь по сторонам и работайте вместе со своими товарищами, чтобы остаться в живых!]]

L.info_popup_detective = [[Вы детектив! Штаб выдал вам особое снаряжение, чтобы найти предателей.
Используйте его, чтобы помочь невиновным выжить, но будьте осторожны,
ведь предатели будут стараться убить вас первым!

Нажмите {menukey}, чтобы купить особое снаряжение!]]

L.info_popup_traitor_alone = [[Вы предатель! В этом раунде у вас нет товарищей.

Убейте всех, чтобы победить!

Нажмите {menukey}, чтобы купить особое снаряжение!]]

L.info_popup_traitor = [[Вы предатель! Работайте со своими товарищами, чтобы убить всех остальных.
Но будьте осторожны, иначе ваше предательство будет раскрыто...

Ваши товарищи:
{traitorlist}

Нажмите {menukey}, чтобы купить особое снаряжение!]]

--- Various other text
L.name_kick = "Игрок был автоматически кикнут за смену никнейма во время раунда."

L.idle_popup = [[Вы бездействовали в течение {num} сек., в результате чего были переведены в режим наблюдения. Пока вы в этом режиме, вы не возродитесь, когда начнётся раунд.

Вы можете выключить этот режим нажав {helpkey} и убрав галочку во вкладке настроек. Также вы можете выключить его прямо сейчас.]]

L.idle_popup_close = "Закрыть"
L.idle_popup_off   = "Выключить режим наблюдения"

L.idle_warning = "Внимание: вы будете переведены в режим наблюдения из-за длительного бездействия, если не проявите свою активность!"

L.spec_mode_warning = "Вы в режиме наблюдения и не возродитесь, когда начнётся раунд. Чтобы выключить этот режим, нажмите F1, перейдите во вкладку настроек и уберите галочку с этого режима."


-- Tips, shown at bottom of screen to spectators

-- Tips panel
L.tips_panel_title = "Советы"
L.tips_panel_tip   = "Совет:"

-- Tip texts

L.tip1 = "Зажав {walkkey} и нажав {usekey}, можно скрытно осмотреть тело, не подтверждая смерть игрока."

L.tip2 = "Закладка С4 на большее количество времени увеличит количество проводов, которые вызовут взрыв, а также сделает пиканье более тихим и редким."

L.tip3 = "Детективы могут осмотреть тело, чтобы узнать кто отразился в глазах жертвы. Это будет последний человек, которого видела жертва, но это не значит, что он убийца, так как жертва могла быть убита со спины."

L.tip4 = "Никто не будет знать, что вы умерли, пока ваше тело не найдут и не опознают."

L.tip5 = "Когда предатель убивает детектива, он сразу получает кредитную награду."

L.tip6 = "Когда умирает предатель, все детективы получают кредитную награду."

L.tip7 = "Когда предатели достигают значительных успехов в убийстве невиновных, они получают кредит в качестве награды."

L.tip8 = "Предатели и детективы могут получить неиспользованные кредиты с тел других предателей и детективов."

L.tip9 = "Полтергейст может превратить любой физический объект в смертоносный снаряд. Каждый толчок сопровождается энергетическим взрывом, наносящим урон всем поблизости."

L.tip10 = "Будучи предателем или детективом, обращайте внимание на красные сообщения в правом верхнем углу. Они содержат важную информацию."

L.tip11 = "Будучи предателем или детективом, помните, что вы получаете кредиты, если вы и ваши товарищи хорошо выполняете поставленную задачу. Также не забывайте их тратить!"

L.tip12 = "Сканер ДНК может быть использован для сбора образцов ДНК с оружия или предметов, а затем для нахождения местоположения владельца образца. Полезно, когда вы можете собрать образец с тела или обезвреженной бомбы!"

L.tip13 = "Когда вы близко к тому, кого убиваете, часть вашей ДНК остаётся на теле. Эта ДНК может быть использована с помощью Сканера ДНК, чтобы найти ваше местоположение. Лучше спрятать тело человека после того, как вы его зарезали!"

L.tip14 = "Чем дальше вы от того, кого убьёте, тем быстрее разложиться образец вашего ДНК на его теле."

L.tip15 = "Вы предатель и собираетесь быть снайпером? Попробуйте Маскировку. Если промажете, убегите в безопасное место, выключите Маскировку и никто не будет знать, что именно вы стреляли в них."

L.tip16 = "Будучи предателем, Телепорт может помочь вам убежать от преследователей или быстро переместиться на большой карте. Всегда отмечайте безопасное место для телепортации."

L.tip17 = "Все невиновные сгруппированы и их трудно разъединить? Попробуйте отвлечь некоторых из них звуками перестрелки или пиканьем С4 при помощи Радио."

L.tip18 = "Будучи предателем, вы можете воспроизводить звуки через меню снаряжения после помещения Радио. Можно создать очередь из звуков, нажав на них в желаемом порядке."

L.tip19 = "Будучи детективом, если у вас есть кредиты, вы можете отдать доверенному невиновному Набор сапёра. Так, вы сможете заняться серьёзной следственной работой, а он займётся обезвреживанием бомбы."

L.tip20 = "Бинокль позволяет осматривать и опознавать тела с дальнего расстояния. Плохая новость для предателей, если они надеялись использовать тело как приманку. Конечно, во время использования Бинокля вы безоружны и отвлеченны."

L.tip21 = "Лечебная станция позволяет раненым игрокам восстановить здоровье. Конечно, этими игроками могут быть и предатели."

L.tip22 = "Лечебная станция собирает образцы ДНК всех, кто ей пользовался. Детективы могут использовать образцы с помощью Сканера ДНК, чтобы найти тех, кто ей пользовался."

L.tip23 = "В отличие от оружия и С4, Радио не содержит образец ДНК поставившего его человека. Не волнуйтесь о возможном раскрытии при нахождении Радио детективами."

L.tip24 = "Нажмите {helpkey}, чтобы просмотреть краткое руководство или изменить некоторые настройки ТТТ. К примеру, вы можете выключить эти советы."

L.tip25 = "Когда детектив осматривает тело, результаты осмотра доступны всем игрокам через таблицу счёта, нажав на имя мёртвого человека."

L.tip26 = "В таблице счёта значок лупы возле чьего-либо имени означает, что у вас есть результаты осмотра тела этого человека. Если значок яркий, результаты получены от детектива и могут содержать дополнительную информацию."

L.tip27 = "Тела со значком лупы после имени были осмотрены детективом, а результаты осмотра доступны всем игрокам через таблицу счёта."

L.tip28 = "Наблюдатели могут нажать {mutekey}, чтобы заглушить других наблюдателей, живых игроков или всех."

L.tip29 = "Если на сервере установлены дополнительные языки, вы можете переключиться на другой в любое время через меню настроек."

L.tip30 = "Использовать быстрые сообщения можно нажатием {zoomkey}."

L.tip31 = "Будучи наблюдателем, нажмите на {duckkey}, чтобы включить курсор и нажать на кнопки на этой панели. Нажмите {duckkey} ещё раз, чтобы выключить курсор."

L.tip32 = "Дополнительная атака монтировки толкает игроков."

L.tip33 = "Стрельба при прицеливании слегка увеличивает точность и уменьшает отдачу, в отличие от стрельбы вприсядку."

L.tip34 = "Дымовые гранаты эффективны в помещениях, особенно для создания путаницы в переполненных комнатах."

L.tip35 = "Будучи предателем, помните, что вы можете прятать тела от назойливых глаз невиновных и их детективов."

L.tip36 = "Руководство, доступное по нажатию {helpkey}, содержит информацию о самых важных особенностях игры."

L.tip37 = "В таблице счёта вы можете нажать на имя живого игрока и присвоить ему такие метки, как «подозреваемый» или «друг». Эта метка отобразится под вашим прицелом, если вы наведётесь на игрока."

L.tip38 = "Многое размещаемое снаряжение, такое как С4 или Радио, может быть прикреплено на стены клавишей дополнительной атаки."

L.tip39 = "С4, взорвавшаяся при неудачной попытке обезвреживания, имеет меньший радиус взрыва, чем С4, взорвавшаяся по истечению таймера."

L.tip40 = "Если над таймером написано «Режим спешки», раунд сначала будет длиться лишь несколько минут, но с каждой смертью время увеличивается. Этот режим оказывает давление на предателей, что заставляет их действовать."

--- Round report

L.report_title = "Результаты раунда"

-- Tabs
L.report_tab_hilite = "Основные моменты"
L.report_tab_hilite_tip = "Основные моменты раунда."
L.report_tab_events = "События"
L.report_tab_events_tip = "Журнал событий, произошедших в этом раунде."
L.report_tab_scores = "Счёт"
L.report_tab_scores_tip = "Очки, набранные каждым игроком в этом раунде."

-- Event log saving
L.report_save     = "Сохранить"
L.report_save_tip = "Сохраняет журнал событий в текстовый файл."
L.report_save_error  = "Нет данных журнала событий для сохранения."
L.report_save_result = "Журнал событий сохранён в:"

-- Big title window
L.hilite_win_traitors = "Победа предателей"
L.hilite_win_innocent = "Победа невиновных"

L.hilite_players1 = "Игроков: {numplayers}. {numtraitors} из них были предателями."
L.hilite_players2 = "Игроков: {numplayers}. 1 из них был предателем."

L.hilite_duration = "Раунд длился {time}."

-- Columns
L.col_time   = "Время"
L.col_event  = "Событие"
L.col_player = "Игрок"
L.col_role   = "Роль"
L.col_kills1 = "Убито невиновных"
L.col_kills2 = "Убито предателей"
L.col_points = "Очков"
L.col_team   = "Командный бонус"
L.col_total  = "Всего"

-- Name of a trap that killed us that has not been named by the mapper
L.something      = "что-то"

-- Kill events
L.ev_blowup      = "{victim} взрывает самого себя."
L.ev_blowup_trap = "{victim} взрывается от {trap}."

L.ev_tele_self   = "{victim} убивает себя телепортом."
L.ev_sui         = "{victim} не выдерживает и совершает самоубийство."
L.ev_sui_using   = "{victim} совершает самоубийство при помощи {tool}."

L.ev_fall        = "{victim} разбивается насмерть."
L.ev_fall_pushed = "{victim} разбивается насмерть после толчка от {attacker}."
L.ev_fall_pushed_using = "{victim} разбивается насмерть после толчка от {trap}, активированной {attacker}."

L.ev_shot        = "{victim} был застрелен {attacker}."
L.ev_shot_using  = "{victim} был застрелен {attacker} с помощью {weapon}."

L.ev_drown       = "{victim} был утоплен {attacker}."
L.ev_drown_using = "{victim} был утоплен {trap}, активированной {attacker}."

L.ev_boom        = "{victim} был взорван {attacker}."
L.ev_boom_using  = "{victim} был взорван {attacker} при помощи {trap}."

L.ev_burn        = "{victim} был сожжён {attacker}."
L.ev_burn_using  = "{victim} был сожжён {trap} из-за {attacker}."

L.ev_club        = "{victim} был избит {attacker}."
L.ev_club_using  = "{victim} был избит {attacker} при помощи {trap}."

L.ev_slash       = "{victim} был зарезан {attacker}."
L.ev_slash_using = "{victim} был зарезан {attacker} при помощи {trap}."

L.ev_tele        = "{victim} был убит телепортацией {attacker}."
L.ev_tele_using  = "{victim} был распылён {trap}, установленной {attacker}."

L.ev_goomba      = "{victim} был раздавлен большой массой {attacker}."

L.ev_crush       = "{victim} был раздавлен {attacker}."
L.ev_crush_using = "{victim} был раздавлен {attacker} при помощи {trap}."

L.ev_other       = "{victim} был убит {attacker}."
L.ev_other_using = "{victim} был убит {attacker} при помощи {trap}."

-- Other events
L.ev_body        = "{finder} находит тело {victim}."
L.ev_c4_plant    = "{player} закладывает С4."
L.ev_c4_boom     = "С4, заложенная {player}, взорвалась."
L.ev_c4_disarm1  = "{player} обезвреживает С4, заложенную {owner}."
L.ev_c4_disarm2  = "{player} не удаётся обезвредить С4, заложенную {owner}."
L.ev_credit      = "{finder} находит {num} кредит(а/ов) на теле {player}."

L.ev_start       = "Раунд начался."
L.ev_win_traitor = "Подлые предатели победили!"
L.ev_win_inno    = "Милые невиновные террористы победили!"
L.ev_win_time    = "Предателям не хватило времени и они проиграли!"

--- Awards/highlights

L.aw_sui1_title = "Лидер культа самоубийц"
L.aw_sui1_text  = "показал другим самоубийцам как это сделать, совершив самоубийство первым."

L.aw_sui2_title = "Одинокий и подавленный"
L.aw_sui2_text  = "был единственным, кто совершил самоубийство."

L.aw_exp1_title = "Грант на исследования в области взрывчатки"
L.aw_exp1_text  = "был признан за исследования по взрывчаткам. {num} тестовых субъекта помогли ему."

L.aw_exp2_title = "Полевое исследование"
L.aw_exp2_text  = "испытал своё сопротивление к взрывам. Его оказалось недостаточно."

L.aw_fst1_title = "Первая кровь"
L.aw_fst1_text  = "совершил первое убийство невиновного от рук предателя."

L.aw_fst2_title = "Первое чертовски тупое убийство"
L.aw_fst2_text  = "совершил первое убийство убив другого предателя. Хорошая работа!"

L.aw_fst3_title = "Первая оплошность"
L.aw_fst3_text  = "был первым, кто убил человека. Очень плохо, ведь им был невиновный."

L.aw_fst4_title = "Первый взрыв"
L.aw_fst4_text  = "совершил первый взрыв в пользу невиновных террористов, взорвав предателя."

L.aw_all1_title = "Самый смертоносный среди равных"
L.aw_all1_text  = "был ответственен за каждое убийство, совершенное невинными."

L.aw_all2_title = "Одинокий волк"
L.aw_all2_text  = "был ответственен за каждое убийство, совершенное предателями."

L.aw_nkt1_title = "Один готов, босс!"
L.aw_nkt1_text  = "сумел убить одного невиновного. Мило!"

L.aw_nkt2_title = "Пуля для двоих"
L.aw_nkt2_text  = "показал, что первый выстрел был неудачным, убив другого."

L.aw_nkt3_title = "Серийный предатель"
L.aw_nkt3_text  = "оборвал жизни трёх невиновных террористов сегодня."

L.aw_nkt4_title = "Волк среди более овцеподобных волков"
L.aw_nkt4_text  = "ест невиновных террористов на ужин. Ужин из {num} тел."

L.aw_nkt5_title = "Контртеррористическая операция"
L.aw_nkt5_text  = "получает деньги за убийства и теперь может купить ещё одну роскошную яхту."

L.aw_nki1_title = "Предай это"
L.aw_nki1_text  = "нашёл предателя. Застрелил предателя. Всё просто."

L.aw_nki2_title = "Принят в отряд правосудия"
L.aw_nki2_text  = "сопроводил двух предателей в загробный мир."

L.aw_nki3_title = "Мечтают ли предатели о предательских овцах?"
L.aw_nki3_text  = "упокоил трёх предателей."

L.aw_nki4_title = "Сотрудник внутренних дел"
L.aw_nki4_text  = "получает деньги за убийства и теперь может купить бассейн."

L.aw_fal1_title = "Нет, Мистер Бонд, я ожидаю, что вы упадёте"
L.aw_fal1_text  = "толкнул кого-то с большой высоты."

L.aw_fal2_title = "Приземлившийся"
L.aw_fal2_text  = "позволил своему телу достигнуть земли после падения с большой высоты."

L.aw_fal3_title = "Человеческий метеорит"
L.aw_fal3_text  = "раздавил кого-то, упав с большой высоты."

L.aw_hed1_title = "Эффективность"
L.aw_hed1_text  = "получает наслаждение от выстрелов в голову, поэтому сделал {num} выстрела."

L.aw_hed2_title = "Неврология"
L.aw_hed2_text  = "извлёк мозги из {num} голов для тщательного изучения."

L.aw_hed3_title = "Видеоигры заставили меня сделать это"
L.aw_hed3_text  = "применил знания, полученные в симуляторе маньяка, и выстрелил {num} врагам в голову."

L.aw_cbr1_title = "Тук-тук-тук"
L.aw_cbr1_text  = "имеет средний размах с монтировкой, как выяснили {num} жертвы."

L.aw_cbr2_title = "Фримен"
L.aw_cbr2_text  = "запачкал свою монтировку мозгами не менее {num} человек."

L.aw_pst1_title = "Настойчивый маленький паршивец"
L.aw_pst1_text  = "совершил {num} убийства с помощью пистолета, а затем пошёл обнимать кого-то до смерти."

L.aw_pst2_title = "Резня малого калибра"
L.aw_pst2_text  = "убил {num} человек с помощью пистолета. Наверно, установив в дуло крошечный дробовик."

L.aw_sgn1_title = "Лёгкий режим"
L.aw_sgn1_text  = "применяет дробь там, где болит, убив {num} цели."

L.aw_sgn2_title = "Тысяча дробинок"
L.aw_sgn2_text  = "не очень любил свои дробины, поэтому раздал их всем. {num} получателям не удалось выжить."

L.aw_rfl1_title = "Целься и стреляй"
L.aw_rfl1_text  = "показал, что винтовка и твёрдая рука — всё что нужно для {num} убийств."

L.aw_rfl2_title = "Я вижу твою голову отсюда"
L.aw_rfl2_text  = "знает свою винтовку. Теперь {num} других людей знают её тоже."

L.aw_dgl1_title = "Это как крошечная винтовка"
L.aw_dgl1_text  = "научился пользоваться Desert Eagle и убил {num} человек."

L.aw_dgl2_title = "Мастер Deagle"
L.aw_dgl2_text  = "пристрелил {num} человек с помощью Desert Eagle."

L.aw_mac1_title = "Молись и убивай"
L.aw_mac1_text  = "убил {num} человек с помощью MAC10, но не скажет, сколько патронов понадобилось."

L.aw_mac2_title = "Мак и сыр"
L.aw_mac2_text  = "интересно, сколько людей бы погибло от его рук с двумя MAC10? {num} то число?"

L.aw_sip1_title = "Потише"
L.aw_sip1_text  = "убил {num} людей с помощью Пистолета с глушителем."

L.aw_sip2_title = "Бесшумный ассасин"
L.aw_sip2_text  = "убил {num} людей, не услышавших собственной смерти."

L.aw_knf1_title = "Нож тебя знает"
L.aw_knf1_text  = "воткнул кому-то нож в лицо через интернет."

L.aw_knf2_title = "Откуда ты это взял?"
L.aw_knf2_text  = "не был предателем, но всё равно зарезал кого-то ножом."

L.aw_knf3_title = "Столь ножевой человек"
L.aw_knf3_text  = "нашёл {num} ножа, лежащих вокруг, и воспользовался ими."

L.aw_knf4_title = "Самый ножевой человек в мире"
L.aw_knf4_text  = "убил {num} человек ножом. Не спрашивайте как."

L.aw_flg1_title = "Во спасение"
L.aw_flg1_text  = "использовал сигнальные ракеты, чтобы позвать на помощь, но сжёг {num} людей."

L.aw_flg2_title = "Сигнальная ракета обозначает огонь"
L.aw_flg2_text  = "рассказал {num} людям об опасности ношения легковоспламеняющейся одежды."

L.aw_hug1_title = "Большой разброс"
L.aw_hug1_text  = "был в гармонии со своим H.U.G.E, умудрившись как-то заставить свои пули убить 4 человек."

L.aw_hug2_title = "Терпеливая пара"
L.aw_hug2_text  = "продолжал стрелять из H.U.G.E. и обнаружил, что терпение вознаградило его {num} убийствами."

L.aw_msx1_title = "Пыщ-пыщ-пыщ"
L.aw_msx1_text  = "убил {num} человек с помощью M16"

L.aw_msx2_title = "Безумие средней дальности"
L.aw_msx2_text  = "знает, как убивать с помощью M16, и убивает {num} человек."

L.aw_tkl1_title = "Ой"
L.aw_tkl1_text  = "нажал на курок прямо тогда, когда целился в товарища."

L.aw_tkl2_title = "Ой-ой"
L.aw_tkl2_text  = "дважды думал, что он предатель, но был неправ в обоих случаях."

L.aw_tkl3_title = "Осознающий карму"
L.aw_tkl3_text  = "не смог остановиться после убийства двоих товарищей. Три - его счастливое число."

L.aw_tkl4_title = "Товарищеубийца"
L.aw_tkl4_text  = "убил всю свою команду. О БОЖЕ МОЙ, БАН, БАН, БАН."

L.aw_tkl5_title = "Ролевой игрок"
L.aw_tkl5_text  = "отыгрывал психа, честно. Вот почему он убил большую часть своей команды."

L.aw_tkl6_title = "Идиот"
L.aw_tkl6_text  = "не смог понять, на чьей он стороне, и поэтому убил половину своих товарищей."

L.aw_tkl7_title = "Деревенщина"
L.aw_tkl7_text  = "очень хорошо защитил свою территорию, убив более четверти своих товарищей."

L.aw_brn1_title = "По бабушкиному рецепту"
L.aw_brn1_text  = "зажарил несколько человек до хрустящей корочки."

L.aw_brn2_title = "Пиромания"
L.aw_brn2_text  = "услышал громкое кудахтанье после сожжения одной из его многочисленных жертв."

L.aw_brn3_title = "Пиррово сожжение"
L.aw_brn3_text  = "сжёг их всех, но у него закончились зажигательные гранаты. Как он с этим справиться?!"

L.aw_fnd1_title = "Коронер"
L.aw_fnd1_text  = "нашёл тела {num} людей, валяющихся вокруг."

L.aw_fnd2_title = "Должен найти их всех"
L.aw_fnd2_text  = "нашёл {num} тел для своей коллекции."

L.aw_fnd3_title = "Запах смерти"
L.aw_fnd3_text  = "продолжает спотыкаться на случайные тела, {num} раз за этот раунд."

L.aw_crd1_title = "Переработчик"
L.aw_crd1_text  = "собрал {num} неиспользованных кредита(ов) с тел."

L.aw_tod1_title = "Пиррова победа"
L.aw_tod1_text  = "умер всего лишь за несколько секунд до победы своей команды."

L.aw_tod2_title = "Я ненавижу эту игру"
L.aw_tod2_text  = "умер сразу после начала раунда."


--- New and modified pieces of text are placed below this point, marked with the
--- version or the date in which they were added, to make updating translations easier.


--- v23
L.set_avoid_det     = "Избегать становление детективом."
L.set_avoid_det_tip = "Включите, чтобы сервер не выбирал вас детективом, когда это возможно. Это не значит, что вы будете предателем чаще."

--- v24
L.drop_no_ammo = "Недостаточно патронов в обойме для их выброса в виде коробки с патронами."

--- v31
L.set_cross_brightness = "Яркость прицела"
L.set_cross_size = "Размер прицела"

--- 2015-05-25
L.hat_retrieve = "Вы подобрали шляпу детектива."

--- 2017-03-09
L.sb_sortby = "Сортировка:"

--- 2018-07-24
L.equip_tooltip_main = "Меню снаряжения"
L.equip_tooltip_radar = "Управление радаром"
L.equip_tooltip_disguise = "Управление Маскировкой"
L.equip_tooltip_radio = "Управление Радио"
L.equip_tooltip_xfer = "Передача кредитов"

L.confgrenade_name = "Отталкивающая граната"
L.polter_name = "Полтергейст"
L.stungun_name = "Прототип UMP"

L.knife_instant = "МГНОВЕННОЕ УБИЙСТВО"

L.dna_hud_type = "ТИП"
L.dna_hud_body = "ТЕЛО"
L.dna_hud_item = "ПРЕДМЕТ"

L.binoc_zoom_level = "УРОВЕНЬ"
L.binoc_body = "ОБНАРУЖЕНО ТЕЛО"

L.idle_popup_title = "Бездействие"

--- 2021-06-07
L.sb_playervolume = "Громкость игрока"

--- 2021-09-22
L.tip41 = "Вы можете настроить громкость микрофона игрока, нажав правой кнопкой мыши по его иконке заглушения в таблице счёта."
