# Included mods

Here you can find the mod comparison table between the currently supported Minecraft versions (may not be accurate for alphas and betas). Some mods have been obsoleted or superseded by better alternatives in the newer versions - [see the changelog for full info](https://github.com/Fabulously-Optimized/fabulously-optimized/blob/main/CHANGELOG.md). You can also find the version-specific mod list by clicking on the version on CurseForge or Modrinth.

The selected mods are inspired, but not limited by the [list of OptiFine alternatives](https://lambdaurora.dev/optifine_alternatives). The modpack also [improves the default settings](https://fabulously-optimized.gitbook.io/modpack/readme/changed-options).

## Smooth
| Name | Author | 1.16.5 | 1.17.1 | 1.18.2 | 1.19.4 | 1.20.6 | 1.21.1 | Description |
|---|---|---|---|---|---|---|---|---|
| [Better Beds](https://www.curseforge.com/minecraft/mc-mods/better-beds) | [TeamMidnightDust](https://www.curseforge.com/members/teammidnightdust) | &nbsp;&nbsp;✅ |  |  |  |  |  | Makes beds render faster |
| [Dynamic FPS](https://www.curseforge.com/minecraft/mc-mods/dynamic-fps) | [juliand665](https://www.curseforge.com/members/juliand665) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Renders Minecraft slower if it is in the background to reduce CPU usage |
| [Enhanced Block Entities](https://www.curseforge.com/minecraft/mc-mods/enhanced-block-entities) | [FoundationGames](https://www.curseforge.com/members/FoundationGames) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes chests, signs, beds, etc. render faster |
| [Entity Culling](https://www.curseforge.com/minecraft/mc-mods/entityculling) | [tr9zw](https://www.curseforge.com/members/tr9zw) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Stops rendering entities that are behind walls |
| [FastChest](https://www.curseforge.com/minecraft/mc-mods/fastchest) | [fake_domi](https://www.curseforge.com/members/fake_domi) | &nbsp;&nbsp;✅ |  |  |  |  |  | Makes chests render faster |
| [FastQuit](https://www.curseforge.com/minecraft/mc-mods/fastquit) | [KingContaria](https://www.curseforge.com/members/kingcontaria) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Quit from singleplayer worlds instantly |
| [FerriteCore](https://www.curseforge.com/minecraft/mc-mods/ferritecore-fabric) | [malte0811](https://www.curseforge.com/members/malte0811) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Reduces RAM usage |
| [Hydrogen](https://modrinth.com/mod/hydrogen) ¹ | [CaffeineMC](https://www.curseforge.com/members/jellysquid3_) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Reduces RAM usage |
| [ImmediatelyFast](https://www.curseforge.com/minecraft/mc-mods/immediatelyfast) | [RaphiMC](https://www.curseforge.com/members/raphimc) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Optimizes mobs, container blocks, GUI, HUD |
| [Language Reload](https://www.curseforge.com/minecraft/mc-mods/language-reload) | [Jerozgen](https://www.curseforge.com/members/Jerozgen) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes language switching instant, adds a searchbar |
| [LazyDFU](https://www.curseforge.com/minecraft/mc-mods/lazydfu) | [tuxed](https://www.curseforge.com/members/tuxed) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  | Makes the game startup faster |
| [Lithium](https://www.curseforge.com/minecraft/mc-mods/lithium) | [CaffeineMC](https://www.curseforge.com/members/jellysquid3_) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Optimizes game physics and chunk loading |
| [MemoryLeakFix](https://www.curseforge.com/minecraft/mc-mods/memoryleakfix) | [FX_PR0CESS](https://www.curseforge.com/members/fx_pr0cess) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  | Fixes several memory leaks |
| [ModernFix](https://www.curseforge.com/minecraft/mc-mods/modernfix) | [embeddedt](https://www.curseforge.com/members/embeddedt/) |  |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Improves performance, reduces RAM use, fixes bugs |
| [No Fade](https://www.curseforge.com/minecraft/mc-mods/no-fade) | [UltimateBoomer](https://www.curseforge.com/members/UltimateBoomer) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  | Makes game startup and resource packs switch faster by removing fade animations |
| [Phosphor](https://www.curseforge.com/minecraft/mc-mods/phosphor) | [CaffeineMC](https://www.curseforge.com/members/jellysquid3_) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Optimizes light rendering |
| [Remove Reloading Screen](https://www.curseforge.com/minecraft/mc-mods/rrls) | [dimadencep](https://www.curseforge.com/members/dimadencep/) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes resource packs load in the background |
| [Smooth Boot](https://www.curseforge.com/minecraft/mc-mods/smooth-boot) | [UltimateBoomer](https://www.curseforge.com/members/UltimateBoomer) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  | Improves the overall responsiveness of the game (less likely to freeze) |
| [Sodium](https://www.curseforge.com/minecraft/mc-mods/sodium) | [CaffeineMC](https://www.curseforge.com/members/jellysquid3_) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Optimizes general rendering to improve FPS, adds some graphics options |
| [Starlight](https://www.curseforge.com/minecraft/mc-mods/starlight) | [Spottedstar](https://www.curseforge.com/members/Spottedstar) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  | Optimizes light rendering |

¹ [Not from CurseForge](https://support.overwolf.com/en/support/solutions/articles/9000197913-non-curseforge-mods)

## Pretty
| Name | Author | 1.16.5 | 1.17.1 | 1.18.2 | 1.19.4 | 1.20.6 | 1.21.1 | Description |
|---|---|---|---|---|---|---|---|---|
| [AdvancementInfo](https://www.curseforge.com/minecraft/mc-mods/advancementinfo) | [Giserbaer](https://www.curseforge.com/members/Giserbaer) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  | Makes the advancement pages bigger, adds a requirement list and search bar |
| [Animatica](https://www.curseforge.com/minecraft/mc-mods/animatica) | [FoundationGames](https://www.curseforge.com/members/FoundationGames) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds OptiFine's animated textures support |
| [Better Mount Hud](https://www.curseforge.com/minecraft/mc-mods/better-mount-hud) | [Lortseam_](https://www.curseforge.com/members/Lortseam_) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Shows horse health and player's food via HUD at the same time, Automatically changes to jump bar when jumping with horse |
| [Capes](https://www.curseforge.com/minecraft/mc-mods/capes) | [VictorKohler](https://www.curseforge.com/members/VictorKohler) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds OptiFine's and other mods' capes, [(instructions for a free cape)](https://fabulously-optimized.gitbook.io/modpack/readme/free-cape) |
| [CIT Resewn](https://www.curseforge.com/minecraft/mc-mods/cit-resewn) | [SHsuperCM](https://www.curseforge.com/members/SHsuperCM) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |    | &nbsp;&nbsp;✅ | Adds OptiFine's custom item textures support |
| [Colormatic](https://www.curseforge.com/minecraft/mc-mods/colormatic) | [kwertiTheCats](https://www.curseforge.com/members/kwertiTheCats) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  | Adds OptiFine's custom colors support, clear skies and clear void options |
| [Continuity](https://www.curseforge.com/minecraft/mc-mods/continuity) | [Pepper_Bell](https://www.curseforge.com/members/Pepper_Bell) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds OptiFine's connected textures support |
| [Cull Leaves](https://www.curseforge.com/minecraft/mc-mods/cull-leaves) | [TeamMidnightDust](https://www.curseforge.com/members/teammidnightdust) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Adds OptiFine's "better trees" - fancy leaves are more see-through for better FPS |
| [Cull Less Leaves](https://www.curseforge.com/minecraft/mc-mods/cull-less-leaves) | [isXander](https://www.curseforge.com/members/xanderisdev) |  |  | &nbsp;&nbsp;✅ |  |  |  | Makes tree leaves faster without compromising on appearance |
| [Custom Entity Models](https://www.curseforge.com/minecraft/mc-mods/custom-entity-models-cem) | [dorianpb](https://www.curseforge.com/members/dorianpb) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  | Adds OptiFine's custom entity models (alpha) |
| [Custom Fog](https://www.curseforge.com/minecraft/mc-mods/custom-fog) | [Setadokalo](https://www.curseforge.com/members/setadokalo) | &nbsp;&nbsp;✅ |  |  |  |  |  | Lets you change fog settings (distance, density, dimensions, etc.) |
| [Entity Model Features](https://www.curseforge.com/minecraft/mc-mods/entity-model-features) | [traben_0](https://www.curseforge.com/members/traben_0) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds OptiFine's custom entity models |
| [Entity Texture Features](https://www.curseforge.com/minecraft/mc-mods/entity-texture-features-fabric) | [traben_0](https://www.curseforge.com/members/traben_0) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds OptiFine's random and emissive mobs support |
| [FabricSkyboxes](https://www.curseforge.com/minecraft/mc-mods/fabricskyboxes) | [AMereBagatelle](https://www.curseforge.com/members/amerebagatelle) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds custom skybox support |
| [Fabrishot](https://www.curseforge.com/minecraft/mc-mods/fabrishot) | [ramidzkh](https://www.curseforge.com/members/ramidzkh) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Lets you take a high-res screenshot with F9 |
| [Farsight](https://www.curseforge.com/minecraft/mc-mods/farsight-fabric) | [someaddon](https://www.curseforge.com/members/someaddon) |  |  | &nbsp;&nbsp;✅ |   ✅¹ |  |  | Keeps far loaded chunks visible in servers, increasing visible render distance |
| [Hold That Chunk](https://www.curseforge.com/minecraft/mc-mods/hold-that-chunk) | [The_TermiGator](https://www.curseforge.com/members/the_termigator) |  |  |  |   ●¹ |  |  | Keeps far loaded chunks visible in servers to increase visible render distance, clears old chunks after 1 hr |
| [Iris Shaders](https://www.curseforge.com/minecraft/mc-mods/irisshaders) | [coderbot](https://www.curseforge.com/members/coderbot) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds OptiFine's shaders support, [(recommended shader list is here)](https://github.com/IrisShaders/Iris/blob/trunk/docs/supportedshaders.md) |
| [Item Model Fix](https://www.curseforge.com/minecraft/mc-mods/item-model-fix) | [Pepper_Bell](https://www.curseforge.com/members/Pepper_Bell) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  | Fixes transparent gaps in held items |
| [LambdaBetterGrass](https://www.curseforge.com/minecraft/mc-mods/lambdabettergrass) | [LambdAurora](https://www.curseforge.com/members/LambdAurora) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  | Adds OptiFine's "better grass" and "better snow" |
| [LambDynamicLights](https://www.curseforge.com/minecraft/mc-mods/lambdynamiclights) | [LambdAurora](https://www.curseforge.com/members/LambdAurora) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |    | &nbsp;&nbsp;✅ | Adds OptiFine's "dynamic lights" - lights up areas by holding a light source, activating TNT or creeper |
| [Model Gap Fix](https://www.curseforge.com/minecraft/mc-mods/model-gap-fix) | [MehVahdJukaar](https://www.curseforge.com/members/mehvahdjukaar) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Fixes transparent gaps in items and blocks |
| [MoreCulling](https://www.curseforge.com/minecraft/mc-mods/moreculling) | [FX_PR0CESS](https://www.curseforge.com/members/fx_pr0cess) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Stops rendering hidden sides of certain blocks |
| [No Potion Offset](https://www.curseforge.com/minecraft/mc-mods/no-potion-offset) | [shedaniel](https://www.curseforge.com/members/shedaniel) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Keeps player inventory in place when under potion effects |
| [Paginated Advancements](https://www.curseforge.com/minecraft/mc-mods/paginated-advancements) | [DaFuqsy](https://legacy.curseforge.com/members/dafuqsy/) |  |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes the advancement pages bigger, adds a requirement list |
| [Polytone](https://www.curseforge.com/minecraft/mc-mods/polytone) | [TeamMidnightDust](https://www.curseforge.com/members/mehvahdjukaar/) |  |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds OptiFine's custom colors support, additional resource pack features |
| [Puzzle](https://www.curseforge.com/minecraft/mc-mods/puzzle) | [TeamMidnightDust](https://www.curseforge.com/members/teammidnightdust) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds some minor OptiFine features like resource pack-provided splash screen |
| [OptiGUI](https://www.curseforge.com/minecraft/mc-mods/optigui) | [opekope2](https://www.curseforge.com/members/opekope2) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds OptiFine's custom GUI support |
| [Reese's Sodium Options](https://www.curseforge.com/minecraft/mc-mods/reeses-sodium-options) | [FlashyReese](https://www.curseforge.com/members/FlashyReese) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes Sodium's settings vertical, centered and scrollable |
| ['Slight' Gui Modifications](https://www.curseforge.com/minecraft/mc-mods/slight-gui-modifications) | [shedaniel](https://www.curseforge.com/members/shedaniel) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Adds toast animations and FO text in main menu, plus several opt-in features |
| [Sodium Extra](https://www.curseforge.com/minecraft/mc-mods/sodium-extra) | [FlashyReese](https://www.curseforge.com/members/FlashyReese) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds many OptiFine-like graphics toggles: animations, particles, weather, FPS indicator and more |
| [ToolTipFix](https://www.curseforge.com/minecraft/mc-mods/tooltipfix) | [Kyrptonaught](https://www.curseforge.com/members/Kyrptonaught) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  | Ensures all possible tooltips fit to screen |

¹ CurseForge, MultiMC and MultiMC (auto-update) include Farsight, Modrinth includes Hold That Chunk because Farsight could not be distributed there.

## Functional
| Name | Author | 1.16.5 | 1.17.1 | 1.18.2 | 1.19.4 | 1.20.6 | 1.21.1 | Description |
|---|---|---|---|---|---|---|---|---|
| [AntiGhost](https://www.curseforge.com/minecraft/mc-mods/antighost) | [Giselbaer](https://www.curseforge.com/members/Giselbaer) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  | Fixes glitching blocks by typing /ghost (repetitively using this can likely alert staff members in-game) |
| [Borderless Mining](https://www.curseforge.com/minecraft/mc-mods/borderless-mining) | [comp500](https://www.curseforge.com/members/comp500) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  | Allows you to have Minecraft in full screen and interact with a different window (disabled by default) |
| [Controlify](https://www.curseforge.com/minecraft/mc-mods/controlify) | [isXander](https://www.curseforge.com/members/xanderisdev) |  |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds controller support that is better than Bedrock's |
| [Cubes Without Borders](https://www.curseforge.com/minecraft/mc-mods/cubes-without-borders) | [Kir_Antipov](https://www.curseforge.com/members/kir_antipov/) |  |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Allows you to have Minecraft in full screen and interact with a different window (disabled by default) |
| [Don't Clear Chat History](https://www.curseforge.com/minecraft/mc-mods/dont-clear-chat-history) | [anar4732](https://www.curseforge.com/members/anar4732) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  | Keeps typed message history across worlds |
| [Debugify](https://www.curseforge.com/minecraft/mc-mods/debugify) | [isXander](https://www.curseforge.com/members/xanderisdev) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Fixes [a set of bugs](https://fabulously-optimized.gitbook.io/modpack/readme/changed-options#fixed-bugs), disables sending diagnostics data to Mojang |
| [e4mc](https://www.curseforge.com/minecraft/mc-mods/e4mc) | [skyegreen](https://www.curseforge.com/members/skyegreen/projects) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Allows opening worlds to public access the same way you can open to LAN |
| [FabricSkyBoxes Interop](https://www.curseforge.com/minecraft/mc-mods/fabricskyboxes-interop) | [FlashyReese](https://www.curseforge.com/members/flashyreese) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds OptiFine resourcepack support to FabricSkyboxes |
| [FastOpenLinksAndFolders](https://www.curseforge.com/minecraft/mc-mods/fastopenlinksandfolders) | [altrisi](https://www.curseforge.com/members/altrisi) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Fixes the game freezing when you open resource pack folders, a screenshot etc. |
| [LittleTweaks](https://www.curseforge.com/minecraft/mc-mods/littletweaks) | [ImUrX](https://www.curseforge.com/members/imurx/projects) |  | &nbsp;&nbsp;✅ |  |  |  |  | Adds the audio output option like 1.18 |
| [Main Menu Credits](https://www.curseforge.com/minecraft/mc-mods/main-menu-credits) | [isXander](https://www.curseforge.com/members/xanderisdev) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds modpack's clickable version number in title screen's bottom corner |
| [MidnightControls](https://www.curseforge.com/minecraft/mc-mods/midnightcontrols) | [TeamMidnightDust](https://www.curseforge.com/members/teammidnightdust) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  | Adds controller and touchscreen support - Bedrock parity! |
| [MixinTrace](https://www.curseforge.com/minecraft/mc-mods/mixintrace) | [comp500](https://www.curseforge.com/members/comp500) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Helps developers find the cause of crashes |
| [Mod Menu](https://www.curseforge.com/minecraft/mc-mods/modmenu) | [TerraformersMC](https://www.curseforge.com/members/TerraformersMC) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds a mod list with descriptions (keep bundled resource pack enabled for better experience!) |
| [More Chat History](https://www.curseforge.com/minecraft/mc-mods/more-chat-history) | [JackFred2](https://www.curseforge.com/members/JackFred2) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Increases chat history limit |
| [No Chat Reports](https://www.curseforge.com/minecraft/mc-mods/no-chat-reports) | [Aizistral](https://www.curseforge.com/members/aizistral) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Provides consistent chat status indicators and visual options |
| [Not Enough Crashes](https://www.curseforge.com/minecraft/mc-mods/not-enough-crashes) | [NatanFudge](https://www.curseforge.com/members/NatanFudge) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Allows playing after a crash and getting the crash report as a link |
| [Your Options Shall Be Respected](https://www.curseforge.com/minecraft/mc-mods/yosbr) | [shedaniel](https://www.curseforge.com/members/shedaniel) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Keeps your settings when updating the modpack |
| [WI Zoom](https://www.curseforge.com/minecraft/mc-mods/wi-zoom) | [alexander9892](https://www.curseforge.com/members/alexander9892) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Adds a scrollable zoom feature |
| [Zoomify](https://www.curseforge.com/minecraft/mc-mods/zoomify) | [isXander](https://www.curseforge.com/members/xanderisdev) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds a scrollable and customizable zoom feature |

## Libraries

Mods that make other mods work. Hidden from in-game mod menu, but should not be removed.

| Name | Author | 1.16.5 | 1.17.1 | 1.18.2 | 1.19.4 | 1.20.6 | 1.21.1 | Description |
|---|---|---|---|---|---|---|---|---|
| [Architectury](https://www.curseforge.com/minecraft/mc-mods/architectury-fabric) | [shedaniel](https://www.curseforge.com/members/shedaniel) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Makes some mods work |
| [ARRP](https://www.curseforge.com/minecraft/mc-mods/arrp) | [one_point_o](https://www.curseforge.com/members/one_point_o) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes some mods work |
| [Cloth API (Fabric)](https://www.curseforge.com/minecraft/mc-mods/cloth-api) | [shedaniel](https://www.curseforge.com/members/shedaniel) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ |  |  |  |  | Makes some mods work |
| [Cloth Config API](https://www.curseforge.com/minecraft/mc-mods/cloth-config) | [shedaniel](https://www.curseforge.com/members/shedaniel) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes many mods' config work |
| [CompleteConfig](https://www.curseforge.com/minecraft/mc-mods/completeconfig) | [lortseam_](https://www.curseforge.com/members/lortseam_) |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes some mods' config work |
| [Fabric API](https://www.curseforge.com/minecraft/mc-mods/fabric-api) | [modmuss50](https://www.curseforge.com/members/modmuss50) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes most mods work |
| [Fabric Language Kotlin](https://www.curseforge.com/minecraft/mc-mods/fabric-language-kotlin) | [modmuss50](https://www.curseforge.com/members/modmuss50) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes some mods work |
| [Indium](https://www.curseforge.com/minecraft/mc-mods/indium) | [comp500](https://www.curseforge.com/members/comp500) | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Adds support for the Rendering API (more parity mods) |
| [MidnightLib](https://www.curseforge.com/minecraft/mc-mods/midnightlib) | [TeamMidnightDust](https://www.curseforge.com/members/TeamMidnightDust) |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes some mods work |
| [YetAnotherConfigLib](https://www.curseforge.com/minecraft/mc-mods/yacl) | [XanderIsDev](https://www.curseforge.com/members/xanderisdev) |  |  |  | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | &nbsp;&nbsp;✅ | Makes some mods' config work |

## Alternative mods

Mods that are usually not included in the latest modpack (may be on legacy or beta versions), but can be used as a replacement for some included ones, if these do not satisfy your needs. In the game's mod menu they are marked with yellow arrows `🔀`. See the wiki on [how to add](https://fabulously-optimized.gitbook.io/modpack/readme/adding-more-mods) and [how to disable](https://fabulously-optimized.gitbook.io/modpack/readme/disabling-mods) existing mods.

| Name | Author | Alternative for | Description |
|---|---|---|---|
| [Better Beds](https://www.curseforge.com/minecraft/mc-mods/better-beds) | [TeamMidnightDust](https://www.curseforge.com/members/teammidnightdust/) | [Enhanced Block Entities](https://www.curseforge.com/minecraft/mc-mods/enhanced-block-entities) | Makes only the beds render faster |
| [Custom Entity Models](https://www.curseforge.com/minecraft/mc-mods/custom-entity-models-cem) | [dorianpb](https://www.curseforge.com/members/dorianpb) | [Entity Model Features](https://www.curseforge.com/minecraft/mc-mods/entity-model-features) | A slightly less compatible custom entity models mod |
| [Cull Less Leaves](https://www.curseforge.com/minecraft/mc-mods/cull-less-leaves) | [isXander](https://www.curseforge.com/members/xanderisdev) | [MoreCulling](https://www.curseforge.com/minecraft/mc-mods/moreculling) | Makes only the leaves cull faster |
| [Item Model Fix](https://www.curseforge.com/minecraft/mc-mods/item-model-fix) | [Pepper_Bell](https://www.curseforge.com/members/pepper_bell/) | [Model Gap Fix](https://www.curseforge.com/minecraft/mc-mods/model-gap-fix) | Uses a different, potentially more intensive method for fixing models |
| [MidnightControls](https://www.curseforge.com/minecraft/mc-mods/midnightcontrols) | [TeamMidnightDust](https://www.curseforge.com/members/teammidnightdust) | [Controlify](https://www.curseforge.com/minecraft/mc-mods/controlify)  | A controller support mod with slightly different features |
